/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.tileentity.ITileEntityMachineBlockUpdateable;
import gregapi.tileentity.base.TileEntityBase08Directional;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class TileEntityBase09FacingSingle
extends TileEntityBase08Directional
implements IMultiTileEntity.IMTE_OnPlaced,
IMultiTileEntity.IMTE_AddToolTips {
    public byte mFacing = this.getDefaultSide();

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.facing")) {
            this.mFacing = aNBT.func_74771_c("gt.facing");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74774_a("gt.facing", this.mFacing);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.x.to.toggle.facing.pre") + LH.get("gt.lang.tool.name." + this.getFacingTool(), "Unknown") + LH.get("gt.lang.use.x.to.toggle.facing.post"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals(this.getFacingTool())) {
            byte aTargetSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ);
            if (this.getValidSides()[aTargetSide]) {
                byte oFacing = this.mFacing;
                this.mFacing = aTargetSide;
                this.updateClientData();
                this.causeBlockUpdate();
                this.onFacingChange(oFacing);
                return 10000L;
            }
        }
        return 0L;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        this.mFacing = this.useSidePlacementRotation() ? (this.useInversePlacementRotation() ? (this.getValidSides()[CS.OPPOSITES[aSide]] ? CS.OPPOSITES[aSide] : this.getDefaultSide()) : (this.getValidSides()[aSide] ? aSide : this.getDefaultSide())) : (this.useInversePlacementRotation() ? UT.Code.getOppositeSideForPlayerPlacing((Entity)aPlayer, this.mFacing, this.getValidSides()) : UT.Code.getSideForPlayerPlacing((Entity)aPlayer, this.mFacing, this.getValidSides()));
        this.onFacingChange((byte)6);
        this.checkCoverValidity();
        this.doEnetUpdate();
        return true;
    }

    @Override
    public byte getDirectionData() {
        return (byte)(this.mFacing & 7);
    }

    @Override
    public void setDirectionData(byte aData) {
        this.mFacing = (byte)(aData & 7);
    }

    @Override
    public String getFacingTool() {
        return "wrench";
    }

    public short getFacing() {
        return this.mFacing;
    }

    public void setFacing(short aSide) {
        if (this.isClientSide()) {
            return;
        }
        byte oFacing = this.mFacing;
        this.mFacing = (byte)aSide;
        this.updateClientData();
        this.causeBlockUpdate();
        this.onFacingChange(oFacing);
        this.checkCoverValidity();
        this.doEnetUpdate();
        if (this.hasMultiBlockMachineRelevantData()) {
            ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(this.getWorld(), this.getCoords(), this.getBlock(this.getCoords()), this.getMetaData(this.getCoords()), false);
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer aPlayer, int aSide) {
        return this.getFacingTool().equals("wrench") && this.getValidSides()[aSide];
    }

    @Override
    public boolean isConnectedWrenchingOverlay(ItemStack aStack, byte aSide) {
        return aSide == this.mFacing;
    }

    public byte getDefaultSide() {
        return 1;
    }

    public boolean[] getValidSides() {
        return CS.SIDES_VALID;
    }

    public void onFacingChange(byte aPreviousFacing) {
    }

    public boolean useSidePlacementRotation() {
        return false;
    }

    public boolean useInversePlacementRotation() {
        return false;
    }
}

