/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.MT;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.oredict.OreDictMaterial;
import gregapi.tileentity.ITileEntityDecolorable;
import gregapi.tileentity.base.TileEntityBase06Covers;
import gregapi.util.UT;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityBase07Paintable
extends TileEntityBase06Covers
implements ITileEntityDecolorable,
IMultiTileEntity.IMTE_GetExplosionResistance,
IMultiTileEntity.IMTE_GetBlockHardness,
IMultiTileEntity.IMTE_GetLightOpacity,
IMultiTileEntity.IMTE_SyncDataByte,
IMultiTileEntity.IMTE_SyncDataByteArray {
    protected boolean mIsPainted = false;
    protected int mRGBa = 0xFFFFFF;
    protected float mHardness = 3.0f;
    protected float mResistance = 3.0f;
    protected OreDictMaterial mMaterial = MT.NULL;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.color")) {
            this.mRGBa = aNBT.func_74762_e("gt.color");
        }
        if (aNBT.func_74764_b("gt.painted")) {
            this.mIsPainted = aNBT.func_74767_n("gt.painted");
        }
        if (aNBT.func_74764_b("gt.hardness")) {
            this.mHardness = aNBT.func_74760_g("gt.hardness");
        }
        if (aNBT.func_74764_b("gt.resistance")) {
            this.mResistance = aNBT.func_74760_g("gt.resistance");
        }
        if (aNBT.func_74764_b("gt.material")) {
            this.mMaterial = OreDictMaterial.get(aNBT.func_74779_i("gt.material"));
        }
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return aSendAll ? this.getClientDataPacketByteArray(aSendAll, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getVisualData()) : super.getClientDataPacketByte(aSendAll, this.getVisualData());
    }

    @Override
    public boolean receiveDataByte(byte aData, INetworkHandler aNetworkHandler) {
        this.setVisualData(aData);
        return true;
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[0]), UT.Code.unsignB(aData[1]), UT.Code.unsignB(aData[2])});
        this.setVisualData(aData[3]);
        return true;
    }

    @Override
    public boolean unpaint() {
        if (this.mIsPainted) {
            this.mIsPainted = false;
            this.mRGBa = UT.Code.getRGBInt(this.mMaterial.mRGBaSolid);
            this.updateClientData();
            return true;
        }
        return false;
    }

    @Override
    public boolean isPainted() {
        return this.mIsPainted || this.field_145850_b != null && this.isClientSide() && UT.Code.getRGBInt(this.mMaterial.mRGBaSolid) != this.mRGBa;
    }

    @Override
    public boolean paint(int aRGB) {
        if (aRGB != this.mRGBa) {
            this.mRGBa = aRGB;
            this.mIsPainted = true;
            return true;
        }
        return false;
    }

    @Override
    public int getPaint() {
        return this.mRGBa;
    }

    @Override
    public int getLightOpacity() {
        return 255;
    }

    @Override
    public float getBlockHardness() {
        return this.mHardness;
    }

    @Override
    public float getExplosionResistance(Entity aExploder, double aExplosionX, double aExplosionY, double aExplosionZ) {
        return this.getExplosionResistance();
    }

    @Override
    public float getExplosionResistance() {
        return this.mResistance;
    }

    public byte getVisualData() {
        return 0;
    }

    public void setVisualData(byte aData) {
    }
}

