/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.tileentity.base.TileEntityBase04MultiTileEntities;
import gregapi.util.OM;
import gregapi.util.UT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.Explosion;

public abstract class TileEntityBase05Inventories
extends TileEntityBase04MultiTileEntities
implements IInventory,
ITileEntityInventoryGUI,
IMultiTileEntity.IMTE_OnBlockExploded,
IMultiTileEntity.IMTE_BreakBlock {
    private ItemStack[] mInventory = CS.ZL_ITEMSTACK;
    public boolean mInventoryChanged = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        this.mInventory = this.getDefaultInventory(aNBT);
        if (this.mInventory != null && this.mInventory.length > 0) {
            NBTTagList tList = aNBT.func_150295_c("gt.invlist", 10);
            for (int i = 0; i < tList.func_74745_c(); ++i) {
                NBTTagCompound tNBT = tList.func_150305_b(i);
                short tSlot = tNBT.func_74765_d("s");
                if (tSlot < 0 || tSlot >= this.mInventory.length) continue;
                this.mInventory[tSlot] = UT.Stacks.load(tNBT);
            }
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        if (this.mInventory != null && this.mInventory.length > 0) {
            NBTTagList tList = new NBTTagList();
            for (short tSlot = 0; tSlot < this.mInventory.length; tSlot = (short)((short)(tSlot + 1))) {
                if (this.mInventory[tSlot] == null) continue;
                tList.func_74742_a((NBTBase)UT.NBT.getNBTShort(UT.Stacks.save(this.mInventory[tSlot]), "s", tSlot));
            }
            aNBT.func_74782_a("gt.invlist", (NBTBase)tList);
        }
    }

    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        short tSize = aNBT.func_74765_d("gt.invsize");
        return tSize > 0 ? new ItemStack[tSize] : CS.ZL_ITEMSTACK;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.mInventoryChanged = false;
    }

    public final ItemStack slot(int aIndex, ItemStack aStack) {
        this.mInventory[aIndex] = aStack;
        return this.mInventory[aIndex];
    }

    public final ItemStack slot(int aIndex) {
        return this.mInventory[aIndex];
    }

    public final boolean slotHas(int aIndex) {
        return this.mInventory[aIndex] != null;
    }

    public final boolean invempty() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null) continue;
            return false;
        }
        return true;
    }

    public final NBTTagCompound slotNBT(int aIndex) {
        return this.mInventory[aIndex] != null ? this.mInventory[aIndex].func_77978_p() : null;
    }

    @Override
    protected void updateInventory() {
        this.mInventoryChanged = true;
    }

    public boolean func_70300_a(EntityPlayer aPlayer) {
        return this.allowInteraction((Entity)aPlayer) && aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.updateInventory();
    }

    public ItemStack func_70298_a(int aSlot, int aDecrement) {
        this.updateInventory();
        if (this.mInventory[aSlot] == null) {
            return null;
        }
        if (this.mInventory[aSlot].field_77994_a <= aDecrement) {
            ItemStack tStack = UT.Stacks.copy(this.mInventory[aSlot]);
            if (this.allowZeroStacks(aSlot)) {
                this.mInventory[aSlot].field_77994_a = 0;
            } else {
                this.mInventory[aSlot] = CS.NI;
            }
            return tStack;
        }
        ItemStack rStack = this.mInventory[aSlot].func_77979_a(aDecrement);
        if (this.mInventory[aSlot].field_77994_a <= 0 && !this.allowZeroStacks(aSlot)) {
            this.mInventory[aSlot] = CS.NI;
        }
        return rStack;
    }

    public ItemStack func_70304_b(int aSlot) {
        ItemStack rStack = this.mInventory[aSlot];
        this.mInventory[aSlot] = null;
        return rStack;
    }

    public ItemStack func_70301_a(int aSlot) {
        return this.mInventory[aSlot];
    }

    public String func_145825_b() {
        String rName = this.getCustomName();
        if (UT.Code.stringValid(rName)) {
            return rName;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        return tRegistry == null ? this.getClass().getName() : tRegistry.getLocal(this.getMultiTileEntityID());
    }

    public int func_70302_i_() {
        return this.mInventory == null ? 0 : this.mInventory.length;
    }

    public void func_70299_a(int aSlot, ItemStack aStack) {
        this.updateInventory();
        this.mInventory[aSlot] = OM.get(aStack);
    }

    public boolean func_145818_k_() {
        return this.getCustomName() != null;
    }

    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        return true;
    }

    @Override
    public void onExploded(Explosion aExplosion) {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.field_145850_b.field_73012_v.nextInt(3) == 0) continue;
            this.mInventory[i] = null;
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean allowZeroStacks(int aSlot) {
        return false;
    }

    public ItemStack[] getInventory() {
        return this.mInventory;
    }

    public void setInventory(ItemStack[] aInventory) {
        this.mInventory = aInventory;
    }

    public void removeAllDroppableNullStacks() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (!this.canDrop(i) || this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
    }

    public abstract boolean canDrop(int var1);

    @Override
    public int getSizeInventoryGUI() {
        return this.mInventory == null ? 0 : this.mInventory.length;
    }

    @Override
    public ItemStack getStackInSlotGUI(int aSlot) {
        return this.mInventory[aSlot];
    }

    @Override
    public ItemStack decrStackSizeGUI(int aSlot, int aDecrement) {
        this.updateInventory();
        if (this.mInventory[aSlot] == null) {
            return null;
        }
        if (this.mInventory[aSlot].field_77994_a <= aDecrement) {
            ItemStack tStack = UT.Stacks.copy(this.mInventory[aSlot]);
            if (this.allowZeroStacks(aSlot)) {
                this.mInventory[aSlot].field_77994_a = 0;
            } else {
                this.mInventory[aSlot] = CS.NI;
            }
            return tStack;
        }
        ItemStack rStack = this.mInventory[aSlot].func_77979_a(aDecrement);
        if (this.mInventory[aSlot].field_77994_a <= 0 && !this.allowZeroStacks(aSlot)) {
            this.mInventory[aSlot] = CS.NI;
        }
        return rStack;
    }

    @Override
    public ItemStack getStackInSlotOnClosingGUI(int aSlot) {
        ItemStack rStack = this.mInventory[aSlot];
        this.mInventory[aSlot] = null;
        return rStack;
    }

    @Override
    public void setInventorySlotContentsGUI(int aSlot, ItemStack aStack) {
        this.updateInventory();
        this.mInventory[aSlot] = OM.get(aStack);
    }

    @Override
    public String getInventoryNameGUI() {
        String rName = this.getCustomName();
        if (UT.Code.stringValid(rName)) {
            return rName;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        return tRegistry == null ? this.getClass().getName() : tRegistry.getLocal(this.getMultiTileEntityID());
    }

    @Override
    public boolean hasCustomInventoryNameGUI() {
        return this.getCustomName() != null;
    }

    @Override
    public int getInventoryStackLimitGUI(int aSlot) {
        return this.func_70297_j_();
    }

    @Override
    public void markDirtyGUI() {
        this.func_70296_d();
    }

    @Override
    public boolean isUseableByPlayerGUI(EntityPlayer aPlayer) {
        return this.allowInteraction((Entity)aPlayer) && aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public void openInventoryGUI() {
        this.func_70295_k_();
    }

    @Override
    public void closeInventoryGUI() {
        this.func_70305_f();
    }

    @Override
    public boolean isItemValidForSlotGUI(int aSlot, ItemStack aStack) {
        return true;
    }

    @Override
    public boolean breakBlock() {
        if (this.isServerSide()) {
            for (int i = 0; i < this.mInventory.length; i = (int)((short)(i + 1))) {
                if (this.mInventory[i] == null || !this.canDrop(i)) continue;
                this.mInventory[i].field_77994_a = (int)UT.Code.bind_(0L, 512 * Math.max(1, this.mInventory[i].func_77976_d()), this.mInventory[i].field_77994_a);
                while (this.mInventory[i].field_77994_a > Math.max(1, this.mInventory[i].func_77976_d())) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, UT.Stacks.amount(Math.max(1, this.mInventory[i].func_77976_d()), this.mInventory[i])));
                    this.mInventory[i].field_77994_a -= Math.max(1, this.mInventory[i].func_77976_d());
                }
                if (this.mInventory[i].field_77994_a <= 0) continue;
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, UT.Stacks.copy(this.mInventory[i])));
            }
        }
        return false;
    }

    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        if (UT.Stacks.invalid(aStack)) {
            return true;
        }
        if (aIndex < 0 || aIndex >= this.func_70302_i_()) {
            return false;
        }
        ItemStack tStack = this.func_70301_a(aIndex);
        if (UT.Stacks.invalid(tStack)) {
            this.func_70299_a(aIndex, aStack);
            return true;
        }
        if (UT.Stacks.equal(tStack, aStack = OM.get_(aStack)) && tStack.field_77994_a + aStack.field_77994_a <= Math.min(Math.max(1, tStack.func_77976_d()), this.func_70297_j_())) {
            tStack.field_77994_a += aStack.field_77994_a;
            this.updateInventory();
            return true;
        }
        return false;
    }
}

