/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.TD;
import gregapi.gui.ContainerCommon;
import gregapi.network.packets.PacketBlockError;
import gregapi.network.packets.PacketBlockEvent;
import gregapi.render.IRenderedBlockObject;
import gregapi.tileentity.ITileEntity;
import gregapi.tileentity.ITileEntityGUI;
import gregapi.tileentity.data.ITileEntitySurface;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityCanDelegate;
import gregapi.tileentity.delegate.ITileEntityDelegating;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.util.UT;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class TileEntityBase01Root
extends TileEntity
implements ITileEntity,
ITileEntityGUI {
    public boolean mIgnoreUnloadedChunks = true;
    public boolean mIsDead = false;
    public boolean mShouldRefresh = true;
    public boolean mDoesBlockUpdate = false;
    public boolean mIsAddedToEnet = false;
    public boolean mDoEnetCheck = true;
    public final boolean mIsTicking;
    private final ChunkCoordinates mReturnedCoordinates = new ChunkCoordinates();
    public float mExplosionStrength = 0.0f;
    public String ERROR_MESSAGE = null;

    public TileEntityBase01Root(boolean aIsTicking) {
        this.mIsTicking = aIsTicking;
    }

    @Override
    public void onTileEntityPlaced() {
    }

    @Override
    public void onAdjacentBlockChange(int aTileX, int aTileY, int aTileZ) {
    }

    public void func_70296_d() {
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public int getX() {
        return this.field_145851_c;
    }

    @Override
    public int getY() {
        return this.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.field_145849_e;
    }

    @Override
    public int getOffsetX(byte aSide) {
        return this.field_145851_c + CS.OFFSETS_X[aSide];
    }

    @Override
    public int getOffsetY(byte aSide) {
        return this.field_145848_d + CS.OFFSETS_Y[aSide];
    }

    @Override
    public int getOffsetZ(byte aSide) {
        return this.field_145849_e + CS.OFFSETS_Z[aSide];
    }

    @Override
    public int getOffsetX(byte aSide, int aMultiplier) {
        return this.field_145851_c + CS.OFFSETS_X[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetY(byte aSide, int aMultiplier) {
        return this.field_145848_d + CS.OFFSETS_Y[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetZ(byte aSide, int aMultiplier) {
        return this.field_145849_e + CS.OFFSETS_Z[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetXN(byte aSide) {
        return this.field_145851_c - CS.OFFSETS_X[aSide];
    }

    @Override
    public int getOffsetYN(byte aSide) {
        return this.field_145848_d - CS.OFFSETS_Y[aSide];
    }

    @Override
    public int getOffsetZN(byte aSide) {
        return this.field_145849_e - CS.OFFSETS_Z[aSide];
    }

    @Override
    public int getOffsetXN(byte aSide, int aMultiplier) {
        return this.field_145851_c - CS.OFFSETS_X[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetYN(byte aSide, int aMultiplier) {
        return this.field_145848_d - CS.OFFSETS_Y[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetZN(byte aSide, int aMultiplier) {
        return this.field_145849_e - CS.OFFSETS_Z[aSide] * aMultiplier;
    }

    @Override
    public ChunkCoordinates getCoords() {
        this.mReturnedCoordinates.field_71574_a = this.field_145851_c;
        this.mReturnedCoordinates.field_71572_b = this.field_145848_d;
        this.mReturnedCoordinates.field_71573_c = this.field_145849_e;
        return this.mReturnedCoordinates;
    }

    @Override
    public ChunkCoordinates getOffset(byte aSide, int aMultiplier) {
        return new ChunkCoordinates(this.getOffsetX(aSide, aMultiplier), this.getOffsetY(aSide, aMultiplier), this.getOffsetZ(aSide, aMultiplier));
    }

    @Override
    public ChunkCoordinates getOffsetN(byte aSide, int aMultiplier) {
        return new ChunkCoordinates(this.getOffsetXN(aSide, aMultiplier), this.getOffsetYN(aSide, aMultiplier), this.getOffsetZN(aSide, aMultiplier));
    }

    @Override
    public boolean isServerSide() {
        return this.field_145850_b == null ? FMLCommonHandler.instance().getEffectiveSide().isServer() : !this.field_145850_b.field_72995_K;
    }

    @Override
    public boolean isClientSide() {
        return this.field_145850_b == null ? FMLCommonHandler.instance().getEffectiveSide().isClient() : this.field_145850_b.field_72995_K;
    }

    @Override
    public boolean openGUI(EntityPlayer aPlayer) {
        return this.openGUI(aPlayer, 0);
    }

    @Override
    public boolean openGUI(EntityPlayer aPlayer, int aID) {
        if (aPlayer == null) {
            return false;
        }
        aPlayer.openGui((Object)CS.GAPI, aID, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public int getRandomNumber(int aRange) {
        return (this.field_145850_b == null ? CS.RANDOM : this.field_145850_b.field_73012_v).nextInt(aRange);
    }

    @Override
    public BiomeGenBase getBiome(ChunkCoordinates aCoords) {
        return this.field_145850_b.func_72807_a(aCoords.field_71574_a, aCoords.field_71573_c);
    }

    @Override
    public BiomeGenBase getBiome(int aX, int aZ) {
        return this.field_145850_b.func_72807_a(aX, aZ);
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.getBiome(this.field_145851_c, this.field_145849_e);
    }

    @Override
    public Block getBlockOffset(int aX, int aY, int aZ) {
        return this.getBlock(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public Block getBlockAtSide(byte aSide) {
        return this.getBlockAtSideAndDistance(aSide, 1);
    }

    @Override
    public Block getBlockAtSideAndDistance(byte aSide, int aDistance) {
        return this.getBlock(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public byte getMetaDataOffset(int aX, int aY, int aZ) {
        return this.getMetaData(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public byte getMetaDataAtSide(byte aSide) {
        return this.getMetaDataAtSideAndDistance(aSide, 1);
    }

    @Override
    public byte getMetaDataAtSideAndDistance(byte aSide, int aDistance) {
        return this.getMetaData(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public byte getLightLevelOffset(int aX, int aY, int aZ) {
        return this.getLightLevel(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public byte getLightLevelAtSide(byte aSide) {
        return this.getLightLevelAtSideAndDistance(aSide, 1);
    }

    @Override
    public byte getLightLevelAtSideAndDistance(byte aSide, int aDistance) {
        return this.getLightLevel(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public boolean getOpacityOffset(int aX, int aY, int aZ) {
        return this.getOpacity(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public boolean getOpacityAtSide(byte aSide) {
        return this.getOpacityAtSideAndDistance(aSide, 1);
    }

    @Override
    public boolean getOpacityAtSideAndDistance(byte aSide, int aDistance) {
        return this.getOpacity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public boolean getRainOffset(int aX, int aY, int aZ) {
        return this.getRain(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public boolean getRainAtSide(byte aSide) {
        return this.getRainAtSideAndDistance(aSide, 1);
    }

    @Override
    public boolean getRainAtSideAndDistance(byte aSide, int aDistance) {
        return this.getRain(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public boolean getSkyOffset(int aX, int aY, int aZ) {
        return this.getSky(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public boolean getSkyAtSide(byte aSide) {
        return this.getSkyAtSideAndDistance(aSide, 1);
    }

    @Override
    public boolean getSkyAtSideAndDistance(byte aSide, int aDistance) {
        return this.getSky(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public boolean getAirOffset(int aX, int aY, int aZ) {
        return this.getAir(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public boolean getAirAtSide(byte aSide) {
        return this.getAirAtSideAndDistance(aSide, 1);
    }

    @Override
    public boolean getAirAtSideAndDistance(byte aSide, int aDistance) {
        return this.getAir(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public TileEntity getTileEntityOffset(int aX, int aY, int aZ) {
        return this.getTileEntity(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public TileEntity getTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        return this.getTileEntity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public DelegatorTileEntity<TileEntity> getAdjacentTileEntity(byte aSide) {
        return this.getAdjacentTileEntity(aSide, true, false);
    }

    @Override
    public DelegatorTileEntity<IInventory> getAdjacentInventory(byte aSide) {
        return this.getAdjacentInventory(aSide, true, false);
    }

    @Override
    public DelegatorTileEntity<ISidedInventory> getAdjacentSidedInventory(byte aSide) {
        return this.getAdjacentSidedInventory(aSide, true, false);
    }

    @Override
    public DelegatorTileEntity<IFluidHandler> getAdjacentTank(byte aSide) {
        return this.getAdjacentTank(aSide, true, false);
    }

    @Override
    public DelegatorTileEntity<IInventory> getAdjacentInventory(byte aSide, boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide, aAllowDelegates, aNotConnectToDelegators);
        return new DelegatorTileEntity<IInventory>(tDelegator.mTileEntity instanceof IInventory ? (IInventory)tDelegator.mTileEntity : null, tDelegator);
    }

    @Override
    public DelegatorTileEntity<ISidedInventory> getAdjacentSidedInventory(byte aSide, boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide, aAllowDelegates, aNotConnectToDelegators);
        return new DelegatorTileEntity<ISidedInventory>(tDelegator.mTileEntity instanceof ISidedInventory ? (ISidedInventory)tDelegator.mTileEntity : null, tDelegator);
    }

    @Override
    public DelegatorTileEntity<IFluidHandler> getAdjacentTank(byte aSide, boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide, aAllowDelegates, aNotConnectToDelegators);
        return new DelegatorTileEntity<IFluidHandler>(tDelegator.mTileEntity instanceof IFluidHandler ? (IFluidHandler)tDelegator.mTileEntity : null, tDelegator);
    }

    @Override
    public DelegatorTileEntity<TileEntity> getAdjacentTileEntity(byte aSide, boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, 1);
        if (tTileEntity == null) {
            return new DelegatorTileEntity<Object>(null, this.field_145850_b, this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), CS.OPPOSITES[aSide]);
        }
        if (aNotConnectToDelegators && tTileEntity instanceof ITileEntityCanDelegate && ((ITileEntityCanDelegate)tTileEntity).isExtender(aSide)) {
            return new DelegatorTileEntity<Object>(null, this.field_145850_b, this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), CS.OPPOSITES[aSide]);
        }
        if (aAllowDelegates && tTileEntity instanceof ITileEntityDelegating) {
            return ((ITileEntityDelegating)tTileEntity).getDelegateTileEntity(CS.OPPOSITES[aSide]);
        }
        return new DelegatorTileEntity<TileEntity>(tTileEntity, tTileEntity.func_145831_w(), tTileEntity.field_145851_c, tTileEntity.field_145848_d, tTileEntity.field_145849_e, CS.OPPOSITES[aSide]);
    }

    public List<DelegatorTileEntity<TileEntity>> allAdjacentTileEntities(boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        ArrayListNoNulls<DelegatorTileEntity<TileEntity>> rDelegates = new ArrayListNoNulls<DelegatorTileEntity<TileEntity>>();
        for (byte tSide : CS.ALL_SIDES_VALID) {
            DelegatorTileEntity<TileEntity> tDelegate = this.getAdjacentTileEntity(tSide, aAllowDelegates, aNotConnectToDelegators);
            if (tDelegate.mTileEntity == null) continue;
            rDelegates.add(tDelegate);
        }
        return rDelegates;
    }

    @Override
    public Block getBlock(int aX, int aY, int aZ) {
        if (this.field_145850_b == null) {
            return CS.NB;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return CS.NB;
        }
        return this.field_145850_b.func_147439_a(aX, aY, aZ);
    }

    @Override
    public byte getMetaData(int aX, int aY, int aZ) {
        if (this.field_145850_b == null) {
            return 0;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return 0;
        }
        return (byte)this.field_145850_b.func_72805_g(aX, aY, aZ);
    }

    @Override
    public byte getLightLevel(int aX, int aY, int aZ) {
        if (this.field_145850_b == null) {
            return 14;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return 0;
        }
        return UT.Code.bind4((long)this.field_145850_b.func_72801_o(aX, aY, aZ) * 15L);
    }

    @Override
    public boolean getSky(int aX, int aY, int aZ) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return true;
        }
        return this.field_145850_b.func_72937_j(aX, aY, aZ);
    }

    @Override
    public boolean getRain(int aX, int aY, int aZ) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return true;
        }
        return this.field_145850_b.func_72874_g(aX, aZ) <= aY;
    }

    @Override
    public boolean getOpacity(int aX, int aY, int aZ) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return false;
        }
        return this.field_145850_b.func_147439_a(aX, aY, aZ).func_149662_c();
    }

    @Override
    public boolean getAir(int aX, int aY, int aZ) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return true;
        }
        return this.field_145850_b.func_147439_a(aX, aY, aZ).isAir((IBlockAccess)this.field_145850_b, aX, aY, aZ);
    }

    @Override
    public TileEntity getTileEntity(int aX, int aY, int aZ) {
        if (this.field_145850_b == null) {
            return null;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return null;
        }
        return UT.Worlds.getTileEntity(this.field_145850_b, aX, aY, aZ, true);
    }

    @Override
    public Block getBlock(ChunkCoordinates aCoords) {
        if (this.field_145850_b == null) {
            return CS.NB;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.field_145850_b.func_72899_e(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c)) {
            return CS.NB;
        }
        return this.field_145850_b.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public byte getMetaData(ChunkCoordinates aCoords) {
        if (this.field_145850_b == null) {
            return 0;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.field_145850_b.func_72899_e(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c)) {
            return 0;
        }
        return (byte)this.field_145850_b.func_72805_g(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public byte getLightLevel(ChunkCoordinates aCoords) {
        if (this.field_145850_b == null) {
            return 14;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.field_145850_b.func_72899_e(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c)) {
            return 0;
        }
        return UT.Code.bind4((long)this.field_145850_b.func_72801_o(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c) * 15L);
    }

    @Override
    public boolean getSky(ChunkCoordinates aCoords) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.field_145850_b.func_72899_e(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c)) {
            return true;
        }
        return this.field_145850_b.func_72937_j(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public boolean getRain(ChunkCoordinates aCoords) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.field_145850_b.func_72899_e(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c)) {
            return true;
        }
        return this.field_145850_b.func_72874_g(aCoords.field_71574_a, aCoords.field_71573_c) <= aCoords.field_71572_b;
    }

    @Override
    public boolean getOpacity(ChunkCoordinates aCoords) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.field_145850_b.func_72899_e(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c)) {
            return false;
        }
        return this.field_145850_b.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c).func_149662_c();
    }

    @Override
    public boolean getAir(ChunkCoordinates aCoords) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.field_145850_b.func_72899_e(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c)) {
            return true;
        }
        return this.field_145850_b.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c).isAir((IBlockAccess)this.field_145850_b, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public TileEntity getTileEntity(ChunkCoordinates aCoords) {
        if (this.field_145850_b == null) {
            return null;
        }
        if (this.mIgnoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.field_145850_b.func_72899_e(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c)) {
            return null;
        }
        return UT.Worlds.getTileEntity(this.field_145850_b, aCoords, true);
    }

    @Override
    public void sendBlockEvent(byte aID, byte aValue) {
        CS.NW_API.sendToAllPlayersInRange(new PacketBlockEvent(this.getCoords(), aID, aValue), this.field_145850_b, this.getCoords());
    }

    @Override
    public boolean isDead() {
        return this.mIsDead;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.setDead();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.setAlive();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.setDead();
    }

    @Optional.Method(modid="IC2")
    private void loadIntoEnet() {
        if (this instanceof IEnergyTile && (this.isEnergyType(TD.Energy.EU, (byte)6, true) || this.isEnergyType(TD.Energy.EU, (byte)6, false))) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.mIsAddedToEnet = true;
        } else {
            this.mDoEnetCheck = false;
        }
    }

    @Optional.Method(modid="IC2")
    private void unloadFromEnet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        this.mIsAddedToEnet = false;
    }

    protected void doEnetUpdate() {
        if (this.isServerSide() && this.mIsAddedToEnet && this.mDoEnetCheck) {
            try {
                this.unloadFromEnet();
                this.loadIntoEnet();
            }
            catch (Throwable e) {
                this.mDoEnetCheck = false;
            }
        }
    }

    protected void setDead() {
        if (!this.mIsDead) {
            this.mIsDead = true;
            if (this.isServerSide() && this.mIsAddedToEnet) {
                try {
                    this.unloadFromEnet();
                }
                catch (Throwable e) {
                    this.mDoEnetCheck = false;
                }
            }
        }
    }

    protected void setAlive() {
        this.mIsDead = false;
    }

    public void func_145845_h() {
        this.setAlive();
        if (this.isServerSide() && !this.mIsAddedToEnet && this.mDoEnetCheck) {
            try {
                this.loadIntoEnet();
            }
            catch (Throwable e) {
                this.mDoEnetCheck = false;
            }
        }
        if (this.mExplosionStrength > 0.0f) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.mExplosionStrength < 1.0f) {
                UT.Sounds.send(this.field_145850_b, "random.explode", 1.0f, 1.0f, this.getCoords());
            } else {
                this.field_145850_b.func_72885_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.mExplosionStrength, false, true);
            }
            this.setDead();
            return;
        }
        if (this.mDoesBlockUpdate) {
            this.doBlockUpdate();
            this.mDoesBlockUpdate = false;
        }
    }

    @Override
    public long getTimer() {
        return 0L;
    }

    public boolean canUpdate() {
        return this.mIsTicking && this.mShouldRefresh;
    }

    public boolean shouldRefresh(Block aOldBlock, Block aNewBlock, int aOldMeta, int aNewMeta, World aWorld, int aX, int aY, int aZ) {
        return this.mShouldRefresh;
    }

    public final void causeBlockUpdate() {
        if (this.mIsTicking) {
            this.mDoesBlockUpdate = true;
        } else {
            this.doBlockUpdate();
        }
    }

    public void doBlockUpdate() {
        Block tBlock = this.getBlock(this.getCoords());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        if (this instanceof IMultiTileEntity.IMTE_IsProvidingStrongPower) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (!this.getBlockAtSide(tSide).isNormalCube((IBlockAccess)this.field_145850_b, this.field_145851_c + CS.OFFSETS_X[tSide], this.field_145848_d + CS.OFFSETS_Y[tSide], this.field_145849_e + CS.OFFSETS_Z[tSide])) continue;
                this.field_145850_b.func_147441_b(this.field_145851_c + CS.OFFSETS_X[tSide], this.field_145848_d + CS.OFFSETS_Y[tSide], this.field_145849_e + CS.OFFSETS_Z[tSide], tBlock, (int)tSide);
            }
        }
    }

    public final boolean crossedChunkBorder(int aX, int aZ) {
        return aX >> 4 != this.field_145851_c >> 4 || aZ >> 4 != this.field_145849_e >> 4;
    }

    public final boolean crossedChunkBorder(ChunkCoordinates aCoords) {
        return aCoords.field_71574_a >> 4 != this.field_145851_c >> 4 || aCoords.field_71573_c >> 4 != this.field_145849_e >> 4;
    }

    public void explode() {
        this.explode(4.0);
    }

    public void explode(double aStrength) {
        this.mExplosionStrength = (float)Math.max(aStrength, (double)this.mExplosionStrength);
        if (!this.mIsTicking) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.mExplosionStrength < 1.0f) {
                UT.Sounds.send(this.field_145850_b, "random.explode", 1.0f, 1.0f, this.getCoords());
            } else {
                this.field_145850_b.func_72885_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.mExplosionStrength, false, true);
            }
        }
    }

    public void overcharge(long aVoltage, TagData aEnergyType) {
        if (CS.OVERCHARGE_EXPLOSIONS) {
            if (TD.Energy.ALL_EXPLODING.contains(aEnergyType)) {
                this.explode(UT.Code.tierMax(aVoltage));
            } else {
                this.explode(0.1);
            }
        }
        UT.Sounds.send(this.field_145850_b, TD.Energy.ALL_ELECTRIC.contains(aEnergyType) ? CS.SFX.IC_MACHINE_OVERLOAD : (TD.Energy.ALL_KINETIC.contains(aEnergyType) ? CS.SFX.IC_MACHINE_INTERRUPT : "random.explode"), 1.0f, 1.0f, this.getCoords());
        CS.DEB.println("Machine overcharged with: " + aVoltage + " " + aEnergyType.getLocalisedNameLong());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGUIClient(int aGUIID, EntityPlayer aPlayer) {
        return null;
    }

    @Override
    public Object getGUIServer(int aGUIID, EntityPlayer aPlayer) {
        return null;
    }

    public void killGUIs() {
        for (Object tPlayer : this.field_145850_b.field_73010_i) {
            if (!(tPlayer instanceof EntityPlayer) || !(((EntityPlayer)tPlayer).field_71070_bA instanceof ContainerCommon) || ((ContainerCommon)((EntityPlayer)tPlayer).field_71070_bA).mTileEntity != this) continue;
            ((EntityPlayer)tPlayer).func_71053_j();
        }
    }

    public void rebootGUIs(int aGUIID) {
        for (Object tPlayer : this.field_145850_b.field_73010_i) {
            if (!(tPlayer instanceof EntityPlayer) || !(((EntityPlayer)tPlayer).field_71070_bA instanceof ContainerCommon) || ((ContainerCommon)((EntityPlayer)tPlayer).field_71070_bA).mTileEntity != this) continue;
            ((EntityPlayer)tPlayer).func_71053_j();
            this.openGUI((EntityPlayer)tPlayer, aGUIID);
        }
    }

    public long getOpenGUIs() {
        long rGUIs = 0L;
        for (Object tPlayer : this.field_145850_b.field_73010_i) {
            if (!(tPlayer instanceof EntityPlayer) || !(((EntityPlayer)tPlayer).field_71070_bA instanceof ContainerCommon) || ((ContainerCommon)((EntityPlayer)tPlayer).field_71070_bA).mTileEntity != this) continue;
            ++rGUIs;
        }
        return rGUIs;
    }

    public boolean shouldSideBeRendered(byte aSide) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, 1);
        return tTileEntity instanceof ITileEntitySurface ? !((ITileEntitySurface)tTileEntity).isSurfaceOpaque(CS.OPPOSITES[aSide]) : !UT.Worlds.isVisuallyOpaque(this.field_145850_b, this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), true, true);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderItem(Block aBlock, RenderBlocks aRenderer) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderBlock(Block aBlock, RenderBlocks aRenderer) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean usesRenderPass(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderFullBlockSide(Block aBlock, RenderBlocks aRenderer, byte aSide) {
        return this.shouldSideBeRendered(aSide);
    }

    @SideOnly(value=Side.CLIENT)
    public final IRenderedBlockObject passRenderingToObject(ItemStack aStack) {
        return this.ERROR_MESSAGE == null ? this.passRenderingToObject2(aStack) : IRenderedBlockObject.ErrorRenderer.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public final IRenderedBlockObject passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.ERROR_MESSAGE == null ? this.passRenderingToObject2(aWorld, aX, aY, aZ) : IRenderedBlockObject.ErrorRenderer.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderedBlockObject passRenderingToObject2(ItemStack aStack) {
        return (IRenderedBlockObject)((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderedBlockObject passRenderingToObject2(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return (IRenderedBlockObject)((Object)this);
    }

    protected void updateInventory() {
    }

    public void playClick() {
        UT.Sounds.send(this.field_145850_b, "random.click", 1.0f, 1.0f, this.getCoords());
    }

    public void updateLightValue() {
        if (this instanceof IMultiTileEntity.IMTE_GetLightValue) {
            this.field_145850_b.func_72915_b(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e, ((IMultiTileEntity.IMTE_GetLightValue)((Object)this)).getLightValue());
            for (byte tSide : CS.ALL_SIDES_MIDDLE) {
                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c + CS.OFFSETS_X[tSide], this.field_145848_d + CS.OFFSETS_Y[tSide], this.field_145849_e + CS.OFFSETS_Z[tSide]);
            }
        }
    }

    @Override
    public boolean hasRedstoneIncoming() {
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (this.getRedstoneIncoming(tSide) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte getRedstoneIncoming(byte aSide) {
        if (CS.SIDES_INVALID[aSide]) {
            byte rRedstone = 0;
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if ((rRedstone = (byte)Math.max(rRedstone, this.field_145850_b.func_72878_l(this.getOffsetX(tSide), this.getOffsetY(tSide), this.getOffsetZ(tSide), (int)tSide))) < 15) continue;
                return 15;
            }
            return rRedstone;
        }
        return UT.Code.bind4(this.field_145850_b.func_72878_l(this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), (int)aSide));
    }

    @Override
    public byte getComparatorIncoming(byte aSide) {
        Block tBlock = this.getBlockAtSide(aSide);
        return tBlock.func_149740_M() ? UT.Code.bind4(tBlock.func_149736_g(this.field_145850_b, this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), (int)CS.OPPOSITES[aSide])) : this.getRedstoneIncoming(aSide);
    }

    protected IFluidTank getFluidTankFillable(byte aSide, FluidStack aFluidToFill) {
        return null;
    }

    protected IFluidTank getFluidTankDrainable(byte aSide, FluidStack aFluidToDrain) {
        return null;
    }

    protected IFluidTank[] getFluidTanks(byte aSide) {
        return CS.ZL_IFLUIDTANK;
    }

    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null || aFluid.amount <= 0) {
            return 0;
        }
        IFluidTank tTank = this.getFluidTankFillable(UT.Code.side(aDirection), aFluid);
        if (tTank == null) {
            return 0;
        }
        int rFilledAmount = tTank.fill(aFluid, aDoFill);
        if (rFilledAmount > 0 && aDoFill) {
            this.updateInventory();
        }
        return rFilledAmount;
    }

    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        if (aFluid == null || aFluid.amount <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(UT.Code.side(aDirection), aFluid);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0 || !tTank.getFluid().isFluidEqual(aFluid)) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aFluid.amount, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.updateInventory();
        }
        return rDrained;
    }

    public FluidStack drain(ForgeDirection aDirection, int aAmountToDrain, boolean aDoDrain) {
        if (aAmountToDrain <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(UT.Code.side(aDirection), null);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aAmountToDrain, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.updateInventory();
        }
        return rDrained;
    }

    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankFillable(UT.Code.side(aDirection), new FluidStack(aFluid, 0));
        return tTank != null && (tTank.getFluid() == null || tTank.getFluid().getFluid() == aFluid);
    }

    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankDrainable(UT.Code.side(aDirection), new FluidStack(aFluid, 0));
        return tTank != null && tTank.getFluid() != null && tTank.getFluid().getFluid() == aFluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aDirection) {
        IFluidTank[] tTanks = this.getFluidTanks(UT.Code.side(aDirection));
        if (tTanks == null || tTanks.length <= 0) {
            return CS.ZL_FLUIDTANKINFO;
        }
        FluidTankInfo[] rInfo = new FluidTankInfo[tTanks.length];
        for (int i = 0; i < tTanks.length; ++i) {
            rInfo[i] = new FluidTankInfo(tTanks[i]);
        }
        return rInfo;
    }

    protected IFluidTank getFluidTankFillable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToFill) {
        return this.getFluidTankFillable(aSide, aFluidToFill);
    }

    protected IFluidTank getFluidTankDrainable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToDrain) {
        return this.getFluidTankDrainable(aSide, aFluidToDrain);
    }

    protected IFluidTank[] getFluidTanks(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getFluidTanks(aSide);
    }

    public int fill(MultiTileEntityMultiBlockPart aPart, byte aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null || aFluid.amount <= 0) {
            return 0;
        }
        IFluidTank tTank = this.getFluidTankFillable(aPart, UT.Code.side(aDirection), aFluid);
        if (tTank == null) {
            return 0;
        }
        int rFilledAmount = tTank.fill(aFluid, aDoFill);
        if (rFilledAmount > 0 && aDoFill) {
            this.updateInventory();
        }
        return rFilledAmount;
    }

    public FluidStack drain(MultiTileEntityMultiBlockPart aPart, byte aDirection, FluidStack aFluid, boolean aDoDrain) {
        if (aFluid == null || aFluid.amount <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, UT.Code.side(aDirection), aFluid);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0 || !tTank.getFluid().isFluidEqual(aFluid)) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aFluid.amount, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.updateInventory();
        }
        return rDrained;
    }

    public FluidStack drain(MultiTileEntityMultiBlockPart aPart, byte aDirection, int aAmountToDrain, boolean aDoDrain) {
        if (aAmountToDrain <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, UT.Code.side(aDirection), null);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aAmountToDrain, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.updateInventory();
        }
        return rDrained;
    }

    public boolean canFill(MultiTileEntityMultiBlockPart aPart, byte aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankFillable(aPart, UT.Code.side(aDirection), new FluidStack(aFluid, 0));
        return tTank != null && (tTank.getFluid() == null || tTank.getFluid().getFluid() == aFluid);
    }

    public boolean canDrain(MultiTileEntityMultiBlockPart aPart, byte aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, UT.Code.side(aDirection), new FluidStack(aFluid, 0));
        return tTank != null && tTank.getFluid() != null && tTank.getFluid().getFluid() == aFluid;
    }

    public FluidTankInfo[] getTankInfo(MultiTileEntityMultiBlockPart aPart, byte aDirection) {
        IFluidTank[] tTanks = this.getFluidTanks(aPart, UT.Code.side(aDirection));
        if (tTanks == null || tTanks.length <= 0) {
            return CS.ZL_FLUIDTANKINFO;
        }
        FluidTankInfo[] rInfo = new FluidTankInfo[tTanks.length];
        for (int i = 0; i < tTanks.length; ++i) {
            rInfo[i] = new FluidTankInfo(tTanks[i]);
        }
        return rInfo;
    }

    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        return 0L;
    }

    public long doExtract(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoExtract) {
        return 0L;
    }

    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return false;
    }

    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return false;
    }

    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    public Collection<TagData> getEnergyTypes(byte aSide) {
        return Collections.EMPTY_LIST;
    }

    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        return Collections.EMPTY_LIST;
    }

    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, true) && this.getSurfaceSizeAttachable(aSide) > 0.0f;
    }

    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, false) && this.getSurfaceSizeAttachable(aSide) > 0.0f;
    }

    public synchronized long doEnergyExtraction(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoExtract) {
        return aSize != 0L && this.isEnergyEmittingTo(aEnergyType, aSide, false) && (TD.Energy.ALL_SIZE_IRRELEVANT.contains(aEnergyType) || Math.abs(aSize) >= this.getEnergySizeOutputMin(aEnergyType, aSide)) ? this.doExtract(aEnergyType, aSide, aSize, aAmount, aDoExtract) : 0L;
    }

    public synchronized long doEnergyInjection(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        return aSize != 0L && this.isEnergyAcceptingFrom(aEnergyType, aSide, false) && (TD.Energy.ALL_SIZE_IRRELEVANT.contains(aEnergyType) || Math.abs(aSize) >= this.getEnergySizeInputMin(aEnergyType, aSide)) ? this.doInject(aEnergyType, aSide, aSize, aAmount, aDoInject) : 0L;
    }

    public long getEnergyOffered(TagData aEnergyType, byte aSide, long aSize) {
        return 0L;
    }

    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return this.getEnergySizeOutputRecommended(aEnergyType, aSide) / 2L;
    }

    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.getEnergySizeOutputRecommended(aEnergyType, aSide) * 2L;
    }

    public long getEnergyDemanded(TagData aEnergyType, byte aSide, long aSize) {
        return 0L;
    }

    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return this.getEnergySizeInputRecommended(aEnergyType, aSide) / 2L;
    }

    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return this.getEnergySizeInputRecommended(aEnergyType, aSide) * 2L;
    }

    public boolean isEnergyType(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, boolean aEmitting) {
        return this.isEnergyType(aEnergyType, aSide, aEmitting);
    }

    public boolean isEnergyCapacitorType(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.isEnergyCapacitorType(aEnergyType, aSide);
    }

    public long getEnergyStored(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergyStored(aEnergyType, aSide);
    }

    public long getEnergyCapacity(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergyCapacity(aEnergyType, aSide);
    }

    public Collection<TagData> getEnergyTypes(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getEnergyTypes(aSide);
    }

    public Collection<TagData> getEnergyCapacitorTypes(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getEnergyCapacitorTypes(aSide);
    }

    public boolean isEnergyAcceptingFrom(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical);
    }

    public boolean isEnergyEmittingTo(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    public long doEnergyInjection(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        return this.doEnergyInjection(aEnergyType, aSide, aSize, aAmount, aDoInject);
    }

    public long doEnergyExtraction(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoExtract) {
        return this.doEnergyExtraction(aEnergyType, aSide, aSize, aAmount, aDoExtract);
    }

    public long getEnergyOffered(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, long aSize) {
        return this.getEnergyOffered(aEnergyType, aSide, aSize);
    }

    public long getEnergySizeOutputRecommended(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergySizeOutputRecommended(aEnergyType, aSide);
    }

    public long getEnergySizeOutputMin(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergySizeOutputMin(aEnergyType, aSide);
    }

    public long getEnergySizeOutputMax(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergySizeOutputMax(aEnergyType, aSide);
    }

    public long getEnergyDemanded(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide, long aSize) {
        return this.getEnergyDemanded(aEnergyType, aSide, aSize);
    }

    public long getEnergySizeInputRecommended(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergySizeInputRecommended(aEnergyType, aSide);
    }

    public long getEnergySizeInputMin(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergySizeInputMin(aEnergyType, aSide);
    }

    public long getEnergySizeInputMax(MultiTileEntityMultiBlockPart aPart, TagData aEnergyType, byte aSide) {
        return this.getEnergySizeInputMax(aEnergyType, aSide);
    }

    public boolean canConnectEnergy(ForgeDirection aDirection) {
        for (TagData tTag : TD.Energy.ALL_RF) {
            if (!this.isEnergyEmittingTo(tTag, UT.Code.side(aDirection), true)) continue;
            return true;
        }
        return this.isEnergyAcceptingFrom(TD.Energy.RF, UT.Code.side(aDirection), true);
    }

    public int receiveEnergy(ForgeDirection aDirection, int aSize, boolean aSimulate) {
        return (int)this.doEnergyInjection(TD.Energy.RF, UT.Code.side(aDirection), aSize, 1L, !aSimulate) * aSize;
    }

    public int extractEnergy(ForgeDirection aDirection, int aSize, boolean aSimulate) {
        return (int)this.doEnergyExtraction(TD.Energy.RF, UT.Code.side(aDirection), aSize, 1L, !aSimulate) * aSize;
    }

    public int getEnergyStored(ForgeDirection aDirection) {
        return UT.Code.bindInt(this.getEnergyCapacity(TD.Energy.RF, UT.Code.side(aDirection)));
    }

    public int getMaxEnergyStored(ForgeDirection aDirection) {
        return UT.Code.bindInt(this.getEnergyCapacity(TD.Energy.RF, UT.Code.side(aDirection)));
    }

    public int getSinkTier() {
        return UT.Code.tierMax(this.getEnergySizeInputRecommended(TD.Energy.EU, (byte)6));
    }

    public int getSourceTier() {
        return UT.Code.tierMax(this.getEnergySizeOutputRecommended(TD.Energy.EU, (byte)6));
    }

    public boolean acceptsEnergyFrom(TileEntity aEmitter, ForgeDirection aDirection) {
        return !(aEmitter instanceof ITileEntityEnergy) && this.isEnergyAcceptingFrom(TD.Energy.EU, UT.Code.side(aDirection), true);
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, ForgeDirection aDirection) {
        return !(aReceiver instanceof ITileEntityEnergy) && this.isEnergyEmittingTo(TD.Energy.EU, UT.Code.side(aDirection), true);
    }

    public double getDemandedEnergy() {
        return this.getEnergySizeInputMax(TD.Energy.EU, (byte)6);
    }

    public double injectEnergy(ForgeDirection aDirection, double aAmount, double aSize) {
        return aAmount - ((aSize = Math.min(aSize, aAmount)) <= 0.0 ? aAmount * (double)this.doEnergyInjection(TD.Energy.EU, UT.Code.side(aDirection), (long)aAmount, 1L, true) : aSize * (double)this.doEnergyInjection(TD.Energy.EU, UT.Code.side(aDirection), (long)aSize, (long)(aAmount / aSize), true));
    }

    public boolean doDefaultStructuralChecks() {
        for (TagData tEnergyType : this.getEnergyTypes((byte)6)) {
            if (TD.Energy.ALL_WEAK_TO_FIRE.contains(tEnergyType)) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (this.isFireProof(tSide) || !(this.getBlockAtSide(tSide) instanceof BlockFire) || this.getRandomNumber(10) != 0) continue;
                    if (CS.FIRE_EXPLOSIONS) {
                        if (TD.Energy.ALL_EXPLODING.contains(tEnergyType)) {
                            this.explode(4.0);
                        } else {
                            this.explode(0.1);
                        }
                    }
                    UT.Sounds.send(this.field_145850_b, TD.Energy.ALL_ELECTRIC.contains(tEnergyType) ? CS.SFX.IC_MACHINE_OVERLOAD : (TD.Energy.ALL_KINETIC.contains(tEnergyType) ? CS.SFX.IC_MACHINE_INTERRUPT : "random.explode"), 1.0f, 1.0f, this.getCoords());
                    CS.DEB.println("Machine came into contact with Fire - Energy Type: " + tEnergyType.getLocalisedNameLong());
                    return false;
                }
            }
            if (TD.Energy.ALL_WEAK_TO_WATER.contains(tEnergyType)) {
                for (byte tSide : CS.ALL_SIDES_BUT_BOTTOM) {
                    if (!this.isWaterProof(tSide) && this.getBlockAtSide(tSide) == Blocks.field_150355_j) {
                        if (CS.WATER_EXPLOSIONS) {
                            if (TD.Energy.ALL_EXPLODING.contains(tEnergyType)) {
                                this.explode(4.0);
                            } else {
                                this.explode(0.1);
                            }
                        }
                        UT.Sounds.send(this.field_145850_b, TD.Energy.ALL_ELECTRIC.contains(tEnergyType) ? CS.SFX.IC_MACHINE_OVERLOAD : (TD.Energy.ALL_KINETIC.contains(tEnergyType) ? CS.SFX.IC_MACHINE_INTERRUPT : "random.explode"), 1.0f, 1.0f, this.getCoords());
                        CS.DEB.println("Machine came into contact with Water - Energy Type: " + tEnergyType.getLocalisedNameLong());
                        return false;
                    }
                    if (this.isRainProof(tSide) || !this.field_145850_b.func_72896_J() || !(this.getBiome().field_76751_G > 0.0f) || this.getRandomNumber(100) != 0 || !this.getRainAtSide(tSide)) continue;
                    if (CS.RAIN_EXPLOSIONS) {
                        if (TD.Energy.ALL_EXPLODING.contains(tEnergyType)) {
                            this.explode(4.0);
                        } else {
                            this.explode(0.1);
                        }
                    }
                    UT.Sounds.send(this.field_145850_b, TD.Energy.ALL_ELECTRIC.contains(tEnergyType) ? CS.SFX.IC_MACHINE_OVERLOAD : (TD.Energy.ALL_KINETIC.contains(tEnergyType) ? CS.SFX.IC_MACHINE_INTERRUPT : "random.explode"), 1.0f, 1.0f, this.getCoords());
                    CS.DEB.println("Machine came into contact with Rain - Energy Type: " + tEnergyType.getLocalisedNameLong());
                    return false;
                }
            }
            if (!TD.Energy.ALL_WEAK_TO_THUNDER.contains(tEnergyType)) continue;
            for (byte tSide : CS.ALL_SIDES_BUT_BOTTOM) {
                if (this.isThunderProof(tSide) || !this.field_145850_b.func_72911_I() || this.getRandomNumber(1000) != 0 || !this.getRainAtSide(tSide)) continue;
                if (CS.THUNDER_EXPLOSIONS) {
                    if (TD.Energy.ALL_EXPLODING.contains(tEnergyType)) {
                        this.explode(4.0);
                    } else {
                        this.explode(0.1);
                    }
                }
                UT.Sounds.send(this.field_145850_b, TD.Energy.ALL_ELECTRIC.contains(tEnergyType) ? CS.SFX.IC_MACHINE_OVERLOAD : (TD.Energy.ALL_KINETIC.contains(tEnergyType) ? CS.SFX.IC_MACHINE_INTERRUPT : "random.explode"), 1.0f, 1.0f, this.getCoords());
                CS.DEB.println("Machine came into contact with Thunder - Energy Type: " + tEnergyType.getLocalisedNameLong());
                return false;
            }
        }
        return true;
    }

    public boolean isFireProof(byte aSide) {
        return false;
    }

    public boolean isRainProof(byte aSide) {
        return false;
    }

    public boolean isWaterProof(byte aSide) {
        return false;
    }

    public boolean isThunderProof(byte aSide) {
        return false;
    }

    public float getSurfaceSize(byte aSide) {
        return 1.0f;
    }

    public float getSurfaceSizeAttachable(byte aSide) {
        return this.getSurfaceSize(aSide);
    }

    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    public boolean isSurfaceSolid(byte aSide) {
        return this.isSurfaceOpaque(aSide);
    }

    public boolean isSurfaceOpaque(byte aSide) {
        return true;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public int getFireSpreadSpeed(byte aSide) {
        return this.getBlockOffset(0, 0, 0).func_149688_o().func_76217_h() ? 150 : 0;
    }

    public int getFlammability(byte aSide) {
        return this.getBlockOffset(0, 0, 0).func_149688_o().func_76217_h() ? 150 : 0;
    }

    public void setOnFire() {
        UT.Worlds.setOnFire(this.field_145850_b, this.getCoords(), false, false);
    }

    public void setToFire() {
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150480_ab);
    }

    public boolean allowInteraction(Entity aEntity) {
        return true;
    }

    public boolean allowRightclick(Entity aEntity) {
        return this.allowInteraction(aEntity);
    }

    public boolean hasMultiBlockMachineRelevantData() {
        return false;
    }

    @Override
    public void setError(String aError) {
        this.ERROR_MESSAGE = aError;
        if (this.isServerSide()) {
            CS.NW_API.sendToAllPlayersInRange(new PacketBlockError(this.getCoords(), this.ERROR_MESSAGE), this.field_145850_b, this.getCoords());
        }
    }
}

