/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity;

import gregapi.GT_API;
import gregapi.code.HashSetNoNulls;
import gregapi.data.CS;
import gregapi.util.UT;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public interface ITileEntityMachineBlockUpdateable {
    public void onMachineBlockUpdate(ChunkCoordinates var1, Block var2, byte var3, boolean var4);

    public static class Util {
        public static final Map<Block, Integer> MACHINE_BLOCKS = new HashMap<Block, Integer>();

        public static boolean causeMachineUpdate(World aWorld, ChunkCoordinates aCoords, Block aBlock, byte aMeta, boolean aRemoved) {
            if (!aWorld.field_72995_K) {
                new Thread((Runnable)new MachineBlockUpdateRunnable(aWorld, aCoords, aBlock, aMeta, aRemoved), "Machine Block Updating").start();
            }
            return true;
        }

        public static boolean registerMachineBlock(Block aBlock, int aMeta) {
            if (aBlock == null) {
                return false;
            }
            if (GT_API.sCompatTC != null) {
                GT_API.sCompatTC.registerPortholeBlacklistedBlock(aBlock);
            }
            MACHINE_BLOCKS.put(aBlock, aMeta);
            return true;
        }

        public static boolean registerMachineBlock(Block aBlock, boolean ... aMeta) {
            if (aBlock == null || aMeta == null || aMeta.length == 0) {
                return false;
            }
            if (GT_API.sCompatTC != null) {
                GT_API.sCompatTC.registerPortholeBlacklistedBlock(aBlock);
            }
            int rMeta = 0;
            for (int i = 0; i < aMeta.length && i < 16; i = (int)((byte)(i + 1))) {
                if (!aMeta[i]) continue;
                rMeta |= CS.B[i];
            }
            MACHINE_BLOCKS.put(aBlock, rMeta);
            return true;
        }

        public static boolean isMachineBlock(Block aBlock, int aMeta) {
            if (aBlock == Blocks.field_150350_a) {
                return false;
            }
            Integer tNumber = MACHINE_BLOCKS.get(aBlock);
            return tNumber != null && (tNumber & CS.B[aMeta]) != 0;
        }

        private static class MachineBlockUpdateRunnable
        implements Runnable {
            private final ChunkCoordinates mCoords;
            private final World mWorld;
            private final Block mBlock;
            private final byte mMeta;
            private final boolean mRemoved;

            public MachineBlockUpdateRunnable(World aWorld, ChunkCoordinates aCoords, Block aBlock, byte aMeta, boolean aRemoved) {
                this.mWorld = aWorld;
                this.mCoords = aCoords;
                this.mBlock = aBlock;
                this.mMeta = aMeta;
                this.mRemoved = aRemoved;
            }

            @Override
            public void run() {
                try {
                    this.stepToUpdateMachine(this.mWorld, this.mCoords, new HashSetNoNulls<ChunkCoordinates>(false, this.mCoords));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            private void stepToUpdateMachine(World aWorld, ChunkCoordinates aCoords, HashSetNoNulls<ChunkCoordinates> aSet) {
                TileEntity tTileEntity = UT.Worlds.getTileEntity(aWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, true);
                if (tTileEntity != null && tTileEntity instanceof ITileEntityMachineBlockUpdateable) {
                    ((ITileEntityMachineBlockUpdateable)tTileEntity).onMachineBlockUpdate(this.mCoords, this.mBlock, this.mMeta, this.mRemoved);
                }
                if (aSet.size() < 5 || tTileEntity != null && tTileEntity instanceof ITileEntityMachineBlockUpdateable || Util.isMachineBlock(aWorld.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c), aWorld.func_72805_g(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c))) {
                    ChunkCoordinates tCoords = new ChunkCoordinates(aCoords.field_71574_a + 1, aCoords.field_71572_b, aCoords.field_71573_c);
                    if (aSet.add(tCoords)) {
                        this.stepToUpdateMachine(aWorld, tCoords, aSet);
                    }
                    if (aSet.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a - 1, aCoords.field_71572_b, aCoords.field_71573_c))) {
                        this.stepToUpdateMachine(aWorld, tCoords, aSet);
                    }
                    if (aSet.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b + 1, aCoords.field_71573_c))) {
                        this.stepToUpdateMachine(aWorld, tCoords, aSet);
                    }
                    if (aSet.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b - 1, aCoords.field_71573_c))) {
                        this.stepToUpdateMachine(aWorld, tCoords, aSet);
                    }
                    if (aSet.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c + 1))) {
                        this.stepToUpdateMachine(aWorld, tCoords, aSet);
                    }
                    if (aSet.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c - 1))) {
                        this.stepToUpdateMachine(aWorld, tCoords, aSet);
                    }
                }
            }
        }
    }
}

