/*
 * Decompiled with CFR 0.152.
 */
package gregapi.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import gregapi.data.CS;
import gregapi.render.IRenderedBlock;
import gregapi.render.IRenderedBlockObject;
import gregapi.render.IRenderedBlockObjectSideCheck;
import gregapi.render.ITexture;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RendererBlockTextured
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public final int mRenderID;
    public static RendererBlockTextured INSTANCE;
    public static NBTTagCompound mUsedNBT;

    public RendererBlockTextured(int aRenderID) {
        INSTANCE = this;
        this.mRenderID = aRenderID;
    }

    public void renderInventoryBlock(Block aBlock, int aMetaData, int aModelID, RenderBlocks aRenderer) {
        aRenderer.func_147775_a(aBlock);
        ItemStack aStack = UT.Stacks.make(aBlock, 1L, (long)aMetaData, mUsedNBT);
        ITexture.Util.startRendering(aRenderer, aBlock, null, 0, 0, 0);
        if (aBlock instanceof IRenderedBlock) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            boolean tNeedsToSetBounds = true;
            IRenderedBlockObject tRenderer = ((IRenderedBlock)aBlock).passRenderingToObject(aStack);
            if (tRenderer != null) {
                tRenderer = tRenderer.passRenderingToObject(aStack);
            }
            if (tRenderer == null) {
                int j = ((IRenderedBlock)aBlock).getRenderPasses(aStack);
                for (int i = 0; i < j; ++i) {
                    if (!((IRenderedBlock)aBlock).usesRenderPass(i, aStack)) continue;
                    Tessellator.field_78398_a.func_78382_b();
                    if (((IRenderedBlock)aBlock).setBlockBounds(i, aStack)) {
                        tNeedsToSetBounds = true;
                        aRenderer.func_147775_a(aBlock);
                    } else {
                        if (tNeedsToSetBounds) {
                            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        }
                        aRenderer.func_147775_a(aBlock);
                        tNeedsToSetBounds = false;
                    }
                    Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
                    RendererBlockTextured.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, ((IRenderedBlock)aBlock).getTexture(i, (byte)0, aStack), !tNeedsToSetBounds, true, aBlock);
                    Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
                    RendererBlockTextured.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, ((IRenderedBlock)aBlock).getTexture(i, (byte)1, aStack), !tNeedsToSetBounds, true, aBlock);
                    Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
                    RendererBlockTextured.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, ((IRenderedBlock)aBlock).getTexture(i, (byte)2, aStack), !tNeedsToSetBounds, true, aBlock);
                    Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
                    RendererBlockTextured.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, ((IRenderedBlock)aBlock).getTexture(i, (byte)3, aStack), !tNeedsToSetBounds, true, aBlock);
                    Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
                    RendererBlockTextured.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, ((IRenderedBlock)aBlock).getTexture(i, (byte)4, aStack), !tNeedsToSetBounds, true, aBlock);
                    Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
                    RendererBlockTextured.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, ((IRenderedBlock)aBlock).getTexture(i, (byte)5, aStack), !tNeedsToSetBounds, true, aBlock);
                    Tessellator.field_78398_a.func_78381_a();
                }
            } else if (!tRenderer.renderItem(aBlock, aRenderer)) {
                int j = tRenderer.getRenderPasses(aBlock, CS.SIDES_VALID);
                for (int i = 0; i < j; ++i) {
                    if (!tRenderer.usesRenderPass(i, CS.SIDES_VALID)) continue;
                    Tessellator.field_78398_a.func_78382_b();
                    if (tRenderer.setBlockBounds(aBlock, i, CS.SIDES_VALID)) {
                        tNeedsToSetBounds = true;
                        aRenderer.func_147775_a(aBlock);
                    } else {
                        if (tNeedsToSetBounds) {
                            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        }
                        aRenderer.func_147775_a(aBlock);
                        tNeedsToSetBounds = false;
                    }
                    Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
                    RendererBlockTextured.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, tRenderer.getTexture(aBlock, i, (byte)0, CS.SIDES_VALID), !tNeedsToSetBounds, true, tRenderer);
                    Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
                    RendererBlockTextured.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, tRenderer.getTexture(aBlock, i, (byte)1, CS.SIDES_VALID), !tNeedsToSetBounds, true, tRenderer);
                    Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
                    RendererBlockTextured.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, tRenderer.getTexture(aBlock, i, (byte)2, CS.SIDES_VALID), !tNeedsToSetBounds, true, tRenderer);
                    Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
                    RendererBlockTextured.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, tRenderer.getTexture(aBlock, i, (byte)3, CS.SIDES_VALID), !tNeedsToSetBounds, true, tRenderer);
                    Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
                    RendererBlockTextured.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, tRenderer.getTexture(aBlock, i, (byte)4, CS.SIDES_VALID), !tNeedsToSetBounds, true, tRenderer);
                    Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
                    RendererBlockTextured.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, tRenderer.getTexture(aBlock, i, (byte)5, CS.SIDES_VALID), !tNeedsToSetBounds, true, tRenderer);
                    Tessellator.field_78398_a.func_78381_a();
                }
            }
            if (tNeedsToSetBounds) {
                aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        aRenderer.func_147775_a(aBlock);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        ITexture.Util.endRendering(aRenderer, aBlock, null, 0, 0, 0);
    }

    public boolean renderWorldBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, int aModelID, RenderBlocks aRenderer) {
        Tessellator.field_78398_a.func_78380_c(983055);
        boolean rReturn = false;
        aRenderer.func_147775_a(aBlock);
        ITexture.Util.startRendering(aRenderer, aBlock, aWorld, aX, aY, aZ);
        if (aBlock instanceof IRenderedBlock) {
            IRenderedBlockObject tRenderer = ((IRenderedBlock)aBlock).passRenderingToObject(aWorld, aX, aY, aZ);
            if (tRenderer != null) {
                tRenderer = tRenderer.passRenderingToObject(aWorld, aX, aY, aZ);
            }
            if (tRenderer == null) {
                boolean tNeedsToSetBounds = true;
                boolean[] tSides = new boolean[6];
                if (aBlock instanceof IRenderedBlockObjectSideCheck) {
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        tSides[tSide] = ((IRenderedBlockObjectSideCheck)aBlock).renderFullBlockSide(aBlock, aRenderer, tSide);
                    }
                } else {
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        tSides[tSide] = aBlock.func_149646_a(aWorld, aX + CS.OFFSETS_X[tSide], aY + CS.OFFSETS_Y[tSide], aZ + CS.OFFSETS_Z[tSide], (int)tSide);
                    }
                }
                int j = ((IRenderedBlock)aBlock).getRenderPasses(aWorld, aX, aY, aZ, tSides);
                for (int i = 0; i < j; ++i) {
                    if (!((IRenderedBlock)aBlock).usesRenderPass(i, aWorld, aX, aY, aZ, tSides)) continue;
                    if (((IRenderedBlock)aBlock).setBlockBounds(i, aWorld, aX, aY, aZ, tSides)) {
                        tNeedsToSetBounds = true;
                        aRenderer.func_147775_a(aBlock);
                    } else {
                        if (tNeedsToSetBounds) {
                            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        }
                        aRenderer.func_147775_a(aBlock);
                        tNeedsToSetBounds = false;
                    }
                    if (RendererBlockTextured.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, ((IRenderedBlock)aBlock).getTexture(i, (byte)0, tSides, aWorld, aX, aY, aZ), !tNeedsToSetBounds, tSides[0], aBlock)) {
                        rReturn = true;
                    }
                    if (RendererBlockTextured.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, ((IRenderedBlock)aBlock).getTexture(i, (byte)1, tSides, aWorld, aX, aY, aZ), !tNeedsToSetBounds, tSides[1], aBlock)) {
                        rReturn = true;
                    }
                    if (RendererBlockTextured.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, ((IRenderedBlock)aBlock).getTexture(i, (byte)2, tSides, aWorld, aX, aY, aZ), !tNeedsToSetBounds, tSides[2], aBlock)) {
                        rReturn = true;
                    }
                    if (RendererBlockTextured.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, ((IRenderedBlock)aBlock).getTexture(i, (byte)3, tSides, aWorld, aX, aY, aZ), !tNeedsToSetBounds, tSides[3], aBlock)) {
                        rReturn = true;
                    }
                    if (RendererBlockTextured.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, ((IRenderedBlock)aBlock).getTexture(i, (byte)4, tSides, aWorld, aX, aY, aZ), !tNeedsToSetBounds, tSides[4], aBlock)) {
                        rReturn = true;
                    }
                    if (!RendererBlockTextured.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, ((IRenderedBlock)aBlock).getTexture(i, (byte)5, tSides, aWorld, aX, aY, aZ), !tNeedsToSetBounds, tSides[5], aBlock)) continue;
                    rReturn = true;
                }
                if (tNeedsToSetBounds) {
                    aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            } else if (tRenderer.renderBlock(aBlock, aRenderer)) {
                rReturn = true;
            } else {
                boolean tNeedsToSetBounds = true;
                boolean[] tSides = new boolean[6];
                if (aBlock instanceof IRenderedBlockObjectSideCheck) {
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        tSides[tSide] = ((IRenderedBlockObjectSideCheck)aBlock).renderFullBlockSide(aBlock, aRenderer, tSide);
                    }
                } else {
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        tSides[tSide] = aBlock.func_149646_a(aWorld, aX + CS.OFFSETS_X[tSide], aY + CS.OFFSETS_Y[tSide], aZ + CS.OFFSETS_Z[tSide], (int)tSide);
                    }
                }
                int j = tRenderer.getRenderPasses(aBlock, tSides);
                for (int i = 0; i < j; ++i) {
                    if (!tRenderer.usesRenderPass(i, tSides)) continue;
                    if (tRenderer.setBlockBounds(aBlock, i, tSides)) {
                        tNeedsToSetBounds = true;
                        aRenderer.func_147775_a(aBlock);
                    } else {
                        if (tNeedsToSetBounds) {
                            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        }
                        aRenderer.func_147775_a(aBlock);
                        tNeedsToSetBounds = false;
                    }
                    if (RendererBlockTextured.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tRenderer.getTexture(aBlock, i, (byte)0, tSides), !tNeedsToSetBounds, tSides[0], tRenderer)) {
                        rReturn = true;
                    }
                    if (RendererBlockTextured.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tRenderer.getTexture(aBlock, i, (byte)1, tSides), !tNeedsToSetBounds, tSides[1], tRenderer)) {
                        rReturn = true;
                    }
                    if (RendererBlockTextured.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tRenderer.getTexture(aBlock, i, (byte)2, tSides), !tNeedsToSetBounds, tSides[2], tRenderer)) {
                        rReturn = true;
                    }
                    if (RendererBlockTextured.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tRenderer.getTexture(aBlock, i, (byte)3, tSides), !tNeedsToSetBounds, tSides[3], tRenderer)) {
                        rReturn = true;
                    }
                    if (RendererBlockTextured.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tRenderer.getTexture(aBlock, i, (byte)4, tSides), !tNeedsToSetBounds, tSides[4], tRenderer)) {
                        rReturn = true;
                    }
                    if (!RendererBlockTextured.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tRenderer.getTexture(aBlock, i, (byte)5, tSides), !tNeedsToSetBounds, tSides[5], tRenderer)) continue;
                    rReturn = true;
                }
                if (tNeedsToSetBounds) {
                    aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
        aRenderer.func_147775_a(aBlock);
        ITexture.Util.endRendering(aRenderer, aBlock, aWorld, aX, aY, aZ);
        return rReturn;
    }

    public static boolean renderNegativeYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture aIcon, boolean aFullBlock, boolean aShouldSideBeRendered, Object aRenderedBlockObject) {
        if (aIcon == null || !aIcon.isValidTexture()) {
            return false;
        }
        int aBrightness = 240;
        if (aWorld != null) {
            if (aFullBlock && !aShouldSideBeRendered) {
                return false;
            }
            aBrightness = aBlock.func_149677_c(aWorld, aX, aFullBlock ? aY - 1 : aY, aZ);
            aRenderer.field_147863_w = true;
        }
        aIcon.renderYNeg(aRenderer, aBlock, aX, aY, aZ, aBrightness, !aFullBlock);
        aRenderer.field_147842_e = false;
        aRenderer.field_147833_aA = 0.5f;
        aRenderer.field_147839_az = 0.5f;
        aRenderer.field_147841_ay = 0.5f;
        aRenderer.field_147854_ax = 0.5f;
        aRenderer.field_147856_aw = 0.5f;
        aRenderer.field_147858_av = 0.5f;
        aRenderer.field_147860_au = 0.5f;
        aRenderer.field_147846_at = 0.5f;
        aRenderer.field_147848_as = 0.5f;
        aRenderer.field_147850_ar = 0.5f;
        aRenderer.field_147852_aq = 0.5f;
        aRenderer.field_147872_ap = 0.5f;
        return true;
    }

    public static boolean renderPositiveYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture aIcon, boolean aFullBlock, boolean aShouldSideBeRendered, Object aRenderedBlockObject) {
        if (aIcon == null || !aIcon.isValidTexture()) {
            return false;
        }
        int aBrightness = 240;
        if (aWorld != null) {
            if (aFullBlock && !aShouldSideBeRendered) {
                return false;
            }
            aBrightness = aBlock.func_149677_c(aWorld, aX, aFullBlock ? aY + 1 : aY, aZ);
            aRenderer.field_147863_w = true;
        }
        aIcon.renderYPos(aRenderer, aBlock, aX, aY, aZ, aBrightness, !aFullBlock);
        aRenderer.field_147842_e = false;
        aRenderer.field_147833_aA = 1.0f;
        aRenderer.field_147839_az = 1.0f;
        aRenderer.field_147841_ay = 1.0f;
        aRenderer.field_147854_ax = 1.0f;
        aRenderer.field_147856_aw = 1.0f;
        aRenderer.field_147858_av = 1.0f;
        aRenderer.field_147860_au = 1.0f;
        aRenderer.field_147846_at = 1.0f;
        aRenderer.field_147848_as = 1.0f;
        aRenderer.field_147850_ar = 1.0f;
        aRenderer.field_147852_aq = 1.0f;
        aRenderer.field_147872_ap = 1.0f;
        return true;
    }

    public static boolean renderNegativeZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture aIcon, boolean aFullBlock, boolean aShouldSideBeRendered, Object aRenderedBlockObject) {
        if (aIcon == null || !aIcon.isValidTexture()) {
            return false;
        }
        int aBrightness = 240;
        if (aWorld != null) {
            if (aFullBlock && !aShouldSideBeRendered) {
                return false;
            }
            aBrightness = aBlock.func_149677_c(aWorld, aX, aY, aFullBlock ? aZ - 1 : aZ);
            aRenderer.field_147863_w = true;
        }
        aRenderer.field_147842_e = !aFullBlock;
        aIcon.renderZNeg(aRenderer, aBlock, aX, aY, aZ, aBrightness, !aFullBlock);
        aRenderer.field_147842_e = false;
        aRenderer.field_147833_aA = 0.8f;
        aRenderer.field_147839_az = 0.8f;
        aRenderer.field_147841_ay = 0.8f;
        aRenderer.field_147854_ax = 0.8f;
        aRenderer.field_147856_aw = 0.8f;
        aRenderer.field_147858_av = 0.8f;
        aRenderer.field_147860_au = 0.8f;
        aRenderer.field_147846_at = 0.8f;
        aRenderer.field_147848_as = 0.8f;
        aRenderer.field_147850_ar = 0.8f;
        aRenderer.field_147852_aq = 0.8f;
        aRenderer.field_147872_ap = 0.8f;
        return true;
    }

    public static boolean renderPositiveZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture aIcon, boolean aFullBlock, boolean aShouldSideBeRendered, Object aRenderedBlockObject) {
        if (aIcon == null || !aIcon.isValidTexture()) {
            return false;
        }
        int aBrightness = 240;
        if (aWorld != null) {
            if (aFullBlock && !aShouldSideBeRendered) {
                return false;
            }
            aBrightness = aBlock.func_149677_c(aWorld, aX, aY, aFullBlock ? aZ + 1 : aZ);
            aRenderer.field_147863_w = true;
        }
        aIcon.renderZPos(aRenderer, aBlock, aX, aY, aZ, aBrightness, !aFullBlock);
        aRenderer.field_147842_e = false;
        aRenderer.field_147833_aA = 0.8f;
        aRenderer.field_147839_az = 0.8f;
        aRenderer.field_147841_ay = 0.8f;
        aRenderer.field_147854_ax = 0.8f;
        aRenderer.field_147856_aw = 0.8f;
        aRenderer.field_147858_av = 0.8f;
        aRenderer.field_147860_au = 0.8f;
        aRenderer.field_147846_at = 0.8f;
        aRenderer.field_147848_as = 0.8f;
        aRenderer.field_147850_ar = 0.8f;
        aRenderer.field_147852_aq = 0.8f;
        aRenderer.field_147872_ap = 0.8f;
        return true;
    }

    public static boolean renderNegativeXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture aIcon, boolean aFullBlock, boolean aShouldSideBeRendered, Object aRenderedBlockObject) {
        if (aIcon == null || !aIcon.isValidTexture()) {
            return false;
        }
        int aBrightness = 240;
        if (aWorld != null) {
            if (aFullBlock && !aShouldSideBeRendered) {
                return false;
            }
            aBrightness = aBlock.func_149677_c(aWorld, aFullBlock ? aX - 1 : aX, aY, aZ);
            aRenderer.field_147863_w = true;
        }
        aIcon.renderXNeg(aRenderer, aBlock, aX, aY, aZ, aBrightness, !aFullBlock);
        aRenderer.field_147842_e = false;
        aRenderer.field_147833_aA = 0.6f;
        aRenderer.field_147839_az = 0.6f;
        aRenderer.field_147841_ay = 0.6f;
        aRenderer.field_147854_ax = 0.6f;
        aRenderer.field_147856_aw = 0.6f;
        aRenderer.field_147858_av = 0.6f;
        aRenderer.field_147860_au = 0.6f;
        aRenderer.field_147846_at = 0.6f;
        aRenderer.field_147848_as = 0.6f;
        aRenderer.field_147850_ar = 0.6f;
        aRenderer.field_147852_aq = 0.6f;
        aRenderer.field_147872_ap = 0.6f;
        return true;
    }

    public static boolean renderPositiveXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture aIcon, boolean aFullBlock, boolean aShouldSideBeRendered, Object aRenderedBlockObject) {
        if (aIcon == null || !aIcon.isValidTexture()) {
            return false;
        }
        int aBrightness = 240;
        if (aWorld != null) {
            if (aFullBlock && !aShouldSideBeRendered) {
                return false;
            }
            aBrightness = aBlock.func_149677_c(aWorld, aFullBlock ? aX + 1 : aX, aY, aZ);
            aRenderer.field_147863_w = true;
        }
        aRenderer.field_147842_e = !aFullBlock;
        aIcon.renderXPos(aRenderer, aBlock, aX, aY, aZ, aBrightness, !aFullBlock);
        aRenderer.field_147842_e = false;
        aRenderer.field_147833_aA = 0.6f;
        aRenderer.field_147839_az = 0.6f;
        aRenderer.field_147841_ay = 0.6f;
        aRenderer.field_147854_ax = 0.6f;
        aRenderer.field_147856_aw = 0.6f;
        aRenderer.field_147858_av = 0.6f;
        aRenderer.field_147860_au = 0.6f;
        aRenderer.field_147846_at = 0.6f;
        aRenderer.field_147848_as = 0.6f;
        aRenderer.field_147850_ar = 0.6f;
        aRenderer.field_147852_aq = 0.6f;
        aRenderer.field_147872_ap = 0.6f;
        return true;
    }

    public boolean shouldRender3DInInventory(int aModel) {
        return true;
    }

    public int getRenderId() {
        return this.mRenderID;
    }

    public boolean handleRenderType(ItemStack aStack, IItemRenderer.ItemRenderType aType) {
        mUsedNBT = aStack.func_77978_p();
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType aType, ItemStack aStack, IItemRenderer.ItemRendererHelper aHelper) {
        mUsedNBT = aStack.func_77978_p();
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType aType, ItemStack aStack, Object ... data) {
        mUsedNBT = aStack.func_77978_p();
    }

    static {
        mUsedNBT = null;
    }
}

