/*
 * Decompiled with CFR 0.152.
 */
package gregapi.render;

import gregapi.data.CS;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public interface ITexture {
    public void renderXPos(RenderBlocks var1, Block var2, int var3, int var4, int var5, int var6, boolean var7);

    public void renderXNeg(RenderBlocks var1, Block var2, int var3, int var4, int var5, int var6, boolean var7);

    public void renderYPos(RenderBlocks var1, Block var2, int var3, int var4, int var5, int var6, boolean var7);

    public void renderYNeg(RenderBlocks var1, Block var2, int var3, int var4, int var5, int var6, boolean var7);

    public void renderZPos(RenderBlocks var1, Block var2, int var3, int var4, int var5, int var6, boolean var7);

    public void renderZNeg(RenderBlocks var1, Block var2, int var3, int var4, int var5, int var6, boolean var7);

    public boolean isValidTexture();

    public static class Util {
        public static boolean OPTIFINE_LOADED = false;
        public static boolean GT_ALPHA_BLENDING = false;
        public static boolean MC_ALPHA_BLENDING = false;
        public static boolean IS_RENDERING_ALPHA = false;
        public static float OFFSET_X_POS = 0.0f;
        public static float OFFSET_X_NEG = 0.0f;
        public static float OFFSET_Y_POS = 0.0f;
        public static float OFFSET_Y_NEG = 0.0f;
        public static float OFFSET_Z_POS = 0.0f;
        public static float OFFSET_Z_NEG = 0.0f;
        public static float OFFSET_DEFAULT = 0.0f;
        public static float OFFSET_ADD = 1.0E-4f;
        public static float OFFSET_BREAK = 1.0E-4f;

        public static void startRendering(RenderBlocks aRenderer, Block aBlock, IBlockAccess aWorld, int aX, int aY, int aZ) {
            OFFSET_Z_NEG = aRenderer.func_147744_b() ? OFFSET_BREAK : OFFSET_DEFAULT;
            OFFSET_Z_POS = OFFSET_Z_NEG;
            OFFSET_Y_NEG = OFFSET_Z_NEG;
            OFFSET_Y_POS = OFFSET_Z_NEG;
            OFFSET_X_NEG = OFFSET_Z_NEG;
            OFFSET_X_POS = OFFSET_Z_NEG;
            if (aWorld != null) {
                if (aRenderer.func_147744_b()) {
                    if (aBlock.func_149701_w() > 0) {
                        GL11.glDisable((int)3042);
                    }
                } else if (GT_ALPHA_BLENDING && aBlock.func_149701_w() < 1) {
                    IS_RENDERING_ALPHA = true;
                    Tessellator.field_78398_a.func_78381_a();
                    Tessellator.field_78398_a.func_78382_b();
                    GL11.glEnable((int)3042);
                    GL11.glAlphaFunc((int)516, (float)0.1f);
                }
            }
        }

        public static void endRendering(RenderBlocks aRenderer, Block aBlock, IBlockAccess aWorld, int aX, int aY, int aZ) {
            if (aWorld != null && IS_RENDERING_ALPHA) {
                IS_RENDERING_ALPHA = false;
                Tessellator.field_78398_a.func_78381_a();
                Tessellator.field_78398_a.func_78382_b();
                GL11.glDisable((int)3042);
                GL11.glAlphaFunc((int)516, (float)0.1f);
            }
        }

        public static boolean renderSide(byte aSide, IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            if (aIcon == null) {
                return false;
            }
            switch (aSide) {
                case 0: {
                    return Util.renderYNeg(aIcon, aRGBa, aAllowAlpha, aUseConstantBrightness, aEnableAO, aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
                }
                case 1: {
                    return Util.renderYPos(aIcon, aRGBa, aAllowAlpha, aUseConstantBrightness, aEnableAO, aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
                }
                case 2: {
                    return Util.renderZNeg(aIcon, aRGBa, aAllowAlpha, aUseConstantBrightness, aEnableAO, aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
                }
                case 3: {
                    return Util.renderZPos(aIcon, aRGBa, aAllowAlpha, aUseConstantBrightness, aEnableAO, aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
                }
                case 4: {
                    return Util.renderXNeg(aIcon, aRGBa, aAllowAlpha, aUseConstantBrightness, aEnableAO, aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
                }
                case 5: {
                    return Util.renderXPos(aIcon, aRGBa, aAllowAlpha, aUseConstantBrightness, aEnableAO, aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
                }
            }
            return false;
        }

        public static boolean renderXPos(IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            boolean tAmbientOcclusion = aRenderer.field_147863_w;
            if (!aEnableAO) {
                aRenderer.field_147863_w = false;
            }
            Util.prepareRenderXPos(aRGBa, aAllowAlpha, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            boolean rReturn = Util.doRenderXPos(aIcon, aRenderer, aBlock, aX, aY, aZ, aChangedBlockBounds);
            aRenderer.field_147863_w = tAmbientOcclusion;
            return rReturn;
        }

        public static boolean renderXNeg(IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            boolean tAmbientOcclusion = aRenderer.field_147863_w;
            if (!aEnableAO) {
                aRenderer.field_147863_w = false;
            }
            Util.prepareRenderXNeg(aRGBa, aAllowAlpha, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            boolean rReturn = Util.doRenderXNeg(aIcon, aRenderer, aBlock, aX, aY, aZ, aChangedBlockBounds);
            aRenderer.field_147863_w = tAmbientOcclusion;
            return rReturn;
        }

        public static boolean renderYPos(IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            boolean tAmbientOcclusion = aRenderer.field_147863_w;
            if (!aEnableAO) {
                aRenderer.field_147863_w = false;
            }
            Util.prepareRenderYPos(aRGBa, aAllowAlpha, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            boolean rReturn = Util.doRenderYPos(aIcon, aRenderer, aBlock, aX, aY, aZ, aChangedBlockBounds);
            aRenderer.field_147863_w = tAmbientOcclusion;
            return rReturn;
        }

        public static boolean renderYNeg(IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            boolean tAmbientOcclusion = aRenderer.field_147863_w;
            if (!aEnableAO) {
                aRenderer.field_147863_w = false;
            }
            Util.prepareRenderYNeg(aRGBa, aAllowAlpha, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            boolean rReturn = Util.doRenderYNeg(aIcon, aRenderer, aBlock, aX, aY, aZ, aChangedBlockBounds);
            aRenderer.field_147863_w = tAmbientOcclusion;
            return rReturn;
        }

        public static boolean renderZPos(IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            boolean tAmbientOcclusion = aRenderer.field_147863_w;
            if (!aEnableAO) {
                aRenderer.field_147863_w = false;
            }
            Util.prepareRenderZPos(aRGBa, aAllowAlpha, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            boolean rReturn = Util.doRenderZPos(aIcon, aRenderer, aBlock, aX, aY, aZ, aChangedBlockBounds);
            aRenderer.field_147863_w = tAmbientOcclusion;
            return rReturn;
        }

        public static boolean renderZNeg(IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            boolean tAmbientOcclusion = aRenderer.field_147863_w;
            if (!aEnableAO) {
                aRenderer.field_147863_w = false;
            }
            Util.prepareRenderZNeg(aRGBa, aAllowAlpha, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            boolean rReturn = Util.doRenderZNeg(aIcon, aRenderer, aBlock, aX, aY, aZ, aChangedBlockBounds);
            aRenderer.field_147863_w = tAmbientOcclusion;
            return rReturn;
        }

        public static void prepareRenderXPos(short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRGBa == null) {
                aRGBa = CS.UNCOLOURED;
            }
            Tessellator.field_78398_a.func_78370_a((int)((float)UT.Code.bind8(aRGBa[0]) * 0.6f), (int)((float)UT.Code.bind8(aRGBa[1]) * 0.6f), (int)((float)UT.Code.bind8(aRGBa[2]) * 0.6f), aAllowAlpha ? (int)UT.Code.bind8(aRGBa[3]) : 255);
            Tessellator.field_78398_a.func_78380_c(aBrightness);
            if (aRenderer.field_147863_w) {
                Util.applyAmbientOcclusionXPos(aRGBa, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            }
        }

        public static void prepareRenderXNeg(short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRGBa == null) {
                aRGBa = CS.UNCOLOURED;
            }
            Tessellator.field_78398_a.func_78370_a((int)((float)UT.Code.bind8(aRGBa[0]) * 0.6f), (int)((float)UT.Code.bind8(aRGBa[1]) * 0.6f), (int)((float)UT.Code.bind8(aRGBa[2]) * 0.6f), aAllowAlpha ? (int)UT.Code.bind8(aRGBa[3]) : 255);
            Tessellator.field_78398_a.func_78380_c(aBrightness);
            if (aRenderer.field_147863_w) {
                Util.applyAmbientOcclusionXNeg(aRGBa, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            }
        }

        public static void prepareRenderYPos(short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRGBa == null) {
                aRGBa = CS.UNCOLOURED;
            }
            Tessellator.field_78398_a.func_78370_a((int)((float)UT.Code.bind8(aRGBa[0]) * 1.0f), (int)((float)UT.Code.bind8(aRGBa[1]) * 1.0f), (int)((float)UT.Code.bind8(aRGBa[2]) * 1.0f), aAllowAlpha ? (int)UT.Code.bind8(aRGBa[3]) : 255);
            Tessellator.field_78398_a.func_78380_c(aBrightness);
            if (aRenderer.field_147863_w) {
                Util.applyAmbientOcclusionYPos(aRGBa, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            }
        }

        public static void prepareRenderYNeg(short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRGBa == null) {
                aRGBa = CS.UNCOLOURED;
            }
            Tessellator.field_78398_a.func_78370_a((int)((float)UT.Code.bind8(aRGBa[0]) * 0.5f), (int)((float)UT.Code.bind8(aRGBa[1]) * 0.5f), (int)((float)UT.Code.bind8(aRGBa[2]) * 0.5f), aAllowAlpha ? (int)UT.Code.bind8(aRGBa[3]) : 255);
            Tessellator.field_78398_a.func_78380_c(aBrightness);
            if (aRenderer.field_147863_w) {
                Util.applyAmbientOcclusionYNeg(aRGBa, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            }
        }

        public static void prepareRenderZPos(short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRGBa == null) {
                aRGBa = CS.UNCOLOURED;
            }
            Tessellator.field_78398_a.func_78370_a((int)((float)UT.Code.bind8(aRGBa[0]) * 0.8f), (int)((float)UT.Code.bind8(aRGBa[1]) * 0.8f), (int)((float)UT.Code.bind8(aRGBa[2]) * 0.8f), aAllowAlpha ? (int)UT.Code.bind8(aRGBa[3]) : 255);
            Tessellator.field_78398_a.func_78380_c(aBrightness);
            if (aRenderer.field_147863_w) {
                Util.applyAmbientOcclusionZPos(aRGBa, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            }
        }

        public static void prepareRenderZNeg(short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRGBa == null) {
                aRGBa = CS.UNCOLOURED;
            }
            Tessellator.field_78398_a.func_78370_a((int)((float)UT.Code.bind8(aRGBa[0]) * 0.8f), (int)((float)UT.Code.bind8(aRGBa[1]) * 0.8f), (int)((float)UT.Code.bind8(aRGBa[2]) * 0.8f), aAllowAlpha ? (int)UT.Code.bind8(aRGBa[3]) : 255);
            Tessellator.field_78398_a.func_78380_c(aBrightness);
            if (aRenderer.field_147863_w) {
                Util.applyAmbientOcclusionZNeg(aRGBa, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            }
        }

        public static boolean doRenderXPos(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, boolean aChangedBlockBounds) {
            if (aChangedBlockBounds) {
                aRenderer.field_147842_e = !aRenderer.field_147842_e;
                aRenderer.field_152631_f = true;
            }
            if (aBlock.func_149701_w() > 0) {
                double tOldValue = aRenderer.field_147861_i;
                aRenderer.field_147861_i = aRenderer.field_147861_i + (double)((float)(aRenderer.field_147838_g ? -1 : 1) * OFFSET_X_POS);
                aRenderer.func_147764_f(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
                aRenderer.field_147861_i = tOldValue;
                OFFSET_X_POS += OFFSET_ADD;
            } else {
                aRenderer.func_147764_f(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
            }
            if (aChangedBlockBounds) {
                aRenderer.field_147842_e = !aRenderer.field_147842_e;
                aRenderer.field_152631_f = false;
            }
            return true;
        }

        public static boolean doRenderXNeg(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, boolean aChangedBlockBounds) {
            if (aBlock.func_149701_w() > 0) {
                double tOldValue = aRenderer.field_147859_h;
                aRenderer.field_147859_h = aRenderer.field_147859_h - (double)((float)(aRenderer.field_147838_g ? -1 : 1) * OFFSET_X_NEG);
                aRenderer.func_147798_e(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
                aRenderer.field_147859_h = tOldValue;
                OFFSET_X_NEG += OFFSET_ADD;
            } else {
                aRenderer.func_147798_e(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
            }
            return true;
        }

        public static boolean doRenderYPos(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, boolean aChangedBlockBounds) {
            if (aBlock.func_149701_w() > 0) {
                double tOldValue = aRenderer.field_147857_k;
                aRenderer.field_147857_k = aRenderer.field_147857_k + (double)((float)(aRenderer.field_147838_g ? -1 : 1) * OFFSET_Y_POS);
                aRenderer.func_147806_b(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
                aRenderer.field_147857_k = tOldValue;
                OFFSET_Y_POS += OFFSET_ADD;
            } else {
                aRenderer.func_147806_b(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
            }
            return true;
        }

        public static boolean doRenderYNeg(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, boolean aChangedBlockBounds) {
            if (aBlock.func_149701_w() > 0) {
                double tOldValue = aRenderer.field_147855_j;
                aRenderer.field_147855_j = aRenderer.field_147855_j - (double)((float)(aRenderer.field_147838_g ? -1 : 1) * OFFSET_Y_NEG);
                Util.renderFixedNegativeYFacing(aIcon, aRenderer, aBlock, aX, aY, aZ);
                aRenderer.field_147855_j = tOldValue;
                OFFSET_Y_NEG += OFFSET_ADD;
            } else {
                Util.renderFixedNegativeYFacing(aIcon, aRenderer, aBlock, aX, aY, aZ);
            }
            return true;
        }

        public static boolean doRenderZPos(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, boolean aChangedBlockBounds) {
            if (aBlock.func_149701_w() > 0) {
                double tOldValue = aRenderer.field_147853_m;
                aRenderer.field_147853_m = aRenderer.field_147853_m + (double)((float)(aRenderer.field_147838_g ? -1 : 1) * OFFSET_Z_POS);
                aRenderer.func_147734_d(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
                aRenderer.field_147853_m = tOldValue;
                OFFSET_Z_POS += OFFSET_ADD;
            } else {
                aRenderer.func_147734_d(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
            }
            return true;
        }

        public static boolean doRenderZNeg(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, boolean aChangedBlockBounds) {
            if (aChangedBlockBounds) {
                aRenderer.field_147842_e = !aRenderer.field_147842_e;
                aRenderer.field_152631_f = true;
            }
            if (aBlock.func_149701_w() > 0) {
                double tOldValue = aRenderer.field_147851_l;
                aRenderer.field_147851_l = aRenderer.field_147851_l - (double)((float)(aRenderer.field_147838_g ? -1 : 1) * OFFSET_Z_NEG);
                aRenderer.func_147761_c(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
                aRenderer.field_147851_l = tOldValue;
                OFFSET_Z_NEG += OFFSET_ADD;
            } else {
                aRenderer.func_147761_c(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
            }
            if (aChangedBlockBounds) {
                aRenderer.field_147842_e = !aRenderer.field_147842_e;
                aRenderer.field_152631_f = false;
            }
            return true;
        }

        public static void renderFixedNegativeYFacing(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
            if (aRenderer.func_147744_b()) {
                aIcon = aRenderer.field_147840_d;
            }
            double tMaxX1 = aIcon.func_94214_a(aRenderer.field_147861_i * 16.0);
            double tMinX1 = aIcon.func_94214_a(aRenderer.field_147859_h * 16.0);
            double tMaxZ1 = aIcon.func_94207_b(aRenderer.field_147853_m * 16.0);
            double tMinZ1 = aIcon.func_94207_b(aRenderer.field_147851_l * 16.0);
            if (aRenderer.field_147859_h < 0.0 || aRenderer.field_147861_i > 1.0) {
                tMinX1 = aIcon.func_94209_e();
                tMaxX1 = aIcon.func_94212_f();
            }
            if (aRenderer.field_147851_l < 0.0 || aRenderer.field_147853_m > 1.0) {
                tMaxZ1 = aIcon.func_94206_g();
                tMinZ1 = aIcon.func_94210_h();
            }
            double tMaxX2 = tMaxX1;
            double tMinX2 = tMinX1;
            double tMaxZ2 = tMaxZ1;
            double tMinZ2 = tMinZ1;
            if (aRenderer.field_147865_v == 2) {
                tMinX1 = aIcon.func_94214_a(aRenderer.field_147851_l * 16.0);
                tMaxZ1 = aIcon.func_94207_b(16.0 - aRenderer.field_147861_i * 16.0);
                tMaxX1 = aIcon.func_94214_a(aRenderer.field_147853_m * 16.0);
                tMinZ1 = aIcon.func_94207_b(16.0 - aRenderer.field_147859_h * 16.0);
                tMaxZ2 = tMaxZ1;
                tMinZ2 = tMinZ1;
                tMaxX2 = tMinX1;
                tMinX2 = tMaxX1;
                tMaxZ1 = tMinZ1;
                tMinZ1 = tMaxZ2;
            } else if (aRenderer.field_147865_v == 1) {
                tMinX1 = aIcon.func_94214_a(16.0 - aRenderer.field_147853_m * 16.0);
                tMaxZ1 = aIcon.func_94207_b(aRenderer.field_147859_h * 16.0);
                tMaxX1 = aIcon.func_94214_a(16.0 - aRenderer.field_147851_l * 16.0);
                tMinZ1 = aIcon.func_94207_b(aRenderer.field_147861_i * 16.0);
                tMaxX2 = tMaxX1;
                tMinX2 = tMinX1;
                tMinX1 = tMaxX1;
                tMaxX1 = tMinX2;
                tMaxZ2 = tMinZ1;
                tMinZ2 = tMaxZ1;
            } else if (aRenderer.field_147865_v == 3) {
                tMinX1 = aIcon.func_94214_a(16.0 - aRenderer.field_147859_h * 16.0);
                tMaxX1 = aIcon.func_94214_a(16.0 - aRenderer.field_147861_i * 16.0);
                tMaxZ1 = aIcon.func_94207_b(16.0 - aRenderer.field_147851_l * 16.0);
                tMinZ1 = aIcon.func_94207_b(16.0 - aRenderer.field_147853_m * 16.0);
                tMaxX2 = tMaxX1;
                tMinX2 = tMinX1;
                tMaxZ2 = tMaxZ1;
                tMinZ2 = tMinZ1;
            }
            double tMinX3 = (double)aX + aRenderer.field_147859_h;
            double tMaxX3 = (double)aX + aRenderer.field_147861_i;
            double tMinY3 = (double)aY + aRenderer.field_147855_j;
            double tMinZ3 = (double)aZ + aRenderer.field_147851_l;
            double tMaxZ3 = (double)aZ + aRenderer.field_147853_m;
            if (aRenderer.field_147838_g) {
                tMinX3 = (double)aX + aRenderer.field_147861_i;
                tMaxX3 = (double)aX + aRenderer.field_147859_h;
            }
            if (aRenderer.field_147863_w) {
                Tessellator.field_78398_a.func_78386_a(aRenderer.field_147872_ap, aRenderer.field_147846_at, aRenderer.field_147854_ax);
                Tessellator.field_78398_a.func_78380_c(aRenderer.field_147864_al);
                Tessellator.field_78398_a.func_78374_a(tMinX3, tMinY3, tMaxZ3, tMinX2, tMinZ2);
                Tessellator.field_78398_a.func_78386_a(aRenderer.field_147852_aq, aRenderer.field_147860_au, aRenderer.field_147841_ay);
                Tessellator.field_78398_a.func_78380_c(aRenderer.field_147874_am);
                Tessellator.field_78398_a.func_78374_a(tMinX3, tMinY3, tMinZ3, tMinX1, tMaxZ1);
                Tessellator.field_78398_a.func_78386_a(aRenderer.field_147850_ar, aRenderer.field_147858_av, aRenderer.field_147839_az);
                Tessellator.field_78398_a.func_78380_c(aRenderer.field_147876_an);
                Tessellator.field_78398_a.func_78374_a(tMaxX3, tMinY3, tMinZ3, tMaxX2, tMaxZ2);
                Tessellator.field_78398_a.func_78386_a(aRenderer.field_147848_as, aRenderer.field_147856_aw, aRenderer.field_147833_aA);
                Tessellator.field_78398_a.func_78380_c(aRenderer.field_147870_ao);
                Tessellator.field_78398_a.func_78374_a(tMaxX3, tMinY3, tMaxZ3, tMaxX1, tMinZ1);
            } else {
                Tessellator.field_78398_a.func_78374_a(tMinX3, tMinY3, tMaxZ3, tMinX2, tMinZ2);
                Tessellator.field_78398_a.func_78374_a(tMinX3, tMinY3, tMinZ3, tMinX1, tMaxZ1);
                Tessellator.field_78398_a.func_78374_a(tMaxX3, tMinY3, tMinZ3, tMaxX2, tMaxZ2);
                Tessellator.field_78398_a.func_78374_a(tMaxX3, tMinY3, tMaxZ3, tMaxX1, tMinZ1);
            }
        }

        public static void applyAmbientOcclusionXPos(short[] aRGBa, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRenderer.field_147861_i >= 1.0) {
                ++aX;
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 1.0f;
            aRenderer.field_147810_D = aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ).func_149685_I();
            aRenderer.field_147820_O = aRenderer.field_147845_a.func_147439_a(aX, aY, aZ - 1).func_149685_I();
            aRenderer.field_147829_Q = aRenderer.field_147845_a.func_147439_a(aX, aY, aZ + 1).func_149685_I();
            aRenderer.field_147824_K = aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ).func_149685_I();
            aRenderer.field_147835_X = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY - 1, aZ);
            aRenderer.field_147866_ai = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY, aZ - 1);
            aRenderer.field_147862_ak = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY, aZ + 1);
            aRenderer.field_147885_ae = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY + 1, aZ);
            boolean flag2 = aRenderer.field_147845_a.func_147439_a(aX + 1, aY + 1, aZ).func_149751_l();
            boolean flag3 = aRenderer.field_147845_a.func_147439_a(aX + 1, aY - 1, aZ).func_149751_l();
            boolean flag4 = aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ + 1).func_149751_l();
            boolean flag5 = aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ - 1).func_149751_l();
            if (!flag3 && !flag5) {
                aRenderer.field_147816_C = aRenderer.field_147820_O;
                aRenderer.field_147827_W = aRenderer.field_147866_ai;
            } else {
                aRenderer.field_147816_C = aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ - 1).func_149685_I();
                int n = aRenderer.field_147827_W = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY - 1, aZ - 1);
            }
            if (!flag3 && !flag4) {
                aRenderer.field_147811_E = aRenderer.field_147829_Q;
                aRenderer.field_147834_Y = aRenderer.field_147862_ak;
            } else {
                aRenderer.field_147811_E = aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ + 1).func_149685_I();
                int n = aRenderer.field_147834_Y = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY - 1, aZ + 1);
            }
            if (!flag2 && !flag5) {
                aRenderer.field_147823_J = aRenderer.field_147820_O;
                aRenderer.field_147879_ad = aRenderer.field_147866_ai;
            } else {
                aRenderer.field_147823_J = aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ - 1).func_149685_I();
                int n = aRenderer.field_147879_ad = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY + 1, aZ - 1);
            }
            if (!flag2 && !flag4) {
                aRenderer.field_147818_M = aRenderer.field_147829_Q;
                aRenderer.field_147882_ag = aRenderer.field_147862_ak;
            } else {
                aRenderer.field_147818_M = aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ + 1).func_149685_I();
                int n = aRenderer.field_147882_ag = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY + 1, aZ + 1);
            }
            if (aRenderer.field_147861_i >= 1.0) {
                --aX;
            }
            if (aRenderer.field_147861_i >= 1.0 || !UT.Worlds.isVisuallyOpaque(aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ))) {
                aBrightness = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX + 1, aY, aZ);
            }
            f7 = aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ).func_149685_I();
            f3 = (aRenderer.field_147810_D + aRenderer.field_147811_E + f7 + aRenderer.field_147829_Q) / 4.0f;
            f4 = (aRenderer.field_147816_C + aRenderer.field_147810_D + aRenderer.field_147820_O + f7) / 4.0f;
            f5 = (aRenderer.field_147820_O + f7 + aRenderer.field_147823_J + aRenderer.field_147824_K) / 4.0f;
            f6 = (f7 + aRenderer.field_147829_Q + aRenderer.field_147824_K + aRenderer.field_147818_M) / 4.0f;
            aRenderer.field_147864_al = aRenderer.func_147778_a(aRenderer.field_147835_X, aRenderer.field_147834_Y, aRenderer.field_147862_ak, aBrightness);
            aRenderer.field_147870_ao = aRenderer.func_147778_a(aRenderer.field_147862_ak, aRenderer.field_147885_ae, aRenderer.field_147882_ag, aBrightness);
            aRenderer.field_147876_an = aRenderer.func_147778_a(aRenderer.field_147866_ai, aRenderer.field_147879_ad, aRenderer.field_147885_ae, aBrightness);
            aRenderer.field_147874_am = aRenderer.func_147778_a(aRenderer.field_147827_W, aRenderer.field_147835_X, aRenderer.field_147866_ai, aBrightness);
            aRenderer.field_147850_ar = aRenderer.field_147848_as = (float)UT.Code.bind8(aRGBa[0]) / 256.0f * 0.6f;
            aRenderer.field_147852_aq = aRenderer.field_147848_as;
            aRenderer.field_147872_ap = aRenderer.field_147848_as;
            aRenderer.field_147858_av = aRenderer.field_147856_aw = (float)UT.Code.bind8(aRGBa[1]) / 256.0f * 0.6f;
            aRenderer.field_147860_au = aRenderer.field_147856_aw;
            aRenderer.field_147846_at = aRenderer.field_147856_aw;
            aRenderer.field_147839_az = aRenderer.field_147833_aA = (float)UT.Code.bind8(aRGBa[2]) / 256.0f * 0.6f;
            aRenderer.field_147841_ay = aRenderer.field_147833_aA;
            aRenderer.field_147854_ax = aRenderer.field_147833_aA;
            aRenderer.field_147872_ap *= f3;
            aRenderer.field_147846_at *= f3;
            aRenderer.field_147854_ax *= f3;
            aRenderer.field_147852_aq *= f4;
            aRenderer.field_147860_au *= f4;
            aRenderer.field_147841_ay *= f4;
            aRenderer.field_147850_ar *= f5;
            aRenderer.field_147858_av *= f5;
            aRenderer.field_147839_az *= f5;
            aRenderer.field_147848_as *= f6;
            aRenderer.field_147856_aw *= f6;
            aRenderer.field_147833_aA *= f6;
        }

        public static void applyAmbientOcclusionXNeg(short[] aRGBa, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRenderer.field_147859_h <= 0.0) {
                --aX;
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 1.0f;
            aRenderer.field_147886_y = aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ).func_149685_I();
            aRenderer.field_147819_N = aRenderer.field_147845_a.func_147439_a(aX, aY, aZ - 1).func_149685_I();
            aRenderer.field_147830_P = aRenderer.field_147845_a.func_147439_a(aX, aY, aZ + 1).func_149685_I();
            aRenderer.field_147813_G = aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ).func_149685_I();
            aRenderer.field_147831_S = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY - 1, aZ);
            aRenderer.field_147883_ah = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY, aZ - 1);
            aRenderer.field_147868_aj = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY, aZ + 1);
            aRenderer.field_147880_aa = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY + 1, aZ);
            boolean flag2 = aRenderer.field_147845_a.func_147439_a(aX - 1, aY + 1, aZ).func_149751_l();
            boolean flag3 = aRenderer.field_147845_a.func_147439_a(aX - 1, aY - 1, aZ).func_149751_l();
            boolean flag4 = aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ - 1).func_149751_l();
            boolean flag5 = aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ + 1).func_149751_l();
            if (!flag4 && !flag3) {
                aRenderer.field_147888_x = aRenderer.field_147819_N;
                aRenderer.field_147832_R = aRenderer.field_147883_ah;
            } else {
                aRenderer.field_147888_x = aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ - 1).func_149685_I();
                int n = aRenderer.field_147832_R = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY - 1, aZ - 1);
            }
            if (!flag5 && !flag3) {
                aRenderer.field_147884_z = aRenderer.field_147830_P;
                aRenderer.field_147826_T = aRenderer.field_147868_aj;
            } else {
                aRenderer.field_147884_z = aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ + 1).func_149685_I();
                int n = aRenderer.field_147826_T = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY - 1, aZ + 1);
            }
            if (!flag4 && !flag2) {
                aRenderer.field_147812_F = aRenderer.field_147819_N;
                aRenderer.field_147836_Z = aRenderer.field_147883_ah;
            } else {
                aRenderer.field_147812_F = aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ - 1).func_149685_I();
                int n = aRenderer.field_147836_Z = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY + 1, aZ - 1);
            }
            if (!flag5 && !flag2) {
                aRenderer.field_147821_H = aRenderer.field_147830_P;
                aRenderer.field_147881_ab = aRenderer.field_147868_aj;
            } else {
                aRenderer.field_147821_H = aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ + 1).func_149685_I();
                int n = aRenderer.field_147881_ab = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY + 1, aZ + 1);
            }
            if (aRenderer.field_147859_h <= 0.0) {
                ++aX;
            }
            if (aRenderer.field_147859_h <= 0.0 || !UT.Worlds.isVisuallyOpaque(aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ))) {
                aBrightness = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX - 1, aY, aZ);
            }
            f7 = aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ).func_149685_I();
            f6 = (aRenderer.field_147886_y + aRenderer.field_147884_z + f7 + aRenderer.field_147830_P) / 4.0f;
            f3 = (f7 + aRenderer.field_147830_P + aRenderer.field_147813_G + aRenderer.field_147821_H) / 4.0f;
            f4 = (aRenderer.field_147819_N + f7 + aRenderer.field_147812_F + aRenderer.field_147813_G) / 4.0f;
            f5 = (aRenderer.field_147888_x + aRenderer.field_147886_y + aRenderer.field_147819_N + f7) / 4.0f;
            aRenderer.field_147870_ao = aRenderer.func_147778_a(aRenderer.field_147831_S, aRenderer.field_147826_T, aRenderer.field_147868_aj, aBrightness);
            aRenderer.field_147864_al = aRenderer.func_147778_a(aRenderer.field_147868_aj, aRenderer.field_147880_aa, aRenderer.field_147881_ab, aBrightness);
            aRenderer.field_147874_am = aRenderer.func_147778_a(aRenderer.field_147883_ah, aRenderer.field_147836_Z, aRenderer.field_147880_aa, aBrightness);
            aRenderer.field_147876_an = aRenderer.func_147778_a(aRenderer.field_147832_R, aRenderer.field_147831_S, aRenderer.field_147883_ah, aBrightness);
            aRenderer.field_147850_ar = aRenderer.field_147848_as = (float)UT.Code.bind8(aRGBa[0]) / 256.0f * 0.6f;
            aRenderer.field_147852_aq = aRenderer.field_147848_as;
            aRenderer.field_147872_ap = aRenderer.field_147848_as;
            aRenderer.field_147858_av = aRenderer.field_147856_aw = (float)UT.Code.bind8(aRGBa[1]) / 256.0f * 0.6f;
            aRenderer.field_147860_au = aRenderer.field_147856_aw;
            aRenderer.field_147846_at = aRenderer.field_147856_aw;
            aRenderer.field_147839_az = aRenderer.field_147833_aA = (float)UT.Code.bind8(aRGBa[2]) / 256.0f * 0.6f;
            aRenderer.field_147841_ay = aRenderer.field_147833_aA;
            aRenderer.field_147854_ax = aRenderer.field_147833_aA;
            aRenderer.field_147872_ap *= f3;
            aRenderer.field_147846_at *= f3;
            aRenderer.field_147854_ax *= f3;
            aRenderer.field_147852_aq *= f4;
            aRenderer.field_147860_au *= f4;
            aRenderer.field_147841_ay *= f4;
            aRenderer.field_147850_ar *= f5;
            aRenderer.field_147858_av *= f5;
            aRenderer.field_147839_az *= f5;
            aRenderer.field_147848_as *= f6;
            aRenderer.field_147856_aw *= f6;
            aRenderer.field_147833_aA *= f6;
        }

        public static void applyAmbientOcclusionYPos(short[] aRGBa, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRenderer.field_147857_k >= 1.0) {
                ++aY;
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 1.0f;
            aRenderer.field_147880_aa = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX - 1, aY, aZ);
            aRenderer.field_147885_ae = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX + 1, aY, aZ);
            aRenderer.field_147878_ac = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY, aZ - 1);
            aRenderer.field_147887_af = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY, aZ + 1);
            aRenderer.field_147813_G = aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ).func_149685_I();
            aRenderer.field_147824_K = aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ).func_149685_I();
            aRenderer.field_147822_I = aRenderer.field_147845_a.func_147439_a(aX, aY, aZ - 1).func_149685_I();
            aRenderer.field_147817_L = aRenderer.field_147845_a.func_147439_a(aX, aY, aZ + 1).func_149685_I();
            boolean flag2 = aRenderer.field_147845_a.func_147439_a(aX + 1, aY + 1, aZ).func_149751_l();
            boolean flag3 = aRenderer.field_147845_a.func_147439_a(aX - 1, aY + 1, aZ).func_149751_l();
            boolean flag4 = aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ + 1).func_149751_l();
            boolean flag5 = aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ - 1).func_149751_l();
            if (!flag5 && !flag3) {
                aRenderer.field_147812_F = aRenderer.field_147813_G;
                aRenderer.field_147836_Z = aRenderer.field_147880_aa;
            } else {
                aRenderer.field_147812_F = aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ - 1).func_149685_I();
                int n = aRenderer.field_147836_Z = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX - 1, aY, aZ - 1);
            }
            if (!flag5 && !flag2) {
                aRenderer.field_147823_J = aRenderer.field_147824_K;
                aRenderer.field_147879_ad = aRenderer.field_147885_ae;
            } else {
                aRenderer.field_147823_J = aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ - 1).func_149685_I();
                int n = aRenderer.field_147879_ad = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX + 1, aY, aZ - 1);
            }
            if (!flag4 && !flag3) {
                aRenderer.field_147821_H = aRenderer.field_147813_G;
                aRenderer.field_147881_ab = aRenderer.field_147880_aa;
            } else {
                aRenderer.field_147821_H = aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ + 1).func_149685_I();
                int n = aRenderer.field_147881_ab = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX - 1, aY, aZ + 1);
            }
            if (!flag4 && !flag2) {
                aRenderer.field_147818_M = aRenderer.field_147824_K;
                aRenderer.field_147882_ag = aRenderer.field_147885_ae;
            } else {
                aRenderer.field_147818_M = aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ + 1).func_149685_I();
                int n = aRenderer.field_147882_ag = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX + 1, aY, aZ + 1);
            }
            if (aRenderer.field_147857_k >= 1.0) {
                --aY;
            }
            if (aRenderer.field_147857_k >= 1.0 || !UT.Worlds.isVisuallyOpaque(aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ))) {
                aBrightness = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY + 1, aZ);
            }
            f7 = aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ).func_149685_I();
            f6 = (aRenderer.field_147821_H + aRenderer.field_147813_G + aRenderer.field_147817_L + f7) / 4.0f;
            f3 = (aRenderer.field_147817_L + f7 + aRenderer.field_147818_M + aRenderer.field_147824_K) / 4.0f;
            f4 = (f7 + aRenderer.field_147822_I + aRenderer.field_147824_K + aRenderer.field_147823_J) / 4.0f;
            f5 = (aRenderer.field_147813_G + aRenderer.field_147812_F + f7 + aRenderer.field_147822_I) / 4.0f;
            aRenderer.field_147870_ao = aRenderer.func_147778_a(aRenderer.field_147881_ab, aRenderer.field_147880_aa, aRenderer.field_147887_af, aBrightness);
            aRenderer.field_147864_al = aRenderer.func_147778_a(aRenderer.field_147887_af, aRenderer.field_147882_ag, aRenderer.field_147885_ae, aBrightness);
            aRenderer.field_147874_am = aRenderer.func_147778_a(aRenderer.field_147878_ac, aRenderer.field_147885_ae, aRenderer.field_147879_ad, aBrightness);
            aRenderer.field_147876_an = aRenderer.func_147778_a(aRenderer.field_147880_aa, aRenderer.field_147836_Z, aRenderer.field_147878_ac, aBrightness);
            aRenderer.field_147850_ar = aRenderer.field_147848_as = (float)UT.Code.bind8(aRGBa[0]) / 256.0f;
            aRenderer.field_147852_aq = aRenderer.field_147848_as;
            aRenderer.field_147872_ap = aRenderer.field_147848_as;
            aRenderer.field_147858_av = aRenderer.field_147856_aw = (float)UT.Code.bind8(aRGBa[1]) / 256.0f;
            aRenderer.field_147860_au = aRenderer.field_147856_aw;
            aRenderer.field_147846_at = aRenderer.field_147856_aw;
            aRenderer.field_147839_az = aRenderer.field_147833_aA = (float)UT.Code.bind8(aRGBa[2]) / 256.0f;
            aRenderer.field_147841_ay = aRenderer.field_147833_aA;
            aRenderer.field_147854_ax = aRenderer.field_147833_aA;
            aRenderer.field_147872_ap *= f3;
            aRenderer.field_147846_at *= f3;
            aRenderer.field_147854_ax *= f3;
            aRenderer.field_147852_aq *= f4;
            aRenderer.field_147860_au *= f4;
            aRenderer.field_147841_ay *= f4;
            aRenderer.field_147850_ar *= f5;
            aRenderer.field_147858_av *= f5;
            aRenderer.field_147839_az *= f5;
            aRenderer.field_147848_as *= f6;
            aRenderer.field_147856_aw *= f6;
            aRenderer.field_147833_aA *= f6;
        }

        public static void applyAmbientOcclusionYNeg(short[] aRGBa, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRenderer.field_147855_j <= 0.0) {
                --aY;
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 1.0f;
            aRenderer.field_147831_S = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX - 1, aY, aZ);
            aRenderer.field_147825_U = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY, aZ - 1);
            aRenderer.field_147828_V = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY, aZ + 1);
            aRenderer.field_147835_X = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX + 1, aY, aZ);
            aRenderer.field_147886_y = aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ).func_149685_I();
            aRenderer.field_147814_A = aRenderer.field_147845_a.func_147439_a(aX, aY, aZ - 1).func_149685_I();
            aRenderer.field_147815_B = aRenderer.field_147845_a.func_147439_a(aX, aY, aZ + 1).func_149685_I();
            aRenderer.field_147810_D = aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ).func_149685_I();
            boolean flag2 = aRenderer.field_147845_a.func_147439_a(aX + 1, aY - 1, aZ).func_149751_l();
            boolean flag3 = aRenderer.field_147845_a.func_147439_a(aX - 1, aY - 1, aZ).func_149751_l();
            boolean flag4 = aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ + 1).func_149751_l();
            boolean flag5 = aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ - 1).func_149751_l();
            if (!flag5 && !flag3) {
                aRenderer.field_147888_x = aRenderer.field_147886_y;
                aRenderer.field_147832_R = aRenderer.field_147831_S;
            } else {
                aRenderer.field_147888_x = aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ - 1).func_149685_I();
                int n = aRenderer.field_147832_R = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX - 1, aY, aZ - 1);
            }
            if (!flag4 && !flag3) {
                aRenderer.field_147884_z = aRenderer.field_147886_y;
                aRenderer.field_147826_T = aRenderer.field_147831_S;
            } else {
                aRenderer.field_147884_z = aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ + 1).func_149685_I();
                int n = aRenderer.field_147826_T = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX - 1, aY, aZ + 1);
            }
            if (!flag5 && !flag2) {
                aRenderer.field_147816_C = aRenderer.field_147810_D;
                aRenderer.field_147827_W = aRenderer.field_147835_X;
            } else {
                aRenderer.field_147816_C = aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ - 1).func_149685_I();
                int n = aRenderer.field_147827_W = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX + 1, aY, aZ - 1);
            }
            if (!flag4 && !flag2) {
                aRenderer.field_147811_E = aRenderer.field_147810_D;
                aRenderer.field_147834_Y = aRenderer.field_147835_X;
            } else {
                aRenderer.field_147811_E = aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ + 1).func_149685_I();
                int n = aRenderer.field_147834_Y = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX + 1, aY, aZ + 1);
            }
            if (aRenderer.field_147855_j <= 0.0) {
                ++aY;
            }
            if (aRenderer.field_147855_j <= 0.0 || !UT.Worlds.isVisuallyOpaque(aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ))) {
                aBrightness = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY - 1, aZ);
            }
            f7 = aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ).func_149685_I();
            f3 = (aRenderer.field_147884_z + aRenderer.field_147886_y + aRenderer.field_147815_B + f7) / 4.0f;
            f6 = (aRenderer.field_147815_B + f7 + aRenderer.field_147811_E + aRenderer.field_147810_D) / 4.0f;
            f5 = (f7 + aRenderer.field_147814_A + aRenderer.field_147810_D + aRenderer.field_147816_C) / 4.0f;
            f4 = (aRenderer.field_147886_y + aRenderer.field_147888_x + f7 + aRenderer.field_147814_A) / 4.0f;
            aRenderer.field_147864_al = aRenderer.func_147778_a(aRenderer.field_147826_T, aRenderer.field_147831_S, aRenderer.field_147828_V, aBrightness);
            aRenderer.field_147870_ao = aRenderer.func_147778_a(aRenderer.field_147828_V, aRenderer.field_147834_Y, aRenderer.field_147835_X, aBrightness);
            aRenderer.field_147876_an = aRenderer.func_147778_a(aRenderer.field_147825_U, aRenderer.field_147835_X, aRenderer.field_147827_W, aBrightness);
            aRenderer.field_147874_am = aRenderer.func_147778_a(aRenderer.field_147831_S, aRenderer.field_147832_R, aRenderer.field_147825_U, aBrightness);
            aRenderer.field_147850_ar = aRenderer.field_147848_as = (float)UT.Code.bind8(aRGBa[0]) / 256.0f * 0.5f;
            aRenderer.field_147852_aq = aRenderer.field_147848_as;
            aRenderer.field_147872_ap = aRenderer.field_147848_as;
            aRenderer.field_147858_av = aRenderer.field_147856_aw = (float)UT.Code.bind8(aRGBa[1]) / 256.0f * 0.5f;
            aRenderer.field_147860_au = aRenderer.field_147856_aw;
            aRenderer.field_147846_at = aRenderer.field_147856_aw;
            aRenderer.field_147839_az = aRenderer.field_147833_aA = (float)UT.Code.bind8(aRGBa[2]) / 256.0f * 0.5f;
            aRenderer.field_147841_ay = aRenderer.field_147833_aA;
            aRenderer.field_147854_ax = aRenderer.field_147833_aA;
            aRenderer.field_147872_ap *= f3;
            aRenderer.field_147846_at *= f3;
            aRenderer.field_147854_ax *= f3;
            aRenderer.field_147852_aq *= f4;
            aRenderer.field_147860_au *= f4;
            aRenderer.field_147841_ay *= f4;
            aRenderer.field_147850_ar *= f5;
            aRenderer.field_147858_av *= f5;
            aRenderer.field_147839_az *= f5;
            aRenderer.field_147848_as *= f6;
            aRenderer.field_147856_aw *= f6;
            aRenderer.field_147833_aA *= f6;
        }

        public static void applyAmbientOcclusionZPos(short[] aRGBa, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRenderer.field_147853_m >= 1.0) {
                ++aZ;
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 1.0f;
            aRenderer.field_147830_P = aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ).func_149685_I();
            aRenderer.field_147829_Q = aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ).func_149685_I();
            aRenderer.field_147815_B = aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ).func_149685_I();
            aRenderer.field_147817_L = aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ).func_149685_I();
            aRenderer.field_147868_aj = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX - 1, aY, aZ);
            aRenderer.field_147862_ak = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX + 1, aY, aZ);
            aRenderer.field_147828_V = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY - 1, aZ);
            aRenderer.field_147887_af = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY + 1, aZ);
            boolean flag2 = aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ + 1).func_149751_l();
            boolean flag3 = aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ + 1).func_149751_l();
            boolean flag4 = aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ + 1).func_149751_l();
            boolean flag5 = aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ + 1).func_149751_l();
            if (!flag3 && !flag5) {
                aRenderer.field_147884_z = aRenderer.field_147830_P;
                aRenderer.field_147826_T = aRenderer.field_147868_aj;
            } else {
                aRenderer.field_147884_z = aRenderer.field_147845_a.func_147439_a(aX - 1, aY - 1, aZ).func_149685_I();
                int n = aRenderer.field_147826_T = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX - 1, aY - 1, aZ);
            }
            if (!flag3 && !flag4) {
                aRenderer.field_147821_H = aRenderer.field_147830_P;
                aRenderer.field_147881_ab = aRenderer.field_147868_aj;
            } else {
                aRenderer.field_147821_H = aRenderer.field_147845_a.func_147439_a(aX - 1, aY + 1, aZ).func_149685_I();
                int n = aRenderer.field_147881_ab = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX - 1, aY + 1, aZ);
            }
            if (!flag2 && !flag5) {
                aRenderer.field_147811_E = aRenderer.field_147829_Q;
                aRenderer.field_147834_Y = aRenderer.field_147862_ak;
            } else {
                aRenderer.field_147811_E = aRenderer.field_147845_a.func_147439_a(aX + 1, aY - 1, aZ).func_149685_I();
                int n = aRenderer.field_147834_Y = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX + 1, aY - 1, aZ);
            }
            if (!flag2 && !flag4) {
                aRenderer.field_147818_M = aRenderer.field_147829_Q;
                aRenderer.field_147882_ag = aRenderer.field_147862_ak;
            } else {
                aRenderer.field_147818_M = aRenderer.field_147845_a.func_147439_a(aX + 1, aY + 1, aZ).func_149685_I();
                int n = aRenderer.field_147882_ag = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX + 1, aY + 1, aZ);
            }
            if (aRenderer.field_147853_m >= 1.0) {
                --aZ;
            }
            if (aRenderer.field_147853_m >= 1.0 || !UT.Worlds.isVisuallyOpaque(aRenderer.field_147845_a.func_147439_a(aX, aY, aZ + 1))) {
                aBrightness = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY, aZ + 1);
            }
            f7 = aRenderer.field_147845_a.func_147439_a(aX, aY, aZ + 1).func_149685_I();
            f3 = (aRenderer.field_147830_P + aRenderer.field_147821_H + f7 + aRenderer.field_147817_L) / 4.0f;
            f6 = (f7 + aRenderer.field_147817_L + aRenderer.field_147829_Q + aRenderer.field_147818_M) / 4.0f;
            f5 = (aRenderer.field_147815_B + f7 + aRenderer.field_147811_E + aRenderer.field_147829_Q) / 4.0f;
            f4 = (aRenderer.field_147884_z + aRenderer.field_147830_P + aRenderer.field_147815_B + f7) / 4.0f;
            aRenderer.field_147864_al = aRenderer.func_147778_a(aRenderer.field_147868_aj, aRenderer.field_147881_ab, aRenderer.field_147887_af, aBrightness);
            aRenderer.field_147870_ao = aRenderer.func_147778_a(aRenderer.field_147887_af, aRenderer.field_147862_ak, aRenderer.field_147882_ag, aBrightness);
            aRenderer.field_147876_an = aRenderer.func_147778_a(aRenderer.field_147828_V, aRenderer.field_147834_Y, aRenderer.field_147862_ak, aBrightness);
            aRenderer.field_147874_am = aRenderer.func_147778_a(aRenderer.field_147826_T, aRenderer.field_147868_aj, aRenderer.field_147828_V, aBrightness);
            aRenderer.field_147850_ar = aRenderer.field_147848_as = (float)UT.Code.bind8(aRGBa[0]) / 256.0f * 0.8f;
            aRenderer.field_147852_aq = aRenderer.field_147848_as;
            aRenderer.field_147872_ap = aRenderer.field_147848_as;
            aRenderer.field_147858_av = aRenderer.field_147856_aw = (float)UT.Code.bind8(aRGBa[1]) / 256.0f * 0.8f;
            aRenderer.field_147860_au = aRenderer.field_147856_aw;
            aRenderer.field_147846_at = aRenderer.field_147856_aw;
            aRenderer.field_147839_az = aRenderer.field_147833_aA = (float)UT.Code.bind8(aRGBa[2]) / 256.0f * 0.8f;
            aRenderer.field_147841_ay = aRenderer.field_147833_aA;
            aRenderer.field_147854_ax = aRenderer.field_147833_aA;
            aRenderer.field_147872_ap *= f3;
            aRenderer.field_147846_at *= f3;
            aRenderer.field_147854_ax *= f3;
            aRenderer.field_147852_aq *= f4;
            aRenderer.field_147860_au *= f4;
            aRenderer.field_147841_ay *= f4;
            aRenderer.field_147850_ar *= f5;
            aRenderer.field_147858_av *= f5;
            aRenderer.field_147839_az *= f5;
            aRenderer.field_147848_as *= f6;
            aRenderer.field_147856_aw *= f6;
            aRenderer.field_147833_aA *= f6;
        }

        public static void applyAmbientOcclusionZNeg(short[] aRGBa, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRenderer.field_147851_l <= 0.0) {
                --aZ;
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 1.0f;
            aRenderer.field_147819_N = aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ).func_149685_I();
            aRenderer.field_147814_A = aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ).func_149685_I();
            aRenderer.field_147822_I = aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ).func_149685_I();
            aRenderer.field_147820_O = aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ).func_149685_I();
            aRenderer.field_147883_ah = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX - 1, aY, aZ);
            aRenderer.field_147825_U = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY - 1, aZ);
            aRenderer.field_147878_ac = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY + 1, aZ);
            aRenderer.field_147866_ai = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX + 1, aY, aZ);
            boolean flag2 = aRenderer.field_147845_a.func_147439_a(aX + 1, aY, aZ - 1).func_149751_l();
            boolean flag3 = aRenderer.field_147845_a.func_147439_a(aX - 1, aY, aZ - 1).func_149751_l();
            boolean flag4 = aRenderer.field_147845_a.func_147439_a(aX, aY + 1, aZ - 1).func_149751_l();
            boolean flag5 = aRenderer.field_147845_a.func_147439_a(aX, aY - 1, aZ - 1).func_149751_l();
            if (!flag3 && !flag5) {
                aRenderer.field_147888_x = aRenderer.field_147819_N;
                aRenderer.field_147832_R = aRenderer.field_147883_ah;
            } else {
                aRenderer.field_147888_x = aRenderer.field_147845_a.func_147439_a(aX - 1, aY - 1, aZ).func_149685_I();
                int n = aRenderer.field_147832_R = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX - 1, aY - 1, aZ);
            }
            if (!flag3 && !flag4) {
                aRenderer.field_147812_F = aRenderer.field_147819_N;
                aRenderer.field_147836_Z = aRenderer.field_147883_ah;
            } else {
                aRenderer.field_147812_F = aRenderer.field_147845_a.func_147439_a(aX - 1, aY + 1, aZ).func_149685_I();
                int n = aRenderer.field_147836_Z = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX - 1, aY + 1, aZ);
            }
            if (!flag2 && !flag5) {
                aRenderer.field_147816_C = aRenderer.field_147820_O;
                aRenderer.field_147827_W = aRenderer.field_147866_ai;
            } else {
                aRenderer.field_147816_C = aRenderer.field_147845_a.func_147439_a(aX + 1, aY - 1, aZ).func_149685_I();
                int n = aRenderer.field_147827_W = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX + 1, aY - 1, aZ);
            }
            if (!flag2 && !flag4) {
                aRenderer.field_147823_J = aRenderer.field_147820_O;
                aRenderer.field_147879_ad = aRenderer.field_147866_ai;
            } else {
                aRenderer.field_147823_J = aRenderer.field_147845_a.func_147439_a(aX + 1, aY + 1, aZ).func_149685_I();
                int n = aRenderer.field_147879_ad = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX + 1, aY + 1, aZ);
            }
            if (aRenderer.field_147851_l <= 0.0) {
                ++aZ;
            }
            if (aRenderer.field_147851_l <= 0.0 || !UT.Worlds.isVisuallyOpaque(aRenderer.field_147845_a.func_147439_a(aX, aY, aZ - 1))) {
                aBrightness = aUseConstantBrightness ? aBrightness : aBlock.func_149677_c(aRenderer.field_147845_a, aX, aY, aZ - 1);
            }
            f7 = aRenderer.field_147845_a.func_147439_a(aX, aY, aZ - 1).func_149685_I();
            f3 = (aRenderer.field_147819_N + aRenderer.field_147812_F + f7 + aRenderer.field_147822_I) / 4.0f;
            f4 = (f7 + aRenderer.field_147822_I + aRenderer.field_147820_O + aRenderer.field_147823_J) / 4.0f;
            f5 = (aRenderer.field_147814_A + f7 + aRenderer.field_147816_C + aRenderer.field_147820_O) / 4.0f;
            f6 = (aRenderer.field_147888_x + aRenderer.field_147819_N + aRenderer.field_147814_A + f7) / 4.0f;
            aRenderer.field_147864_al = aRenderer.func_147778_a(aRenderer.field_147883_ah, aRenderer.field_147836_Z, aRenderer.field_147878_ac, aBrightness);
            aRenderer.field_147874_am = aRenderer.func_147778_a(aRenderer.field_147878_ac, aRenderer.field_147866_ai, aRenderer.field_147879_ad, aBrightness);
            aRenderer.field_147876_an = aRenderer.func_147778_a(aRenderer.field_147825_U, aRenderer.field_147827_W, aRenderer.field_147866_ai, aBrightness);
            aRenderer.field_147870_ao = aRenderer.func_147778_a(aRenderer.field_147832_R, aRenderer.field_147883_ah, aRenderer.field_147825_U, aBrightness);
            aRenderer.field_147850_ar = aRenderer.field_147848_as = (float)UT.Code.bind8(aRGBa[0]) / 256.0f * 0.8f;
            aRenderer.field_147852_aq = aRenderer.field_147848_as;
            aRenderer.field_147872_ap = aRenderer.field_147848_as;
            aRenderer.field_147858_av = aRenderer.field_147856_aw = (float)UT.Code.bind8(aRGBa[1]) / 256.0f * 0.8f;
            aRenderer.field_147860_au = aRenderer.field_147856_aw;
            aRenderer.field_147846_at = aRenderer.field_147856_aw;
            aRenderer.field_147839_az = aRenderer.field_147833_aA = (float)UT.Code.bind8(aRGBa[2]) / 256.0f * 0.8f;
            aRenderer.field_147841_ay = aRenderer.field_147833_aA;
            aRenderer.field_147854_ax = aRenderer.field_147833_aA;
            aRenderer.field_147872_ap *= f3;
            aRenderer.field_147846_at *= f3;
            aRenderer.field_147854_ax *= f3;
            aRenderer.field_147852_aq *= f4;
            aRenderer.field_147860_au *= f4;
            aRenderer.field_147841_ay *= f4;
            aRenderer.field_147850_ar *= f5;
            aRenderer.field_147858_av *= f5;
            aRenderer.field_147839_az *= f5;
            aRenderer.field_147848_as *= f6;
            aRenderer.field_147856_aw *= f6;
            aRenderer.field_147833_aA *= f6;
        }
    }
}

