/*
 * Decompiled with CFR 0.152.
 */
package gregapi.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.IRenderedBlockObjectSideCheck;
import gregapi.render.ITexture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public interface IRenderedBlockObject {
    @SideOnly(value=Side.CLIENT)
    public ITexture getTexture(Block var1, int var2, byte var3, boolean[] var4);

    @SideOnly(value=Side.CLIENT)
    public boolean usesRenderPass(int var1, boolean[] var2);

    @SideOnly(value=Side.CLIENT)
    public boolean setBlockBounds(Block var1, int var2, boolean[] var3);

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(Block var1, boolean[] var2);

    @SideOnly(value=Side.CLIENT)
    public boolean renderItem(Block var1, RenderBlocks var2);

    @SideOnly(value=Side.CLIENT)
    public boolean renderBlock(Block var1, RenderBlocks var2);

    @SideOnly(value=Side.CLIENT)
    public IRenderedBlockObject passRenderingToObject(ItemStack var1);

    @SideOnly(value=Side.CLIENT)
    public IRenderedBlockObject passRenderingToObject(IBlockAccess var1, int var2, int var3, int var4);

    public static class ErrorRenderer
    implements IRenderedBlockObjectSideCheck,
    IRenderedBlockObject {
        public static final ErrorRenderer INSTANCE = new ErrorRenderer();
        public ITexture mErrorTexture = BlockTextureDefault.get((IIconContainer)new Textures.BlockIcons.CustomIcon("system/error"), true);

        @Override
        public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
            return this.mErrorTexture;
        }

        @Override
        public boolean usesRenderPass(int aRenderPass, boolean[] aShouldSideBeRendered) {
            return true;
        }

        @Override
        public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
            return false;
        }

        @Override
        public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
            return 1;
        }

        @Override
        public boolean renderItem(Block aBlock, RenderBlocks aRenderer) {
            return false;
        }

        @Override
        public boolean renderBlock(Block aBlock, RenderBlocks aRenderer) {
            return false;
        }

        @Override
        public boolean renderFullBlockSide(Block aBlock, RenderBlocks aRenderer, byte aSide) {
            return true;
        }

        @Override
        public IRenderedBlockObject passRenderingToObject(ItemStack aStack) {
            return this;
        }

        @Override
        public IRenderedBlockObject passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
            return this;
        }
    }
}

