/*
 * Decompiled with CFR 0.152.
 */
package gregapi.render;

import gregapi.data.CS;
import gregapi.render.ITexture;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlockTextureFluid
implements ITexture {
    private final FluidStack mFluidStack;
    private final Fluid mFluid;
    private final int mLuminosity;
    private final boolean mAllowAlpha;
    public short[] mRGBa;

    public static BlockTextureFluid get(FluidStack aFluidStack, boolean aAllowAlpha) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureFluid(aFluidStack, aAllowAlpha) : null;
    }

    public static BlockTextureFluid get(FluidStack aFluidStack) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureFluid(aFluidStack) : null;
    }

    public static BlockTextureFluid get(Fluid aFluid, boolean aAllowAlpha) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureFluid(aFluid, aAllowAlpha) : null;
    }

    public static BlockTextureFluid get(Fluid aFluid) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureFluid(aFluid) : null;
    }

    public BlockTextureFluid(FluidStack aFluidStack, boolean aAllowAlpha) {
        if (aFluidStack == null) {
            this.mFluidStack = null;
            this.mFluid = null;
            this.mLuminosity = 0;
            this.mRGBa = CS.UNCOLOURED;
        } else {
            this.mFluidStack = aFluidStack;
            this.mFluid = this.mFluidStack.getFluid();
            this.mLuminosity = this.mFluid.getLuminosity(this.mFluidStack) * 16;
            this.mRGBa = UT.Code.getRGBaArray(this.mFluid.getColor(this.mFluidStack));
        }
        this.mAllowAlpha = aAllowAlpha;
    }

    public BlockTextureFluid(FluidStack aFluidStack) {
        this(aFluidStack, false);
    }

    public BlockTextureFluid(Fluid aFluid, boolean aAllowAlpha) {
        this(new FluidStack(aFluid, 0), aAllowAlpha);
    }

    public BlockTextureFluid(Fluid aFluid) {
        this(aFluid, false);
    }

    private IIcon getIcon(int aSide) {
        return this.mFluid.getIcon(this.mFluidStack);
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        ITexture.Util.renderSide((byte)5, this.getIcon(5), this.mRGBa, this.mAllowAlpha, this.mLuminosity > aBrightness, true, aRenderer, aBlock, aX, aY, aZ, Math.max(this.mLuminosity, aBrightness), aChangedBlockBounds);
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        ITexture.Util.renderSide((byte)4, this.getIcon(4), this.mRGBa, this.mAllowAlpha, this.mLuminosity > aBrightness, true, aRenderer, aBlock, aX, aY, aZ, Math.max(this.mLuminosity, aBrightness), aChangedBlockBounds);
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        ITexture.Util.renderSide((byte)1, this.getIcon(1), this.mRGBa, this.mAllowAlpha, this.mLuminosity > aBrightness, true, aRenderer, aBlock, aX, aY, aZ, Math.max(this.mLuminosity, aBrightness), aChangedBlockBounds);
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        ITexture.Util.renderSide((byte)0, this.getIcon(0), this.mRGBa, this.mAllowAlpha, this.mLuminosity > aBrightness, true, aRenderer, aBlock, aX, aY, aZ, Math.max(this.mLuminosity, aBrightness), aChangedBlockBounds);
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        ITexture.Util.renderSide((byte)3, this.getIcon(3), this.mRGBa, this.mAllowAlpha, this.mLuminosity > aBrightness, true, aRenderer, aBlock, aX, aY, aZ, Math.max(this.mLuminosity, aBrightness), aChangedBlockBounds);
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        ITexture.Util.renderSide((byte)2, this.getIcon(2), this.mRGBa, this.mAllowAlpha, this.mLuminosity > aBrightness, true, aRenderer, aBlock, aX, aY, aZ, Math.max(this.mLuminosity, aBrightness), aChangedBlockBounds);
    }

    @Override
    public boolean isValidTexture() {
        return this.mFluid != null;
    }
}

