/*
 * Decompiled with CFR 0.152.
 */
package gregapi.render;

import gregapi.data.CS;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;

public class BlockTextureDefault
implements ITexture {
    private final IIconContainer mIconContainer;
    public short[] mRGBa;
    private final boolean mAllowAlpha;
    private final boolean mUseMaxBrightness;
    private final boolean mUseConstantBrightness;
    private final boolean mEnableAO;

    public static BlockTextureDefault get(OreDictMaterial aMaterial, OreDictPrefix aPrefix, boolean aGlow, boolean aEnableAO) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aMaterial, aPrefix, aGlow, aEnableAO) : null;
    }

    public static BlockTextureDefault get(OreDictMaterial aMaterial, OreDictPrefix aPrefix, short[] aRGBa, boolean aGlow, boolean aEnableAO) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aMaterial, aPrefix, aRGBa, aGlow, aEnableAO) : null;
    }

    public static BlockTextureDefault get(OreDictMaterial aMaterial, int aTextureSetIndex, int aState, boolean aGlow, boolean aEnableAO) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aMaterial, aTextureSetIndex, aState, aGlow, aEnableAO) : null;
    }

    public static BlockTextureDefault get(OreDictMaterial aMaterial, int aTextureSetIndex, short[] aRGBa, boolean aGlow, boolean aEnableAO) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aMaterial, aTextureSetIndex, aRGBa, aGlow, aEnableAO) : null;
    }

    public static BlockTextureDefault get(OreDictMaterial aMaterial, OreDictPrefix aPrefix, boolean aGlow) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aMaterial, aPrefix, aGlow) : null;
    }

    public static BlockTextureDefault get(OreDictMaterial aMaterial, OreDictPrefix aPrefix, short[] aRGBa, boolean aGlow) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aMaterial, aPrefix, aRGBa, aGlow) : null;
    }

    public static BlockTextureDefault get(OreDictMaterial aMaterial, int aTextureSetIndex, int aState, boolean aGlow) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aMaterial, aTextureSetIndex, aState, aGlow) : null;
    }

    public static BlockTextureDefault get(OreDictMaterial aMaterial, int aTextureSetIndex, boolean aGlow, int aRGBa) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aMaterial, aTextureSetIndex, aGlow, aRGBa) : null;
    }

    public static BlockTextureDefault get(OreDictMaterial aMaterial, int aTextureSetIndex, short[] aRGBa, boolean aGlow) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aMaterial, aTextureSetIndex, aRGBa, aGlow) : null;
    }

    public static BlockTextureDefault get(OreDictMaterial aMaterial, int aTextureSetIndex, boolean aGlow) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aMaterial, aTextureSetIndex, aGlow) : null;
    }

    public static BlockTextureDefault get(OreDictMaterial aMaterial, int aTextureSetIndex) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aMaterial, aTextureSetIndex) : null;
    }

    public static BlockTextureDefault get(IIconContainer aIcon, int aRGBa, boolean aGlow) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aIcon, aRGBa, aGlow) : null;
    }

    public static BlockTextureDefault get(IIconContainer aIcon, boolean aGlow) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aIcon, aGlow) : null;
    }

    public static BlockTextureDefault get(IIconContainer aIcon, int aRGBa) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aIcon, aRGBa) : null;
    }

    public static BlockTextureDefault get(IIconContainer aIcon, short[] aRGBa) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aIcon, aRGBa) : null;
    }

    public static BlockTextureDefault get(IIconContainer aIcon, int aRGBa, boolean aAllowAlpha, boolean aUseMaxBrightness, boolean aUseConstantBrightness, boolean aEnableAO) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aIcon, aRGBa, aAllowAlpha, aUseMaxBrightness, aUseConstantBrightness, aEnableAO) : null;
    }

    public static BlockTextureDefault get(IIconContainer aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseMaxBrightness, boolean aUseConstantBrightness, boolean aEnableAO) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aIcon, aRGBa, aAllowAlpha, aUseMaxBrightness, aUseConstantBrightness, aEnableAO) : null;
    }

    public static BlockTextureDefault get(IIconContainer aIcon) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureDefault(aIcon) : null;
    }

    public BlockTextureDefault(OreDictMaterial aMaterial, OreDictPrefix aPrefix, boolean aGlow, boolean aEnableAO) {
        this(aMaterial, aPrefix, aMaterial.mRGBa[aPrefix.mState], aGlow, aEnableAO);
    }

    public BlockTextureDefault(OreDictMaterial aMaterial, OreDictPrefix aPrefix, short[] aRGBa, boolean aGlow, boolean aEnableAO) {
        this(aMaterial, aPrefix.mIconIndexBlock, aRGBa, aGlow, aEnableAO);
    }

    public BlockTextureDefault(OreDictMaterial aMaterial, int aTextureSetIndex, int aState, boolean aGlow, boolean aEnableAO) {
        this(aMaterial, aTextureSetIndex, aMaterial.mRGBa[aState], aGlow, aEnableAO);
    }

    public BlockTextureDefault(OreDictMaterial aMaterial, int aTextureSetIndex, short[] aRGBa, boolean aGlow, boolean aEnableAO) {
        this(aMaterial.mTextureSetsBlock.get(aTextureSetIndex), aRGBa, false, aGlow, false, aEnableAO);
    }

    public BlockTextureDefault(OreDictMaterial aMaterial, OreDictPrefix aPrefix, boolean aGlow) {
        this(aMaterial, aPrefix, aMaterial.mRGBa[aPrefix.mState], aGlow);
    }

    public BlockTextureDefault(OreDictMaterial aMaterial, OreDictPrefix aPrefix, short[] aRGBa, boolean aGlow) {
        this(aMaterial, aPrefix.mIconIndexBlock, aRGBa, aGlow);
    }

    public BlockTextureDefault(OreDictMaterial aMaterial, int aTextureSetIndex, int aState, boolean aGlow) {
        this(aMaterial, aTextureSetIndex, aMaterial.mRGBa[aState], aGlow);
    }

    public BlockTextureDefault(OreDictMaterial aMaterial, int aTextureSetIndex, boolean aGlow, int aRGBa) {
        this(aMaterial, aTextureSetIndex, UT.Code.getRGBaArray(aRGBa), aGlow);
    }

    public BlockTextureDefault(OreDictMaterial aMaterial, int aTextureSetIndex, short[] aRGBa, boolean aGlow) {
        this(aMaterial.mTextureSetsBlock.get(aTextureSetIndex), aRGBa, false, aGlow, false, true);
    }

    public BlockTextureDefault(OreDictMaterial aMaterial, int aTextureSetIndex, boolean aGlow) {
        this(aMaterial, aTextureSetIndex, 0, aGlow);
    }

    public BlockTextureDefault(OreDictMaterial aMaterial, int aTextureSetIndex) {
        this(aMaterial, aTextureSetIndex, false);
    }

    public BlockTextureDefault(IIconContainer aIcon, int aRGBa, boolean aGlow) {
        this(aIcon, aRGBa, false, aGlow, false, true);
    }

    public BlockTextureDefault(IIconContainer aIcon, boolean aGlow) {
        this(aIcon, CS.UNCOLOURED, false, aGlow, false, true);
    }

    public BlockTextureDefault(IIconContainer aIcon, int aRGBa) {
        this(aIcon, aRGBa, false, false, false, true);
    }

    public BlockTextureDefault(IIconContainer aIcon, short[] aRGBa) {
        this(aIcon, aRGBa, false, false, false, true);
    }

    public BlockTextureDefault(IIconContainer aIcon, int aRGBa, boolean aAllowAlpha, boolean aUseMaxBrightness, boolean aUseConstantBrightness, boolean aEnableAO) {
        this(aIcon, UT.Code.getRGBaArray(aRGBa), aAllowAlpha, aUseMaxBrightness, aUseConstantBrightness, aEnableAO);
    }

    public BlockTextureDefault(IIconContainer aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseMaxBrightness, boolean aUseConstantBrightness, boolean aEnableAO) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ BlockTextureDefault");
        }
        this.mIconContainer = aIcon;
        this.mUseMaxBrightness = aUseMaxBrightness;
        this.mUseConstantBrightness = aUseMaxBrightness || aUseConstantBrightness;
        this.mAllowAlpha = aAllowAlpha;
        this.mEnableAO = aEnableAO;
        this.mRGBa = aRGBa;
    }

    public BlockTextureDefault(IIconContainer aIcon) {
        this(aIcon, CS.UNCOLOURED, false, false, false, true);
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        int j = this.mIconContainer.getIconPasses();
        for (int i = 0; i < j; ++i) {
            ITexture.Util.renderSide((byte)5, this.mIconContainer.getIcon(i), this.mIconContainer.isUsingColorModulation(i) ? this.mRGBa : this.mIconContainer.getIconColor(i), this.mAllowAlpha, this.mUseConstantBrightness, this.mEnableAO, aRenderer, aBlock, aX, aY, aZ, this.mUseMaxBrightness ? 240 : aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        int j = this.mIconContainer.getIconPasses();
        for (int i = 0; i < j; ++i) {
            ITexture.Util.renderSide((byte)4, this.mIconContainer.getIcon(i), this.mIconContainer.isUsingColorModulation(i) ? this.mRGBa : this.mIconContainer.getIconColor(i), this.mAllowAlpha, this.mUseConstantBrightness, this.mEnableAO, aRenderer, aBlock, aX, aY, aZ, this.mUseMaxBrightness ? 240 : aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        int j = this.mIconContainer.getIconPasses();
        for (int i = 0; i < j; ++i) {
            ITexture.Util.renderSide((byte)1, this.mIconContainer.getIcon(i), this.mIconContainer.isUsingColorModulation(i) ? this.mRGBa : this.mIconContainer.getIconColor(i), this.mAllowAlpha, this.mUseConstantBrightness, this.mEnableAO, aRenderer, aBlock, aX, aY, aZ, this.mUseMaxBrightness ? 240 : aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        int j = this.mIconContainer.getIconPasses();
        for (int i = 0; i < j; ++i) {
            ITexture.Util.renderSide((byte)0, this.mIconContainer.getIcon(i), this.mIconContainer.isUsingColorModulation(i) ? this.mRGBa : this.mIconContainer.getIconColor(i), this.mAllowAlpha, this.mUseConstantBrightness, this.mEnableAO, aRenderer, aBlock, aX, aY, aZ, this.mUseMaxBrightness ? 240 : aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        int j = this.mIconContainer.getIconPasses();
        for (int i = 0; i < j; ++i) {
            ITexture.Util.renderSide((byte)3, this.mIconContainer.getIcon(i), this.mIconContainer.isUsingColorModulation(i) ? this.mRGBa : this.mIconContainer.getIconColor(i), this.mAllowAlpha, this.mUseConstantBrightness, this.mEnableAO, aRenderer, aBlock, aX, aY, aZ, this.mUseMaxBrightness ? 240 : aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        int j = this.mIconContainer.getIconPasses();
        for (int i = 0; i < j; ++i) {
            ITexture.Util.renderSide((byte)2, this.mIconContainer.getIcon(i), this.mIconContainer.isUsingColorModulation(i) ? this.mRGBa : this.mIconContainer.getIconColor(i), this.mAllowAlpha, this.mUseConstantBrightness, this.mEnableAO, aRenderer, aBlock, aX, aY, aZ, this.mUseMaxBrightness ? 240 : aBrightness, aChangedBlockBounds);
        }
    }

    public short[] getRGBA() {
        return this.mRGBa;
    }

    @Override
    public boolean isValidTexture() {
        return this.mIconContainer != null;
    }
}

