/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.data.CS;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.recipes.Recipe;
import gregapi.recipes.maps.RecipeMapSpecialSingleInput;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RecipeMapShredder
extends RecipeMapSpecialSingleInput {
    private List<Recipe> mBufferedDynamicRecipes = null;

    public RecipeMapShredder(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs);
    }

    @Override
    public List<Recipe> getNEIAllRecipes() {
        List<Recipe> rList = super.getNEIAllRecipes();
        if (this.mBufferedDynamicRecipes == null) {
            this.mBufferedDynamicRecipes = new ArrayListNoNulls<Recipe>();
            for (OreDictMaterial tMaterial : OP.dust.mRegisteredMaterials) {
                for (ItemStackContainer tStack : tMaterial.mRegisteredItems) {
                    this.mBufferedDynamicRecipes.add(this.getRecipeFor(tStack.toStack()));
                }
            }
        }
        rList.addAll(this.mBufferedDynamicRecipes);
        return rList;
    }

    @Override
    public List<Recipe> getNEIRecipes(ItemStack ... aOutputs) {
        List<Recipe> rList = super.getNEIRecipes(aOutputs);
        for (ItemStack aOutput : aOutputs) {
            OreDictItemData aData = OM.anyassociation(aOutput);
            if (aData == null || !aData.mPrefix.contains(TD.Prefix.DUST_BASED)) continue;
            for (ItemStackContainer tStack : aData.mMaterial.mMaterial.mRegisteredItems) {
                rList.add(this.getRecipeFor(tStack.toStack()));
            }
            break;
        }
        return rList;
    }

    @Override
    protected Recipe getRecipeFor(ItemStack aInput) {
        OreDictItemData aData = OM.anydata(aInput);
        if (aData == null || aData.mMaterial != null && aData.mMaterial.mMaterial.contains(TD.Atomic.ANTIMATTER) || aData.mPrefix != null && (UT.Fluids.getFluidForFilledItem(aInput, true) != null || aData.mPrefix.containsAny(TD.Prefix.DUST_BASED, TD.Prefix.ORE, TD.Prefix.ORE_PROCESSING_DIRTY) || !aData.mPrefix.contains(TD.Prefix.RECYCLABLE))) {
            return null;
        }
        ArrayListNoNulls<OreDictMaterialStack> tList = new ArrayListNoNulls<OreDictMaterialStack>();
        for (OreDictMaterialStack tMaterial : aData.getAllMaterialStacks()) {
            if (tMaterial.mMaterial.mTargetPulver.mAmount <= 0L) continue;
            OM.stack(UT.Code.units(tMaterial.mAmount, 420076800L, tMaterial.mMaterial.mTargetPulver.mAmount, false), tMaterial.mMaterial.mTargetPulver.mMaterial).addToList(tList);
        }
        if (tList.isEmpty()) {
            return null;
        }
        ItemStack[] tOutputs = new ItemStack[Math.min(tList.size(), this.mOutputItemsCount)];
        int i = 0;
        int tDuration = 0;
        for (OreDictMaterialStack tMaterial : tList) {
            ItemStack tStack;
            tDuration = (int)((long)tDuration + UT.Code.units(tMaterial.mAmount, 420076800L, 256 * Math.max(1, tMaterial.mMaterial.mToolQuality + 1), true));
            if (i >= tOutputs.length || (tStack = OM.dust(tMaterial)) == null) continue;
            tOutputs[i++] = tStack;
        }
        if (!UT.Code.exists(0, tOutputs)) {
            return null;
        }
        Recipe rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, aInput)}, tOutputs, null, null, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, Math.max(1, tDuration), 16L, 0L);
        rRecipe.mCanBeBuffered = false;
        return rRecipe;
    }
}

