/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackMap;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapScannerVisuals
extends Recipe.RecipeMap {
    public final ItemStackMap<ItemStackContainer, ItemStack> mMappings = new ItemStackMap();

    public RecipeMapScannerVisuals(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs);
        this.mMappings.put(new ItemStackContainer(Items.field_151033_d, 1L, 32767L), UT.Stacks.make((Block)Blocks.field_150480_ab, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151120_aE, 1L, 32767L), UT.Stacks.make(Blocks.field_150436_aH, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151126_ay, 1L, 32767L), UT.Stacks.make(Blocks.field_150433_aE, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151014_N, 1L, 32767L), UT.Stacks.make(Blocks.field_150464_aj, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151015_O, 1L, 32767L), UT.Stacks.make(Blocks.field_150464_aj, 1L, 7L));
        this.mMappings.put(new ItemStackContainer(Items.field_151172_bF, 1L, 32767L), UT.Stacks.make(Blocks.field_150459_bM, 1L, 7L));
        this.mMappings.put(new ItemStackContainer(Items.field_151170_bI, 1L, 32767L), UT.Stacks.make(Blocks.field_150469_bN, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151174_bG, 1L, 32767L), UT.Stacks.make(Blocks.field_150469_bN, 1L, 7L));
        this.mMappings.put(new ItemStackContainer(Items.field_151081_bc, 1L, 32767L), UT.Stacks.make(Blocks.field_150394_bc, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151127_ba, 1L, 32767L), UT.Stacks.make(Blocks.field_150394_bc, 1L, 7L));
        this.mMappings.put(new ItemStackContainer(Items.field_151080_bb, 1L, 32767L), UT.Stacks.make(Blocks.field_150393_bb, 1L, 7L));
        this.mMappings.put(new ItemStackContainer(Items.field_151100_aR, 1L, 3L), UT.Stacks.make(Blocks.field_150375_by, 1L, 8L));
        this.mMappings.put(new ItemStackContainer(Items.field_151007_F, 1L, 32767L), UT.Stacks.make(Blocks.field_150321_G, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151075_bm, 1L, 32767L), UT.Stacks.make(Blocks.field_150388_bm, 1L, 3L));
        this.mMappings.put(new ItemStackContainer(Items.field_151132_bS, 1L, 32767L), UT.Stacks.make((Block)Blocks.field_150455_bV, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151107_aW, 1L, 32767L), UT.Stacks.make((Block)Blocks.field_150416_aS, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151104_aV, 1L, 32767L), UT.Stacks.make(Blocks.field_150324_C, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151139_aw, 1L, 32767L), UT.Stacks.make(Blocks.field_150454_av, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151135_aq, 1L, 32767L), UT.Stacks.make(Blocks.field_150466_ao, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151079_bi, 1L, 32767L), UT.Stacks.make((Block)Blocks.field_150427_aO, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151061_bv, 1L, 32767L), UT.Stacks.make(Blocks.field_150378_br, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151131_as, 1L, 32767L), UT.Stacks.make(Blocks.field_150355_j, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151129_at, 1L, 32767L), UT.Stacks.make(Blocks.field_150353_l, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151066_bu, 1L, 32767L), UT.Stacks.make((Block)Blocks.field_150383_bp, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151067_bt, 1L, 32767L), UT.Stacks.make(Blocks.field_150382_bo, 1L, 0L));
        this.mMappings.put(new ItemStackContainer(Items.field_151162_bE, 1L, 32767L), UT.Stacks.make(Blocks.field_150457_bL, 1L, 0L));
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (aInputs == null || aInputs.length < 2 || aInputs[0] == null || aInputs[1] == null || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        if (rRecipe == null) {
            ItemStack tUSB = null;
            ItemStack tScanned = null;
            for (ItemStack aInput : aInputs) {
                Block tBlock;
                if (!UT.Stacks.valid(aInput)) continue;
                if (UT.Stacks.invalid(tUSB) && OM.is_(CS.OD_USB_STICKS[1], aInput)) {
                    tUSB = aInput;
                } else {
                    tScanned = aInput;
                }
                if (!UT.Stacks.valid(tUSB) || !UT.Stacks.valid(tScanned)) continue;
                assert (tScanned != null);
                if (IL.Paper_Blueprint_Used.equal(tScanned, false, true)) {
                    ItemStack[] tCraftingRecipe = UT.NBT.getBlueprintCrafting(tScanned);
                    if (tCraftingRecipe != CS.ZL_ITEMSTACK) {
                        rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, tScanned), UT.Stacks.amount(1L, tUSB)}, new ItemStack[]{UT.Stacks.amount(1L, tUSB), UT.Stacks.amount(1L, tScanned)}, null, null, null, null, 64L, 16L, 0L);
                        rRecipe.mCanBeBuffered = false;
                        if (!rRecipe.mOutputs[0].func_77942_o()) {
                            rRecipe.mOutputs[0].func_77982_d(new NBTTagCompound());
                        }
                        rRecipe.mOutputs[0].func_77978_p().func_74782_a("gt.usb.data", (NBTBase)UT.NBT.setBlueprintCrafting(new NBTTagCompound(), tCraftingRecipe));
                        rRecipe.mOutputs[0].func_77978_p().func_74774_a("gt.usb.tier", (byte)1);
                        return rRecipe;
                    }
                    return rRecipe;
                }
                if (OM.is_("gt:canvas", tScanned)) {
                    if (tScanned.func_77942_o() && tScanned.func_77978_p().func_74764_b("gt.canvas.block")) {
                        rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, tScanned), UT.Stacks.amount(1L, tUSB)}, new ItemStack[]{UT.Stacks.amount(1L, tUSB), UT.Stacks.amount(1L, tScanned)}, null, null, null, null, 64L, 16L, 0L);
                        rRecipe.mCanBeBuffered = false;
                        if (!rRecipe.mOutputs[0].func_77942_o()) {
                            rRecipe.mOutputs[0].func_77982_d(new NBTTagCompound());
                        }
                        NBTTagCompound tNBT = new NBTTagCompound();
                        tNBT.func_74768_a("gt.canvas.block", tScanned.func_77978_p().func_74762_e("gt.canvas.block"));
                        tNBT.func_74768_a("gt.canvas.meta", tScanned.func_77978_p().func_74762_e("gt.canvas.meta"));
                        rRecipe.mOutputs[0].func_77978_p().func_74782_a("gt.usb.data", (NBTBase)tNBT);
                        rRecipe.mOutputs[0].func_77978_p().func_74774_a("gt.usb.tier", (byte)1);
                        return rRecipe;
                    }
                    return rRecipe;
                }
                if ((tScanned.func_77973_b() == CS.ItemsGT.sMultiItemBooks || OM.is_("bookWritten", tScanned) || IL.Paper_Printed_Pages.equal(tScanned, false, true) || IL.Paper_Printed_Pages_Many.equal(tScanned, false, true)) && UT.Code.stringValid(UT.NBT.getBookTitle(tScanned))) {
                    rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, tScanned), UT.Stacks.amount(1L, tUSB)}, new ItemStack[]{UT.Stacks.amount(1L, tUSB), UT.Stacks.amount(1L, tScanned)}, null, null, null, null, 512L, 16L, 0L);
                    rRecipe.mCanBeBuffered = false;
                    if (!rRecipe.mOutputs[0].func_77942_o()) {
                        rRecipe.mOutputs[0].func_77982_d(new NBTTagCompound());
                    }
                    rRecipe.mOutputs[0].func_77978_p().func_74782_a("gt.usb.data", tScanned.func_77978_p().func_74737_b());
                    rRecipe.mOutputs[0].func_77978_p().func_74774_a("gt.usb.tier", (byte)1);
                    return rRecipe;
                }
                if (tScanned.func_77973_b() == Items.field_151098_aY) {
                    rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, tScanned), UT.Stacks.amount(1L, tUSB)}, new ItemStack[]{UT.Stacks.amount(1L, tUSB), UT.Stacks.amount(1L, tScanned)}, null, null, null, null, 64L, 16L, 0L);
                    rRecipe.mCanBeBuffered = false;
                    if (!rRecipe.mOutputs[0].func_77942_o()) {
                        rRecipe.mOutputs[0].func_77982_d(new NBTTagCompound());
                    }
                    rRecipe.mOutputs[0].func_77978_p().func_74782_a("gt.usb.data", (NBTBase)UT.NBT.setMapID(new NBTTagCompound(), UT.Stacks.meta(tScanned)));
                    rRecipe.mOutputs[0].func_77978_p().func_74774_a("gt.usb.tier", (byte)1);
                    return rRecipe;
                }
                ItemStack tMapping = this.mMappings.get(tScanned.func_77973_b(), (long)UT.Stacks.meta(tScanned));
                if (tMapping == null) {
                    tMapping = this.mMappings.get(tScanned.func_77973_b(), 32767L);
                }
                if ((tBlock = UT.Stacks.block_(tMapping == null ? tScanned : tMapping)) != null && tBlock != CS.NB) {
                    rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, tScanned), UT.Stacks.amount(1L, tUSB)}, new ItemStack[]{UT.Stacks.amount(1L, tUSB), UT.Stacks.amount(1L, tScanned)}, null, null, null, null, 512L, 16L, 0L);
                    rRecipe.mCanBeBuffered = false;
                    if (!rRecipe.mOutputs[0].func_77942_o()) {
                        rRecipe.mOutputs[0].func_77982_d(new NBTTagCompound());
                    }
                    NBTTagCompound tNBT = new NBTTagCompound();
                    tNBT.func_74768_a("gt.canvas.block", Block.func_149682_b((Block)tBlock));
                    tNBT.func_74768_a("gt.canvas.meta", (int)UT.Stacks.meta(tScanned));
                    rRecipe.mOutputs[0].func_77978_p().func_74782_a("gt.usb.data", (NBTBase)tNBT);
                    rRecipe.mOutputs[0].func_77978_p().func_74774_a("gt.usb.tier", (byte)1);
                    return rRecipe;
                }
                return rRecipe;
            }
        }
        return rRecipe;
    }

    @Override
    public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return true;
    }
}

