/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.oredict.OreDictMaterial;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.tileentity.computer.ITileEntityUSBPort;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapReplicator
extends Recipe.RecipeMap {
    public RecipeMapReplicator(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs);
        this.mMaxFluidInputSize = 2000;
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        short tID;
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (rRecipe != null || aInputs == null || aFluids == null || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        ItemStack tUSB = null;
        NBTTagCompound tData = null;
        block0: for (ItemStack aInput : aInputs) {
            if (aInput == null || tData != null) continue;
            if (OM.is_(CS.OD_USB_STICKS[3], aInput)) {
                if (!aInput.func_77942_o()) {
                    return rRecipe;
                }
                tUSB = aInput;
                tData = tUSB.func_77978_p().func_74775_l("gt.usb.data");
                continue;
            }
            if (!OM.is_(CS.OD_USB_CABLES[3], aInput)) continue;
            if (aTileEntity == null) {
                return rRecipe;
            }
            tUSB = aInput;
            for (byte tSide : CS.ALL_SIDES_VALID_ONLY[tUSB.func_77942_o() && tUSB.func_77978_p().func_74764_b("gt.usb.dir") ? (int)tUSB.func_77978_p().func_74771_c("gt.usb.dir") : 6]) {
                DelegatorTileEntity<TileEntity> tDelegator = aTileEntity.getAdjacentTileEntity(tSide);
                if (!(tDelegator.mTileEntity instanceof ITileEntityUSBPort) || (tData = ((ITileEntityUSBPort)tDelegator.mTileEntity).getUSBData(tDelegator.mSideOfTileEntity, 3)) == null) continue;
                if (!tData.func_82582_d()) continue block0;
                tData = null;
            }
        }
        if (tData == null || tData.func_82582_d()) {
            return rRecipe;
        }
        if (tUSB != null && tData.func_74764_b("gt.replicator.data") && (tID = tData.func_74765_d("gt.replicator.data")) > 0 && UT.Code.exists(tID, OreDictMaterial.MATERIAL_ARRAY)) {
            return RecipeMapReplicator.getReplicatorRecipe(OreDictMaterial.MATERIAL_ARRAY[tID], tUSB);
        }
        return rRecipe;
    }

    public static Recipe getReplicatorRecipe(OreDictMaterial aMaterial, ItemStack aUSB) {
        if (aMaterial.contains(TD.Processing.UUM) && !aMaterial.contains(TD.Atomic.ANTIMATTER)) {
            FluidStack tFluidOutput;
            FluidStack[] tMatters = new FluidStack[]{aMaterial.mNeutrons <= 0L ? CS.NF : UT.Fluids.make("neutralmatter", aMaterial.mNeutrons), aMaterial.mProtons <= 0L ? CS.NF : UT.Fluids.make("chargedmatter", aMaterial.mProtons)};
            long tPower = (aMaterial.mProtons + aMaterial.mNeutrons) * 65536L;
            if (aMaterial.mMeltingPoint <= 293L && (tFluidOutput = aMaterial.fluid(293L, 420076800L, false)) != null) {
                return new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(0L, aUSB)}, CS.ZL_ITEMSTACK, null, null, tMatters, new FluidStack[]{tFluidOutput}, tPower, 1L, 0L).setNoBuffering();
            }
            ItemStack tOutput = CS.NI;
            if (aMaterial == MT.Redstone || aMaterial == MT.Glowstone || aMaterial == MT.Nikolite || aMaterial == MT.Teslatite || aMaterial == MT.Electrotine) {
                tOutput = OP.dust.mat(aMaterial, 1L);
            }
            if (aMaterial == MT.Si || aMaterial == MT.RedstoneAlloy) {
                tOutput = OP.plateGem.mat(aMaterial, 1L);
            }
            if (tOutput == null && UT.Stacks.invalid(tOutput = OP.gem.mat(aMaterial, 1L)) && UT.Stacks.invalid(tOutput = OP.plateGem.mat(aMaterial, 1L)) && UT.Stacks.invalid(tOutput = OP.ingot.mat(aMaterial, 1L)) && UT.Stacks.invalid(tOutput = OP.plate.mat(aMaterial, 1L)) && UT.Stacks.invalid(tOutput = OP.nugget.mat(aMaterial, 9L)) && UT.Stacks.invalid(tOutput = OP.chunkGt.mat(aMaterial, 4L)) && UT.Stacks.invalid(tOutput = OP.dust.mat(aMaterial, 1L)) && UT.Stacks.invalid(tOutput = OP.dustTiny.mat(aMaterial, 9L)) && UT.Stacks.invalid(tOutput = OP.dustSmall.mat(aMaterial, 4L)) && UT.Stacks.invalid(tOutput = OP.stick.mat(aMaterial, 2L))) {
                FluidStack tFluidOutput2 = aMaterial.liquid(420076800L, false);
                if (tFluidOutput2 == null) {
                    tFluidOutput2 = aMaterial.gas(420076800L, false);
                }
                if (tFluidOutput2 == null) {
                    tFluidOutput2 = aMaterial.plasma(420076800L, false);
                }
                if (tFluidOutput2 == null) {
                    return null;
                }
                return new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(0L, aUSB)}, CS.ZL_ITEMSTACK, null, null, tMatters, new FluidStack[]{tFluidOutput2}, tPower, 1L, 0L).setNoBuffering();
            }
            return new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(0L, aUSB)}, new ItemStack[]{tOutput}, null, null, tMatters, null, tPower, 1L, 0L).setNoBuffering();
        }
        return null;
    }

    @Override
    public boolean containsInput(FluidStack aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return super.containsInput(aFluid, aTileEntity, aSpecialSlot) || UT.Fluids.is(aFluid, "neutralmatter", "chargedmatter");
    }

    @Override
    public boolean containsInput(Fluid aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return super.containsInput(aFluid, aTileEntity, aSpecialSlot) || UT.Fluids.is(aFluid, "neutralmatter", "chargedmatter");
    }
}

