/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.oredict.OreDictMaterial;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.GT_ModHandler;
import gregapi.recipes.Recipe;
import gregapi.tileentity.computer.ITileEntityUSBPort;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapPrinter
extends Recipe.RecipeMap {
    public RecipeMapPrinter(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs);
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (rRecipe != null || aInputs == null || aInputs.length <= 0 || aInputs[0] == null || aFluids == null || aFluids.length <= 0 || aFluids[0] == null || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        ItemStack tUSB = null;
        ItemStack tPaper = null;
        NBTTagCompound tData = null;
        block0: for (ItemStack aInput : aInputs) {
            if (aInput == null) continue;
            if (tData == null) {
                if (OM.is_(CS.OD_USB_STICKS[1], aInput)) {
                    if (!aInput.func_77942_o()) {
                        return rRecipe;
                    }
                    tUSB = aInput;
                    tData = tUSB.func_77978_p().func_74775_l("gt.usb.data");
                    continue;
                }
                if (OM.is_(CS.OD_USB_CABLES[1], aInput)) {
                    if (aTileEntity == null) {
                        return rRecipe;
                    }
                    tUSB = aInput;
                    for (byte tSide : CS.ALL_SIDES_VALID_ONLY[tUSB.func_77942_o() && tUSB.func_77978_p().func_74764_b("gt.usb.dir") ? (int)tUSB.func_77978_p().func_74771_c("gt.usb.dir") : 6]) {
                        DelegatorTileEntity<TileEntity> tDelegator = aTileEntity.getAdjacentTileEntity(tSide);
                        if (!(tDelegator.mTileEntity instanceof ITileEntityUSBPort) || (tData = ((ITileEntityUSBPort)tDelegator.mTileEntity).getUSBData(tDelegator.mSideOfTileEntity, 1)) == null) continue;
                        if (!tData.func_82582_d()) continue block0;
                        tData = null;
                    }
                    continue;
                }
                tPaper = aInput;
                continue;
            }
            tPaper = aInput;
        }
        if (tData == null || tData.func_82582_d()) {
            return rRecipe;
        }
        if (tPaper != null && tUSB != null) {
            ItemStack[] tBlueprint;
            if (OM.is_("gt:canvas", tPaper)) {
                if (!(!tData.func_74764_b("gt.canvas.block") || tPaper.func_77942_o() && tPaper.func_77978_p().func_74764_b("gt.canvas.block"))) {
                    rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, tPaper), UT.Stacks.amount(0L, tUSB)}, new ItemStack[]{UT.Stacks.amount(1L, tPaper)}, null, null, new FluidStack[]{UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[0], 1L, 9L, true), UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[6], 1L, 9L, true), UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[13], 1L, 9L, true), UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[11], 1L, 9L, true)}, null, 64L, 16L, 0L);
                    rRecipe.mCanBeBuffered = false;
                    NBTTagCompound tNBT = rRecipe.mOutputs[0].func_77978_p();
                    if (tNBT == null) {
                        tNBT = new NBTTagCompound();
                    }
                    tNBT.func_74768_a("gt.canvas.block", tData.func_74762_e("gt.canvas.block"));
                    tNBT.func_74768_a("gt.canvas.meta", tData.func_74762_e("gt.canvas.meta"));
                    rRecipe.mOutputs[0].func_77982_d(tNBT);
                    return rRecipe;
                }
                return rRecipe;
            }
            if (IL.Paper_Blueprint_Empty.equal(tPaper, false, true)) {
                tBlueprint = UT.NBT.getBlueprintCrafting(tData);
                if (tBlueprint != CS.ZL_ITEMSTACK) {
                    ItemStack tCrafted = GT_ModHandler.getAllRecipeOutput(null, tBlueprint);
                    rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, tPaper), UT.Stacks.amount(0L, tUSB)}, new ItemStack[]{IL.Paper_Blueprint_Used.getWithNameAndNBT(1L, tCrafted == null ? null : tCrafted.func_82833_r(), UT.NBT.setBlueprintCrafting(new NBTTagCompound(), tBlueprint), new Object[0])}, null, null, new FluidStack[]{UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[15], 1L, 9L, true)}, null, 32L, 16L, 0L);
                    rRecipe.mCanBeBuffered = false;
                    return rRecipe;
                }
                return rRecipe;
            }
            if (IL.Paper_Punch_Card_Empty.equal(tPaper, false, true)) {
                if (UT.Code.stringValid(UT.NBT.getPunchCardData(tData))) {
                    rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, tPaper), UT.Stacks.amount(0L, tUSB)}, new ItemStack[]{IL.Paper_Punch_Card_Encoded.get(1L, new Object[0])}, null, null, new FluidStack[]{UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[0], 1L, 9L, true)}, null, 32L, 16L, 0L);
                    rRecipe.mCanBeBuffered = false;
                    UT.NBT.setPunchCardData(rRecipe.mOutputs[0], UT.NBT.getPunchCardData(tData));
                    return rRecipe;
                }
                return rRecipe;
            }
            if (OM.is_("paperEmpty", tPaper)) {
                tBlueprint = UT.NBT.getBlueprintCrafting(tData);
                if (tBlueprint != CS.ZL_ITEMSTACK) {
                    ItemStack tCrafted = GT_ModHandler.getAllRecipeOutput(null, tBlueprint);
                    rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, tPaper), UT.Stacks.amount(0L, tUSB)}, new ItemStack[]{IL.Paper_Blueprint_Used.getWithNameAndNBT(1L, tCrafted == null ? null : tCrafted.func_82833_r(), UT.NBT.setBlueprintCrafting(new NBTTagCompound(), tBlueprint), new Object[0])}, null, null, new FluidStack[]{CS.DYE_FLUIDS_CHEMICAL[4]}, null, 128L, 16L, 0L);
                    rRecipe.mCanBeBuffered = false;
                    return rRecipe;
                }
                if (UT.Code.stringValid(UT.NBT.getBookTitle(tData)) && UT.Code.stringValid(UT.NBT.getBookAuthor(tData))) {
                    ItemStack tBook;
                    String aMapping;
                    NBTTagList tPages = tData.func_150295_c("pages", 8);
                    if ((tPages == null || tPages.func_74745_c() < 1) && UT.Code.stringValid(aMapping = UT.NBT.getBookMapping(tData)) && (tBook = UT.Books.getWrittenBook(aMapping, CS.NI)) != null && tBook.func_77942_o()) {
                        tPages = tBook.func_77978_p().func_150295_c("pages", 8);
                    }
                    boolean tUseManyPages = tPages != null && tPages.func_74745_c() > 50;
                    rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(tUseManyPages ? 6L : 3L, tPaper), UT.Stacks.amount(0L, tUSB)}, new ItemStack[]{tUseManyPages ? IL.Paper_Printed_Pages_Many.get(1L, new Object[0]) : IL.Paper_Printed_Pages.get(1L, new Object[0])}, null, null, new FluidStack[]{UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[0], 1L, tUseManyPages ? 1L : 2L, true)}, null, tUseManyPages ? 1024L : 512L, 16L, 0L);
                    rRecipe.mCanBeBuffered = false;
                    rRecipe.mOutputs[0].func_77982_d((NBTTagCompound)tData.func_74737_b());
                    return rRecipe;
                }
                short tID = tData.func_74765_d("gt.replicator.data");
                if (tID > 0 && UT.Code.exists(tID, OreDictMaterial.MATERIAL_ARRAY)) {
                    OreDictMaterial tMaterial = OreDictMaterial.MATERIAL_ARRAY[tID];
                    if (UT.Stacks.valid(tMaterial.mDictionaryBook)) {
                        boolean tUseManyPages = UT.Stacks.meta(tMaterial.mDictionaryBook) == 32003;
                        rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(tUseManyPages ? 6L : 3L, tPaper), UT.Stacks.amount(0L, tUSB)}, new ItemStack[]{tUseManyPages ? IL.Paper_Printed_Pages_Many.get(1L, new Object[0]) : IL.Paper_Printed_Pages.get(1L, new Object[0])}, null, null, new FluidStack[]{UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[0], 1L, tUseManyPages ? 1L : 2L, true)}, null, tUseManyPages ? 1024L : 512L, 16L, 0L);
                        rRecipe.mCanBeBuffered = false;
                        rRecipe.mOutputs[0].func_77982_d(tMaterial.mDictionaryBook.func_77978_p());
                        return rRecipe;
                    }
                    return rRecipe;
                }
                return rRecipe;
            }
            if (tPaper.func_77973_b() == Items.field_151148_bJ) {
                short tMapID = UT.NBT.getMapID(tData);
                if (tMapID >= 0) {
                    rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, tPaper), UT.Stacks.amount(0L, tUSB)}, new ItemStack[]{UT.Stacks.make((Item)Items.field_151098_aY, 1L, (long)tMapID)}, null, null, new FluidStack[]{UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[0], 1L, 9L, true), UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[6], 1L, 9L, true), UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[13], 1L, 9L, true), UT.Fluids.mul(CS.DYE_FLUIDS_CHEMICAL[11], 1L, 9L, true)}, null, 64L, 16L, 0L);
                    rRecipe.mCanBeBuffered = false;
                    return rRecipe;
                }
                return rRecipe;
            }
            return rRecipe;
        }
        return rRecipe;
    }

    @Override
    public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return true;
    }
}

