/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.data.CS;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapFurnaceFuel
extends Recipe.RecipeMap {
    public RecipeMapFurnaceFuel(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs) {
        super(aRecipeList, aUnlocalizedName, aNameLocal + " (1 Smelt = 5000 Units)", aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs);
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (aInputs == null || aInputs.length < 1 || UT.Stacks.invalid(aInputs[0]) || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        if (rRecipe == null) {
            long tFuelValue = UT.Stacks.fuel(aInputs[0]);
            OreDictItemData tData = OM.anydata_(aInputs[0]);
            if (tFuelValue > 0L && !UT.Fluids.containsFluid(aInputs[0], UT.Fluids.lava(0L), true) && !OM.materialcontains(tData, TD.Properties.FLAMMABLE, TD.Properties.EXPLOSIVE)) {
                ItemStack tContainer = UT.Stacks.container(aInputs[0], true);
                if (tContainer == null) {
                    OreDictMaterialStack tMaterial = null;
                    if (tData != null) {
                        for (OreDictMaterialStack aMaterial : tData.getAllMaterialStacks()) {
                            if (tMaterial == null || tMaterial.mAmount <= 0L) {
                                tMaterial = OM.stack(aMaterial.mMaterial.mTargetBurning.mMaterial, UT.Code.units(aMaterial.mAmount, 420076800L, aMaterial.mMaterial.mTargetBurning.mAmount, false));
                                continue;
                            }
                            if (tMaterial.mMaterial != aMaterial.mMaterial.mTargetBurning.mMaterial) continue;
                            tMaterial.mAmount += UT.Code.units(aMaterial.mAmount, 420076800L, aMaterial.mMaterial.mTargetBurning.mAmount, false);
                        }
                    }
                    rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, aInputs[0])}, new ItemStack[]{OM.dust(tMaterial)}, null, null, null, null, tFuelValue * (long)CS.EU_PER_SMELT / (long)CS.TICKS_PER_SMELT, -1L, 0L);
                } else {
                    rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, aInputs[0])}, new ItemStack[]{tContainer}, null, null, null, null, tFuelValue * (long)CS.EU_PER_SMELT / (long)CS.TICKS_PER_SMELT, -1L, 0L);
                }
                boolean bl = rRecipe.mCanBeBuffered = aInputs[0].func_77978_p() == null;
                if (rRecipe.mCanBeBuffered) {
                    this.addRecipe(rRecipe, false, false, true);
                }
            }
        }
        return rRecipe;
    }

    @Override
    public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return null != this.findRecipe(null, null, true, Long.MAX_VALUE, null, CS.ZL_FLUIDSTACK, aStack);
    }
}

