/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.data.CS;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class RecipeMapFluidCanner
extends Recipe.RecipeMap {
    public RecipeMapFluidCanner(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs);
        this.mMaxFluidInputSize = 128000;
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        ItemStack tOutput;
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null || rRecipe != null || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        FluidStack tFluid = UT.Fluids.getFluidForFilledItem(aInputs[0], true);
        if (tFluid != null) {
            rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, aInputs[0])}, new ItemStack[]{UT.Stacks.container(aInputs[0], true)}, null, null, null, new FluidStack[]{tFluid}, Math.max(tFluid.amount / 64, 16), 16L, 0L);
        } else if (aFluids != null && aFluids.length > 0 && aFluids[0] != null && (tFluid = UT.Fluids.getFluidForFilledItem(tOutput = UT.Fluids.fillFluidContainer(aFluids[0], aInputs[0], false, true, false), true)) != null) {
            rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, aInputs[0])}, new ItemStack[]{tOutput}, null, null, new FluidStack[]{tFluid}, null, Math.max(tFluid.amount / 64, 16), 16L, 0L);
        }
        if (rRecipe != null) {
            rRecipe.mCanBeBuffered = false;
        }
        return rRecipe;
    }

    @Override
    public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return aStack != null && (super.containsInput(aStack, aTileEntity, aSpecialSlot) || aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0);
    }

    @Override
    public boolean containsInput(FluidStack aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return true;
    }

    @Override
    public boolean containsInput(Fluid aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return true;
    }
}

