/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.data.CS;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.recipes.Recipe;
import gregapi.recipes.maps.RecipeMapSpecialSingleInput;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RecipeMapCrusher
extends RecipeMapSpecialSingleInput {
    private List<Recipe> mBufferedDynamicRecipes = null;

    public RecipeMapCrusher(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs);
    }

    @Override
    public List<Recipe> getNEIAllRecipes() {
        List<Recipe> rList = super.getNEIAllRecipes();
        if (this.mBufferedDynamicRecipes == null) {
            this.mBufferedDynamicRecipes = new ArrayListNoNulls<Recipe>();
            HashSetNoNulls<OreDictMaterial> tSet = new HashSetNoNulls<OreDictMaterial>();
            tSet.addAll(OP.dust.mRegisteredMaterials);
            tSet.addAll(OP.crushed.mRegisteredMaterials);
            for (OreDictMaterial tMaterial : tSet) {
                for (ItemStackContainer tStack : tMaterial.mRegisteredItems) {
                    this.mBufferedDynamicRecipes.add(this.getRecipeFor(tStack.toStack()));
                }
            }
        }
        rList.addAll(this.mBufferedDynamicRecipes);
        return rList;
    }

    @Override
    public List<Recipe> getNEIRecipes(ItemStack ... aOutputs) {
        List<Recipe> rList = super.getNEIRecipes(aOutputs);
        for (ItemStack aOutput : aOutputs) {
            OreDictItemData aData = OM.anyassociation(aOutput);
            if (aData == null || aData.mPrefix != OP.crushed && aData.mPrefix != OP.dust) continue;
            for (ItemStackContainer tStack : aData.mMaterial.mMaterial.mRegisteredItems) {
                rList.add(this.getRecipeFor(tStack.toStack()));
            }
            break;
        }
        return rList;
    }

    @Override
    protected Recipe getRecipeFor(ItemStack aInput) {
        OreDictItemData aData = OM.anydata(aInput);
        if (aData == null || aData.mMaterial != null && aData.mMaterial.mMaterial.contains(TD.Atomic.ANTIMATTER) || aData.mPrefix == null || !aData.mPrefix.contains(TD.Prefix.ORE) || aData.mPrefix.contains(TD.Prefix.DUST_ORE)) {
            return null;
        }
        if (aData.mPrefix == OP.oreBedrock || aData.mPrefix == OP.orePoor || aData.mPrefix == OP.oreSmall || aData.mPrefix == OP.oreRich || aData.mPrefix == OP.oreNormal) {
            return null;
        }
        ItemStack[] tOutputs = new ItemStack[Math.max(1, this.mOutputItemsCount)];
        tOutputs[0] = OP.crushed.mat(aData.mMaterial.mMaterial.mTargetCrushing.mMaterial, UT.Code.units(aData.mMaterial.mMaterial.mTargetCrushing.mAmount, 420076800L, 2 * aData.mMaterial.mMaterial.mOreMultiplier * aData.mMaterial.mMaterial.mOreProcessingMultiplier * (aData.mPrefix == OP.oreNether || aData.mPrefix == OP.oreDense || aData.mPrefix == OP.oreEnd ? 2 : 1), false));
        if (tOutputs[0] == null) {
            tOutputs[0] = OP.dust.mat(aData.mMaterial.mMaterial.mTargetCrushing.mMaterial, UT.Code.units(aData.mMaterial.mMaterial.mTargetCrushing.mAmount, 420076800L, 2 * aData.mMaterial.mMaterial.mOreMultiplier * aData.mMaterial.mMaterial.mOreProcessingMultiplier * (aData.mPrefix == OP.oreNether || aData.mPrefix == OP.oreDense || aData.mPrefix == OP.oreEnd ? 2 : 1), false));
        }
        if (tOutputs[0] == null) {
            return null;
        }
        int i = 0;
        int tDuration = 64 * tOutputs[0].field_77994_a * Math.max(1, aData.mMaterial.mMaterial.mToolQuality + 1);
        for (OreDictMaterialStack tMaterial : aData.mPrefix.mByProducts) {
            ItemStack tStack;
            tDuration = (int)((long)tDuration + UT.Code.units(tMaterial.mAmount, 420076800L, 64 * Math.max(1, tMaterial.mMaterial.mToolQuality + 1), true));
            if (i >= tOutputs.length - 1 || (tStack = OM.dust(tMaterial.mMaterial.mTargetCrushing.mMaterial, UT.Code.units(tMaterial.mAmount, 420076800L, tMaterial.mMaterial.mTargetCrushing.mAmount, false))) == null) continue;
            tOutputs[++i] = tStack;
        }
        Recipe rRecipe = new Recipe(false, false, new ItemStack[]{UT.Stacks.amount(1L, aInput)}, tOutputs, null, null, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, Math.max(1, tDuration), 16L, 0L);
        rRecipe.mCanBeBuffered = false;
        return rRecipe;
    }
}

