/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.gui.Slot_Normal;
import gregapi.gui.Slot_Whitelist;
import gregapi.item.IItemGTHandTool;
import gregapi.oredict.OreDictManager;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.ICraftingRecipeGT;
import gregapi.recipes.Recipe;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.tileentity.computer.ITileEntityUSBPort;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapAutocrafting
extends Recipe.RecipeMap {
    public static final List<IRecipe> ALLOWED_RECIPES = new ArrayListNoNulls<IRecipe>();
    public static final List<IRecipe> RECENT_RECIPES = new ArrayListNoNulls<IRecipe>();

    public RecipeMapAutocrafting(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs);
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        int i;
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (rRecipe != null || aSpecialSlot == null || aInputs == null || aInputs.length < 1 || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        ItemStack[] tBlueprint = this.getBlueprint(aTileEntity, aSpecialSlot);
        if (tBlueprint.length <= 0) {
            return null;
        }
        for (ItemStack tPlan : tBlueprint) {
            if (tPlan == null || !(tPlan.func_77973_b() instanceof IItemGTHandTool)) continue;
            return null;
        }
        if (ALLOWED_RECIPES.isEmpty()) {
            for (Object tCraftingRecipe : CraftingManager.func_77594_a().func_77592_b()) {
                if (!(tCraftingRecipe instanceof IRecipe) || tCraftingRecipe instanceof ICraftingRecipeGT && !((ICraftingRecipeGT)tCraftingRecipe).isAutocraftableByGT()) continue;
                ALLOWED_RECIPES.add((IRecipe)tCraftingRecipe);
            }
        }
        InventoryCrafting tCraftInv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i2 = 0; i2 < 9; ++i2) {
            tCraftInv.func_70299_a(i2, tBlueprint[i2]);
        }
        IRecipe tIRecipe = null;
        int j = RECENT_RECIPES.size();
        for (i = 0; i < j; ++i) {
            if (!RECENT_RECIPES.get(i).func_77569_a(tCraftInv, (World)(aTileEntity == null ? CS.DW : aTileEntity.getWorld()))) continue;
            tIRecipe = RECENT_RECIPES.get(i);
            break;
        }
        if (tIRecipe == null) {
            j = ALLOWED_RECIPES.size();
            for (i = 0; i < j; ++i) {
                if (!ALLOWED_RECIPES.get(i).func_77569_a(tCraftInv, (World)(aTileEntity == null ? CS.DW : aTileEntity.getWorld()))) continue;
                tIRecipe = ALLOWED_RECIPES.get(i);
                ALLOWED_RECIPES.remove(i);
                RECENT_RECIPES.add(tIRecipe);
                break;
            }
        }
        if (tIRecipe == null) {
            return null;
        }
        ItemStack tOutput = tIRecipe.func_77572_b(tCraftInv);
        if (UT.Stacks.invalid(tOutput)) {
            return null;
        }
        ArrayListNoNulls<ItemStack> tInputs = new ArrayListNoNulls<ItemStack>();
        ArrayListNoNulls<ItemStack> tOutputs = new ArrayListNoNulls<ItemStack>(false, tOutput);
        for (ItemStack tPlan : tBlueprint) {
            if (tPlan == null) continue;
            boolean temp = true;
            for (ItemStack tInput : tInputs) {
                if (!UT.Stacks.equal(tInput, tPlan, false)) continue;
                ++tInput.field_77994_a;
                tOutputs.add(UT.Stacks.container(tPlan, false));
                temp = false;
            }
            if (!temp) continue;
            tInputs.add(UT.Stacks.amount(1L, tPlan));
            tOutputs.add(UT.Stacks.container(tPlan, false));
        }
        for (ItemStack tInput : tInputs) {
            if (!OM.is_("gt:autocrafterinfinite", tInput)) continue;
            tInput.field_77994_a = 0;
        }
        return new Recipe(true, false, tInputs.toArray(new ItemStack[tInputs.size()]), tOutputs.toArray(new ItemStack[tOutputs.size()]), null, null, null, null, 1024L, 16L, 0L);
    }

    public ItemStack[] getBlueprint(IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        ItemStack[] rBlueprint = CS.ZL_ITEMSTACK;
        if (IL.Paper_Blueprint_Used.equal(aSpecialSlot, false, true)) {
            rBlueprint = UT.NBT.getBlueprintCrafting(aSpecialSlot);
        } else if (OM.is_(CS.OD_USB_STICKS[1], aSpecialSlot)) {
            if (!aSpecialSlot.func_77942_o()) {
                return rBlueprint;
            }
            NBTTagCompound tData = aSpecialSlot.func_77978_p().func_74775_l("gt.usb.data");
            if (tData == null) {
                return rBlueprint;
            }
            rBlueprint = UT.NBT.getBlueprintCrafting(tData);
        } else if (OM.is_(CS.OD_USB_CABLES[1], aSpecialSlot)) {
            if (aTileEntity == null) {
                return rBlueprint;
            }
            for (byte tSide : CS.ALL_SIDES_VALID_ONLY[aSpecialSlot.func_77942_o() && aSpecialSlot.func_77978_p().func_74764_b("gt.usb.dir") ? (int)aSpecialSlot.func_77978_p().func_74771_c("gt.usb.dir") : 6]) {
                NBTTagCompound tData;
                DelegatorTileEntity<TileEntity> tDelegator = aTileEntity.getAdjacentTileEntity(tSide);
                if (!(tDelegator.mTileEntity instanceof ITileEntityUSBPort) || (tData = ((ITileEntityUSBPort)tDelegator.mTileEntity).getUSBData(tDelegator.mSideOfTileEntity, 1)) == null || (rBlueprint = UT.NBT.getBlueprintCrafting(tData)).length <= 0) continue;
                return rBlueprint;
            }
        }
        return rBlueprint;
    }

    @Override
    public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        ItemStack[] tRecipe;
        for (ItemStack tStack : tRecipe = this.getBlueprint(aTileEntity, aSpecialSlot)) {
            if (!UT.Stacks.equal(tStack, aStack, false)) continue;
            return true;
        }
        return super.containsInput(aStack, aTileEntity, aSpecialSlot);
    }

    @Override
    public Slot_Normal getSpecialSlot(ITileEntityInventoryGUI aInventory, int aIndex, int aX, int aY) {
        return new Slot_Whitelist(aInventory, aIndex, aX, aY, OreDictManager.getOres("gt:autocrafterblueprintitem", false).toArray(CS.ZL_ITEMSTACK)).setTooltip("gt.autocrafting.insert.blueprint", LH.Chat.WHITE);
    }
}

