/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.handlers;

import gregapi.code.ICondition;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.recipes.IRecipeMapHandler;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.UT;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapHandlerPrefix
implements IRecipeMapHandler {
    private final ICondition<OreDictMaterial> mCondition;
    private final OreDictPrefix[] mInputPrefixes;
    private final OreDictPrefix[] mOutputPrefixes;
    private final byte[] mInputAmounts;
    private final byte[] mOutputAmounts;
    private final ItemStack mAdditionalInput;
    private final FluidStack mFluidInputPerUnit;
    private final FluidStack mFluidOutputPerUnit;
    private final long mUnitsInputted;
    private final long mUnitsOutputted;
    private final long mEUt;
    private final long mDuration;
    private final long mMultiplier;
    private final boolean mAllowToGenerateAllRecipesAtOnce;
    private boolean mAlreadyAddedAllRecipes = false;
    private boolean mOutputPulverizedRemains = false;

    public RecipeMapHandlerPrefix(OreDictPrefix aInputPrefix, long aInputAmount, FluidStack aFluidInputPerUnit, long aEUt, long aDuration, long aMultiplier, FluidStack aFluidOutputPerUnit, OreDictPrefix aOutputPrefix, long aOutputAmount, ItemStack aAdditionalInput, boolean aAllowToGenerateAllRecipesAtOnce, boolean aOutputPulverizedRemains, ICondition<OreDictMaterial> aCondition) {
        int i;
        this.mAllowToGenerateAllRecipesAtOnce = aAllowToGenerateAllRecipesAtOnce;
        this.mOutputPulverizedRemains = aOutputPulverizedRemains;
        this.mFluidInputPerUnit = aFluidInputPerUnit;
        this.mFluidOutputPerUnit = aFluidOutputPerUnit;
        this.mCondition = aCondition;
        this.mInputPrefixes = new OreDictPrefix[]{aInputPrefix};
        this.mInputAmounts = new byte[]{UT.Code.bindStack(aInputAmount)};
        this.mOutputPrefixes = new OreDictPrefix[]{aOutputPrefix};
        this.mOutputAmounts = new byte[]{UT.Code.bindStack(aOutputAmount)};
        this.mAdditionalInput = aAdditionalInput;
        this.mMultiplier = aMultiplier;
        this.mDuration = aDuration;
        this.mEUt = aEUt;
        long tUnitsProcessed = 0L;
        for (i = 0; i < this.mInputPrefixes.length; ++i) {
            tUnitsProcessed += this.mInputPrefixes[i].mAmount * (long)this.mInputAmounts[i];
        }
        this.mUnitsInputted = tUnitsProcessed;
        tUnitsProcessed = 0L;
        for (i = 0; i < this.mOutputPrefixes.length; ++i) {
            tUnitsProcessed += this.mOutputPrefixes[i].mAmount * (long)this.mOutputAmounts[i];
        }
        this.mUnitsOutputted = tUnitsProcessed;
    }

    public RecipeMapHandlerPrefix(OreDictPrefix aInputPrefix1, long aInputAmount1, OreDictPrefix aInputPrefix2, long aInputAmount2, FluidStack aFluidInputPerUnit, long aEUt, long aDuration, long aMultiplier, FluidStack aFluidOutputPerUnit, OreDictPrefix aOutputPrefix1, long aOutputAmount1, OreDictPrefix aOutputPrefix2, long aOutputAmount2, ItemStack aAdditionalInput, boolean aAllowToGenerateAllRecipesAtOnce, boolean aOutputPulverizedRemains, ICondition<OreDictMaterial> aCondition) {
        int i;
        byte[] byArray;
        OreDictPrefix[] oreDictPrefixArray;
        byte[] byArray2;
        OreDictPrefix[] oreDictPrefixArray2;
        this.mAllowToGenerateAllRecipesAtOnce = aAllowToGenerateAllRecipesAtOnce;
        this.mOutputPulverizedRemains = aOutputPulverizedRemains;
        this.mFluidInputPerUnit = aFluidInputPerUnit;
        this.mFluidOutputPerUnit = aFluidOutputPerUnit;
        this.mCondition = aCondition;
        if (aInputPrefix2 == null) {
            OreDictPrefix[] oreDictPrefixArray3 = new OreDictPrefix[1];
            oreDictPrefixArray2 = oreDictPrefixArray3;
            oreDictPrefixArray3[0] = aInputPrefix1;
        } else {
            OreDictPrefix[] oreDictPrefixArray4 = new OreDictPrefix[2];
            oreDictPrefixArray4[0] = aInputPrefix1;
            oreDictPrefixArray2 = oreDictPrefixArray4;
            oreDictPrefixArray4[1] = aInputPrefix2;
        }
        this.mInputPrefixes = oreDictPrefixArray2;
        if (aInputPrefix2 == null) {
            byte[] byArray3 = new byte[1];
            byArray2 = byArray3;
            byArray3[0] = UT.Code.bindStack(aInputAmount1);
        } else {
            byte[] byArray4 = new byte[2];
            byArray4[0] = UT.Code.bindStack(aInputAmount1);
            byArray2 = byArray4;
            byArray4[1] = UT.Code.bindStack(aInputAmount2);
        }
        this.mInputAmounts = byArray2;
        if (aOutputPrefix2 == null) {
            OreDictPrefix[] oreDictPrefixArray5 = new OreDictPrefix[1];
            oreDictPrefixArray = oreDictPrefixArray5;
            oreDictPrefixArray5[0] = aOutputPrefix1;
        } else {
            OreDictPrefix[] oreDictPrefixArray6 = new OreDictPrefix[2];
            oreDictPrefixArray6[0] = aOutputPrefix1;
            oreDictPrefixArray = oreDictPrefixArray6;
            oreDictPrefixArray6[1] = aOutputPrefix2;
        }
        this.mOutputPrefixes = oreDictPrefixArray;
        if (aOutputPrefix2 == null) {
            byte[] byArray5 = new byte[1];
            byArray = byArray5;
            byArray5[0] = UT.Code.bindStack(aOutputAmount1);
        } else {
            byte[] byArray6 = new byte[2];
            byArray6[0] = UT.Code.bindStack(aOutputAmount1);
            byArray = byArray6;
            byArray6[1] = UT.Code.bindStack(aOutputAmount2);
        }
        this.mOutputAmounts = byArray;
        this.mAdditionalInput = aAdditionalInput;
        this.mMultiplier = aMultiplier;
        this.mDuration = aDuration;
        this.mEUt = aEUt;
        long tUnitsProcessed = 0L;
        for (i = 0; i < this.mInputPrefixes.length; ++i) {
            tUnitsProcessed += this.mInputPrefixes[i].mAmount * (long)this.mInputAmounts[i];
        }
        this.mUnitsInputted = tUnitsProcessed;
        tUnitsProcessed = 0L;
        for (i = 0; i < this.mOutputPrefixes.length; ++i) {
            tUnitsProcessed += this.mOutputPrefixes[i].mAmount * (long)this.mOutputAmounts[i];
        }
        this.mUnitsOutputted = tUnitsProcessed;
    }

    public RecipeMapHandlerPrefix(OreDictPrefix[] aInputPrefixes, long[] aInputAmount, FluidStack aFluidInputPerUnit, long aEUt, long aDuration, long aMultiplier, FluidStack aFluidOutputPerUnit, OreDictPrefix[] aOutputPrefixes, long[] aOutputAmount, ItemStack aAdditionalInput, boolean aAllowToGenerateAllRecipesAtOnce, boolean aOutputPulverizedRemains, ICondition<OreDictMaterial> aCondition) {
        int i;
        int i2;
        this.mAllowToGenerateAllRecipesAtOnce = aAllowToGenerateAllRecipesAtOnce;
        this.mOutputPulverizedRemains = aOutputPulverizedRemains;
        this.mFluidInputPerUnit = aFluidInputPerUnit;
        this.mFluidOutputPerUnit = aFluidOutputPerUnit;
        this.mCondition = aCondition;
        this.mInputPrefixes = aInputPrefixes;
        this.mInputAmounts = new byte[this.mInputPrefixes.length];
        for (i2 = 0; i2 < this.mInputAmounts.length; ++i2) {
            this.mInputAmounts[i2] = UT.Code.bindStack(aInputAmount[i2]);
        }
        this.mOutputPrefixes = aOutputPrefixes;
        this.mOutputAmounts = new byte[this.mOutputPrefixes.length];
        for (i2 = 0; i2 < this.mOutputAmounts.length; ++i2) {
            this.mOutputAmounts[i2] = UT.Code.bindStack(aOutputAmount[i2]);
        }
        this.mAdditionalInput = aAdditionalInput;
        this.mMultiplier = aMultiplier;
        this.mDuration = aDuration;
        this.mEUt = aEUt;
        long tUnitsProcessed = 0L;
        for (i = 0; i < this.mInputPrefixes.length; ++i) {
            tUnitsProcessed += this.mInputPrefixes[i].mAmount * (long)this.mInputAmounts[i];
        }
        this.mUnitsInputted = tUnitsProcessed;
        tUnitsProcessed = 0L;
        for (i = 0; i < this.mOutputPrefixes.length; ++i) {
            tUnitsProcessed += this.mOutputPrefixes[i].mAmount * (long)this.mOutputAmounts[i];
        }
        this.mUnitsOutputted = tUnitsProcessed;
    }

    @Override
    public boolean addRecipesUsing(Recipe.RecipeMap aMap, ItemStack aStack, OreDictItemData aData) {
        if (this.isDone()) {
            return false;
        }
        if (UT.Stacks.equal(aStack, this.mAdditionalInput)) {
            return this.mAllowToGenerateAllRecipesAtOnce && this.addAllRecipesInternal(aMap);
        }
        return aData != null && aData.hasValidMaterialData() && UT.Code.contains(aData.mPrefix, this.mInputPrefixes) && this.addRecipeForMaterial(aMap, aData.mMaterial.mMaterial);
    }

    @Override
    public boolean addRecipesProducing(Recipe.RecipeMap aMap, ItemStack aStack, OreDictItemData aData) {
        if (this.isDone()) {
            return false;
        }
        return aData != null && aData.hasValidMaterialData() && UT.Code.contains(aData.mPrefix, this.mOutputPrefixes) && this.addRecipeForMaterial(aMap, aData.mMaterial.mMaterial);
    }

    @Override
    public boolean containsInput(Recipe.RecipeMap aMap, ItemStack aStack, OreDictItemData aData) {
        if (this.isDone()) {
            return false;
        }
        return this.addRecipesUsing(aMap, aStack, aData);
    }

    @Override
    public boolean addRecipesUsing(Recipe.RecipeMap aMap, Fluid aFluid) {
        if (this.isDone()) {
            return false;
        }
        return this.mFluidInputPerUnit != null && this.mFluidInputPerUnit.getFluid() == aFluid && this.mAllowToGenerateAllRecipesAtOnce && this.addAllRecipesInternal(aMap);
    }

    @Override
    public boolean addRecipesProducing(Recipe.RecipeMap aMap, Fluid aFluid) {
        if (this.isDone()) {
            return false;
        }
        return this.mFluidOutputPerUnit != null && this.mFluidOutputPerUnit.getFluid() == aFluid && this.mAllowToGenerateAllRecipesAtOnce && this.addAllRecipesInternal(aMap);
    }

    @Override
    public boolean containsInput(Recipe.RecipeMap aMap, Fluid aFluid) {
        return this.mFluidInputPerUnit != null && this.mFluidInputPerUnit.getFluid() == aFluid;
    }

    @Override
    public boolean addAllRecipes(Recipe.RecipeMap aMap) {
        return this.mAllowToGenerateAllRecipesAtOnce && this.addAllRecipesInternal(aMap);
    }

    public boolean addAllRecipesInternal(Recipe.RecipeMap aMap) {
        if (this.isDone()) {
            return false;
        }
        for (OreDictMaterial tMaterial : this.mInputPrefixes[0].mRegisteredMaterials) {
            this.addRecipeForMaterial(aMap, tMaterial);
        }
        this.mAlreadyAddedAllRecipes = true;
        return true;
    }

    @Override
    public boolean isDone() {
        return this.mAlreadyAddedAllRecipes;
    }

    public boolean addRecipeForMaterial(Recipe.RecipeMap aMap, OreDictMaterial aMaterial) {
        int i;
        if (!this.mCondition.isTrue(aMaterial) || aMaterial.contains(TD.Properties.INVALID_MATERIAL)) {
            return false;
        }
        ItemStack[] tInputs = new ItemStack[this.mAdditionalInput == null ? this.mInputPrefixes.length : this.mInputPrefixes.length + 1];
        if (this.mAdditionalInput != null) {
            tInputs[tInputs.length - 1] = this.mAdditionalInput;
        }
        for (int i2 = 0; i2 < this.mInputPrefixes.length; ++i2) {
            tInputs[i2] = this.mInputPrefixes[i2].mat(aMaterial, this.mInputAmounts[i2]);
        }
        for (ItemStack tInput : tInputs) {
            if (!UT.Stacks.invalid(tInput)) continue;
            return false;
        }
        ItemStack[] tOutputs = new ItemStack[this.mOutputPrefixes.length + 1];
        OreDictMaterial tMaterial = this.getOutputMaterial(aMaterial);
        for (i = 0; i < this.mOutputPrefixes.length; ++i) {
            tOutputs[i] = this.mOutputPrefixes[i].mat(tMaterial, this.mOutputAmounts[i]);
        }
        for (i = 0; i < tOutputs.length - 1; ++i) {
            if (!UT.Stacks.invalid(tOutputs[i])) continue;
            return false;
        }
        if (this.mOutputPulverizedRemains) {
            tOutputs[tOutputs.length - 1] = OM.pulverize(aMaterial, this.mUnitsInputted - this.mUnitsOutputted);
        }
        return aMap.addRecipeX(false, true, false, false, true, this.mEUt, this.mDuration <= 0L ? this.getCosts(aMaterial) : this.mDuration, tInputs, UT.Fluids.mul(this.mFluidInputPerUnit, aMaterial.mToolQuality + 1), UT.Fluids.mul(this.mFluidOutputPerUnit, aMaterial.mToolQuality + 1), tOutputs) != null;
    }

    public OreDictMaterial getOutputMaterial(OreDictMaterial aMaterial) {
        return aMaterial;
    }

    public long getCosts(OreDictMaterial aMaterial) {
        return UT.Code.units(this.mUnitsInputted, 420076800L, this.mMultiplier + this.mMultiplier * (long)aMaterial.mToolQuality, true);
    }
}

