/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.handlers;

import gregapi.code.ICondition;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.recipes.IRecipeMapHandler;
import gregapi.recipes.Recipe;
import gregapi.util.UT;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapHandlerMaterial
implements IRecipeMapHandler {
    private final ICondition<OreDictPrefix> mCondition;
    private final OreDictMaterial mInputMaterial;
    private final OreDictMaterial mOutputMaterial;
    private final ItemStack mAdditionalInput;
    private final FluidStack mFluidInputPerUnit;
    private final FluidStack mFluidOutputPerUnit;
    private final long mEUt;
    private final long mDuration;
    private final boolean mAllowToGenerateAllRecipesAtOnce;
    private boolean mAlreadyAddedAllRecipes = false;

    public RecipeMapHandlerMaterial(OreDictMaterial aInputMaterial, FluidStack aFluidInputPerUnit, long aEUt, long aDuration, FluidStack aFluidOutputPerUnit, OreDictMaterial aOutputMaterial, ItemStack aAdditionalInput, boolean aAllowToGenerateAllRecipesAtOnce, ICondition<OreDictPrefix> aCondition) {
        this.mAllowToGenerateAllRecipesAtOnce = aAllowToGenerateAllRecipesAtOnce;
        this.mFluidInputPerUnit = aFluidInputPerUnit;
        this.mFluidOutputPerUnit = aFluidOutputPerUnit;
        this.mCondition = aCondition;
        this.mInputMaterial = aInputMaterial;
        this.mOutputMaterial = aOutputMaterial;
        this.mAdditionalInput = aAdditionalInput;
        this.mDuration = aDuration;
        this.mEUt = aEUt;
    }

    @Override
    public boolean addRecipesUsing(Recipe.RecipeMap aMap, ItemStack aStack, OreDictItemData aData) {
        if (this.isDone()) {
            return false;
        }
        if (UT.Stacks.equal(aStack, this.mAdditionalInput)) {
            return this.mAllowToGenerateAllRecipesAtOnce && this.addAllRecipesInternal(aMap);
        }
        return aData != null && aData.hasValidPrefixMaterialData() && aData.mMaterial.mMaterial == this.mInputMaterial && this.addRecipeForPrefix(aMap, aData.mPrefix);
    }

    @Override
    public boolean addRecipesProducing(Recipe.RecipeMap aMap, ItemStack aStack, OreDictItemData aData) {
        if (this.isDone()) {
            return false;
        }
        return aData != null && aData.hasValidPrefixMaterialData() && aData.mMaterial.mMaterial == this.mOutputMaterial && this.addRecipeForPrefix(aMap, aData.mPrefix);
    }

    @Override
    public boolean containsInput(Recipe.RecipeMap aMap, ItemStack aStack, OreDictItemData aData) {
        if (this.isDone()) {
            return false;
        }
        return this.addRecipesUsing(aMap, aStack, aData);
    }

    @Override
    public boolean addRecipesUsing(Recipe.RecipeMap aMap, Fluid aFluid) {
        if (this.isDone()) {
            return false;
        }
        return this.mFluidInputPerUnit != null && this.mFluidInputPerUnit.getFluid() == aFluid && this.mAllowToGenerateAllRecipesAtOnce && this.addAllRecipesInternal(aMap);
    }

    @Override
    public boolean addRecipesProducing(Recipe.RecipeMap aMap, Fluid aFluid) {
        if (this.isDone()) {
            return false;
        }
        return this.mFluidOutputPerUnit != null && this.mFluidOutputPerUnit.getFluid() == aFluid && this.mAllowToGenerateAllRecipesAtOnce && this.addAllRecipesInternal(aMap);
    }

    @Override
    public boolean containsInput(Recipe.RecipeMap aMap, Fluid aFluid) {
        return this.mFluidInputPerUnit != null && this.mFluidInputPerUnit.getFluid() == aFluid;
    }

    @Override
    public boolean addAllRecipes(Recipe.RecipeMap aMap) {
        return this.mAllowToGenerateAllRecipesAtOnce && this.addAllRecipesInternal(aMap);
    }

    public boolean addAllRecipesInternal(Recipe.RecipeMap aMap) {
        if (this.isDone()) {
            return false;
        }
        for (OreDictPrefix tPrefix : OreDictPrefix.VALUES) {
            this.addRecipeForPrefix(aMap, tPrefix);
        }
        this.mAlreadyAddedAllRecipes = true;
        return true;
    }

    @Override
    public boolean isDone() {
        return this.mAlreadyAddedAllRecipes;
    }

    public boolean addRecipeForPrefix(Recipe.RecipeMap aMap, OreDictPrefix aPrefix) {
        if (!this.mCondition.isTrue(aPrefix)) {
            return false;
        }
        ItemStack[] tInputs = new ItemStack[this.mAdditionalInput == null ? 1 : 2];
        if (this.mAdditionalInput != null) {
            tInputs[tInputs.length - 1] = this.mAdditionalInput;
        }
        tInputs[0] = aPrefix.mat(this.mInputMaterial, 1L);
        for (ItemStack tInput : tInputs) {
            if (!UT.Stacks.invalid(tInput)) continue;
            return false;
        }
        ItemStack tOutput = aPrefix.mat(this.mOutputMaterial, 1L);
        if (UT.Stacks.invalid(tOutput)) {
            return false;
        }
        return aMap.addRecipeX(false, true, false, false, true, this.mEUt, Math.max(1L, this.getCosts(aPrefix)), tInputs, UT.Fluids.mul(this.mFluidInputPerUnit, aPrefix.mAmount, 420076800L, true), UT.Fluids.mul(this.mFluidOutputPerUnit, aPrefix.mAmount, 420076800L, false), tOutput) != null;
    }

    public long getCosts(OreDictPrefix aPrefix) {
        return UT.Code.units(aPrefix.mAmount, 420076800L, this.mDuration, true);
    }
}

