/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes;

import codechicken.nei.recipe.GuiCraftingRecipe;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackMap;
import gregapi.config.Config;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.gui.Slot_Normal;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.IRecipeMapHandler;
import gregapi.recipes.maps.RecipeMapAssembler;
import gregapi.recipes.maps.RecipeMapAutocrafting;
import gregapi.recipes.maps.RecipeMapBath;
import gregapi.recipes.maps.RecipeMapChisel;
import gregapi.recipes.maps.RecipeMapCompressor;
import gregapi.recipes.maps.RecipeMapCrusher;
import gregapi.recipes.maps.RecipeMapCutter;
import gregapi.recipes.maps.RecipeMapExtractor;
import gregapi.recipes.maps.RecipeMapFluidCanner;
import gregapi.recipes.maps.RecipeMapFormingPress;
import gregapi.recipes.maps.RecipeMapFuel;
import gregapi.recipes.maps.RecipeMapFurnace;
import gregapi.recipes.maps.RecipeMapFurnaceFuel;
import gregapi.recipes.maps.RecipeMapHammer;
import gregapi.recipes.maps.RecipeMapMacerator;
import gregapi.recipes.maps.RecipeMapMicrowave;
import gregapi.recipes.maps.RecipeMapOreWasher;
import gregapi.recipes.maps.RecipeMapPrinter;
import gregapi.recipes.maps.RecipeMapRecycler;
import gregapi.recipes.maps.RecipeMapReplicator;
import gregapi.recipes.maps.RecipeMapScannerMolecular;
import gregapi.recipes.maps.RecipeMapScannerVisuals;
import gregapi.recipes.maps.RecipeMapShredder;
import gregapi.recipes.maps.RecipeMapThermalCentrifuge;
import gregapi.recipes.maps.RecipeMapUnboxinator;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class Recipe {
    public ItemStack[] mInputs;
    public ItemStack[] mOutputs;
    public FluidStack[] mFluidInputs;
    public FluidStack[] mFluidOutputs;
    public long[] mChances;
    public long[] mMaxChances;
    public Object mSpecialItems;
    public long mDuration;
    public long mEUt;
    public long mSpecialValue;
    public boolean mEnabled = true;
    public boolean mHidden = false;
    public boolean mFakeRecipe = false;
    public boolean mCanBeBuffered = true;
    public boolean mNeedsEmptyOutput = false;

    public static void reInit() {
        for (RecipeMap tMapEntry : RecipeMap.RECIPE_MAPS.values()) {
            tMapEntry.reInit();
        }
    }

    public int getOutputChance(long aIndex) {
        if (aIndex < 0L || aIndex >= (long)this.mChances.length) {
            return 10000;
        }
        return (int)this.mChances[(int)aIndex];
    }

    public int getMaxChance(long aIndex) {
        if (aIndex < 0L || aIndex >= (long)this.mMaxChances.length) {
            return 10000;
        }
        return (int)this.mMaxChances[(int)aIndex];
    }

    public ItemStack getRepresentativeInput(long aIndex) {
        if (aIndex < 0L || aIndex >= (long)this.mInputs.length) {
            return null;
        }
        return UT.Stacks.copy(this.mInputs[(int)aIndex]);
    }

    public ItemStack getOutput(long aIndex) {
        if (aIndex < 0L || aIndex >= (long)this.mOutputs.length) {
            return null;
        }
        return UT.Stacks.copy(this.mOutputs[(int)aIndex]);
    }

    public FluidStack getRepresentativeFluidInput(long aIndex) {
        if (aIndex < 0L || aIndex >= (long)this.mFluidInputs.length || this.mFluidInputs[(int)aIndex] == null) {
            return null;
        }
        return this.mFluidInputs[(int)aIndex].copy();
    }

    public FluidStack getFluidOutput(long aIndex) {
        if (aIndex < 0L || aIndex >= (long)this.mFluidOutputs.length || this.mFluidOutputs[(int)aIndex] == null) {
            return null;
        }
        return this.mFluidOutputs[(int)aIndex].copy();
    }

    public Recipe copy() {
        return new Recipe(this);
    }

    public Recipe setNoBuffering() {
        this.mCanBeBuffered = false;
        return this;
    }

    public Recipe setNeedEmptyOut() {
        this.mNeedsEmptyOutput = true;
        return this;
    }

    public FluidStack[] getFluidOutputs(Random aRandom) {
        FluidStack[] rArray = new FluidStack[this.mFluidOutputs.length];
        for (int i = 0; i < rArray.length; ++i) {
            rArray[i] = this.getFluidOutput(i);
        }
        return rArray;
    }

    public ItemStack[] getOutputs(Random aRandom) {
        ItemStack[] rArray = new ItemStack[this.mOutputs.length];
        if (aRandom == null) {
            aRandom = new Random();
        }
        for (int i = 0; i < rArray.length; ++i) {
            ItemStack tOutput = this.getOutput(i);
            if (tOutput == null) continue;
            int tChance = this.getOutputChance(i);
            if (tChance > 0) {
                int tMax = this.getMaxChance(i);
                if (tChance == tMax) {
                    rArray[i] = tOutput;
                    continue;
                }
                if (tChance < tMax) {
                    for (int j = 0; j < tOutput.field_77994_a; ++j) {
                        if (aRandom.nextInt(tMax) >= tChance) continue;
                        if (rArray[i] == null) {
                            rArray[i] = UT.Stacks.amount(1L, tOutput);
                            continue;
                        }
                        ++rArray[i].field_77994_a;
                    }
                    continue;
                }
                int tIterations = 3 * tChance / (2 * tMax);
                int tAmount = tOutput.field_77994_a;
                tChance /= tIterations;
                for (int j = 0; j < tIterations; ++j) {
                    if (aRandom.nextInt(tMax) >= tChance) continue;
                    if (rArray[i] == null) {
                        rArray[i] = tOutput;
                        continue;
                    }
                    rArray[i].field_77994_a += tAmount;
                }
                continue;
            }
            rArray[i] = tOutput;
        }
        return rArray;
    }

    @Deprecated
    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        return this.isRecipeInputEqual(aDecreaseStacksizeBySuccess, false, aFluidInputs, aInputs);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        boolean temp;
        if (this.mFluidInputs.length > 0 && (aFluidInputs == null || aFluidInputs.length < 1)) {
            return false;
        }
        if (this.mInputs.length > 0 && (aInputs == null || aInputs.length < 1)) {
            return false;
        }
        for (FluidStack fluidStack : this.mFluidInputs) {
            if (fluidStack == null) continue;
            temp = true;
            for (FluidStack fluidStack2 : aFluidInputs) {
                if (fluidStack2 == null || !fluidStack2.isFluidEqual(fluidStack) || !aDontCheckStackSizes && fluidStack2.amount < fluidStack.amount) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        for (FluidStack fluidStack : this.mInputs) {
            if (!UT.Stacks.valid(fluidStack)) continue;
            temp = true;
            for (FluidStack fluidStack3 : aInputs) {
                if (!UT.Stacks.valid(fluidStack3) || !OreDictManager.INSTANCE.equal_(false, (ItemStack)fluidStack3, (ItemStack)fluidStack) || !aDontCheckStackSizes && fluidStack3.field_77994_a < fluidStack.field_77994_a) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (aDecreaseStacksizeBySuccess) {
            if (aFluidInputs != null) {
                block4: for (FluidStack fluidStack : this.mFluidInputs) {
                    if (fluidStack == null) continue;
                    FluidStack[] arr$ = aFluidInputs;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        FluidStack aFluid = arr$[i$];
                        if (aFluid == null || !aFluid.isFluidEqual(fluidStack) || !aDontCheckStackSizes && aFluid.amount < fluidStack.amount) continue;
                        aFluid.amount -= fluidStack.amount;
                        continue block4;
                    }
                }
            }
            if (aInputs != null) {
                block6: for (FluidStack fluidStack : this.mInputs) {
                    if (!UT.Stacks.valid(fluidStack)) continue;
                    for (ItemStack aStack : aInputs) {
                        if (!UT.Stacks.valid(aStack) || !OreDictManager.INSTANCE.equal_(false, aStack, (ItemStack)fluidStack) || !aDontCheckStackSizes && aStack.field_77994_a < fluidStack.field_77994_a) continue;
                        aStack.field_77994_a -= fluidStack.field_77994_a;
                        continue block6;
                    }
                }
            }
        }
        return true;
    }

    private Recipe(Recipe aRecipe) {
        this.mInputs = UT.Stacks.copyArray(aRecipe.mInputs);
        this.mOutputs = UT.Stacks.copyArray(aRecipe.mOutputs);
        this.mSpecialItems = aRecipe.mSpecialItems;
        this.mChances = Arrays.copyOf(aRecipe.mChances, aRecipe.mChances.length);
        this.mMaxChances = Arrays.copyOf(aRecipe.mMaxChances, aRecipe.mMaxChances.length);
        this.mFluidInputs = UT.Fluids.copyArray(aRecipe.mFluidInputs);
        this.mFluidOutputs = UT.Fluids.copyArray(aRecipe.mFluidOutputs);
        this.mEUt = aRecipe.mEUt;
        this.mDuration = aRecipe.mDuration;
        this.mSpecialValue = aRecipe.mSpecialValue;
        this.mNeedsEmptyOutput = aRecipe.mNeedsEmptyOutput;
        this.mCanBeBuffered = aRecipe.mCanBeBuffered;
        this.mFakeRecipe = aRecipe.mFakeRecipe;
        this.mEnabled = aRecipe.mEnabled;
        this.mHidden = aRecipe.mHidden;
    }

    public Recipe(boolean aOptimize, boolean aUnificate, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, long[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, long aDuration, long aEUt, long aSpecialValue) {
        int i;
        int i2;
        if (aInputs == null) {
            aInputs = CS.ZL_ITEMSTACK;
        }
        if (aOutputs == null) {
            aOutputs = CS.ZL_ITEMSTACK;
        }
        if (aFluidInputs == null) {
            aFluidInputs = CS.ZL_FLUIDSTACK;
        }
        if (aFluidOutputs == null) {
            aFluidOutputs = CS.ZL_FLUIDSTACK;
        }
        if (aChances == null) {
            long[] lArray = aChances = aOutputs.length < 0 ? CS.ZL_LONG : new long[aOutputs.length];
        }
        if (aChances.length < aOutputs.length) {
            aChances = Arrays.copyOf(aChances, aOutputs.length);
        }
        aInputs = UT.Code.getWithoutTrailingNulls(aInputs).toArray(CS.ZL_ITEMSTACK);
        aOutputs = UT.Code.getWithoutTrailingNulls(aOutputs).toArray(CS.ZL_ITEMSTACK);
        if (aUnificate) {
            OreDictManager.INSTANCE.setStackArray_(true, aInputs);
            OreDictManager.INSTANCE.setStackArray_(true, aOutputs);
        }
        for (int i3 = 0; i3 < aFluidOutputs.length; ++i3) {
            if (aFluidOutputs[i3] == CS.NF || aFluidOutputs[i3].amount > 0) continue;
            aFluidOutputs[i3] = CS.NF;
        }
        aFluidInputs = UT.Code.getWithoutNulls(aFluidInputs).toArray(CS.ZL_FLUIDSTACK);
        aFluidOutputs = UT.Code.getWithoutNulls(aFluidOutputs).toArray(CS.ZL_FLUIDSTACK);
        for (ItemStack tStack : aOutputs) {
            if (tStack == null) continue;
            if (UT.Stacks.meta(tStack) == Short.MAX_VALUE) {
                UT.Stacks.meta(tStack, 0L);
            }
            UT.Stacks.update(tStack);
        }
        for (i2 = 0; i2 < aChances.length; ++i2) {
            if (aChances[i2] > 0L) continue;
            aChances[i2] = 10000L;
        }
        for (i2 = 0; i2 < aInputs.length; ++i2) {
            if (aInputs[i2] == CS.NI) continue;
            aInputs[i2] = aInputs[i2].func_77946_l();
        }
        for (i2 = 0; i2 < aOutputs.length; ++i2) {
            if (aOutputs[i2] == CS.NI) continue;
            aOutputs[i2] = aOutputs[i2].func_77946_l();
        }
        for (i2 = 0; i2 < aFluidInputs.length; ++i2) {
            aFluidInputs[i2] = aFluidInputs[i2].copy();
        }
        for (i2 = 0; i2 < aFluidOutputs.length; ++i2) {
            aFluidOutputs[i2] = aFluidOutputs[i2].copy();
        }
        if (aOptimize) {
            for (i2 = 0; i2 < aInputs.length; ++i2) {
                if (aInputs[i2] == CS.NI || UT.Stacks.meta(aInputs[i2]) == Short.MAX_VALUE) continue;
                for (int j = 0; j < aOutputs.length; ++j) {
                    if (!UT.Stacks.equal(aInputs[i2], aOutputs[j])) continue;
                    if (aInputs[i2].field_77994_a >= aOutputs[j].field_77994_a) {
                        aInputs[i2].field_77994_a -= aOutputs[j].field_77994_a;
                        aOutputs[j] = CS.NI;
                        continue;
                    }
                    aOutputs[j].field_77994_a -= aInputs[i2].field_77994_a;
                }
            }
            if (aDuration >= 32L) {
                ArrayListNoNulls<ItemStack> tList = new ArrayListNoNulls<ItemStack>(Arrays.asList(aInputs));
                ((ArrayList)tList).addAll(Arrays.asList(aOutputs));
                for (byte i4 = (byte)Math.min(tList.isEmpty() ? 1000L : 64L, aDuration / 16L); i4 > 1; i4 = (byte)(i4 - 1)) {
                    int j;
                    if (aDuration / (long)i4 < 16L) continue;
                    boolean temp = true;
                    int k = tList.size();
                    for (j = 0; temp && j < k; ++j) {
                        if (((ItemStack)tList.get((int)j)).field_77994_a % i4 == 0) continue;
                        temp = false;
                    }
                    for (j = 0; temp && j < aFluidInputs.length; ++j) {
                        if (aFluidInputs[j].amount % i4 == 0) continue;
                        temp = false;
                    }
                    for (j = 0; temp && j < aFluidOutputs.length; ++j) {
                        if (aFluidOutputs[j].amount % i4 == 0) continue;
                        temp = false;
                    }
                    if (!temp) continue;
                    k = tList.size();
                    for (j = 0; j < k; ++j) {
                        ((ItemStack)tList.get((int)j)).field_77994_a /= i4;
                    }
                    for (j = 0; j < aFluidInputs.length; ++j) {
                        aFluidInputs[j].amount /= i4;
                    }
                    for (j = 0; j < aFluidOutputs.length; ++j) {
                        aFluidOutputs[j].amount /= i4;
                    }
                    aDuration /= (long)i4;
                    break;
                }
            }
        }
        for (i = 0; i < aInputs.length; ++i) {
            if (aInputs[i] == CS.NI || aInputs[i].field_77994_a <= 64) continue;
            aInputs[i].field_77994_a = 64;
        }
        for (i = 0; i < aOutputs.length; ++i) {
            if (aOutputs[i] == CS.NI || aOutputs[i].field_77994_a <= 64) continue;
            aOutputs[i].field_77994_a = 64;
        }
        this.mInputs = aInputs;
        this.mOutputs = aOutputs;
        this.mSpecialItems = aSpecialItems;
        this.mChances = aChances;
        this.mMaxChances = new long[aChances.length];
        Arrays.fill(this.mMaxChances, 10000L);
        this.mFluidInputs = aFluidInputs;
        this.mFluidOutputs = aFluidOutputs;
        this.mDuration = aDuration;
        this.mSpecialValue = aSpecialValue;
        this.mEUt = aEUt;
    }

    public static class RecipeMap
    implements Runnable {
        public static final Map<String, RecipeMap> RECIPE_MAPS = new HashMap<String, RecipeMap>();
        public static final RecipeMap sOreWasherRecipes = new RecipeMapOreWasher(null, "ic.recipe.orewasher", "Ore Washer", "ic2.blockOreWashingPlant", 0L, 1L, CS.RES_PATH_GUI + "machines/OreWasher", 1L, 3L, 1L, 0L, 0L, 1L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sThermalCentrifugeRecipes = new RecipeMapThermalCentrifuge(null, "ic.recipe.thermalcentrifuge", "Thermal Centrifuge", "ic2.blockCentrifuge", 0L, 1L, CS.RES_PATH_GUI + "machines/ThermalCentrifuge", 1L, 3L, 1L, 0L, 0L, 0L, 0L, 2L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sMaceratorRecipes = new RecipeMapMacerator(null, "ic.recipe.macerator", "Macerator", "ic2.macerator", 0L, 1L, CS.RES_PATH_GUI + "machines/Macerator", 1L, 4L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sIC2CompressorRecipes = new RecipeMapCompressor(null, "ic.recipe.compressor", "Compressor", "ic2.compressor", 0L, 1L, CS.RES_PATH_GUI + "machines/Compressor", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sExtractorRecipes = new RecipeMapExtractor(null, "ic.recipe.extractor", "Extractor", "ic2.extractor", 0L, 1L, CS.RES_PATH_GUI + "machines/Extractor", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sRecyclerRecipes = new RecipeMapRecycler(null, "ic.recipe.recycler", "Recycler", "ic2.recycler", 0L, 1L, CS.RES_PATH_GUI + "machines/Recycler", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sFurnaceRecipes = new RecipeMapFurnace(null, "mc.recipe.furnace", "Furnace", "smelting", 0L, 1L, CS.RES_PATH_GUI + "machines/E_Furnace", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sMicrowaveRecipes = new RecipeMapMicrowave(null, "gt.recipe.microwave", "Microwave", "smelting", 0L, 1L, CS.RES_PATH_GUI + "machines/E_Furnace", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sFurnaceFuel = new RecipeMapFurnaceFuel(null, "mc.recipe.furnacefuel", "Furnace Fuels", "smelting", 0L, 1L, CS.RES_PATH_GUI + "machines/E_Furnace", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, false);
        public static final RecipeMap sScannerFakeRecipes = new RecipeMap(null, "gt.recipe.scanner", "Scanner", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Scanner", 2L, 2L, 1L, 1L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sRockBreakerFakeRecipes = new RecipeMap(null, "gt.recipe.rockbreaker", "Rock Breaker", null, 0L, 1L, CS.RES_PATH_GUI + "machines/RockBreaker", 1L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sByProductList = new RecipeMap(null, "gt.recipe.byproductlist", "Ore Byproduct List", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 6L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, false, true);
        public static final RecipeMap sCrucibleSmelting = new RecipeMap(null, "gt.recipe.cruciblesmelting", "Crucible Smelting", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 6L, 6L, 1L, 0L, 0L, 0L, 0L, 1L, "Temperature: ", 1L, " K", true, true, false, true);
        public static final RecipeMap sCrucibleAlloying = new RecipeMap(null, "gt.recipe.cruciblealloying", "Combination Smelting", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 6L, 6L, 1L, 0L, 0L, 0L, 0L, 1L, "Temperature: ", 1L, " K", true, true, false, true);
        public static final RecipeMap sGenerifierRecipes = new RecipeMap(null, "gt.recipe.generifier", "Generifier", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Generifier", 1L, 1L, 0L, 1L, 1L, 0L, 1L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sSharpeningRecipes = new RecipeMap(null, "gt.recipe.sharpener", "Sharpener", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Sharpener", 1L, 2L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sSifterRecipes = new RecipeMap(null, "gt.recipe.sifter", "Sifter", null, 2L, 1L, CS.RES_PATH_GUI + "machines/Sifter", 1L, 12L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sHammerRecipes = new RecipeMapHammer(null, "gt.recipe.hammer", "Hammer", null, 6L, 3L, CS.RES_PATH_GUI + "machines/Hammer", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, true, true);
        public static final RecipeMap sChiselRecipes = new RecipeMapChisel(null, "gt.recipe.chisel", "Chisel", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Chisel", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, true, true);
        public static final RecipeMap sShredderRecipes = new RecipeMapShredder(null, "gt.recipe.shredder", "Shredder", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Shredder", 1L, 6L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sCrusherRecipes = new RecipeMapCrusher(null, "gt.recipe.crusher", "Crusher", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Crusher", 1L, 4L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sLatheRecipes = new RecipeMap(null, "gt.recipe.lathe", "Lathe", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Lathe", 1L, 2L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sCutterRecipes = new RecipeMapCutter(null, "gt.recipe.cutter", "Cutter", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Cutter", 1L, 2L, 1L, 1L, 0L, 1L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sCoagulatorRecipes = new RecipeMap(null, "gt.recipe.coagulator", "Coagulator", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Coagulator", 0L, 1L, 0L, 1L, 0L, 1L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sSqueezerRecipes = new RecipeMap(null, "gt.recipe.squeezer", "Squeezer", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Squeezer", 1L, 1L, 1L, 0L, 1L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sJuicerRecipes = new RecipeMap(null, "gt.recipe.juicer", "Juicer", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Juicer", 1L, 1L, 1L, 0L, 1L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sCompressorRecipes = new RecipeMap(null, "gt.recipe.compressor", "Compressor", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Compressor", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sCentrifugeRecipes = new RecipeMap(null, "gt.recipe.centrifuge", "Centrifuge", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Centrifuge", 1L, 6L, 0L, 1L, 6L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sElectrolyzerRecipes = new RecipeMap(null, "gt.recipe.electrolyzer", "Electrolyzer", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Electrolyzer", 1L, 6L, 0L, 1L, 6L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sRollingMillRecipes = new RecipeMap(null, "gt.recipe.rollingmill", "Rolling Mill", null, 0L, 1L, CS.RES_PATH_GUI + "machines/RollingMill", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sRollBenderRecipes = new RecipeMap(null, "gt.recipe.rollbender", "Roll Bender", null, 0L, 1L, CS.RES_PATH_GUI + "machines/RollBender", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sRollFormerRecipes = new RecipeMap(null, "gt.recipe.rollformer", "Roll Former", null, 0L, 1L, CS.RES_PATH_GUI + "machines/RollFormer", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sClusterMillRecipes = new RecipeMap(null, "gt.recipe.clustermill", "Cluster Mill", null, 0L, 1L, CS.RES_PATH_GUI + "machines/ClusterMill", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sWiremillRecipes = new RecipeMap(null, "gt.recipe.wiremill", "Wiremill", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Wiremill", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sMixerRecipes = new RecipeMap(null, "gt.recipe.mixer", "Mixer", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Mixer", 6L, 1L, 0L, 6L, 2L, 0L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sCannerRecipes = new RecipeMapFluidCanner(null, "gt.recipe.canner", "Canning Machine", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Canner", 2L, 2L, 1L, 1L, 1L, 0L, 1L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sInjectorRecipes = new RecipeMap(null, "gt.recipe.injector", "Injector", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Injector", 2L, 1L, 0L, 2L, 1L, 0L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sRoastingRecipes = new RecipeMap(null, "gt.recipe.roaster", "Roaster", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Roaster", 1L, 3L, 1L, 1L, 1L, 1L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sDryingRecipes = new RecipeMap(null, "gt.recipe.drying", "Dryer", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Dryer", 1L, 1L, 0L, 1L, 1L, 0L, 1L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sFermenterRecipes = new RecipeMap(null, "gt.recipe.fermenter", "Fermenter", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Fermenter", 1L, 1L, 0L, 1L, 1L, 0L, 1L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sDistilleryRecipes = new RecipeMap(null, "gt.recipe.distillery", "Distillery", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Distillery", 1L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sExtruderRecipes = new RecipeMap(null, "gt.recipe.extruder", "Extruder", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Extruder", 2L, 1L, 2L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sPolarizerRecipes = new RecipeMap(null, "gt.recipe.polarizer", "Polarizer", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Polarizer", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sLoomRecipes = new RecipeMap(null, "gt.recipe.loom", "Loom", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Loom", 6L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sCookingRecipes = new RecipeMap(null, "gt.recipe.cooker", "Cooker", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Cooker", 9L, 1L, 1L, 3L, 1L, 1L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sPressRecipes = new RecipeMapFormingPress(null, "gt.recipe.press", "Press", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Press", 3L, 1L, 2L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sBathRecipes = new RecipeMapBath(null, "gt.recipe.bath", "Bath", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Bath", 6L, 6L, 1L, 1L, 3L, 1L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sSmelterRecipes = new RecipeMap(null, "gt.recipe.smelter", "Smelter", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Smelter", 1L, 1L, 0L, 1L, 1L, 0L, 1L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sLaserEngraverRecipes = new RecipeMap(null, "gt.recipe.laserengraver", "Precision Laser Engraver", null, 0L, 1L, CS.RES_PATH_GUI + "machines/LaserEngraver", 2L, 1L, 2L, 0L, 0L, 0L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sWelderRecipes = new RecipeMap(null, "gt.recipe.welder", "Welding Machine", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Welder", 6L, 1L, 2L, 0L, 0L, 0L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sCrystallisationCrucibleRecipes = new RecipeMap(null, "gt.recipe.crystallisationcrucible", "Crystallisation Crucible", null, 0L, 1L, CS.RES_PATH_GUI + "machines/CrystallisationCrucible", 1L, 1L, 1L, 2L, 0L, 1L, 1L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sScannerVisualsRecipes = new RecipeMapScannerVisuals(null, "gt.recipe.scannervisuals", "Scanner (Visuals)", null, 0L, 1L, CS.RES_PATH_GUI + "machines/ScannerVisuals", 2L, 2L, 2L, 0L, 0L, 0L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sPrinterRecipes = new RecipeMapPrinter(null, "gt.recipe.printer", "Printer", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Printer", 2L, 1L, 1L, 6L, 0L, 1L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sSluiceRecipes = new RecipeMap(null, "gt.recipe.sluice", "Sluice", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Sluice", 1L, 9L, 1L, 1L, 1L, 1L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sMagneticSeparatorRecipes = new RecipeMap(null, "gt.recipe.magneticseparator", "Magnetic Separator", null, 0L, 1L, CS.RES_PATH_GUI + "machines/MagneticSeparator", 1L, 6L, 1L, 0L, 0L, 0L, 1L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sAutocrafterRecipes = new RecipeMapAutocrafting(null, "gt.recipe.autocrafting", "Crafting", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Crafting", 9L, 12L, 1L, 0L, 0L, 0L, 1L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sMassfabRecipes = new RecipeMap(null, "gt.recipe.massfab", "Matter Fabricator", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Massfab", 1L, 1L, 0L, 1L, 2L, 0L, 1L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sScannerMolecularRecipes = new RecipeMapScannerMolecular(null, "gt.recipe.scannermolecular", "Molecular Scanner", null, 0L, 1L, CS.RES_PATH_GUI + "machines/ScannerMolecular", 2L, 1L, 1L, 0L, 0L, 0L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sReplicatorRecipes = new RecipeMapReplicator(null, "gt.recipe.replicator", "Matter Replicator", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Replicator", 3L, 3L, 1L, 3L, 3L, 0L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sSlicerRecipes = new RecipeMap(null, "gt.recipe.slicer", "Slicer", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Slicer", 2L, 2L, 2L, 0L, 0L, 0L, 2L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sCokeOvenRecipes = new RecipeMap(null, "gt.recipe.cokeoven", "Coke Oven", null, 0L, 1L, CS.RES_PATH_GUI + "machines/CokeOven", 1L, 1L, 1L, 0L, 1L, 0L, 1L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sDistillationTowerRecipes = new RecipeMap(null, "gt.recipe.distillationtower", "Distillation Tower", null, 0L, 1L, CS.RES_PATH_GUI + "machines/DistillationTower", 1L, 3L, 0L, 1L, 9L, 0L, 1L, 1L, "", 1L, "", true, true, true, true);
        public static final RecipeMap sAutoclaveRecipes = new RecipeMap(null, "gt.recipe.autoclave", "Autoclave", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Autoclave", 1L, 1L, 1L, 0L, 0L, 1L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sBrewingRecipes = new RecipeMap(null, "gt.recipe.brewer", "Brewing Machine", null, 0L, 1L, CS.RES_PATH_GUI + "machines/PotionBrewer", 1L, 0L, 1L, 0L, 0L, 1L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sFluidSolidficationRecipes = new RecipeMap(null, "gt.recipe.fluidsolidifier", "Fluid Solidifier", null, 0L, 1L, CS.RES_PATH_GUI + "machines/FluidSolidifier", 1L, 1L, 1L, 0L, 0L, 1L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sBoxinatorRecipes = new RecipeMap(null, "gt.recipe.packager", "Packager", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Packager", 2L, 1L, 2L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sUnboxinatorRecipes = new RecipeMapUnboxinator(null, "gt.recipe.unpackager", "Unpackager", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Unpackager", 1L, 2L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sFusionRecipes = new RecipeMap(null, "gt.recipe.fusionreactor", "Fusion Reactor", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 2L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, "Start: ", 1L, " EU", true, false, false, true);
        public static final RecipeMap sBlastRecipes = new RecipeMap(null, "gt.recipe.blastfurnace", "Blast Furnace", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 2L, 2L, 1L, 0L, 0L, 0L, 0L, 1L, "Heat Capacity: ", 1L, " K", false, false, false, true);
        public static final RecipeMap sImplosionRecipes = new RecipeMap(null, "gt.recipe.implosioncompressor", "Implosion Compressor", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 2L, 2L, 2L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sVacuumRecipes = new RecipeMap(null, "gt.recipe.vacuumfreezer", "Vacuum Freezer", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sAssemblerRecipes = new RecipeMapAssembler(null, "gt.recipe.assembler", "Assembler", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Assembler", 2L, 1L, 1L, 1L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sCNCRecipes = new RecipeMap(null, "gt.recipe.cncmachine", "CNC Machine", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 2L, 1L, 2L, 1L, 0L, 1L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sAmplifiers = new RecipeMap(null, "gt.recipe.uuamplifier", "UU Amplifier", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Amplifabricator", 1L, 0L, 1L, 0L, 0L, 0L, 0L, 1L, "", 1L, "", true, false, false, true);
        public static final RecipeMap sFuelsBurn = new RecipeMapFuel(null, "gt.recipe.fuels.burn", "Burnable Fuels", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 2L, 0L, 1L, 2L, 0L, 1L, 1L, "", 1L, "", true, true, true, false);
        public static final RecipeMap sFuelsGas = new RecipeMapFuel(null, "gt.recipe.fuels.gas", "Gas Fuels", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 2L, 0L, 1L, 2L, 0L, 1L, 1L, "", 1L, "", true, true, true, false);
        public static final RecipeMap sFuelsHot = new RecipeMapFuel(null, "gt.recipe.fuels.hot", "Hot Fuels", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 2L, 0L, 1L, 2L, 0L, 1L, 1L, "", 1L, "", true, true, true, false);
        public static final RecipeMap sFuelsPlasma = new RecipeMapFuel(null, "gt.recipe.fuels.plasma", "Plasma Fuels", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 2L, 0L, 1L, 2L, 0L, 1L, 1L, "", 1L, "", true, true, true, false);
        public static final RecipeMap sFuelsEngine = new RecipeMapFuel(null, "gt.recipe.fuels.engine", "Engine Fuels", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 2L, 0L, 1L, 2L, 0L, 1L, 1L, "", 1L, "", true, true, true, false);
        public static final RecipeMap sFuelsTurbine = new RecipeMapFuel(null, "gt.recipe.fuels.turbine", "Turbine Fuels", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 2L, 0L, 1L, 2L, 0L, 1L, 1L, "", 1L, "", true, true, true, false);
        public static final RecipeMap sFuelsMagic = new RecipeMapFuel(null, "gt.recipe.fuels.magic", "Magic Fuels", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 2L, 0L, 1L, 2L, 0L, 1L, 1L, "", 1L, "", true, true, true, false);
        public static final RecipeMapFuel sDieselFuels = new RecipeMapFuel(null, "gt.recipe.dieselgeneratorfuel", "Diesel Generator Fuel", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, "Fuel Value: ", 1000L, " EU", true, false, false, false);
        public static final RecipeMapFuel sTurbineFuels = new RecipeMapFuel(null, "gt.recipe.gasturbinefuel", "Gas Turbine Fuel", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, "Fuel Value: ", 1000L, " EU", true, false, false, false);
        public static final RecipeMapFuel sHotFuels = new RecipeMapFuel(null, "gt.recipe.thermalgeneratorfuel", "Thermal Generator Fuel", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, "Fuel Value: ", 1000L, " EU", true, false, false, false);
        public static final RecipeMapFuel sDenseLiquidFuels = new RecipeMapFuel(null, "gt.recipe.semifluidboilerfuels", "Semifluid Boiler Fuels", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, "Fuel Value: ", 1000L, " EU", true, false, false, false);
        public static final RecipeMapFuel sPlasmaFuels = new RecipeMapFuel(null, "gt.recipe.plasmageneratorfuels", "Plasma generator Fuels", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, "Fuel Value: ", 1000L, " EU", true, false, false, false);
        public static final RecipeMapFuel sMagicFuels = new RecipeMapFuel(null, "gt.recipe.magicfuels", "Magic Fuels", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, "Fuel Value: ", 1000L, " EU", true, false, false, false);
        public static final RecipeMapFuel sSmallNaquadahReactorFuels = new RecipeMapFuel(null, "gt.recipe.smallnaquadahreactor", "Small Naquadah Reactor", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, "Fuel Value: ", 1000L, " EU", true, false, false, false);
        public static final RecipeMapFuel sLargeNaquadahReactorFuels = new RecipeMapFuel(null, "gt.recipe.largenaquadahreactor", "Large Naquadah Reactor", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, "Fuel Value: ", 1000L, " EU", true, false, false, false);
        public static final RecipeMapFuel sFluidNaquadahReactorFuels = new RecipeMapFuel(null, "gt.recipe.fluidnaquadahreactor", "Fluid Naquadah Reactor", null, 0L, 1L, CS.RES_PATH_GUI + "machines/Default", 1L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, "Fuel Value: ", 1000L, " EU", true, false, false, false);
        public final List<IRecipeMapHandler> mRecipeMapHandlers = new ArrayListNoNulls<IRecipeMapHandler>();
        public final List<ItemStack> mRecipeMachineList = new ArrayListNoNulls<ItemStack>();
        public final Map<ItemStackContainer, Collection<Recipe>> mRecipeItemMap = new ItemStackMap();
        public final Map<String, Collection<Recipe>> mRecipeFluidMap = new HashMap<String, Collection<Recipe>>();
        public final Collection<Recipe> mRecipeList;
        public final String mNameInternal;
        public final String mNameLocal;
        public final String mNameLocalUnderscored;
        public final String mNameNEI;
        public final String mGUIPath;
        public final String mNEISpecialValuePre;
        public final String mNEISpecialValuePost;
        public final byte mProgressBarDirection;
        public final byte mProgressBarAmount;
        public final int mInputItemsCount;
        public final int mOutputItemsCount;
        public final int mInputFluidCount;
        public final int mOutputFluidCount;
        public final int mMinimalInputItems;
        public final int mMinimalInputFluids;
        public final int mMinimalInputs;
        public final long mNEISpecialValueMultiplier;
        public final long mPower;
        public final boolean mNEIAllowed;
        public final boolean mShowVoltageAmperageInNEI;
        public final boolean mNeedsOutputs;
        public int mMaxFluidInputSize = 1000;
        public Config mConfigFile = null;
        private Recipe oRecipe = null;

        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs) {
            this.mNEIAllowed = aNEIAllowed;
            this.mShowVoltageAmperageInNEI = aShowVoltageAmperageInNEI;
            this.mNeedsOutputs = aNeedsOutputs;
            this.mRecipeList = aRecipeList == null ? new HashSetNoNulls() : aRecipeList;
            this.mNameInternal = aNameInternal;
            this.mNameLocal = aNameLocal;
            this.mNameLocalUnderscored = this.mNameLocal.replaceAll(" ", "_");
            this.mNameNEI = aNameNEI == null ? this.mNameInternal : aNameNEI;
            this.mGUIPath = aNEIGUIPath.endsWith(".png") ? aNEIGUIPath : aNEIGUIPath + ".png";
            this.mNEISpecialValuePre = aNEISpecialValuePre;
            this.mNEISpecialValueMultiplier = aNEISpecialValueMultiplier;
            this.mNEISpecialValuePost = aNEISpecialValuePost;
            this.mPower = aPower;
            this.mMinimalInputItems = (int)aMinimalInputItems;
            this.mInputItemsCount = (int)Math.max(aInputItemsCount, (long)this.mMinimalInputItems);
            this.mOutputItemsCount = (int)aOutputItemsCount;
            this.mMinimalInputFluids = (int)aMinimalInputFluids;
            this.mInputFluidCount = (int)Math.max(aInputFluidCount, (long)this.mMinimalInputFluids);
            this.mOutputFluidCount = (int)aOutputFluidCount;
            this.mMinimalInputs = (int)aMinimalInputs;
            this.mProgressBarDirection = (byte)aProgressBarDirection;
            this.mProgressBarAmount = (byte)aProgressBarAmount;
            LH.add(this.mNameInternal, this.mNameLocal);
            if (RECIPE_MAPS.containsKey(this.mNameInternal)) {
                throw new IllegalArgumentException("Recipe Map Name already exists: " + this.mNameInternal);
            }
            RECIPE_MAPS.put(this.mNameInternal, this);
            if (aConfigAllowed) {
                if (CS.GAPI.mBeforePreInit != null) {
                    CS.GAPI.mBeforePreInit.add(this);
                } else {
                    this.run();
                }
            }
        }

        public String toString() {
            return this.mNameInternal;
        }

        @Override
        public void run() {
            this.mConfigFile = new Config(CS.DirectoriesGT.CONFIG_RECIPES, this.mNameLocalUnderscored + ".cfg");
        }

        @Deprecated
        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs) {
            this(aRecipeList, aNameInternal, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, 0L, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs);
        }

        @Deprecated
        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed) {
            this(aRecipeList, aNameInternal, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, 0L, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, true);
        }

        @Deprecated
        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            this(aRecipeList, aNameInternal, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, 0L, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, true, true);
        }

        @Deprecated
        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aMinimalInputFluids, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            this(aRecipeList, aNameInternal, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, 0L, 0L, aMinimalInputFluids, 0L, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, true, true);
        }

        @Deprecated
        public RecipeMap(Collection<Recipe> aRecipeList, String aNameInternal, String aNameLocal, String aNameNEI, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aMinimalInputFluids, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            this(aRecipeList, aNameInternal, aNameLocal, aNameNEI, 0L, 1L, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, 0L, 0L, aMinimalInputFluids, 0L, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, true, true);
        }

        public Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, long[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, long aDuration, long aEUt, long aSpecialValue) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public Recipe addRecipe(Recipe aRecipe) {
            return this.addRecipe(aRecipe, true, false, false, true);
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, aOutputs, CS.NI, CS.ZL_LONG, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, CS.ZL_LONG, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, ItemStack[] aInputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, aOutputs, CS.NI, CS.ZL_LONG, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, aOutputs, CS.NI, aChances, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, aChances, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, aOutputs, CS.NI, aChances, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, long aChance, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, CS.ZL_ITEMSTACK, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, CS.ZL_ITEMSTACK, aOutputs, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, aOutputs, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, aOutputs, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, long[] aChances, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, CS.ZL_ITEMSTACK, aOutputs, CS.NI, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, aOutputs, CS.NI, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, aOutputs, CS.NI, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, CS.ZL_ITEMSTACK, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, long aChance, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, CS.ZL_ITEMSTACK, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, CS.ZL_ITEMSTACK, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, long[] aChances, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, CS.ZL_ITEMSTACK, aOutputs, CS.NI, aChances, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, aOutputs, CS.NI, aChances, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, aChances, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, aOutputs, CS.NI, aChances, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, CS.ZL_ITEMSTACK, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, long aChance, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, CS.ZL_ITEMSTACK, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, CS.ZL_ITEMSTACK, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe0(boolean aOptimize, long aEUt, long aDuration, long[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, CS.ZL_ITEMSTACK, aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput}, aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe2(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipeX(boolean aOptimize, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, true, aInputs, aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L));
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, aOutputs, CS.NI, CS.ZL_LONG, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, CS.ZL_LONG, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack[] aInputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, aOutputs, CS.NI, CS.ZL_LONG, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, aOutputs, CS.NI, aChances, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, aChances, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, aOutputs, CS.NI, aChances, CS.ZL_FLUIDSTACK, CS.ZL_FLUIDSTACK, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, CS.ZL_ITEMSTACK, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, CS.ZL_ITEMSTACK, aOutputs, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, aOutputs, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, aOutputs, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, CS.ZL_ITEMSTACK, aOutputs, CS.NI, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, aOutputs, CS.NI, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, aOutputs, CS.NI, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, CS.ZL_ITEMSTACK, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack aFluidInput, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, new FluidStack[]{aFluidInput}, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, CS.ZL_ITEMSTACK, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, CS.ZL_ITEMSTACK, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, CS.ZL_ITEMSTACK, aOutputs, CS.NI, aChances, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, aOutputs, CS.NI, aChances, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, aChances, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack aFluidOutput, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, aOutputs, CS.NI, aChances, aFluidInputs, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, CS.ZL_ITEMSTACK, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack ... aFluidOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, CS.ZL_ITEMSTACK, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, CS.ZL_ITEMSTACK, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long aChance, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack aOutput) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, new ItemStack[]{aOutput}, CS.NI, new long[]{aChance}, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, CS.ZL_ITEMSTACK, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, aOutputs, CS.NI, CS.ZL_LONG, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe0(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, CS.ZL_ITEMSTACK, aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe1(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput}, aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe2(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, new ItemStack[]{aInput1, aInput2}, aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipeX(boolean aOptimize, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors, long aEUt, long aDuration, long[] aChances, ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack ... aOutputs) {
            return this.addRecipe(new Recipe(aOptimize, aCheckForCollisions, aInputs, aOutputs, CS.NI, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, 0L), aCheckForCollisions, aFakeRecipe, aHidden, aLogErrors);
        }

        public Recipe addRecipe(Recipe aRecipe, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden, boolean aLogErrors) {
            aRecipe.mHidden = aHidden;
            aRecipe.mFakeRecipe = aFakeRecipe;
            if (aCheckForCollisions && this.findRecipeInternal(null, null, false, false, Long.MAX_VALUE, null, aRecipe.mFluidInputs, aRecipe.mInputs) != null) {
                return null;
            }
            return this.add(aRecipe, aLogErrors);
        }

        public Recipe addRecipe(Recipe aRecipe, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden) {
            return this.addRecipe(aRecipe, aCheckForCollisions, aFakeRecipe, aHidden, true);
        }

        public Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, long[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, long aDuration, long aEUt, long aSpecialValue) {
            return this.addFakeRecipe(aCheckForCollisions, new Recipe(false, false, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, long aDuration, long aEUt, long aSpecialValue) {
            return this.addFakeRecipe(aCheckForCollisions, new Recipe(false, false, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public Recipe addFakeRecipe(boolean aCheckForCollisions, Recipe aRecipe) {
            return this.addRecipe(aRecipe, aCheckForCollisions, true, false, true);
        }

        public Recipe add(Recipe aRecipe) {
            return this.add(aRecipe, true);
        }

        public synchronized Recipe add(Recipe aRecipe, boolean aLogErrors) {
            if (!aRecipe.mFakeRecipe) {
                boolean tErrored = false;
                boolean tFailed = false;
                if (aRecipe.mInputs.length + aRecipe.mFluidInputs.length <= 0) {
                    if (aLogErrors) {
                        CS.ERR.println("Error: Recipe has no Inputs!");
                    }
                    tFailed = true;
                } else {
                    if (this.mNeedsOutputs && aRecipe.mOutputs.length + aRecipe.mFluidOutputs.length <= 0) {
                        if (aLogErrors) {
                            CS.ERR.println("Error: Recipe has no Outputs!");
                        }
                        tFailed = true;
                    }
                    if (aRecipe.mInputs.length < this.mMinimalInputItems) {
                        if (aLogErrors) {
                            CS.ERR.println("Error: Recipe has less than the minimal amount of Input ItemStacks!");
                        }
                        tFailed = true;
                    }
                    if (aRecipe.mFluidInputs.length < this.mMinimalInputFluids) {
                        if (aLogErrors) {
                            CS.ERR.println("Error: Recipe has less than the minimal amount of Input FluidStacks!");
                        }
                        tFailed = true;
                    }
                    if (aRecipe.mFluidInputs.length + aRecipe.mInputs.length < this.mMinimalInputs) {
                        if (aLogErrors) {
                            CS.ERR.println("Error: Recipe has less than the minimal amount of general Inputs!");
                        }
                        tFailed = true;
                    }
                    if (aRecipe.mInputs.length > this.mInputItemsCount) {
                        if (aLogErrors) {
                            CS.ERR.println("Error: Recipe has more than the maximum amount of Input ItemStacks!");
                        }
                        tFailed = true;
                    }
                    if (aRecipe.mFluidInputs.length > this.mInputFluidCount) {
                        if (aLogErrors) {
                            CS.ERR.println("Error: Recipe has more than the maximum amount of Input FluidStacks!");
                        }
                        tFailed = true;
                    }
                }
                if (aRecipe.mOutputs.length > this.mOutputItemsCount) {
                    if (aLogErrors) {
                        CS.ERR.println("WARNING: Recipe has more than the maximum amount of Output ItemStacks!");
                    }
                    tErrored = true;
                }
                if (aRecipe.mFluidOutputs.length > this.mOutputFluidCount) {
                    if (aLogErrors) {
                        CS.ERR.println("WARNING: Recipe has more than the maximum amount of Output FluidStacks!");
                    }
                    tErrored = true;
                }
                if (aRecipe.mDuration == 0L) {
                    if (aLogErrors) {
                        CS.ERR.println("WARNING: Recipe has no Duration Value!");
                    }
                    tErrored = true;
                }
                if (tErrored || tFailed) {
                    if (aLogErrors) {
                        int i = 0;
                        for (StackTraceElement tElement : new Exception().getStackTrace()) {
                            if (tElement.getClassName().equals("gregapi.recipes.Recipe$RecipeMap")) continue;
                            if (i++ >= 5 || tElement.getClassName().startsWith("sun")) break;
                            CS.ERR.println("\tat " + tElement);
                        }
                    }
                    if (tFailed) {
                        return null;
                    }
                }
            }
            if (this.mConfigFile != null) {
                String tConfigName = "";
                if (aRecipe.mInputs.length > 0) {
                    tConfigName = tConfigName + UT.Stacks.configNames(aRecipe.mInputs);
                }
                if (aRecipe.mFluidInputs.length > 0) {
                    tConfigName = tConfigName + UT.Fluids.configNames(aRecipe.mFluidInputs);
                }
                if (UT.Code.stringValid(tConfigName)) {
                    aRecipe.mDuration = this.mConfigFile.get((Object)this.mNameLocalUnderscored, tConfigName, aRecipe.mEnabled ? aRecipe.mDuration : 0L);
                    boolean bl = aRecipe.mEnabled = aRecipe.mDuration > 0L;
                }
            }
            if (!this.mRecipeList.add(aRecipe)) {
                return null;
            }
            for (FluidStack aFluid : aRecipe.mFluidInputs) {
                if (aFluid == null) continue;
                this.mMaxFluidInputSize = Math.max(this.mMaxFluidInputSize, aFluid.amount);
                Collection<Recipe> tList = this.mRecipeFluidMap.get(aFluid.getFluid().getName());
                if (tList == null) {
                    tList = new HashSet<Recipe>(1);
                    this.mRecipeFluidMap.put(aFluid.getFluid().getName(), tList);
                }
                tList.add(aRecipe);
            }
            return this.addToItemMap(aRecipe);
        }

        public void reInit() {
            this.mRecipeItemMap.clear();
            for (Recipe tRecipe : this.mRecipeList) {
                OreDictManager.INSTANCE.setStackArray(true, tRecipe.mInputs);
                OreDictManager.INSTANCE.setStackArray(true, tRecipe.mOutputs);
                this.addToItemMap(tRecipe);
            }
        }

        public Slot_Normal getSpecialSlot(ITileEntityInventoryGUI aInventory, int aIndex, int aX, int aY) {
            return null;
        }

        public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
            if (UT.Stacks.invalid(aStack)) {
                return false;
            }
            if (this.mRecipeItemMap.containsKey(new ItemStackContainer(aStack))) {
                return true;
            }
            if (this.mRecipeItemMap.containsKey(new ItemStackContainer(UT.Stacks.copyMeta(32767L, aStack)))) {
                return true;
            }
            if (this.mRecipeMapHandlers.isEmpty()) {
                return false;
            }
            OreDictItemData aData = OM.data_(aStack);
            for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                if (!tHandler.containsInput(this, aStack, aData)) continue;
                return true;
            }
            return false;
        }

        public boolean containsInput(FluidStack aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
            return aFluid != null && this.containsInput(aFluid.getFluid(), aTileEntity, aSpecialSlot);
        }

        public boolean containsInput(Fluid aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
            if (aFluid == null) {
                return false;
            }
            if (this.mRecipeFluidMap.containsKey(aFluid.getName())) {
                return true;
            }
            if (this.mRecipeMapHandlers.isEmpty()) {
                return false;
            }
            for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                if (!tHandler.containsInput(this, aFluid)) continue;
                return true;
            }
            return false;
        }

        public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
            return this.findRecipeInternal(aTileEntity, aRecipe, true, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        }

        public Recipe findRecipeInternal(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aLoop, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
            if (this.mRecipeList.isEmpty() && (!aLoop || this.mRecipeMapHandlers.isEmpty())) {
                return null;
            }
            if (CS.GAPI_POST.mFinishedServerStarted > 0) {
                long tItemAmount = UT.Code.getNonNulls(aInputs);
                if (tItemAmount < (long)this.mMinimalInputItems) {
                    return null;
                }
                long tFluidAmount = UT.Code.getNonNulls(aFluids);
                if (tFluidAmount < (long)this.mMinimalInputFluids) {
                    return null;
                }
                if (tFluidAmount + tItemAmount < (long)this.mMinimalInputs) {
                    return null;
                }
            }
            if (aNotUnificated) {
                aInputs = OreDictManager.INSTANCE.getStackArray(true, aInputs);
            }
            if (aRecipe != null && !aRecipe.mFakeRecipe && aRecipe.mCanBeBuffered && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return aRecipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, aRecipe.mEUt) ? (this.oRecipe = aRecipe) : null;
            }
            if (this.oRecipe != null && !this.oRecipe.mFakeRecipe && this.oRecipe.mCanBeBuffered && this.oRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return this.oRecipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, this.oRecipe.mEUt) ? this.oRecipe : null;
            }
            if (this.mInputItemsCount > 0) {
                for (ItemStack tStack1 : aInputs) {
                    Collection<Recipe> collection;
                    Collection<Recipe> collection2;
                    ItemStack tStack2;
                    Collection<Recipe> collection3;
                    if (tStack1 == null) continue;
                    Collection<Recipe> collection4 = this.mRecipeItemMap.get(new ItemStackContainer(tStack1));
                    if (collection4 != null) {
                        for (Recipe tRecipe : collection4) {
                            if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                            return tRecipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, tRecipe.mEUt) ? (this.oRecipe = tRecipe) : null;
                        }
                    }
                    if ((collection3 = this.mRecipeItemMap.get(new ItemStackContainer(UT.Stacks.copyMeta(32767L, tStack1)))) != null) {
                        for (Recipe tRecipe : collection3) {
                            if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                            return tRecipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, tRecipe.mEUt) ? (this.oRecipe = tRecipe) : null;
                        }
                    }
                    if (!UT.Stacks.equal(tStack1, tStack2 = OreDictManager.INSTANCE.getStack_(false, tStack1), true) && (collection2 = this.mRecipeItemMap.get(new ItemStackContainer(tStack2))) != null) {
                        for (Recipe tRecipe : collection2) {
                            if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                            return tRecipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, tRecipe.mEUt) ? (this.oRecipe = tRecipe) : null;
                        }
                    }
                    if (tStack1.func_77973_b() == tStack2.func_77973_b() || (collection = this.mRecipeItemMap.get(new ItemStackContainer(UT.Stacks.copyMeta(32767L, tStack2)))) == null) continue;
                    for (Recipe tRecipe : collection) {
                        if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                        return tRecipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, tRecipe.mEUt) ? (this.oRecipe = tRecipe) : null;
                    }
                }
            }
            if (this.mInputFluidCount > 0 && this.mMinimalInputItems == 0) {
                for (FluidStack aFluid : aFluids) {
                    Collection<Recipe> collection;
                    if (aFluid == null || (collection = this.mRecipeFluidMap.get(aFluid.getFluid().getName())) == null) continue;
                    for (Recipe tRecipe : collection) {
                        if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                        return tRecipe.mEnabled && UT.Code.abs_greater_equal(aSize * this.mPower, tRecipe.mEUt) ? (this.oRecipe = tRecipe) : null;
                    }
                }
            }
            if (aLoop && !this.mRecipeMapHandlers.isEmpty()) {
                Iterator<IRecipeMapHandler> tIterator = this.mRecipeMapHandlers.iterator();
                while (tIterator.hasNext()) {
                    IRecipeMapHandler tHandler = tIterator.next();
                    if (!tHandler.isDone()) continue;
                    tIterator.remove();
                }
                if (!this.mRecipeMapHandlers.isEmpty()) {
                    aLoop = false;
                    for (ItemStack itemStack : aInputs) {
                        if (!UT.Stacks.valid(itemStack)) continue;
                        OreDictItemData tData = OM.data_(itemStack);
                        for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                            if (!tHandler.addRecipesUsing(this, itemStack, tData)) continue;
                            aLoop = true;
                        }
                    }
                    for (ItemStack itemStack : aFluids) {
                        if (itemStack == null) continue;
                        for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                            if (!tHandler.addRecipesUsing(this, itemStack.getFluid())) continue;
                            aLoop = true;
                        }
                    }
                    if (aLoop) {
                        return this.findRecipeInternal(aTileEntity, aRecipe, false, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
                    }
                }
            }
            return null;
        }

        public List<Recipe> getNEIAllRecipes() {
            Iterator<IRecipeMapHandler> tIterator = this.mRecipeMapHandlers.iterator();
            long tTimeBefore = System.currentTimeMillis();
            while (tIterator.hasNext()) {
                IRecipeMapHandler tHandler = tIterator.next();
                tHandler.addAllRecipes(this);
                if (tHandler.isDone()) {
                    tIterator.remove();
                }
                if (System.currentTimeMillis() - tTimeBefore <= 60000L) continue;
                break;
            }
            ArrayListNoNulls<Recipe> rList = new ArrayListNoNulls<Recipe>();
            for (Recipe tRecipe : this.mRecipeList) {
                if (tRecipe.mHidden) continue;
                rList.add(tRecipe);
            }
            return rList;
        }

        public List<Recipe> getNEIRecipes(ItemStack ... aOutputs) {
            for (ItemStack aOutput : aOutputs) {
                if (!UT.Stacks.valid(aOutput)) continue;
                if (IL.Display_Fluid.equal(aOutput, true, true)) {
                    Fluid tFluid = UT.Fluids.fluid(UT.Stacks.meta(aOutput));
                    if (tFluid == null) continue;
                    for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                        tHandler.addRecipesProducing(this, tFluid);
                    }
                    continue;
                }
                OreDictItemData tData = OM.data_(aOutput);
                for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                    tHandler.addRecipesProducing(this, aOutput, tData);
                }
            }
            ArrayListNoNulls<Recipe> rList = new ArrayListNoNulls<Recipe>();
            for (Recipe tRecipe : this.mRecipeList) {
                if (tRecipe.mHidden) continue;
                block4: for (ItemStack aOutput : aOutputs) {
                    if (aOutput == null) continue;
                    if (IL.Display_Fluid.equal(aOutput, true, true)) {
                        for (FluidStack fluidStack : tRecipe.mFluidOutputs) {
                            if (UT.Fluids.id(fluidStack) != UT.Stacks.meta(aOutput)) continue;
                            rList.add(tRecipe);
                            continue block4;
                        }
                        continue;
                    }
                    for (FluidStack fluidStack : tRecipe.mOutputs) {
                        if (fluidStack == null || fluidStack.func_77973_b() != aOutput.func_77973_b() || UT.Stacks.meta((ItemStack)fluidStack) != Short.MAX_VALUE && UT.Stacks.meta((ItemStack)fluidStack) != UT.Stacks.meta(aOutput) && !fluidStack.func_77984_f()) continue;
                        rList.add(tRecipe);
                        continue block4;
                    }
                }
            }
            return rList;
        }

        public List<Recipe> getNEIUsages(ItemStack ... aInputs) {
            for (ItemStack aInput : aInputs) {
                if (!UT.Stacks.valid(aInput)) continue;
                if (IL.Display_Fluid.equal(aInput, true, true)) {
                    Fluid tFluid = UT.Fluids.fluid(UT.Stacks.meta(aInput));
                    if (tFluid == null) continue;
                    for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                        tHandler.addRecipesUsing(this, tFluid);
                    }
                    continue;
                }
                OreDictItemData tData = OM.data_(aInput);
                for (IRecipeMapHandler tHandler : this.mRecipeMapHandlers) {
                    tHandler.addRecipesUsing(this, aInput, tData);
                }
            }
            ArrayListNoNulls<Recipe> rList = new ArrayListNoNulls<Recipe>();
            for (Recipe tRecipe : this.mRecipeList) {
                if (tRecipe.mHidden) continue;
                block4: for (ItemStack aInput : aInputs) {
                    if (aInput == null) continue;
                    if (IL.Display_Fluid.equal(aInput, true, true)) {
                        for (FluidStack fluidStack : tRecipe.mFluidInputs) {
                            if (UT.Fluids.id(fluidStack) != UT.Stacks.meta(aInput)) continue;
                            rList.add(tRecipe);
                            continue block4;
                        }
                        continue;
                    }
                    for (FluidStack fluidStack : tRecipe.mInputs) {
                        if (fluidStack == null || fluidStack.func_77973_b() != aInput.func_77973_b() || UT.Stacks.meta((ItemStack)fluidStack) != Short.MAX_VALUE && UT.Stacks.meta((ItemStack)fluidStack) != UT.Stacks.meta(aInput) && !fluidStack.func_77984_f()) continue;
                        rList.add(tRecipe);
                        continue block4;
                    }
                }
            }
            return rList;
        }

        public Recipe addToItemMap(Recipe aRecipe) {
            for (ItemStack aStack : aRecipe.mInputs) {
                if (aStack == null) continue;
                ItemStackContainer tStack = new ItemStackContainer(aStack);
                Collection<Recipe> tList = this.mRecipeItemMap.get(tStack);
                if (tList == null) {
                    tList = new HashSet<Recipe>(1);
                    this.mRecipeItemMap.put(tStack, tList);
                }
                tList.add(aRecipe);
            }
            return aRecipe;
        }

        public boolean openNEI() {
            try {
                GuiCraftingRecipe.openRecipeGui((String)this.mNameNEI, (Object[])new Object[0]);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }
}

