/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes;

import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import gregapi.api.Abstract_Mod;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.IItemContainer;
import gregapi.config.ConfigCategories;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.item.IItemDamagable;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.recipes.AdvancedCraftingShaped;
import gregapi.recipes.AdvancedCraftingShapeless;
import gregapi.recipes.ICraftingRecipeGT;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.UT;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.reactor.IReactorComponent;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBookCloning;
import net.minecraft.item.crafting.RecipeFireworks;
import net.minecraft.item.crafting.RecipesArmorDyes;
import net.minecraft.item.crafting.RecipesMapCloning;
import net.minecraft.item.crafting.RecipesMapExtending;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class GT_ModHandler {
    private static Map<IRecipeInput, RecipeOutput> sExtractorRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static Map<IRecipeInput, RecipeOutput> sMaceratorRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static Map<IRecipeInput, RecipeOutput> sCompressorRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static Map<IRecipeInput, RecipeOutput> sOreWashingRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static Map<IRecipeInput, RecipeOutput> sThermalCentrifugeRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static Map<IRecipeInput, RecipeOutput> sMassfabRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static boolean sBufferCraftingRecipes = true;
    public static final List<IRecipe> sAllRecipeList = Collections.synchronizedList(new ArrayListNoNulls(5000));
    private static final List<IRecipe> sBufferRecipeList = new ArrayListNoNulls<IRecipe>(1000);
    public static Collection<String> sNativeRecipeClasses = new HashSet<String>();
    public static Collection<String> sSpecialRecipeClasses = new HashSet<String>();
    private static final ArrayListNoNulls<List<ItemStack>> OREDICT_DYE_LISTS;

    public static boolean addSawingRecipe(long aEUt, long aDuration, boolean aIsFoodItem, long aLubricantAmount, ItemStack aInput, ItemStack ... aOutputs) {
        if (UT.Stacks.invalid(aInput) || aOutputs.length <= 0 || UT.Stacks.invalid(aOutputs[0])) {
            return false;
        }
        if (aLubricantAmount <= 0L) {
            aLubricantAmount = 1L;
        }
        FluidStack[] tFluids = new FluidStack[]{UT.Fluids.water(4000L), UT.Fluids.distilledwater(4000L), MT.Lubricant.liquid(420076800L, true), UT.Fluids.make("rc lubricant", 1000L)};
        long[] tTime = new long[]{4L, 3L, 1L, 1L};
        for (int i = 0; i < tFluids.length; i = (int)((byte)(i + 1))) {
            if (tFluids[i] == null || aIsFoodItem && i > 2) continue;
            Recipe.RecipeMap.sCutterRecipes.addRecipe1(true, aEUt, aDuration * tTime[i], aInput, UT.Fluids.mul(tFluids[i], aLubricantAmount, 1000L, true), CS.NF, aOutputs);
        }
        return false;
    }

    public static boolean addFoodCanningRecipe(ItemStack aStack, int aFoodValue, String aCannedName, IItemContainer ... aCans) {
        if (UT.Stacks.invalid(aStack) || aStack.func_77973_b() == CS.ItemsGT.sMultiItemCans || IL.IC2_Food_Can_Filled.equal(aStack, true, true)) {
            return false;
        }
        if (aFoodValue > 0) {
            switch (aFoodValue / 2) {
                case 0: 
                case 1: {
                    return null != Recipe.RecipeMap.sCannerRecipes.addRecipe2(true, 16L, 16L, aStack, IL.Food_Can_Empty.get(1L, new Object[0]), aCans[0].getWithName(1L, aCannedName, new Object[0]), UT.Stacks.container(aStack, true));
                }
                case 2: {
                    return null != Recipe.RecipeMap.sCannerRecipes.addRecipe2(true, 16L, 16L, aStack, IL.Food_Can_Empty.get(1L, new Object[0]), aCans[1].getWithName(1L, aCannedName, new Object[0]), UT.Stacks.container(aStack, true));
                }
                case 3: {
                    return null != Recipe.RecipeMap.sCannerRecipes.addRecipe2(true, 16L, 16L, aStack, IL.Food_Can_Empty.get(1L, new Object[0]), aCans[2].getWithName(1L, aCannedName, new Object[0]), UT.Stacks.container(aStack, true));
                }
                case 4: {
                    return null != Recipe.RecipeMap.sCannerRecipes.addRecipe2(true, 16L, 16L, aStack, IL.Food_Can_Empty.get(1L, new Object[0]), aCans[3].getWithName(1L, aCannedName, new Object[0]), UT.Stacks.container(aStack, true));
                }
                case 5: {
                    return null != Recipe.RecipeMap.sCannerRecipes.addRecipe2(true, 16L, 16L, aStack, IL.Food_Can_Empty.get(1L, new Object[0]), aCans[4].getWithName(1L, aCannedName, new Object[0]), UT.Stacks.container(aStack, true));
                }
                case 8: 
                case 9: {
                    return null != Recipe.RecipeMap.sCannerRecipes.addRecipe2(true, 16L, 16L, aStack, IL.Food_Can_Empty.get(2L, new Object[0]), aCans[3].getWithName(2L, aCannedName, new Object[0]), UT.Stacks.container(aStack, true));
                }
                case 10: 
                case 11: {
                    return null != Recipe.RecipeMap.sCannerRecipes.addRecipe2(true, 16L, 16L, aStack, IL.Food_Can_Empty.get(2L, new Object[0]), aCans[4].getWithName(2L, aCannedName, new Object[0]), UT.Stacks.container(aStack, true));
                }
                case 15: 
                case 16: 
                case 17: {
                    return null != Recipe.RecipeMap.sCannerRecipes.addRecipe2(true, 16L, 16L, aStack, IL.Food_Can_Empty.get(3L, new Object[0]), aCans[4].getWithName(3L, aCannedName, new Object[0]), UT.Stacks.container(aStack, true));
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    return null != Recipe.RecipeMap.sCannerRecipes.addRecipe2(true, 16L, 16L, aStack, IL.Food_Can_Empty.get(4L, new Object[0]), aCans[4].getWithName(4L, aCannedName, new Object[0]), UT.Stacks.container(aStack, true));
                }
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    return null != Recipe.RecipeMap.sCannerRecipes.addRecipe2(true, 16L, 16L, aStack, IL.Food_Can_Empty.get(5L, new Object[0]), aCans[4].getWithName(5L, aCannedName, new Object[0]), UT.Stacks.container(aStack, true));
                }
            }
            return null != Recipe.RecipeMap.sCannerRecipes.addRecipe2(true, 16L, 16L, aStack, IL.Food_Can_Empty.get(aFoodValue / 12, new Object[0]), aCans[5].getWithName(aFoodValue / 12, aCannedName, new Object[0]), UT.Stacks.container(aStack, true));
        }
        return false;
    }

    public static boolean addSmeltingRecipe(ItemStack aInput, ItemStack aOutput) {
        if (UT.Stacks.invalid(aInput) || UT.Stacks.invalid(aOutput)) {
            return false;
        }
        aOutput = OM.get_(aOutput);
        if (UT.Stacks.container(aInput, false) != null || UT.Stacks.equal_(aInput, aOutput, false) || !CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.smelting, aInput, true)) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(aInput, UT.Stacks.copy(aOutput), 0.0f);
        return true;
    }

    public static boolean addLiquidTransposerRecipe(ItemStack aEmptyContainer, FluidStack aLiquid, ItemStack aFullContainer, int aMJ) {
        if (UT.Stacks.invalid(aEmptyContainer) || UT.Stacks.invalid(aFullContainer) || aLiquid == null) {
            return false;
        }
        if (!CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.liquidtransposer, aFullContainer = OM.get_(aFullContainer), true)) {
            return false;
        }
        try {
            ThermalExpansion.addTransposerFill(aMJ * 10, aEmptyContainer, aFullContainer, aLiquid, true);
        }
        catch (Throwable e) {
            // empty catch block
        }
        return true;
    }

    public static boolean addLiquidTransposerFillRecipe(ItemStack aEmptyContainer, FluidStack aLiquid, ItemStack aFullContainer, int aMJ) {
        if (UT.Stacks.invalid(aEmptyContainer) || UT.Stacks.invalid(aFullContainer) || aLiquid == null) {
            return false;
        }
        if (!CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.liquidtransposerfilling, aFullContainer = OM.get_(aFullContainer), true)) {
            return false;
        }
        try {
            ThermalExpansion.addTransposerFill(aMJ * 10, aEmptyContainer, aFullContainer, aLiquid, false);
        }
        catch (Throwable e) {
            // empty catch block
        }
        return true;
    }

    public static boolean addLiquidTransposerEmptyRecipe(ItemStack aFullContainer, FluidStack aLiquid, ItemStack aEmptyContainer, int aMJ) {
        if (UT.Stacks.invalid(aFullContainer) || UT.Stacks.invalid(aEmptyContainer) || aLiquid == null) {
            return false;
        }
        aEmptyContainer = OM.get_(aEmptyContainer);
        if (!CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.liquidtransposeremptying, aFullContainer, true)) {
            return false;
        }
        try {
            ThermalExpansion.addTransposerExtract(aMJ * 10, aFullContainer, aEmptyContainer, aLiquid, 100, false);
        }
        catch (Throwable e) {
            // empty catch block
        }
        return true;
    }

    public static boolean addExtractionRecipe(ItemStack aInput, ItemStack aOutput) {
        if (!CS.ENABLE_ADDING_IC2_EXTRACTOR_RECIPES || UT.Stacks.invalid(aInput) || UT.Stacks.invalid(aOutput)) {
            return false;
        }
        aOutput = OM.get_(aOutput);
        if (!CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.extractor, aInput, true)) {
            UT.removeSimpleIC2MachineRecipe(aInput, GT_ModHandler.getExtractorRecipeList(), null);
            return false;
        }
        UT.addSimpleIC2MachineRecipe(Recipes.extractor, aInput, null, aOutput);
        return true;
    }

    public static boolean addRCBlastFurnaceRecipe(ItemStack aInput, ItemStack aOutput, int aTime) {
        if (UT.Stacks.invalid(aInput) || UT.Stacks.invalid(aOutput) || aTime <= 0) {
            return false;
        }
        aOutput = OM.get_(aOutput);
        if (!CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.rcblastfurnace, aInput, true)) {
            return false;
        }
        aInput = UT.Stacks.copy(aInput);
        aOutput = UT.Stacks.copy(aOutput);
        try {
            RailcraftCraftingManager.blastFurnace.addRecipe(aInput, true, false, aTime, aOutput);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, null, 0, false);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, aOutput2, 100, false);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aChance) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, aOutput2, aChance, false);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, boolean aOverwrite) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, null, 0, aOverwrite);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, boolean aOverwrite) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, aOutput2, 100, aOverwrite);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aChance, boolean aOverwrite) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, aOutput2, aChance, null, 0, aOverwrite);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aChance2, ItemStack aOutput3, int aChance3, boolean aOverwrite) {
        if (UT.Stacks.invalid(aInput) || UT.Stacks.invalid(aOutput1)) {
            return false;
        }
        aOutput1 = OM.get_(aOutput1);
        aOutput2 = OM.get(aOutput2);
        if (UT.Stacks.container(aInput, false) == null) {
            if (CS.ENABLE_ADDING_IC2_MACERATOR_RECIPES) {
                if (CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.maceration, aInput, true)) {
                    UT.addSimpleIC2MachineRecipe(Recipes.macerator, aInput, null, aOutput1);
                } else {
                    UT.removeSimpleIC2MachineRecipe(aInput, GT_ModHandler.getMaceratorRecipeList(), null);
                }
            }
            if (!OP.log.contains(aInput)) {
                if (MT.Wood.contains(aOutput1)) {
                    if (CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.pulverization, aInput, true)) {
                        if (aOutput2 == null) {
                            ThermalExpansion.addSawmillRecipe(32000, UT.Stacks.copy(aInput), UT.Stacks.copy(aOutput1));
                        } else {
                            ThermalExpansion.addSawmillRecipe(32000, UT.Stacks.copy(aInput), UT.Stacks.copy(aOutput1), UT.Stacks.copy(aOutput2), aChance2 <= 0 ? 10 : aChance2);
                        }
                    }
                } else {
                    if (CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.rockcrushing, aInput, UT.Stacks.block(aInput) != CS.NB)) {
                        try {
                            if (UT.Stacks.block(aInput) != Blocks.field_150343_Z && UT.Stacks.block(aInput) != Blocks.field_150351_n) {
                                IRockCrusherRecipe tRecipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(UT.Stacks.amount(1L, aInput), UT.Stacks.meta(aInput) != Short.MAX_VALUE, false);
                                tRecipe.addOutput(UT.Stacks.copy(aOutput1), 1.0f / (float)aInput.field_77994_a);
                                if (aOutput2 != null) {
                                    tRecipe.addOutput(UT.Stacks.copy(aOutput2), 0.01f * (float)(aChance2 <= 0 ? 10 : aChance2) / (float)aInput.field_77994_a);
                                }
                                if (aOutput3 != null) {
                                    tRecipe.addOutput(UT.Stacks.copy(aOutput3), 0.01f * (float)(aChance3 <= 0 ? 10 : aChance3) / (float)aInput.field_77994_a);
                                }
                            }
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    if (CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.pulverization, aInput, true)) {
                        if (aOutput2 == null) {
                            ThermalExpansion.addPulverizerRecipe(32000, UT.Stacks.copy(aInput), UT.Stacks.copy(aOutput1));
                        } else {
                            ThermalExpansion.addPulverizerRecipe(32000, UT.Stacks.copy(aInput), UT.Stacks.copy(aOutput1), UT.Stacks.copy(aOutput2), aChance2 <= 0 ? 10 : aChance2);
                        }
                    }
                }
            }
        }
        return true;
    }

    public static boolean addSawmillRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2) {
        if (UT.Stacks.invalid(aInput) || UT.Stacks.invalid(aOutput1)) {
            return false;
        }
        aOutput1 = OM.get_(aOutput1);
        aOutput2 = OM.get(aOutput2);
        if (!CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.sawmill, aInput, true)) {
            return false;
        }
        try {
            ThermalExpansion.addSawmillRecipe(1600, aInput, aOutput1, aOutput2, 100);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addAlloySmelterRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput1, int aDuration, int aEUt, boolean aAllowSecondaryInputEmpty) {
        if (aInput1 == null || aInput2 == null && !aAllowSecondaryInputEmpty || UT.Stacks.invalid(aOutput1)) {
            return false;
        }
        aOutput1 = OM.get_(aOutput1);
        boolean temp = false;
        if (GT_ModHandler.addInductionSmelterRecipe(aInput1, aInput2, aOutput1, null, aDuration * aEUt * 2, 0)) {
            temp = true;
        }
        return temp;
    }

    public static boolean addInductionSmelterRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput1, ItemStack aOutput2, int aEnergy, int aChance) {
        if (UT.Stacks.invalid(aInput1 == null) || UT.Stacks.invalid(aOutput1)) {
            return false;
        }
        aOutput1 = OM.get_(aOutput1);
        aOutput2 = OM.get(aOutput2);
        if (UT.Stacks.container(aInput1, false) != null || !CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.inductionsmelter, aInput2 == null ? aInput1 : aOutput1, true)) {
            return false;
        }
        try {
            ThermalExpansion.addSmelterRecipe(aEnergy * 10, UT.Stacks.copy(aInput1), aInput2 == null ? UT.Stacks.make((Block)Blocks.field_150354_m, 1L, 0L) : aInput2, aOutput1, aOutput2, aChance);
        }
        catch (Throwable e) {
            // empty catch block
        }
        return true;
    }

    public static Map<IRecipeInput, RecipeOutput> getExtractorRecipeList() {
        try {
            return Recipes.extractor.getRecipes();
        }
        catch (Throwable throwable) {
            return sExtractorRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getCompressorRecipeList() {
        try {
            return Recipes.compressor.getRecipes();
        }
        catch (Throwable throwable) {
            return sCompressorRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getMaceratorRecipeList() {
        try {
            return Recipes.macerator.getRecipes();
        }
        catch (Throwable throwable) {
            return sMaceratorRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getThermalCentrifugeRecipeList() {
        try {
            return Recipes.centrifuge.getRecipes();
        }
        catch (Throwable throwable) {
            return sThermalCentrifugeRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getOreWashingRecipeList() {
        try {
            return Recipes.oreWashing.getRecipes();
        }
        catch (Throwable throwable) {
            return sOreWashingRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getMassFabricatorList() {
        try {
            return Recipes.matterAmplifier.getRecipes();
        }
        catch (Throwable throwable) {
            return sMassfabRecipes;
        }
    }

    public static boolean addThermalCentrifugeRecipe(ItemStack aInput, long aHeat, Object ... aOutput) {
        if (UT.Stacks.invalid(aInput) || aOutput == null || aOutput.length <= 0 || aOutput[0] == null) {
            return false;
        }
        if (!CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.thermalcentrifuge, aInput, true)) {
            UT.removeSimpleIC2MachineRecipe(aInput, GT_ModHandler.getThermalCentrifugeRecipeList(), null);
            return false;
        }
        UT.addSimpleIC2MachineRecipe(Recipes.centrifuge, aInput, UT.NBT.getNBTLong(null, "minHeat", aHeat), aOutput);
        return true;
    }

    public static boolean addOreWasherRecipe(ItemStack aInput, long aWaterAmount, Object ... aOutput) {
        if (!CS.ENABLE_ADDING_IC2_OREWASHER_RECIPES || UT.Stacks.invalid(aInput) || aOutput == null || aOutput.length <= 0 || aOutput[0] == null) {
            return false;
        }
        if (!CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.orewashing, aInput, true)) {
            UT.removeSimpleIC2MachineRecipe(aInput, GT_ModHandler.getOreWashingRecipeList(), null);
            return false;
        }
        UT.addSimpleIC2MachineRecipe(Recipes.oreWashing, aInput, UT.NBT.getNBTLong(null, "amount", aWaterAmount), aOutput);
        return true;
    }

    public static boolean addCompressionRecipe(ItemStack aInput, ItemStack aOutput) {
        if (!CS.ENABLE_ADDING_IC2_COMPRESSOR_RECIPES || UT.Stacks.invalid(aInput) || UT.Stacks.invalid(aOutput)) {
            return false;
        }
        aOutput = OM.get_(aOutput);
        if (!CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.compression, aInput, true)) {
            UT.removeSimpleIC2MachineRecipe(aInput, GT_ModHandler.getCompressorRecipeList(), null);
            return false;
        }
        UT.addSimpleIC2MachineRecipe(Recipes.compressor, aInput, null, aOutput);
        return true;
    }

    public static boolean addIC2MatterAmplifier(ItemStack aAmplifier, int aValue) {
        if (aAmplifier == null || aValue <= 0) {
            return false;
        }
        if (!CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.massfabamplifier, aAmplifier, true)) {
            return false;
        }
        try {
            NBTTagCompound tNBT = new NBTTagCompound();
            tNBT.func_74768_a("amplification", aValue);
            UT.Reflection.callMethod(Recipes.matterAmplifier, "addRecipe", false, false, false, aAmplifier, tNBT);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addRollingMachineRecipe(ItemStack aResult, Object[] aRecipe) {
        if (UT.Stacks.invalid(aResult) || aRecipe == null || aResult.field_77994_a <= 0) {
            return false;
        }
        aResult = OM.get_(aResult);
        try {
            RailcraftCraftingManager.rollingMachine.getRecipeList().add(new ShapedOreRecipe(UT.Stacks.copy(aResult), aRecipe));
        }
        catch (Throwable e) {
            return GT_ModHandler.addCraftingRecipe(UT.Stacks.copy(aResult), aRecipe);
        }
        return true;
    }

    public static void stopBufferingCraftingRecipes() {
        sBufferCraftingRecipes = false;
        for (IRecipe tRecipe : sBufferRecipeList) {
            GameRegistry.addRecipe((IRecipe)tRecipe);
        }
        sBufferRecipeList.clear();
    }

    public static boolean addCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object[] aRecipe) {
        return GT_ModHandler.addCraftingRecipe(aResult, aEnchantmentsAdded, aEnchantmentLevelsAdded, false, true, false, false, false, false, false, false, false, false, false, false, true, false, false, aRecipe);
    }

    public static boolean addCraftingRecipe(ItemStack aResult, Object[] aRecipe) {
        return GT_ModHandler.addCraftingRecipe(aResult, 0L, aRecipe);
    }

    public static boolean addCraftingRecipe(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        return GT_ModHandler.addCraftingRecipe(aResult, new Enchantment[]{}, new int[]{}, (aBitMask & RecipeBits.MIRRORED) != 0L, (aBitMask & RecipeBits.BUFFERED) != 0L, (aBitMask & RecipeBits.KEEPNBT) != 0L, (aBitMask & RecipeBits.DISMANTLEABLE) != 0L, (aBitMask & RecipeBits.NOT_REMOVABLE) == 0L, (aBitMask & RecipeBits.REVERSIBLE) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_RECIPES) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_RECIPES_IF_SAME_NBT) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_SHAPED_RECIPES) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_NATIVE_RECIPES) != 0L, (aBitMask & RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS) == 0L, (aBitMask & RecipeBits.ONLY_ADD_IF_THERE_IS_ANOTHER_RECIPE_FOR_IT) != 0L, (aBitMask & RecipeBits.ONLY_ADD_IF_RESULT_IS_NOT_NULL) != 0L, (aBitMask & RecipeBits.DELETE_ONLY_IF_NO_DYE_IS_INVOLVED) != 0L, (aBitMask & RecipeBits.NOT_AUTOCRAFTABLE) != 0L, aRecipe);
    }

    private static boolean addCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, boolean aMirrored, boolean aBuffered, boolean aKeepNBT, boolean aDismantleable, boolean aRemovable, boolean aReversible, boolean aRemoveAllOthersWithSameOutput, boolean aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, boolean aRemoveAllOtherShapedsWithSameOutput, boolean aRemoveAllOtherNativeRecipes, boolean aCheckForCollisions, boolean aOnlyAddIfThereIsAnyRecipeOutputtingThis, boolean aOnlyAddIfResultIsNotNull, boolean aDeleteOnlyIfNoDyeInvolved, boolean aNotAutoCraftable, Object[] aRecipe) {
        if (aOnlyAddIfResultIsNotNull && UT.Stacks.invalid(aResult)) {
            return false;
        }
        if ((aResult = OM.get(aResult)) != null && UT.Stacks.meta(aResult) == Short.MAX_VALUE) {
            UT.Stacks.meta(aResult, 0L);
        }
        if (aRecipe == null || aRecipe.length <= 0) {
            return false;
        }
        boolean tThereWasARecipe = false;
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] instanceof IItemContainer) {
                aRecipe[i] = ((IItemContainer)aRecipe[i]).get(1L, new Object[0]);
                continue;
            }
            if (aRecipe[i] instanceof Enum) {
                aRecipe[i] = ((Enum)aRecipe[i]).name();
                continue;
            }
            if (aRecipe[i] == null || aRecipe[i] instanceof ItemStack || aRecipe[i] instanceof OreDictItemData || aRecipe[i] instanceof String || aRecipe[i] instanceof Character) continue;
            aRecipe[i] = aRecipe[i].toString();
        }
        try {
            String shape = "";
            int idx = 0;
            if (aRecipe[idx] instanceof Boolean) {
                throw new IllegalArgumentException();
            }
            ArrayList<Object> tRecipeList = new ArrayList<Object>(Arrays.asList(aRecipe));
            while (aRecipe[idx] instanceof String) {
                String s = (String)aRecipe[idx++];
                shape = shape + s;
                while (s.length() < 3) {
                    s = s + " ";
                }
                if (s.length() > 3) {
                    throw new IllegalArgumentException();
                }
                block27: for (char c : s.toCharArray()) {
                    switch (c) {
                        case 'b': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolBlade");
                            continue block27;
                        }
                        case 'c': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolCrowbar");
                            continue block27;
                        }
                        case 'd': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolScrewdriver");
                            continue block27;
                        }
                        case 'e': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolDrill");
                            continue block27;
                        }
                        case 'f': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolFile");
                            continue block27;
                        }
                        case 'h': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolHardHammer");
                            continue block27;
                        }
                        case 'i': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolSolderingIron");
                            continue block27;
                        }
                        case 'j': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolSolderingMetal");
                            continue block27;
                        }
                        case 'k': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolKnife");
                            continue block27;
                        }
                        case 'l': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolMagnifyingGlass");
                            continue block27;
                        }
                        case 'm': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolMortar");
                            continue block27;
                        }
                        case 'n': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolMonkeyWrench");
                            continue block27;
                        }
                        case 'o': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolBendingCylinderSmall");
                            continue block27;
                        }
                        case 'p': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolDrawplate");
                            continue block27;
                        }
                        case 'r': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolSoftHammer");
                            continue block27;
                        }
                        case 's': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolSaw");
                            continue block27;
                        }
                        case 'w': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolWrench");
                            continue block27;
                        }
                        case 'x': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolWireCutter");
                            continue block27;
                        }
                        case 'y': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolChisel");
                            continue block27;
                        }
                        case 'z': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add("craftingToolBendingCylinder");
                        }
                    }
                }
            }
            aRecipe = tRecipeList.toArray();
            if (aRecipe[idx] instanceof Boolean) {
                ++idx;
            }
            HashMap<Character, ItemStack> tItemStackMap = new HashMap<Character, ItemStack>();
            HashMap<Character, OreDictItemData> tItemDataMap = new HashMap<Character, OreDictItemData>();
            tItemStackMap.put(Character.valueOf(' '), null);
            boolean tRemoveRecipe = true;
            while (idx < aRecipe.length) {
                if (aRecipe[idx] == null || aRecipe[idx + 1] == null) {
                    if (CS.D1) {
                        CS.ERR.println("WARNING: Missing Item for shaped Recipe: " + (aResult == null ? "null" : aResult.func_82833_r()));
                        for (Object tContent : aRecipe) {
                            CS.ERR.println(tContent);
                        }
                    }
                    return false;
                }
                Character chr = (Character)aRecipe[idx];
                Object in = aRecipe[idx + 1];
                if (in instanceof ItemStack) {
                    tItemStackMap.put(chr, UT.Stacks.copy((ItemStack)in));
                    tItemDataMap.put(chr, OM.data_((ItemStack)in));
                } else {
                    String tInString = in.toString();
                    OreDictItemData tData = null;
                    if (in instanceof OreDictItemData) {
                        tData = (OreDictItemData)in;
                        String string = tInString;
                        aRecipe[idx + 1] = string;
                        in = string;
                    }
                    if (UT.Code.stringValid(tInString)) {
                        OreDictItemData tData2 = OreDictManager.INSTANCE.getAutomaticItemData(tInString);
                        if (tData2 != null) {
                            tItemDataMap.put(chr, tData2);
                        } else if (tData != null) {
                            tItemDataMap.put(chr, tData);
                        }
                        ItemStack tStack = OreDictManager.INSTANCE.getFirstOre(tInString, 1L);
                        if (tStack == null) {
                            tRemoveRecipe = false;
                        } else {
                            tItemStackMap.put(chr, tStack);
                        }
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
                idx += 2;
            }
            if (aReversible && aResult != null) {
                OreDictItemData[] tData = new OreDictItemData[9];
                int x = -1;
                for (char chr : shape.toCharArray()) {
                    tData[++x] = (OreDictItemData)tItemDataMap.get(Character.valueOf(chr));
                }
                if (UT.Code.containsSomething(tData)) {
                    OM.data(aResult, new OreDictItemData(tData));
                }
            }
            if (aCheckForCollisions && tRemoveRecipe) {
                ItemStack[] tRecipe = new ItemStack[9];
                int x = -1;
                for (char chr : shape.toCharArray()) {
                    tRecipe[++x] = (ItemStack)tItemStackMap.get(Character.valueOf(chr));
                    if (tRecipe[x] == null || UT.Stacks.meta(tRecipe[x]) != Short.MAX_VALUE) continue;
                    UT.Stacks.meta(tRecipe[x], 0L);
                }
                tThereWasARecipe = GT_ModHandler.removeRecipe(tRecipe) != null || tThereWasARecipe;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        if (aResult == null || aResult.field_77994_a <= 0) {
            return false;
        }
        if (aRemoveAllOthersWithSameOutput || aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT || aRemoveAllOtherShapedsWithSameOutput || aRemoveAllOtherNativeRecipes) {
            boolean bl = tThereWasARecipe = GT_ModHandler.removeRecipeByOutput(aResult, !aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, aRemoveAllOtherShapedsWithSameOutput, aRemoveAllOtherNativeRecipes, aDeleteOnlyIfNoDyeInvolved) || tThereWasARecipe;
        }
        if (aOnlyAddIfThereIsAnyRecipeOutputtingThis && !tThereWasARecipe) {
            ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
            for (int i = 0; i < tList.size(); ++i) {
                IRecipe tRecipe = (IRecipe)tList.get(i);
                if (sSpecialRecipeClasses.contains(tRecipe.getClass().getName()) || !UT.Stacks.equal(OM.get(tRecipe.func_77571_b()), aResult, true)) continue;
                tThereWasARecipe = true;
                break;
            }
        }
        if (UT.Stacks.meta(aResult) == Short.MAX_VALUE || UT.Stacks.meta(aResult) < 0) {
            UT.Stacks.meta(aResult, 0L);
        }
        UT.Stacks.update(aResult);
        if (tThereWasARecipe || !aOnlyAddIfThereIsAnyRecipeOutputtingThis) {
            if (sBufferCraftingRecipes && aBuffered) {
                sBufferRecipeList.add((IRecipe)new AdvancedCraftingShaped(UT.Stacks.copy(aResult), aDismantleable, aRemovable, aKeepNBT, !aNotAutoCraftable, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe).setMirrored(aMirrored));
            } else {
                GameRegistry.addRecipe((IRecipe)new AdvancedCraftingShaped(UT.Stacks.copy(aResult), aDismantleable, aRemovable, aKeepNBT, !aNotAutoCraftable, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe).setMirrored(aMirrored));
            }
        }
        return true;
    }

    public static boolean addShapelessEnchantingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object[] aRecipe) {
        return GT_ModHandler.addShapelessCraftingRecipe(aResult, aEnchantmentsAdded, aEnchantmentLevelsAdded, true, false, false, false, false, aRecipe);
    }

    public static boolean addShapelessCraftingRecipe(ItemStack aResult, Object[] aRecipe) {
        return GT_ModHandler.addShapelessCraftingRecipe(aResult, RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | RecipeBits.BUFFERED, aRecipe);
    }

    public static boolean addShapelessCraftingRecipe(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        return GT_ModHandler.addShapelessCraftingRecipe(aResult, new Enchantment[]{}, new int[]{}, (aBitMask & RecipeBits.BUFFERED) != 0L, (aBitMask & RecipeBits.KEEPNBT) != 0L, (aBitMask & RecipeBits.DISMANTLEABLE) != 0L, (aBitMask & RecipeBits.NOT_REMOVABLE) == 0L, (aBitMask & RecipeBits.NOT_AUTOCRAFTABLE) != 0L, aRecipe);
    }

    private static boolean addShapelessCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, boolean aBuffered, boolean aKeepNBT, boolean aDismantleable, boolean aRemovable, boolean aNotAutoCraftable, Object[] aRecipe) {
        if (aRecipe == null || aRecipe.length <= 0) {
            return false;
        }
        if (aRecipe.length > 9) {
            throw new IllegalArgumentException("Shapeless Recipe has more than 9 Inputs! This would crash NEI!");
        }
        aResult = OM.get(aResult);
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] instanceof IItemContainer) {
                aRecipe[i] = ((IItemContainer)aRecipe[i]).get(1L, new Object[0]);
                continue;
            }
            if (aRecipe[i] instanceof Enum) {
                aRecipe[i] = ((Enum)aRecipe[i]).name();
                continue;
            }
            if (aRecipe[i] == null || aRecipe[i] instanceof ItemStack || aRecipe[i] instanceof String || aRecipe[i] instanceof Character) continue;
            aRecipe[i] = aRecipe[i].toString();
        }
        try {
            ItemStack[] tRecipe = new ItemStack[9];
            int i = 0;
            for (Object tObject : aRecipe) {
                if (tObject == null) {
                    if (CS.D1) {
                        CS.ERR.println("WARNING: Missing Item for shapeless Recipe: " + (aResult == null ? "null" : aResult.func_82833_r()));
                    }
                    for (Object tContent : aRecipe) {
                        CS.ERR.println(tContent);
                    }
                    return false;
                }
                if (tObject instanceof ItemStack) {
                    tRecipe[i] = (ItemStack)tObject;
                } else if (tObject instanceof String) {
                    tRecipe[i] = OreDictManager.INSTANCE.getFirstOre(tObject, 1L);
                    if (tRecipe[i] == null) {
                        break;
                    }
                } else if (!(tObject instanceof Boolean)) {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            GT_ModHandler.removeRecipe(tRecipe);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        if (aResult == null || aResult.field_77994_a <= 0) {
            return false;
        }
        if (UT.Stacks.meta(aResult) == Short.MAX_VALUE || UT.Stacks.meta(aResult) < 0) {
            UT.Stacks.meta(aResult, 0L);
        }
        UT.Stacks.update(aResult);
        if (sBufferCraftingRecipes && aBuffered) {
            sBufferRecipeList.add(new AdvancedCraftingShapeless(UT.Stacks.copy(aResult), aDismantleable, aRemovable, aKeepNBT, !aNotAutoCraftable, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe));
        } else {
            GameRegistry.addRecipe((IRecipe)new AdvancedCraftingShapeless(UT.Stacks.copy(aResult), aDismantleable, aRemovable, aKeepNBT, !aNotAutoCraftable, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe));
        }
        return true;
    }

    public static boolean removeFurnaceSmelting(ItemStack aInput) {
        if (aInput != null) {
            for (Object tInput : FurnaceRecipes.func_77602_a().func_77599_b().keySet()) {
                if (!UT.Stacks.valid(tInput) || !UT.Stacks.equal(aInput, (ItemStack)tInput, true)) continue;
                FurnaceRecipes.func_77602_a().func_77599_b().remove(tInput);
                return true;
            }
        }
        return false;
    }

    public static ItemStack removeRecipe(ItemStack ... aRecipe) {
        if (aRecipe == null) {
            return null;
        }
        boolean temp = false;
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] == null) continue;
            temp = true;
            break;
        }
        if (!temp) {
            return null;
        }
        ItemStack rReturn = null;
        ItemStack tReturn = null;
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < aRecipe.length && i < 9; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        for (int i = 0; i < tList.size(); ++i) {
            try {
                while (i < tList.size()) {
                    if ((!(tList.get(i) instanceof ICraftingRecipeGT) || ((ICraftingRecipeGT)tList.get(i)).isRemovableByGT()) && ((IRecipe)tList.get(i)).func_77569_a(aCrafting, (World)CS.DW) && (tReturn = ((IRecipe)tList.get(i)).func_77572_b(aCrafting)) != null) {
                        rReturn = tReturn;
                        tList.remove(i--);
                    }
                    ++i;
                }
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        return rReturn;
    }

    public static boolean removeRecipeByOutput(ItemStack aOutput) {
        return GT_ModHandler.removeRecipeByOutput(aOutput, true, false, false, false);
    }

    public static boolean removeRecipeByOutput(ItemStack aOutput, boolean aIgnoreNBT, boolean aNotRemoveShapelessRecipes, boolean aOnlyRemoveNativeHandlers, boolean aDontRemoveDyeingRecipes) {
        if (UT.Stacks.invalid(aOutput)) {
            return false;
        }
        boolean rReturn = false;
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        aOutput = OM.get_(aOutput);
        for (int i = 0; i < tList.size(); ++i) {
            IRecipe tRecipe = (IRecipe)tList.get(i);
            if (aNotRemoveShapelessRecipes && (tRecipe instanceof ShapelessRecipes || tRecipe instanceof ShapelessOreRecipe) || (!aOnlyRemoveNativeHandlers ? sSpecialRecipeClasses.contains(tRecipe.getClass().getName()) : !sNativeRecipeClasses.contains(tRecipe.getClass().getName()))) continue;
            if (tRecipe instanceof ICraftingRecipeGT && !((ICraftingRecipeGT)tRecipe).isRemovableByGT() || !UT.Stacks.equal(OM.get(tRecipe.func_77571_b()), aOutput, aIgnoreNBT)) continue;
            if (aDontRemoveDyeingRecipes) {
                boolean temp;
                if (tRecipe instanceof ShapedOreRecipe) {
                    temp = false;
                    for (Object tObject : ((ShapedOreRecipe)tRecipe).getInput()) {
                        if (!OREDICT_DYE_LISTS.contains(tObject)) continue;
                        temp = true;
                        break;
                    }
                    if (temp) continue;
                }
                if (tRecipe instanceof ShapelessOreRecipe) {
                    temp = false;
                    for (Object tObject : ((ShapelessOreRecipe)tRecipe).getInput()) {
                        if (!OREDICT_DYE_LISTS.contains(tObject)) continue;
                        temp = true;
                        break;
                    }
                    if (temp) continue;
                }
            }
            tList.remove(i--);
            rReturn = true;
        }
        return rReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemStack getAllRecipeOutput(World aWorld, ItemStack ... aRecipe) {
        if (aRecipe == null || aRecipe.length == 0) {
            return null;
        }
        if (aWorld == null) {
            aWorld = CS.DW;
        }
        boolean temp = false;
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] == null) continue;
            temp = true;
            break;
        }
        if (!temp) {
            return null;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9 && i < aRecipe.length; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        List tList = CraftingManager.func_77594_a().func_77592_b();
        List<IRecipe> list = sAllRecipeList;
        synchronized (list) {
            if (sAllRecipeList.size() != tList.size()) {
                sAllRecipeList.clear();
                sAllRecipeList.addAll(tList);
            }
            int j = sAllRecipeList.size();
            for (int i = 0; i < j; ++i) {
                IRecipe tRecipe = sAllRecipeList.get(i);
                if (!tRecipe.func_77569_a(aCrafting, aWorld)) continue;
                if (i > 10) {
                    sAllRecipeList.remove(i);
                    sAllRecipeList.add(i - 10, tRecipe);
                }
                return tRecipe.func_77572_b(aCrafting);
            }
        }
        int tIndex = 0;
        ItemStack tStack1 = null;
        ItemStack tStack2 = null;
        int j = aCrafting.func_70302_i_();
        for (int i = 0; i < j; ++i) {
            ItemStack tStack = aCrafting.func_70301_a(i);
            if (tStack == null) continue;
            if (tIndex == 0) {
                tStack1 = tStack;
            }
            if (tIndex == 1) {
                tStack2 = tStack;
            }
            ++tIndex;
        }
        if (tIndex == 2) {
            assert (tStack1 != null && tStack2 != null);
            if (tStack1.func_77973_b() == tStack2.func_77973_b() && tStack1.func_77973_b().isRepairable()) {
                int tNewDamage = UT.Stacks.meta(tStack1) + UT.Stacks.meta(tStack2) + tStack1.func_77958_k() / -20 - tStack1.func_77958_k();
                return UT.Stacks.make(tStack1.func_77973_b(), 1L, tNewDamage < 0 ? 0L : (long)tNewDamage);
            }
        }
        return null;
    }

    public static ItemStack getRecipeOutput(ItemStack ... aRecipe) {
        return GT_ModHandler.getRecipeOutput(false, aRecipe);
    }

    public static ItemStack getRecipeOutput(boolean aUncopiedStack, ItemStack ... aRecipe) {
        if (aRecipe == null) {
            return null;
        }
        boolean temp = false;
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] == null) continue;
            temp = true;
            break;
        }
        if (!temp) {
            return null;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9 && i < aRecipe.length; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        for (int i = 0; i < tList.size(); ++i) {
            ItemStack tOutput;
            temp = false;
            try {
                temp = ((IRecipe)tList.get(i)).func_77569_a(aCrafting, (World)CS.DW);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            if (!temp) continue;
            ItemStack itemStack = tOutput = aUncopiedStack ? ((IRecipe)tList.get(i)).func_77571_b() : ((IRecipe)tList.get(i)).func_77572_b(aCrafting);
            if (tOutput == null || tOutput.field_77994_a <= 0) {
                if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI) continue;
                throw new IllegalArgumentException("Seems another Mod added a Crafting Recipe with null Output. Tell the Developer of said Mod to fix that. Recipe Contents: " + UT.Stacks.names(aRecipe));
            }
            if (aUncopiedStack) {
                return tOutput;
            }
            return UT.Stacks.copy(tOutput);
        }
        return null;
    }

    public static ArrayList<ItemStack> getRecipeOutputs(ItemStack ... aRecipe) {
        return GT_ModHandler.getRecipeOutputs(CraftingManager.func_77594_a().func_77592_b(), false, aRecipe);
    }

    public static ArrayList<ItemStack> getRecipeOutputs(List<IRecipe> aList, boolean aDeleteFromList, ItemStack ... aRecipe) {
        int i;
        ArrayListNoNulls<ItemStack> rList = new ArrayListNoNulls<ItemStack>();
        if (aList == null || aRecipe == null) {
            return rList;
        }
        boolean temp = false;
        for (int i2 = 0; i2 < aRecipe.length; i2 = (int)((byte)(i2 + 1))) {
            if (aRecipe[i2] == null) continue;
            temp = true;
            break;
        }
        if (!temp) {
            return rList;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (i = 0; i < 9 && i < aRecipe.length; ++i) {
            aCrafting.func_70299_a(i, aRecipe[i]);
        }
        for (i = 0; i < aList.size(); ++i) {
            temp = false;
            try {
                temp = aList.get(i).func_77569_a(aCrafting, (World)CS.DW);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            if (!temp) continue;
            ItemStack tOutput = aList.get(i).func_77572_b(aCrafting);
            if (tOutput == null || tOutput.field_77994_a <= 0) {
                if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI) continue;
                throw new IllegalArgumentException("Seems another Mod added a Crafting Recipe with null Output. Tell the Developer of said Mod to fix that. Recipe Contents: " + UT.Stacks.names(aRecipe));
            }
            ((ArrayList)rList).add(UT.Stacks.copy(tOutput));
            if (!aDeleteFromList) continue;
            aList.remove(i--);
        }
        return rList;
    }

    public static ItemStack getMaceratorOutput(ItemStack aInput, boolean aRemoveInput, ItemStack aOutputSlot) {
        return UT.Stacks.copy(GT_ModHandler.getMachineOutput(aInput, GT_ModHandler.getMaceratorRecipeList(), aRemoveInput, new NBTTagCompound(), aOutputSlot)[0]);
    }

    public static ItemStack getExtractorOutput(ItemStack aInput, boolean aRemoveInput, ItemStack aOutputSlot) {
        return UT.Stacks.copy(GT_ModHandler.getMachineOutput(aInput, GT_ModHandler.getExtractorRecipeList(), aRemoveInput, new NBTTagCompound(), aOutputSlot)[0]);
    }

    public static ItemStack getCompressorOutput(ItemStack aInput, boolean aRemoveInput, ItemStack aOutputSlot) {
        return UT.Stacks.copy(GT_ModHandler.getMachineOutput(aInput, GT_ModHandler.getCompressorRecipeList(), aRemoveInput, new NBTTagCompound(), aOutputSlot)[0]);
    }

    public static ItemStack getSmeltingOutput(ItemStack aInput, boolean aRemoveInput, ItemStack aOutputSlot) {
        if (aInput == null || aInput.field_77994_a < 1) {
            return null;
        }
        ItemStack rStack = OM.get(FurnaceRecipes.func_77602_a().func_151395_a(aInput));
        if (rStack != null && (aOutputSlot == null || UT.Stacks.equal(rStack, aOutputSlot) && rStack.field_77994_a + aOutputSlot.field_77994_a <= aOutputSlot.func_77976_d())) {
            if (aRemoveInput) {
                --aInput.field_77994_a;
            }
            return rStack;
        }
        return null;
    }

    public static ItemStack[] getMachineOutput(ItemStack aInput, Map<IRecipeInput, RecipeOutput> aRecipeList, boolean aRemoveInput, NBTTagCompound rRecipeMetaData, ItemStack ... aOutputSlots) {
        block8: {
            if (aOutputSlots == null || aOutputSlots.length <= 0) {
                return new ItemStack[0];
            }
            if (aInput == null) {
                return new ItemStack[aOutputSlots.length];
            }
            try {
                for (Map.Entry<IRecipeInput, RecipeOutput> tEntry : aRecipeList.entrySet()) {
                    ItemStack[] tList;
                    if (!tEntry.getKey().matches(aInput)) continue;
                    if (tEntry.getKey().getAmount() > aInput.field_77994_a || (tList = (ItemStack[])tEntry.getValue().items.toArray()).length == 0) break;
                    ItemStack[] rList = new ItemStack[aOutputSlots.length];
                    rRecipeMetaData.func_74782_a("return", (NBTBase)tEntry.getValue().metadata);
                    for (int i = 0; i < aOutputSlots.length && i < tList.length; i = (int)((byte)(i + 1))) {
                        if (tList[i] == null) continue;
                        if (aOutputSlots[i] == null || UT.Stacks.equal(tList[i], aOutputSlots[i]) && tList[i].field_77994_a + aOutputSlots[i].field_77994_a <= aOutputSlots[i].func_77976_d()) {
                            rList[i] = UT.Stacks.copy(tList[i]);
                            continue;
                        }
                        return new ItemStack[aOutputSlots.length];
                    }
                    if (aRemoveInput) {
                        aInput.field_77994_a -= tEntry.getKey().getAmount();
                    }
                    return rList;
                }
            }
            catch (Throwable e) {
                if (!CS.D1) break block8;
                e.printStackTrace(CS.ERR);
            }
        }
        return new ItemStack[aOutputSlots.length];
    }

    public static int chargeElectricItem(ItemStack aStack, int aCharge, int aTier, boolean aIgnoreLimit, boolean aSimulate) {
        try {
            int tTier;
            if (GT_ModHandler.isElectricItem(aStack) && ((tTier = ((IElectricItem)aStack.func_77973_b()).getTier(aStack)) < 0 || tTier == aTier || aTier == Integer.MAX_VALUE)) {
                if (!aIgnoreLimit && tTier >= 0) {
                    aCharge = (int)Math.min((long)aCharge, CS.V[Math.max(0, Math.min(CS.V.length - 1, tTier))]);
                }
                if (aCharge > 0) {
                    int rCharge;
                    return rCharge + ((rCharge = (int)Math.max(0.0, ElectricItem.manager.charge(aStack, (double)aCharge, tTier, true, aSimulate))) * 4 > aTier ? aTier : 0);
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return 0;
    }

    public static int dischargeElectricItem(ItemStack aStack, int aCharge, int aTier, boolean aIgnoreLimit, boolean aSimulate, boolean aIgnoreDischargability) {
        try {
            int tTier;
            if (GT_ModHandler.isElectricItem(aStack) && ((tTier = ((IElectricItem)aStack.func_77973_b()).getTier(aStack)) < 0 || tTier == aTier || aTier == Integer.MAX_VALUE)) {
                if (!aIgnoreLimit && tTier >= 0) {
                    aCharge = (int)Math.min((long)aCharge, CS.V[Math.max(0, Math.min(CS.V.length - 1, tTier))]);
                }
                if (aCharge > 0) {
                    int rCharge = (int)Math.max(0.0, ElectricItem.manager.discharge(aStack, (double)(aCharge + (aCharge * 4 > aTier ? aTier : 0)), tTier, true, !aIgnoreDischargability, aSimulate));
                    return rCharge - (rCharge * 4 > aTier ? aTier : 0);
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return 0;
    }

    public static boolean canUseElectricItem(ItemStack aStack, int aCharge) {
        try {
            if (GT_ModHandler.isElectricItem(aStack)) {
                return ElectricItem.manager.canUse(aStack, (double)aCharge);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean useElectricItem(ItemStack aStack, int aCharge, EntityPlayer aPlayer) {
        try {
            if (GT_ModHandler.isElectricItem(aStack)) {
                ElectricItem.manager.use(aStack, 0.0, (EntityLivingBase)aPlayer);
                if (ElectricItem.manager.canUse(aStack, (double)aCharge)) {
                    return ElectricItem.manager.use(aStack, (double)aCharge, (EntityLivingBase)aPlayer);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean damageOrDechargeItem(ItemStack aStack, int aDamage, int aDecharge, EntityLivingBase aPlayer) {
        if (UT.Stacks.invalid(aStack) || aStack.func_77976_d() <= 1 && aStack.field_77994_a > 1) {
            return false;
        }
        if (aPlayer != null && aPlayer instanceof EntityPlayer && UT.Entities.hasInfiniteItems(aPlayer)) {
            return true;
        }
        if (aStack.func_77973_b() instanceof IItemDamagable) {
            return ((IItemDamagable)aStack.func_77973_b()).doDamageToItem(aStack, aDamage);
        }
        if (GT_ModHandler.isElectricItem(aStack)) {
            if (GT_ModHandler.canUseElectricItem(aStack, aDecharge)) {
                if (aPlayer != null && aPlayer instanceof EntityPlayer) {
                    return GT_ModHandler.useElectricItem(aStack, aDecharge, (EntityPlayer)aPlayer);
                }
                return GT_ModHandler.dischargeElectricItem(aStack, aDecharge, Integer.MAX_VALUE, true, false, true) >= aDecharge;
            }
        } else if (aStack.func_77973_b().func_77645_m()) {
            if (aPlayer == null) {
                aStack.func_77964_b(aStack.func_77960_j() + aDamage);
            } else {
                aStack.func_77972_a(aDamage, aPlayer);
            }
            if (aStack.func_77960_j() >= aStack.func_77958_k()) {
                aStack.func_77964_b(aStack.func_77958_k() + 1);
                ItemStack tStack = UT.Stacks.container(aStack, true);
                if (tStack != null) {
                    aStack.func_150996_a(tStack.func_77973_b());
                    aStack.func_77964_b(tStack.func_77960_j());
                    aStack.field_77994_a = tStack.field_77994_a;
                    aStack.func_77982_d(tStack.func_77978_p());
                }
            }
            return true;
        }
        return false;
    }

    public static boolean useSolderingIron(ItemStack aStack, EntityLivingBase aPlayer) {
        if (aPlayer == null || aStack == null) {
            return false;
        }
        if (CS.ToolsGT.contains("solderingtool", aStack)) {
            if (aPlayer instanceof EntityPlayer) {
                EntityPlayer tPlayer = (EntityPlayer)aPlayer;
                if (UT.Entities.hasInfiniteItems(tPlayer)) {
                    return true;
                }
                for (int i = 0; i < tPlayer.field_71071_by.field_70462_a.length; ++i) {
                    if (!CS.ToolsGT.contains("solderingmetal", tPlayer.field_71071_by.field_70462_a[i]) || !GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, (EntityLivingBase)tPlayer)) continue;
                    if (tPlayer.field_71071_by.field_70462_a[i].func_77960_j() >= tPlayer.field_71071_by.field_70462_a[i].func_77958_k()) {
                        tPlayer.field_71071_by.field_70462_a[i] = null;
                    }
                    if (!GT_ModHandler.damageOrDechargeItem(tPlayer.field_71071_by.field_70462_a[i], 1, 1000, (EntityLivingBase)tPlayer)) continue;
                    if (tPlayer.field_71071_by.field_70462_a[i].func_77960_j() >= tPlayer.field_71071_by.field_70462_a[i].func_77958_k()) {
                        tPlayer.field_71071_by.field_70462_a[i] = null;
                    }
                    if (tPlayer.field_71069_bz != null) {
                        tPlayer.field_71069_bz.func_75142_b();
                    }
                    return true;
                }
            } else {
                GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer);
                return true;
            }
        }
        return false;
    }

    public static boolean isChargerItem(ItemStack aStack) {
        try {
            if (GT_ModHandler.isElectricItem(aStack)) {
                return ((IElectricItem)aStack.func_77973_b()).canProvideEnergy(aStack);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean isElectricItem(ItemStack aStack) {
        try {
            return aStack != null && aStack.func_77973_b() instanceof IElectricItem && ((IElectricItem)aStack.func_77973_b()).getTier(aStack) < Integer.MAX_VALUE;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isElectricItem(ItemStack aStack, byte aTier) {
        try {
            return aStack != null && aStack.func_77973_b() instanceof IElectricItem && ((IElectricItem)aStack.func_77973_b()).getTier(aStack) == aTier;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isReactorItem(ItemStack aStack) {
        try {
            return aStack != null && aStack.func_77973_b() instanceof IReactorComponent;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static {
        sNativeRecipeClasses.add(ShapedRecipes.class.getName());
        sNativeRecipeClasses.add(ShapedOreRecipe.class.getName());
        sNativeRecipeClasses.add(AdvancedCraftingShaped.class.getName());
        sNativeRecipeClasses.add(ShapelessRecipes.class.getName());
        sNativeRecipeClasses.add(ShapelessOreRecipe.class.getName());
        sNativeRecipeClasses.add(AdvancedCraftingShapeless.class.getName());
        sNativeRecipeClasses.add("ic2.core.AdvRecipe");
        sNativeRecipeClasses.add("ic2.core.AdvShapelessRecipe");
        sNativeRecipeClasses.add("appeng.recipes.game.ShapedRecipe");
        sNativeRecipeClasses.add("appeng.recipes.game.ShapelessRecipe");
        sNativeRecipeClasses.add("forestry.core.utils.ShapedRecipeCustom");
        sSpecialRecipeClasses.add(RecipeFireworks.class.getName());
        sSpecialRecipeClasses.add(RecipesArmorDyes.class.getName());
        sSpecialRecipeClasses.add(RecipeBookCloning.class.getName());
        sSpecialRecipeClasses.add(RecipesMapCloning.class.getName());
        sSpecialRecipeClasses.add(RecipesMapExtending.class.getName());
        sSpecialRecipeClasses.add("jds.bibliocraft.BiblioSpecialRecipes");
        sSpecialRecipeClasses.add("dan200.qcraft.shared.EntangledQBlockRecipe");
        sSpecialRecipeClasses.add("dan200.qcraft.shared.EntangledQuantumComputerRecipe");
        sSpecialRecipeClasses.add("dan200.qcraft.shared.QBlockRecipe");
        sSpecialRecipeClasses.add("appeng.recipes.game.FacadeRecipe");
        sSpecialRecipeClasses.add("appeng.recipes.game.DisassembleRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.carts.LocomotivePaintingRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.RotorRepairRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.RoutingTableCopyRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.RoutingTicketCopyRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.TankCartFilterRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.emblems.LocomotiveEmblemRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.emblems.EmblemPostColorRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.emblems.EmblemPostEmblemRecipe");
        sSpecialRecipeClasses.add("mods.immibis.redlogic.interaction.RecipeDyeLumarButton");
        sSpecialRecipeClasses.add("thaumcraft.common.items.armor.RecipesRobeArmorDyes");
        sSpecialRecipeClasses.add("thaumcraft.common.items.armor.RecipesVoidRobeArmorDyes");
        sSpecialRecipeClasses.add("thaumcraft.common.lib.crafting.ShapelessNBTOreRecipe");
        sSpecialRecipeClasses.add("twilightforest.item.TFMapCloningRecipe");
        sSpecialRecipeClasses.add("forestry.lepidopterology.MatingRecipe");
        sSpecialRecipeClasses.add("micdoodle8.mods.galacticraft.planets.asteroids.recipe.CanisterRecipes");
        sSpecialRecipeClasses.add("shedar.mods.ic2.nuclearcontrol.StorageArrayRecipe");
        OREDICT_DYE_LISTS = new ArrayListNoNulls();
        for (String tDye : CS.DYE_OREDICTS) {
            OREDICT_DYE_LISTS.add(OreDictionary.getOres((String)tDye));
        }
    }

    public static class ThermalExpansion {
        public static void addFurnaceRecipe(int energy, ItemStack input, ItemStack output) {
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.func_74768_a("energy", energy);
            toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
            input.func_77955_b(toSend.func_74775_l("input"));
            output.func_77955_b(toSend.func_74775_l("output"));
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"FurnaceRecipe", (NBTTagCompound)toSend);
        }

        public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
            ThermalExpansion.addPulverizerRecipe(energy, input, primaryOutput, null, 0);
        }

        public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
            ThermalExpansion.addPulverizerRecipe(energy, input, primaryOutput, secondaryOutput, 100);
        }

        public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
            if (input == null || primaryOutput == null) {
                return;
            }
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.func_74768_a("energy", energy);
            toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
            input.func_77955_b(toSend.func_74775_l("input"));
            primaryOutput.func_77955_b(toSend.func_74775_l("primaryOutput"));
            if (secondaryOutput != null) {
                secondaryOutput.func_77955_b(toSend.func_74775_l("secondaryOutput"));
            }
            toSend.func_74768_a("secondaryChance", secondaryChance);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"PulverizerRecipe", (NBTTagCompound)toSend);
        }

        public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
            ThermalExpansion.addSawmillRecipe(energy, input, primaryOutput, null, 0);
        }

        public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
            ThermalExpansion.addSawmillRecipe(energy, input, primaryOutput, secondaryOutput, 100);
        }

        public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
            if (input == null || primaryOutput == null) {
                return;
            }
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.func_74768_a("energy", energy);
            toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
            input.func_77955_b(toSend.func_74775_l("input"));
            primaryOutput.func_77955_b(toSend.func_74775_l("primaryOutput"));
            if (secondaryOutput != null) {
                secondaryOutput.func_77955_b(toSend.func_74775_l("secondaryOutput"));
            }
            toSend.func_74768_a("secondaryChance", secondaryChance);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SawmillRecipe", (NBTTagCompound)toSend);
        }

        public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
            ThermalExpansion.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, null, 0);
        }

        public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
            ThermalExpansion.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
        }

        public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
            if (primaryInput == null || secondaryInput == null || primaryOutput == null) {
                return;
            }
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.func_74768_a("energy", energy);
            toSend.func_74782_a("primaryInput", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("secondaryInput", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
            primaryInput.func_77955_b(toSend.func_74775_l("primaryInput"));
            secondaryInput.func_77955_b(toSend.func_74775_l("secondaryInput"));
            primaryOutput.func_77955_b(toSend.func_74775_l("primaryOutput"));
            if (secondaryOutput != null) {
                secondaryOutput.func_77955_b(toSend.func_74775_l("secondaryOutput"));
            }
            toSend.func_74768_a("secondaryChance", secondaryChance);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SmelterRecipe", (NBTTagCompound)toSend);
        }

        public static void addSmelterBlastOre(OreDictMaterial aMaterial) {
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.func_74778_a("oreType", aMaterial.toString());
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SmelterBlastOreType", (NBTTagCompound)toSend);
        }

        public static void addCrucibleRecipe(int energy, ItemStack input, FluidStack output) {
            if (input == null || output == null) {
                return;
            }
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.func_74768_a("energy", energy);
            toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
            input.func_77955_b(toSend.func_74775_l("input"));
            output.writeToNBT(toSend.func_74775_l("output"));
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"CrucibleRecipe", (NBTTagCompound)toSend);
        }

        public static void addTransposerFill(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
            if (input == null || output == null || fluid == null) {
                return;
            }
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.func_74768_a("energy", energy);
            toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
            input.func_77955_b(toSend.func_74775_l("input"));
            output.func_77955_b(toSend.func_74775_l("output"));
            UT.NBT.setBoolean(toSend, "reversible", reversible);
            fluid.writeToNBT(toSend.func_74775_l("fluid"));
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"TransposerFillRecipe", (NBTTagCompound)toSend);
        }

        public static void addTransposerExtract(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible) {
            if (input == null || output == null || fluid == null) {
                return;
            }
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.func_74768_a("energy", energy);
            toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
            toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
            input.func_77955_b(toSend.func_74775_l("input"));
            output.func_77955_b(toSend.func_74775_l("output"));
            UT.NBT.setBoolean(toSend, "reversible", reversible);
            toSend.func_74768_a("chance", chance);
            fluid.writeToNBT(toSend.func_74775_l("fluid"));
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"TransposerExtractRecipe", (NBTTagCompound)toSend);
        }

        public static void addMagmaticFuel(String fluidName, int energy) {
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.func_74778_a("fluidName", fluidName);
            toSend.func_74768_a("energy", energy);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"MagmaticFuel", (NBTTagCompound)toSend);
        }

        public static void addCompressionFuel(String fluidName, int energy) {
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.func_74778_a("fluidName", fluidName);
            toSend.func_74768_a("energy", energy);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"CompressionFuel", (NBTTagCompound)toSend);
        }

        public static void addCoolant(String fluidName, int energy) {
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.func_74778_a("fluidName", fluidName);
            toSend.func_74768_a("energy", energy);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"Coolant", (NBTTagCompound)toSend);
        }
    }

    public static class RecipeBits {
        public static long MIRRORED = CS.B[0];
        public static long BUFFERED = CS.B[1];
        public static long KEEPNBT = CS.B[2];
        public static long DISMANTLEABLE = CS.B[3];
        public static long NOT_REMOVABLE = CS.B[4];
        public static long REVERSIBLE = CS.B[5];
        public static long DELETE_ALL_OTHER_RECIPES = CS.B[6];
        public static long DELETE_ALL_OTHER_RECIPES_IF_SAME_NBT = CS.B[7];
        public static long DELETE_ALL_OTHER_SHAPED_RECIPES = CS.B[8];
        public static long DELETE_ALL_OTHER_NATIVE_RECIPES = CS.B[9];
        public static long DO_NOT_CHECK_FOR_COLLISIONS = CS.B[10];
        public static long ONLY_ADD_IF_THERE_IS_ANOTHER_RECIPE_FOR_IT = CS.B[11];
        public static long ONLY_ADD_IF_RESULT_IS_NOT_NULL = CS.B[12];
        public static long DELETE_ONLY_IF_NO_DYE_IS_INVOLVED = CS.B[13];
        public static long NOT_AUTOCRAFTABLE = CS.B[14];
        public static long DEFAULT = BUFFERED | NOT_REMOVABLE;
        public static long DEFAULT_REV = DEFAULT | REVERSIBLE;
        public static long DEFAULT_NCC = DEFAULT | DO_NOT_CHECK_FOR_COLLISIONS;
        public static long DEFAULT_REV_NCC = DEFAULT_REV | DO_NOT_CHECK_FOR_COLLISIONS;
        public static long DEFAULT_NAC = DEFAULT | NOT_AUTOCRAFTABLE;
        public static long DEFAULT_NAC_NCC = DEFAULT_NCC | NOT_AUTOCRAFTABLE;
        public static long DEFAULT_NAC_REV = DEFAULT_REV | NOT_AUTOCRAFTABLE;
        public static long DEFAULT_NAC_REV_NCC = DEFAULT_REV_NCC | NOT_AUTOCRAFTABLE;
    }
}

