/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes;

import gregapi.item.multiitem.MultiItemTool;
import gregapi.recipes.GT_ModHandler;
import gregapi.recipes.ICraftingRecipeGT;
import gregapi.util.UT;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class AdvancedCraftingShapeless
extends ShapelessOreRecipe
implements ICraftingRecipeGT {
    public final boolean mDismantleable;
    public final boolean mRemovableByGT;
    public final boolean mAutoCraftable;
    public final boolean mKeepingNBT;
    private final Enchantment[] mEnchantmentsAdded;
    private final int[] mEnchantmentLevelsAdded;

    public AdvancedCraftingShapeless(ItemStack aResult, boolean aDismantleAble, boolean aRemovableByGT, boolean aKeepingNBT, boolean aAutoCraftable, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object ... aRecipe) {
        super(aResult, aRecipe);
        this.mEnchantmentsAdded = aEnchantmentsAdded;
        this.mEnchantmentLevelsAdded = aEnchantmentLevelsAdded;
        this.mRemovableByGT = aRemovableByGT;
        this.mKeepingNBT = aKeepingNBT;
        this.mDismantleable = aDismantleAble;
        this.mAutoCraftable = aAutoCraftable;
    }

    public boolean func_77569_a(InventoryCrafting aGrid, World aWorld) {
        if (this.mKeepingNBT) {
            ItemStack tStack = null;
            ItemStack tMainInput = this.getInput().get(0) instanceof ItemStack ? (ItemStack)this.getInput().get(0) : null;
            for (int i = 0; i < aGrid.func_70302_i_(); ++i) {
                if (aGrid.func_70301_a(i) == null || tMainInput != null && !UT.Stacks.equal_(aGrid.func_70301_a(i), tMainInput, true)) continue;
                if (tStack != null && !UT.Stacks.equal_(tStack, aGrid.func_70301_a(i), false)) {
                    return false;
                }
                tStack = aGrid.func_70301_a(i);
            }
        }
        return super.func_77569_a(aGrid, aWorld);
    }

    public ItemStack func_77572_b(InventoryCrafting aGrid) {
        ItemStack rStack = super.func_77572_b(aGrid);
        if (rStack != null) {
            int i;
            UT.Stacks.update(rStack);
            if (this.mKeepingNBT) {
                ItemStack tMainInput = this.getInput().get(0) instanceof ItemStack ? (ItemStack)this.getInput().get(0) : null;
                for (i = 0; i < aGrid.func_70302_i_(); ++i) {
                    if (aGrid.func_70301_a(i) == null || !aGrid.func_70301_a(i).func_77942_o() || tMainInput != null && !UT.Stacks.equal_(aGrid.func_70301_a(i), tMainInput, true)) continue;
                    rStack.func_77982_d((NBTTagCompound)aGrid.func_70301_a(i).func_77978_p().func_74737_b());
                    break;
                }
            }
            if (GT_ModHandler.isElectricItem(rStack)) {
                GT_ModHandler.dischargeElectricItem(rStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false, true);
                int tCharge = 0;
                for (i = 0; i < aGrid.func_70302_i_(); ++i) {
                    tCharge += GT_ModHandler.dischargeElectricItem(aGrid.func_70301_a(i), Integer.MAX_VALUE, Integer.MAX_VALUE, true, true, true);
                }
                if (tCharge > 0) {
                    GT_ModHandler.chargeElectricItem(rStack, tCharge, Integer.MAX_VALUE, true, false);
                }
            }
            if (this.mDismantleable) {
                NBTTagCompound rNBT = rStack.func_77978_p();
                NBTTagCompound tNBT = new NBTTagCompound();
                if (rNBT == null) {
                    rNBT = new NBTTagCompound();
                }
                for (int i2 = 0; i2 < 9; ++i2) {
                    ItemStack tStack = aGrid.func_70301_a(i2);
                    if (tStack == null || UT.Stacks.container(tStack, true) != null || tStack.func_77973_b() instanceof MultiItemTool) continue;
                    tStack = UT.Stacks.amount(1L, tStack);
                    GT_ModHandler.dischargeElectricItem(tStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false, true);
                    tNBT.func_74782_a("" + i2, (NBTBase)UT.Stacks.save(tStack));
                }
                rNBT.func_74782_a("gt.recycling.comps", (NBTBase)tNBT);
                rStack.func_77982_d(rNBT);
            }
            for (int i3 = 0; i3 < this.mEnchantmentsAdded.length; ++i3) {
                UT.NBT.addEnchantment(rStack, this.mEnchantmentsAdded[i3], EnchantmentHelper.func_77506_a((int)this.mEnchantmentsAdded[i3].field_77352_x, (ItemStack)rStack) + this.mEnchantmentLevelsAdded[i3]);
            }
            UT.Stacks.update(rStack);
        }
        return rStack;
    }

    @Override
    public boolean isRemovableByGT() {
        return this.mRemovableByGT;
    }

    @Override
    public boolean isAutocraftableByGT() {
        return this.mAutoCraftable;
    }
}

