/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes;

import gregapi.code.TagData;
import gregapi.item.IItemEnergy;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.recipes.GT_ModHandler;
import gregapi.recipes.ICraftingRecipeGT;
import gregapi.util.UT;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class AdvancedCraftingShaped
extends ShapedOreRecipe
implements ICraftingRecipeGT {
    public final boolean mDismantleable;
    public final boolean mRemovableByGT;
    public final boolean mAutoCraftable;
    public final boolean mKeepingNBT;
    private final Enchantment[] mEnchantmentsAdded;
    private final int[] mEnchantmentLevelsAdded;

    public AdvancedCraftingShaped(ItemStack aResult, boolean aDismantleAble, boolean aRemovableByGT, boolean aKeepingNBT, boolean aAutoCraftable, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object ... aRecipe) {
        super(aResult, aRecipe);
        this.mEnchantmentsAdded = aEnchantmentsAdded;
        this.mEnchantmentLevelsAdded = aEnchantmentLevelsAdded;
        this.mRemovableByGT = aRemovableByGT;
        this.mKeepingNBT = aKeepingNBT;
        this.mDismantleable = aDismantleAble;
        this.mAutoCraftable = aAutoCraftable;
    }

    public boolean func_77569_a(InventoryCrafting aGrid, World aWorld) {
        if (this.mKeepingNBT) {
            ItemStack tStack = null;
            for (int i = 0; i < aGrid.func_70302_i_(); ++i) {
                if (aGrid.func_70301_a(i) == null) continue;
                if (tStack != null && (tStack.func_77942_o() != aGrid.func_70301_a(i).func_77942_o() || tStack.func_77942_o() && !tStack.func_77978_p().equals((Object)aGrid.func_70301_a(i).func_77978_p()))) {
                    return false;
                }
                tStack = aGrid.func_70301_a(i);
            }
        }
        return super.func_77569_a(aGrid, aWorld);
    }

    public ItemStack func_77572_b(InventoryCrafting aGrid) {
        ItemStack rStack = super.func_77572_b(aGrid);
        if (rStack != null) {
            int i;
            int i2;
            UT.Stacks.update(rStack);
            if (this.mKeepingNBT) {
                for (i2 = 0; i2 < aGrid.func_70302_i_(); ++i2) {
                    if (aGrid.func_70301_a(i2) == null || !aGrid.func_70301_a(i2).func_77942_o()) continue;
                    rStack.func_77982_d((NBTTagCompound)aGrid.func_70301_a(i2).func_77978_p().func_74737_b());
                    break;
                }
            }
            if (GT_ModHandler.isElectricItem(rStack)) {
                GT_ModHandler.dischargeElectricItem(rStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false, true);
                long tCharge = 0L;
                for (i = 0; i < aGrid.func_70302_i_(); ++i) {
                    tCharge += (long)GT_ModHandler.dischargeElectricItem(aGrid.func_70301_a(i), Integer.MAX_VALUE, Integer.MAX_VALUE, true, true, true);
                }
                if (tCharge > 0L) {
                    GT_ModHandler.chargeElectricItem(rStack, UT.Code.bindInt(tCharge), Integer.MAX_VALUE, true, false);
                }
            }
            if (rStack.func_77973_b() instanceof IItemEnergy) {
                for (TagData tEnergyType : ((IItemEnergy)rStack.func_77973_b()).getEnergyTypes(rStack)) {
                    long tCharge = 0L;
                    for (int i3 = 0; i3 < aGrid.func_70302_i_(); ++i3) {
                        if (aGrid.func_70301_a(i3) == null || !(aGrid.func_70301_a(i3).func_77973_b() instanceof IItemEnergy)) continue;
                        tCharge += ((IItemEnergy)aGrid.func_70301_a(i3).func_77973_b()).getEnergyStored(tEnergyType, aGrid.func_70301_a(i3));
                    }
                    ((IItemEnergy)rStack.func_77973_b()).setEnergyStored(tEnergyType, rStack, tCharge);
                }
            }
            if (this.mDismantleable) {
                NBTTagCompound rNBT = rStack.func_77978_p();
                NBTTagCompound tNBT = new NBTTagCompound();
                if (rNBT == null) {
                    rNBT = new NBTTagCompound();
                }
                for (i = 0; i < 9; ++i) {
                    ItemStack tStack = aGrid.func_70301_a(i);
                    if (tStack == null || UT.Stacks.container(tStack, true) != null || tStack.func_77973_b() instanceof MultiItemTool) continue;
                    tStack = UT.Stacks.amount(1L, tStack);
                    GT_ModHandler.dischargeElectricItem(tStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false, true);
                    tNBT.func_74782_a("" + i, (NBTBase)UT.Stacks.save(tStack));
                }
                rNBT.func_74782_a("gt.recycling.comps", (NBTBase)tNBT);
                rStack.func_77982_d(rNBT);
            }
            for (i2 = 0; i2 < this.mEnchantmentsAdded.length; ++i2) {
                UT.NBT.addEnchantment(rStack, this.mEnchantmentsAdded[i2], EnchantmentHelper.func_77506_a((int)this.mEnchantmentsAdded[i2].field_77352_x, (ItemStack)rStack) + this.mEnchantmentLevelsAdded[i2]);
            }
            UT.Stacks.update(rStack);
        }
        return rStack;
    }

    @Override
    public boolean isRemovableByGT() {
        return this.mRemovableByGT;
    }

    @Override
    public boolean isAutocraftableByGT() {
        return this.mAutoCraftable;
    }
}

