/*
 * Decompiled with CFR 0.152.
 */
package gregapi.oredict;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.MT;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class OreDictMaterialStack
implements Cloneable {
    public long mAmount;
    public OreDictMaterial mMaterial;

    public OreDictMaterialStack(OreDictMaterial aMaterial, long aAmount) {
        this.mMaterial = aMaterial == null ? MT.NULL : aMaterial;
        this.mAmount = aAmount;
    }

    public OreDictMaterialStack copy(long aAmount) {
        return new OreDictMaterialStack(this.mMaterial, aAmount);
    }

    public OreDictMaterialStack clone() {
        return new OreDictMaterialStack(this.mMaterial, this.mAmount);
    }

    public boolean equals(Object aObject) {
        if (aObject == this) {
            return true;
        }
        if (aObject == null) {
            return false;
        }
        if (aObject instanceof OreDictMaterial) {
            return aObject == this.mMaterial;
        }
        if (aObject instanceof OreDictMaterialStack) {
            return ((OreDictMaterialStack)aObject).mMaterial == this.mMaterial && (this.mAmount < 0L || ((OreDictMaterialStack)aObject).mAmount < 0L || ((OreDictMaterialStack)aObject).mAmount == this.mAmount);
        }
        return false;
    }

    public String toString() {
        return this.mMaterial.toString() + " - " + this.mAmount;
    }

    public int hashCode() {
        return this.mMaterial.hashCode();
    }

    public List<OreDictMaterialStack> addToList(List<OreDictMaterialStack> aList) {
        if (this.mAmount == 0L) {
            return aList;
        }
        for (OreDictMaterialStack tMaterial : aList) {
            if (tMaterial.mMaterial != this.mMaterial) continue;
            tMaterial.mAmount += this.mAmount;
            return aList;
        }
        aList.add(this.clone());
        return aList;
    }

    public NBTTagCompound save() {
        NBTTagCompound rNBT = new NBTTagCompound();
        UT.NBT.setNumber(rNBT, "a", this.mAmount);
        if (this.mMaterial.mID < 0) {
            rNBT.func_74778_a("m", this.mMaterial.mNameInternal);
            return rNBT;
        }
        rNBT.func_74777_a("i", this.mMaterial.mID);
        return rNBT;
    }

    public void save(String aTagName, NBTTagCompound aNBT) {
        aNBT.func_74782_a(aTagName, (NBTBase)this.save());
    }

    public static OreDictMaterialStack load(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("i")) {
            return new OreDictMaterialStack(OreDictMaterial.MATERIAL_ARRAY[aNBT.func_74765_d("i")], aNBT.func_74763_f("a"));
        }
        return new OreDictMaterialStack(OreDictMaterial.get(aNBT.func_74779_i("m")), aNBT.func_74763_f("a"));
    }

    public static OreDictMaterialStack load(String aTagName, NBTTagCompound aNBT) {
        return OreDictMaterialStack.load(aNBT.func_74775_l(aTagName));
    }

    public static NBTTagCompound saveList(List<OreDictMaterialStack> aList) {
        NBTTagCompound rNBT = new NBTTagCompound();
        if (aList == null) {
            return rNBT;
        }
        int l = 0;
        int j = aList.size();
        for (int i = 0; i < j; ++i) {
            OreDictMaterialStack tStack = aList.get(i);
            if (tStack == null || tStack.mMaterial == MT.NULL) continue;
            rNBT.func_74782_a("" + i, (NBTBase)tStack.save());
            ++l;
        }
        rNBT.func_74768_a("size", l);
        return rNBT;
    }

    public static void saveList(String aTagName, NBTTagCompound aNBT, List<OreDictMaterialStack> aList) {
        aNBT.func_74782_a(aTagName, (NBTBase)OreDictMaterialStack.saveList(aList));
    }

    public static List<OreDictMaterialStack> loadList(NBTTagCompound aNBT) {
        ArrayListNoNulls<OreDictMaterialStack> rList = new ArrayListNoNulls<OreDictMaterialStack>();
        if (aNBT == null) {
            return rList;
        }
        int j = aNBT.func_74762_e("size");
        for (int i = 0; i < j; ++i) {
            OreDictMaterialStack tStack = OreDictMaterialStack.load("" + i, aNBT);
            if (tStack.mMaterial == MT.NULL) continue;
            rList.add(tStack);
        }
        return rList;
    }

    public static List<OreDictMaterialStack> loadList(String aTagName, NBTTagCompound aNBT) {
        return OreDictMaterialStack.loadList(aNBT.func_74775_l(aTagName));
    }
}

