/*
 * Decompiled with CFR 0.152.
 */
package gregapi.oredict;

import gregapi.code.ICondition;
import gregapi.code.TagData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;

public class OreDictMaterialCondition {
    public static ICondition<OreDictMaterial> tag(TagData ... aTags) {
        return new TagDataContainsAll(aTags);
    }

    public static ICondition<OreDictMaterial> tagnor(TagData ... aTags) {
        return new TagDataContainsNone(aTags);
    }

    public static ICondition<OreDictMaterial> fullpulver() {
        return FullPulver.INSTANCE;
    }

    public static ICondition<OreDictMaterial> fullforge() {
        return FullForge.INSTANCE;
    }

    public static ICondition<OreDictMaterial> prefix(OreDictPrefix aPrefix) {
        return new TagDataPrefixGenerates(aPrefix);
    }

    public static ICondition<OreDictMaterial> meltmin(long aMeltingPoint) {
        return new MeltingPointMin(aMeltingPoint);
    }

    public static ICondition<OreDictMaterial> meltmax(long aMeltingPoint) {
        return new MeltingPointMax(aMeltingPoint);
    }

    public static ICondition<OreDictMaterial> boilmin(long aBoilingPoint) {
        return new BoilingPointMin(aBoilingPoint);
    }

    public static ICondition<OreDictMaterial> boilmax(long aBoilingPoint) {
        return new BoilingPointMax(aBoilingPoint);
    }

    public static ICondition<OreDictMaterial> plasmin(long aPlasmaPoint) {
        return new PlasmaPointMin(aPlasmaPoint);
    }

    public static ICondition<OreDictMaterial> plasmax(long aPlasmaPoint) {
        return new PlasmaPointMax(aPlasmaPoint);
    }

    public static ICondition<OreDictMaterial> qualmin(long aMinQuality) {
        return new QualityMin(aMinQuality);
    }

    public static ICondition<OreDictMaterial> qualmax(long aMaxQuality) {
        return new QualityMax(aMaxQuality);
    }

    private static class PlasmaPointMax
    implements ICondition<OreDictMaterial> {
        private final long mPlasmaPoint;

        public PlasmaPointMax(long aPlasmaPoint) {
            this.mPlasmaPoint = aPlasmaPoint;
        }

        @Override
        public boolean isTrue(OreDictMaterial aMaterial) {
            return aMaterial.mPlasmaPoint <= this.mPlasmaPoint;
        }
    }

    private static class PlasmaPointMin
    implements ICondition<OreDictMaterial> {
        private final long mPlasmaPoint;

        public PlasmaPointMin(long aPlasmaPoint) {
            this.mPlasmaPoint = aPlasmaPoint;
        }

        @Override
        public boolean isTrue(OreDictMaterial aMaterial) {
            return aMaterial.mPlasmaPoint >= this.mPlasmaPoint;
        }
    }

    private static class BoilingPointMax
    implements ICondition<OreDictMaterial> {
        private final long mBoilingPoint;

        public BoilingPointMax(long aBoilingPoint) {
            this.mBoilingPoint = aBoilingPoint;
        }

        @Override
        public boolean isTrue(OreDictMaterial aMaterial) {
            return aMaterial.mBoilingPoint <= this.mBoilingPoint;
        }
    }

    private static class BoilingPointMin
    implements ICondition<OreDictMaterial> {
        private final long mBoilingPoint;

        public BoilingPointMin(long aBoilingPoint) {
            this.mBoilingPoint = aBoilingPoint;
        }

        @Override
        public boolean isTrue(OreDictMaterial aMaterial) {
            return aMaterial.mBoilingPoint >= this.mBoilingPoint;
        }
    }

    private static class MeltingPointMax
    implements ICondition<OreDictMaterial> {
        private final long mMeltingPoint;

        public MeltingPointMax(long aMeltingPoint) {
            this.mMeltingPoint = aMeltingPoint;
        }

        @Override
        public boolean isTrue(OreDictMaterial aMaterial) {
            return aMaterial.mMeltingPoint <= this.mMeltingPoint;
        }
    }

    private static class MeltingPointMin
    implements ICondition<OreDictMaterial> {
        private final long mMeltingPoint;

        public MeltingPointMin(long aMeltingPoint) {
            this.mMeltingPoint = aMeltingPoint;
        }

        @Override
        public boolean isTrue(OreDictMaterial aMaterial) {
            return aMaterial.mMeltingPoint >= this.mMeltingPoint;
        }
    }

    private static class QualityMax
    implements ICondition<OreDictMaterial> {
        private final long mMaxQuality;

        public QualityMax(long aMaxQuality) {
            this.mMaxQuality = aMaxQuality;
        }

        @Override
        public boolean isTrue(OreDictMaterial aMaterial) {
            return (long)aMaterial.mToolQuality >= this.mMaxQuality;
        }
    }

    private static class QualityMin
    implements ICondition<OreDictMaterial> {
        private final long mMinQuality;

        public QualityMin(long aMinQuality) {
            this.mMinQuality = aMinQuality;
        }

        @Override
        public boolean isTrue(OreDictMaterial aMaterial) {
            return (long)aMaterial.mToolQuality >= this.mMinQuality;
        }
    }

    private static class TagDataPrefixGenerates
    implements ICondition<OreDictMaterial> {
        private final OreDictPrefix mPrefix;

        public TagDataPrefixGenerates(OreDictPrefix aPrefix) {
            this.mPrefix = aPrefix;
        }

        @Override
        public boolean isTrue(OreDictMaterial aMaterial) {
            return this.mPrefix.canGenerateItem(aMaterial);
        }
    }

    private static class TagDataContainsNone
    implements ICondition<OreDictMaterial> {
        private final TagData[] mTags;

        public TagDataContainsNone(TagData ... aTags) {
            this.mTags = aTags;
        }

        @Override
        public boolean isTrue(OreDictMaterial aMaterial) {
            for (TagData tTag : this.mTags) {
                if (!aMaterial.contains(tTag)) continue;
                return false;
            }
            return true;
        }
    }

    private static class TagDataContainsAll
    implements ICondition<OreDictMaterial> {
        private final TagData[] mTags;

        public TagDataContainsAll(TagData ... aTags) {
            this.mTags = aTags;
        }

        @Override
        public boolean isTrue(OreDictMaterial aMaterial) {
            return aMaterial.containsAll(this.mTags);
        }
    }

    private static class FullForge
    implements ICondition<OreDictMaterial> {
        public static final FullForge INSTANCE = new FullForge();

        private FullForge() {
        }

        @Override
        public boolean isTrue(OreDictMaterial aMaterial) {
            return aMaterial.mTargetForging.mAmount >= 420076800L;
        }
    }

    private static class FullPulver
    implements ICondition<OreDictMaterial> {
        public static final FullPulver INSTANCE = new FullPulver();

        private FullPulver() {
        }

        @Override
        public boolean isTrue(OreDictMaterial aMaterial) {
            return aMaterial.mTargetPulver.mAmount >= 420076800L;
        }
    }
}

