/*
 * Decompiled with CFR 0.152.
 */
package gregapi.oredict;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ICondition;
import gregapi.code.ITagDataContainer;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackSet;
import gregapi.code.ModData;
import gregapi.code.ObjectStack;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.data.TC;
import gregapi.data.TD;
import gregapi.lang.LanguageHandler;
import gregapi.oredict.IOreDictConfigurationComponent;
import gregapi.oredict.IOreDictListenerItem;
import gregapi.oredict.OreDictConfigurationComponent;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.render.IIconContainer;
import gregapi.render.TextureSet;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraftforge.fluids.FluidStack;

public final class OreDictMaterial
implements ITagDataContainer<OreDictMaterial>,
ICondition<OreDictMaterial> {
    public static final Map<String, OreDictMaterial> MATERIAL_MAP = new HashMap<String, OreDictMaterial>();
    public static final Map<String, OreDictMaterialStack> FLUID_MAP = new HashMap<String, OreDictMaterialStack>();
    public static final OreDictMaterial[] MATERIAL_ARRAY = new OreDictMaterial[Short.MAX_VALUE];
    public static final Set<OreDictMaterial> ALLOYS = new HashSetNoNulls<OreDictMaterial>();
    public static int sHashID = 0;
    private static final Set<String> INVALID_STRINGS_TO_START_A_MATERIAL_NAME = new HashSetNoNulls<String>(Arrays.asList("Mul", "Div", "Rich", "Poor", "Raw", "Impure", "Pure", "Dirty", "Refined", "Tiny", "Small", "Normal", "Medium", "Large", "Huge", "Dense", "Alloy", "Head", "Tool", "Helmet", "Chestplate", "Leggings", "Boots", "Centrifuged", "Purified", "Quintuple", "Quadruple", "Triple", "Double", "Hot", "Chipped", "Flawed", "Flawless", "Exquisite", "Gt", "Long", "Plasma", "Gas", "Liquid", "Solid", "Gem", "Dust", "Ingot", "Plate", "Block", "Leaves", "Sapling", "Mossy", "Brick", "Crack", "Chisel", "Broken", "Compact", "Curve", "Mixed", "Mixable"));
    public final short mID;
    private final int mHashID;
    public final String mNameInternal;
    public String mNameLocal;
    public ModData mOriginalMod = null;
    public ItemStack mDictionaryBook = null;
    public String[] mDescription = null;
    public byte mOreMultiplier = 1;
    public byte mOreProcessingMultiplier = 1;
    public long mFurnaceBurnTime = 0L;
    public byte mToolQuality = 0;
    public long mToolDurability = 0L;
    public float mToolSpeed = 1.0f;
    public float mHeatDamage = 0.0f;
    public double mGramPerCubicCentimeter = 1.0;
    public final short[] mRGBaSolid = new short[]{255, 255, 255, 255};
    public final short[] mRGBaLiquid = new short[]{255, 255, 255, 255};
    public final short[] mRGBaGas = new short[]{255, 255, 255, 255};
    public final short[] mRGBaPlasma = new short[]{255, 255, 255, 255};
    public final short[][] mRGBa = new short[][]{this.mRGBaSolid, this.mRGBaLiquid, this.mRGBaGas, this.mRGBaPlasma};
    public long mMeltingPoint = 1000L;
    public long mBoilingPoint = 3000L;
    public long mPlasmaPoint = 10000L;
    public long mNeutrons = 55L;
    public long mProtons = 43L;
    public long mElectrons = 43L;
    public long mMass = this.mNeutrons + this.mProtons;
    public List<IIconContainer> mTextureSetsBlock;
    public List<IIconContainer> mTextureSetsItems;
    public final List<TC.TC_AspectStack> mAspects;
    public IOreDictConfigurationComponent mComponents;
    public final Set<OreDictMaterial> mReRegistrations;
    public final List<OreDictMaterial> mByProducts;
    public final Set<OreDictMaterial> mAlloyComponentReferences;
    public final List<IOreDictConfigurationComponent> mAlloyCreationRecipes;
    public final List<Achievement> mAchievementsForCreation;
    public OreDictMaterial mTargetRegistration;
    public OreDictMaterial mHandleMaterial;
    public OreDictMaterialStack mTargetCrushing;
    public OreDictMaterialStack mTargetPulver;
    public OreDictMaterialStack mTargetSmelting;
    public OreDictMaterialStack mTargetSolidifying;
    public OreDictMaterialStack mTargetSmashing;
    public OreDictMaterialStack mTargetCutting;
    public OreDictMaterialStack mTargetWorking;
    public OreDictMaterialStack mTargetForging;
    public OreDictMaterialStack mTargetBurning;
    public OreDictMaterialStack mTargetBending;
    public OreDictMaterialStack mTargetCompressing;
    public long mLiquidUnit;
    public long mGasUnit;
    public long mPlasmaUnit;
    public FluidStack mLiquid;
    public FluidStack mGas;
    public FluidStack mPlasma;
    private final Set<TagData> mTags;
    public final List<ObjectStack<Enchantment>> mEnchantmentTools;
    public final List<ObjectStack<Enchantment>> mEnchantmentArmors;
    public final List<IOreDictListenerItem> mListenersItem;
    public final ItemStackSet<ItemStackContainer> mRegisteredItems;

    public static OreDictMaterial createMaterial(int aID, String aNameOreDict, String aLocalName) {
        OreDictMaterial rMaterial1;
        aID = aID < 0 || aID >= MATERIAL_ARRAY.length || aID == Short.MAX_VALUE ? -1 : aID;
        if ((aNameOreDict = UT.Code.capitalise(aNameOreDict.replaceAll(" ", "").replaceAll("-", ""))).isEmpty()) {
            throw new IllegalArgumentException("This OreDict Name is not usable, due to being an empty String, after stripping all the minuses and spaces.");
        }
        if (aNameOreDict.contains("|") || aNameOreDict.contains("*") || aNameOreDict.contains(":") || aNameOreDict.contains(".") || aNameOreDict.contains("$")) {
            throw new IllegalArgumentException("The Material Name contains at least one of the following five invalid Characters '|', '*', ':', '.' or '$'");
        }
        if (aID >= 0) {
            if (CS.GAPI.mStartedInit) {
                throw new IllegalStateException("Materials with a valid ID have to be initialised in PreInit or earlier!");
            }
            if (CS.CN.contains(Character.valueOf(aNameOreDict.charAt(0)))) {
                throw new IllegalArgumentException("The OreDict Name '" + aNameOreDict + "' is not suitable for a valid Material. Choose a different one, which doesn't happen to start with a Numeral. You can always set the Local Name to your liking, but the internal Name must always be a proper one.");
            }
            if (INVALID_STRINGS_TO_START_A_MATERIAL_NAME.contains(aNameOreDict)) {
                throw new IllegalArgumentException("The OreDict Name '" + aNameOreDict + "' is not suitable for a valid Material. Choose a different one, which doesn't happen to be a blacklisted Adjective. You can always set the Local Name to your liking, but the internal Name must always be a proper one.");
            }
            for (String tInvalidString : INVALID_STRINGS_TO_START_A_MATERIAL_NAME) {
                if (!aNameOreDict.startsWith(tInvalidString)) continue;
                throw new IllegalArgumentException("The OreDict Name '" + aNameOreDict + "' is not suitable for a valid Material, as it conflicts with OreDict Prefixes. A better Name for your Material would be '" + UT.Code.capitalise(aNameOreDict.replaceFirst(tInvalidString, "")) + tInvalidString + "' with the '" + tInvalidString + "' at the end of the Material Name instead of the beginning.");
            }
        }
        if ((rMaterial1 = MATERIAL_MAP.get(aNameOreDict)) == null) {
            return new OreDictMaterial((short)aID, aNameOreDict, aLocalName);
        }
        if (aID < 0 || rMaterial1.mID == aID) {
            if (aID >= 0) {
                CS.DEB.println("NOTICE: Two Materials used the same ID: " + aID + " - Names: " + aNameOreDict + " and " + rMaterial1.mNameInternal);
            }
            return rMaterial1;
        }
        OreDictMaterial rMaterial2 = new OreDictMaterial((short)aID, aNameOreDict, aLocalName);
        rMaterial1.setRegistration(rMaterial2);
        return rMaterial2;
    }

    private OreDictMaterial(short aID, String aNameInternal, String aNameLocal) {
        this.mTextureSetsBlock = TextureSet.SET_NONE[0].mList;
        this.mTextureSetsItems = TextureSet.SET_NONE[1].mList;
        this.mAspects = new ArrayListNoNulls<TC.TC_AspectStack>(1);
        this.mComponents = null;
        this.mReRegistrations = new HashSetNoNulls<OreDictMaterial>();
        this.mByProducts = new ArrayListNoNulls<OreDictMaterial>();
        this.mAlloyComponentReferences = new HashSetNoNulls<OreDictMaterial>();
        this.mAlloyCreationRecipes = new ArrayListNoNulls<IOreDictConfigurationComponent>();
        this.mAchievementsForCreation = new ArrayListNoNulls<Achievement>();
        this.mTargetRegistration = this;
        this.mHandleMaterial = this;
        this.mTargetCrushing = OM.stack(this, 420076800L);
        this.mTargetPulver = OM.stack(this, 420076800L);
        this.mTargetSmelting = OM.stack(this, 420076800L);
        this.mTargetSolidifying = OM.stack(this, 420076800L);
        this.mTargetSmashing = OM.stack(this, 420076800L);
        this.mTargetCutting = OM.stack(this, 420076800L);
        this.mTargetWorking = OM.stack(this, 420076800L);
        this.mTargetForging = OM.stack(this, 420076800L);
        this.mTargetBurning = OM.stack(this, 0L);
        this.mTargetBending = OM.stack(this, 420076800L);
        this.mTargetCompressing = OM.stack(this, 420076800L);
        this.mLiquidUnit = 420076800L;
        this.mGasUnit = 420076800L;
        this.mPlasmaUnit = 420076800L;
        this.mTags = new HashSetNoNulls<TagData>();
        this.mEnchantmentTools = new ArrayListNoNulls<ObjectStack<Enchantment>>(1);
        this.mEnchantmentArmors = new ArrayListNoNulls<ObjectStack<Enchantment>>(1);
        this.mListenersItem = new ArrayListNoNulls<IOreDictListenerItem>();
        this.mRegisteredItems = new ItemStackSet();
        this.mID = aID;
        this.mNameInternal = aNameInternal;
        this.mNameLocal = aNameLocal;
        MATERIAL_MAP.put(this.mNameInternal, this);
        if (this.mID >= 0) {
            OreDictMaterial.MATERIAL_ARRAY[this.mID] = this;
        }
        this.mHashID = sHashID++;
    }

    public OreDictMaterial setLocal(String aNameLocal) {
        this.mNameLocal = aNameLocal == null ? this.mNameInternal : aNameLocal;
        return this;
    }

    public String getLocal() {
        return LanguageHandler.translate("gt.material." + this.mNameInternal, this.mNameLocal);
    }

    public OreDictMaterial setOriginalMod(ModData aOriginalMod) {
        this.mOriginalMod = aOriginalMod == null ? this.mOriginalMod : aOriginalMod;
        return this;
    }

    public OreDictMaterial setOriginalMod(String aModID, String aModName) {
        this.mOriginalMod = new ModData(aModID, aModName);
        return this;
    }

    public OreDictMaterial addIdenticalNames(String ... aNames) {
        for (String aName : aNames) {
            this.addReRegistrations(OreDictMaterial.createMaterial(-1, aName, aName).setRegistration(this));
        }
        return this;
    }

    public OreDictMaterial addReRegistrations(OreDictMaterial ... aMaterials) {
        for (OreDictMaterial aMaterial : aMaterials) {
            this.mReRegistrations.add(aMaterial);
        }
        return this;
    }

    public OreDictMaterial addReRegistrationToThis(OreDictMaterial ... aMaterials) {
        for (OreDictMaterial aMaterial : aMaterials) {
            aMaterial.addReRegistrations(this);
        }
        return this;
    }

    public OreDictMaterial setRegistration(OreDictMaterial aMaterial) {
        this.mTargetRegistration = aMaterial == null ? this : aMaterial.mTargetRegistration;
        this.add(TD.Properties.INVALID_MATERIAL);
        return this;
    }

    public OreDictMaterial makeIntoSimpleAlloy() {
        this.add(TD.Compounds.ALLOY);
        this.add(TD.Compounds.DECOMPOSABLE);
        this.add(TD.Processing.CENTRIFUGE);
        return this.addAlloyingRecipe(this.mComponents);
    }

    public OreDictMaterial addAlloyingRecipe(IOreDictConfigurationComponent aConfiguration) {
        ALLOYS.add(this);
        for (OreDictMaterialStack tMaterial : aConfiguration.getUndividedComponents()) {
            if (this.mMeltingPoint >= tMaterial.mMaterial.mBoilingPoint) {
                CS.ERR.println("The Alloy '" + this.mNameInternal + "' cannot be created due to the melting point being higher than the Boiling Point of its Component '" + tMaterial.mMaterial.mNameInternal + "'");
            }
            tMaterial.mMaterial.mAlloyComponentReferences.add(this);
        }
        this.mAlloyCreationRecipes.add(aConfiguration);
        return this;
    }

    public OreDictMaterial setMoleculeConfiguration(IOreDictConfigurationComponent aComponents) {
        this.mComponents = aComponents;
        double tDivider = 0.0;
        double tProtons = 0.0;
        double tElectrons = 0.0;
        double tNeutrons = 0.0;
        double tMass = 0.0;
        double tGramPerCubicCentimeter = 0.0;
        double tMeltingPoint = 0.0;
        double tBoilingPoint = 0.0;
        double tPlasmaPoint = 0.0;
        for (OreDictMaterialStack tMaterial : this.mComponents.getComponents()) {
            tDivider += (double)tMaterial.mAmount;
        }
        for (OreDictMaterialStack tMaterial : this.mComponents.getComponents()) {
            tProtons += (double)(tMaterial.mMaterial.mProtons * tMaterial.mAmount) / 4.200768E8;
            tElectrons += (double)(tMaterial.mMaterial.mElectrons * tMaterial.mAmount) / 4.200768E8;
            tNeutrons += (double)(tMaterial.mMaterial.mNeutrons * tMaterial.mAmount) / 4.200768E8;
            tMass += (double)(tMaterial.mMaterial.mMass * tMaterial.mAmount) / 4.200768E8;
            tGramPerCubicCentimeter += tMaterial.mMaterial.mGramPerCubicCentimeter * (double)tMaterial.mAmount / 4.200768E8;
            tMeltingPoint += (double)(tMaterial.mMaterial.mMeltingPoint * tMaterial.mAmount) / tDivider;
            tBoilingPoint += (double)(tMaterial.mMaterial.mBoilingPoint * tMaterial.mAmount) / tDivider;
            tPlasmaPoint += (double)(tMaterial.mMaterial.mPlasmaPoint * tMaterial.mAmount) / tDivider;
        }
        this.mProtons = (long)tProtons;
        this.mElectrons = (long)tElectrons;
        this.mNeutrons = (long)tNeutrons;
        this.mMass = (long)tMass;
        this.mMeltingPoint = (long)tMeltingPoint;
        this.mBoilingPoint = Math.max(this.mMeltingPoint + 1L, (long)tBoilingPoint);
        this.mPlasmaPoint = Math.max(this.mBoilingPoint + 1L, (long)tPlasmaPoint);
        this.mGramPerCubicCentimeter = tGramPerCubicCentimeter;
        return this;
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1) {
        if (aCommonDivider == 0L) {
            long tAmount = aAmount1;
            aCommonDivider = tAmount / 420076800L;
            if (tAmount % 420076800L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1)));
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2) {
        if (aCommonDivider == 0L) {
            long tAmount = aAmount1 + aAmount2;
            aCommonDivider = tAmount / 420076800L;
            if (tAmount % 420076800L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1), OM.stack(aMaterial2, aAmount2)));
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3) {
        if (aCommonDivider == 0L) {
            long tAmount = aAmount1 + aAmount2 + aAmount3;
            aCommonDivider = tAmount / 420076800L;
            if (tAmount % 420076800L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1), OM.stack(aMaterial2, aAmount2), OM.stack(aMaterial3, aAmount3)));
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4) {
        if (aCommonDivider == 0L) {
            long tAmount = aAmount1 + aAmount2 + aAmount3 + aAmount4;
            aCommonDivider = tAmount / 420076800L;
            if (tAmount % 420076800L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1), OM.stack(aMaterial2, aAmount2), OM.stack(aMaterial3, aAmount3), OM.stack(aMaterial4, aAmount4)));
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5) {
        if (aCommonDivider == 0L) {
            long tAmount = aAmount1 + aAmount2 + aAmount3 + aAmount4 + aAmount5;
            aCommonDivider = tAmount / 420076800L;
            if (tAmount % 420076800L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1), OM.stack(aMaterial2, aAmount2), OM.stack(aMaterial3, aAmount3), OM.stack(aMaterial4, aAmount4), OM.stack(aMaterial5, aAmount5)));
    }

    public OreDictMaterial setMcfg(long aCommonDivider, OreDictMaterial aMaterial1, long aAmount1, OreDictMaterial aMaterial2, long aAmount2, OreDictMaterial aMaterial3, long aAmount3, OreDictMaterial aMaterial4, long aAmount4, OreDictMaterial aMaterial5, long aAmount5, OreDictMaterial aMaterial6, long aAmount6) {
        long tAmount = aAmount1 + aAmount2 + aAmount3 + aAmount4 + aAmount5 + aAmount6;
        if (aCommonDivider == 0L) {
            aCommonDivider = tAmount / 420076800L;
            if (tAmount % 420076800L != 0L) {
                CS.ERR.println("WARNING: Material '" + this.mNameInternal + "' has an Amount of " + tAmount + " Components and automatically generates a divider, that is leaving a tiny rest after the division, breaking some Material Amounts. Manual setting of Variables is required.");
            }
        }
        return this.setMoleculeConfiguration(new OreDictConfigurationComponent(aCommonDivider, OM.stack(aMaterial1, aAmount1), OM.stack(aMaterial2, aAmount2), OM.stack(aMaterial3, aAmount3), OM.stack(aMaterial4, aAmount4), OM.stack(aMaterial5, aAmount5), OM.stack(aMaterial6, aAmount6)));
    }

    public OreDictMaterial setAllToTheOutputOf(OreDictMaterial aMaterial) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.setPulver(aMaterial.mTargetPulver.mMaterial, aMaterial.mTargetPulver.mAmount);
        this.setSmelting(aMaterial.mTargetSmelting.mMaterial, aMaterial.mTargetSmelting.mAmount);
        this.setSolidifying(aMaterial.mTargetSolidifying.mMaterial, aMaterial.mTargetSolidifying.mAmount);
        this.setSmashing(aMaterial.mTargetSmashing.mMaterial, aMaterial.mTargetSmashing.mAmount);
        this.setCutting(aMaterial.mTargetCutting.mMaterial, aMaterial.mTargetCutting.mAmount);
        this.setWorking(aMaterial.mTargetWorking.mMaterial, aMaterial.mTargetWorking.mAmount);
        this.setForging(aMaterial.mTargetForging.mMaterial, aMaterial.mTargetForging.mAmount);
        this.setBurning(aMaterial.mTargetBurning.mMaterial, aMaterial.mTargetBurning.mAmount);
        this.setBending(aMaterial.mTargetBending.mMaterial, aMaterial.mTargetBending.mAmount);
        this.setCompressing(aMaterial.mTargetCompressing.mMaterial, aMaterial.mTargetCompressing.mAmount);
        return this;
    }

    public OreDictMaterial setAllToTheOutputOf(OreDictMaterial aMaterial, long aMultiplier, long aDivider) {
        if (aMaterial == null) {
            aMaterial = this;
        }
        this.setPulver(aMaterial.mTargetPulver.mMaterial, aMaterial.mTargetPulver.mAmount * aMultiplier / aDivider);
        this.setSmelting(aMaterial.mTargetSmelting.mMaterial, aMaterial.mTargetSmelting.mAmount * aMultiplier / aDivider);
        this.setSolidifying(aMaterial.mTargetSolidifying.mMaterial, aMaterial.mTargetSolidifying.mAmount * aMultiplier / aDivider);
        this.setSmashing(aMaterial.mTargetSmashing.mMaterial, aMaterial.mTargetSmashing.mAmount * aMultiplier / aDivider);
        this.setCutting(aMaterial.mTargetCutting.mMaterial, aMaterial.mTargetCutting.mAmount * aMultiplier / aDivider);
        this.setWorking(aMaterial.mTargetWorking.mMaterial, aMaterial.mTargetWorking.mAmount * aMultiplier / aDivider);
        this.setForging(aMaterial.mTargetForging.mMaterial, aMaterial.mTargetForging.mAmount * aMultiplier / aDivider);
        this.setBurning(aMaterial.mTargetBurning.mMaterial, aMaterial.mTargetBurning.mAmount * aMultiplier / aDivider);
        this.setBending(aMaterial.mTargetBending.mMaterial, aMaterial.mTargetBending.mAmount * aMultiplier / aDivider);
        this.setCompressing(aMaterial.mTargetCompressing.mMaterial, aMaterial.mTargetCompressing.mAmount * aMultiplier / aDivider);
        this.setCrushing(aMaterial.mTargetCrushing.mMaterial, aMaterial.mTargetCrushing.mAmount * aMultiplier / aDivider);
        return this;
    }

    public OreDictMaterial setCrushing(OreDictMaterial aMaterial, long aAmount) {
        this.mTargetCrushing = OM.stack(aMaterial == null ? this : aMaterial, aAmount);
        return this;
    }

    public OreDictMaterial setPulver(OreDictMaterial aMaterial, long aAmount) {
        this.mTargetPulver = OM.stack(aMaterial == null ? this : aMaterial, aAmount);
        return this;
    }

    public OreDictMaterial setSmelting(OreDictMaterial aMaterial, long aAmount) {
        this.mTargetSmelting = OM.stack(aMaterial == null ? this : aMaterial, aAmount);
        if (aAmount > 0L) {
            this.add(TD.Processing.MELTING);
        }
        return this;
    }

    public OreDictMaterial setSolidifying(OreDictMaterial aMaterial, long aAmount) {
        this.mTargetSolidifying = OM.stack(aMaterial == null ? this : aMaterial, aAmount);
        return this;
    }

    public OreDictMaterial setSmashing(OreDictMaterial aMaterial, long aAmount) {
        this.mTargetSmashing = OM.stack(aMaterial == null ? this : aMaterial, aAmount);
        return this;
    }

    public OreDictMaterial setCutting(OreDictMaterial aMaterial, long aAmount) {
        this.mTargetCutting = OM.stack(aMaterial == null ? this : aMaterial, aAmount);
        return this;
    }

    public OreDictMaterial setForging(OreDictMaterial aMaterial, long aAmount) {
        this.mTargetForging = OM.stack(aMaterial == null ? this : aMaterial, aAmount);
        return this;
    }

    public OreDictMaterial setWorking(OreDictMaterial aMaterial, long aAmount) {
        this.mTargetWorking = OM.stack(aMaterial == null ? this : aMaterial, aAmount);
        return this;
    }

    public OreDictMaterial setBurning(OreDictMaterial aMaterial, long aAmount) {
        this.mTargetBurning = OM.stack(aMaterial == null ? this : aMaterial, aAmount);
        return this;
    }

    public OreDictMaterial setBending(OreDictMaterial aMaterial, long aAmount) {
        this.mTargetBending = OM.stack(aMaterial == null ? this : aMaterial, aAmount);
        return this;
    }

    public OreDictMaterial setCompressing(OreDictMaterial aMaterial, long aAmount) {
        this.mTargetCompressing = OM.stack(aMaterial == null ? this : aMaterial, aAmount);
        return this;
    }

    public OreDictMaterial setQuality(float aToolSpeed, long aToolDurability, long aToolQuality) {
        this.add(TD.Properties.HAS_TOOL_STATS, TD.ItemGenerator.PARTS, TD.ItemGenerator.STICKS, TD.ItemGenerator.PLATES);
        this.mToolDurability = aToolDurability;
        this.mToolQuality = UT.Code.bind4(aToolQuality);
        this.mToolSpeed = aToolSpeed;
        return this;
    }

    public OreDictMaterial setMeltingPoint(long aMeltingPoint) {
        this.mMeltingPoint = aMeltingPoint;
        this.mBoilingPoint = this.mMeltingPoint * 2L;
        this.mPlasmaPoint = this.mBoilingPoint * 100L;
        return this;
    }

    public OreDictMaterial setStatsEnergetic(long aMeltingPoint, long aBoilingPoint) {
        if (aMeltingPoint > aBoilingPoint) {
            throw new IllegalArgumentException("The Melting Point cannot be above the Boiling Point.");
        }
        this.mMeltingPoint = aMeltingPoint;
        this.mBoilingPoint = aBoilingPoint;
        this.mPlasmaPoint = aBoilingPoint * 100L;
        return this;
    }

    public OreDictMaterial setStatsEnergetic(long aMeltingPoint, long aBoilingPoint, long aPlasmaPoint) {
        if (aMeltingPoint > aBoilingPoint) {
            throw new IllegalArgumentException("The Melting Point cannot be above the Boiling Point.");
        }
        if (aBoilingPoint > aPlasmaPoint) {
            throw new IllegalArgumentException("The Boiling Point cannot be above the Plasmafication Point.");
        }
        this.mMeltingPoint = aMeltingPoint;
        this.mBoilingPoint = aBoilingPoint;
        this.mPlasmaPoint = aPlasmaPoint;
        return this;
    }

    public OreDictMaterial setStats(long aProtonsAndElectrons, long aNeutrons, long aMeltingPoint, long aBoilingPoint, double aGramPerCubicCentimeter) {
        this.setStatsEnergetic(aMeltingPoint, aBoilingPoint);
        this.mProtons = aProtonsAndElectrons;
        this.mElectrons = aProtonsAndElectrons;
        this.mNeutrons = aNeutrons;
        this.mMass = aProtonsAndElectrons + aNeutrons;
        this.mGramPerCubicCentimeter = aGramPerCubicCentimeter;
        return this;
    }

    public OreDictMaterial setStatsElement(long aProtons, long aElectrons, long aNeutrons, long aAdditionalMass, double aGramPerCubicCentimeter) {
        this.mProtons = aProtons;
        this.mElectrons = aElectrons;
        this.mNeutrons = aNeutrons;
        this.mMass = aProtons + aNeutrons + aAdditionalMass;
        this.mGramPerCubicCentimeter = aGramPerCubicCentimeter;
        return this;
    }

    public OreDictMaterial setTextures(TextureSet ... aSets) {
        this.mTextureSetsBlock = aSets[0].mList;
        this.mTextureSetsItems = aSets[1].mList;
        return this;
    }

    public OreDictMaterial setRGBa(long aR, long aG, long aB, long aA) {
        this.mRGBaGas[0] = this.mRGBaPlasma[0] = UT.Code.bind8(aR);
        this.mRGBaLiquid[0] = this.mRGBaPlasma[0];
        this.mRGBaSolid[0] = this.mRGBaPlasma[0];
        this.mRGBaGas[1] = this.mRGBaPlasma[1] = UT.Code.bind8(aG);
        this.mRGBaLiquid[1] = this.mRGBaPlasma[1];
        this.mRGBaSolid[1] = this.mRGBaPlasma[1];
        this.mRGBaGas[2] = this.mRGBaPlasma[2] = UT.Code.bind8(aB);
        this.mRGBaLiquid[2] = this.mRGBaPlasma[2];
        this.mRGBaSolid[2] = this.mRGBaPlasma[2];
        this.mRGBaGas[3] = this.mRGBaPlasma[3] = UT.Code.bind8(aA);
        this.mRGBaLiquid[3] = this.mRGBaPlasma[3];
        this.mRGBaSolid[3] = this.mRGBaPlasma[3];
        return this;
    }

    public OreDictMaterial setRGBaSolid(long aR, long aG, long aB, long aA) {
        this.mRGBaSolid[0] = UT.Code.bind8(aR);
        this.mRGBaSolid[1] = UT.Code.bind8(aG);
        this.mRGBaSolid[2] = UT.Code.bind8(aB);
        this.mRGBaSolid[3] = UT.Code.bind8(aA);
        return this;
    }

    public OreDictMaterial setRGBaLiquid(long aR, long aG, long aB, long aA) {
        this.mRGBaLiquid[0] = UT.Code.bind8(aR);
        this.mRGBaLiquid[1] = UT.Code.bind8(aG);
        this.mRGBaLiquid[2] = UT.Code.bind8(aB);
        this.mRGBaLiquid[3] = UT.Code.bind8(aA);
        return this;
    }

    public OreDictMaterial setRGBaGas(long aR, long aG, long aB, long aA) {
        this.mRGBaGas[0] = UT.Code.bind8(aR);
        this.mRGBaGas[1] = UT.Code.bind8(aG);
        this.mRGBaGas[2] = UT.Code.bind8(aB);
        this.mRGBaGas[3] = UT.Code.bind8(aA);
        return this;
    }

    public OreDictMaterial setRGBaPlasma(long aR, long aG, long aB, long aA) {
        this.mRGBaPlasma[0] = UT.Code.bind8(aR);
        this.mRGBaPlasma[1] = UT.Code.bind8(aG);
        this.mRGBaPlasma[2] = UT.Code.bind8(aB);
        this.mRGBaPlasma[3] = UT.Code.bind8(aA);
        return this;
    }

    public OreDictMaterial steal(OreDictMaterial aStatsToCopy) {
        this.stealStatsEnergetic(aStatsToCopy);
        this.stealStatsElement(aStatsToCopy);
        this.stealQuality(aStatsToCopy);
        return this;
    }

    public OreDictMaterial stealLooks(OreDictMaterial aStatsToCopy) {
        this.mTextureSetsItems = aStatsToCopy.mTextureSetsItems;
        this.mTextureSetsBlock = aStatsToCopy.mTextureSetsBlock;
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            this.mRGBa[i] = aStatsToCopy.mRGBa[i];
            this.mRGBaSolid[i] = aStatsToCopy.mRGBaSolid[i];
            this.mRGBaLiquid[i] = aStatsToCopy.mRGBaLiquid[i];
            this.mRGBaGas[i] = aStatsToCopy.mRGBaGas[i];
            this.mRGBaPlasma[i] = aStatsToCopy.mRGBaPlasma[i];
        }
        return this;
    }

    public OreDictMaterial stealStatsEnergetic(OreDictMaterial aStatsToCopy) {
        this.setStatsEnergetic(aStatsToCopy.mMeltingPoint, aStatsToCopy.mBoilingPoint, aStatsToCopy.mPlasmaPoint);
        return this;
    }

    public OreDictMaterial stealQuality(OreDictMaterial aStatsToCopy) {
        if (aStatsToCopy.contains(TD.Properties.HAS_TOOL_STATS)) {
            this.setQuality(aStatsToCopy.mToolSpeed, aStatsToCopy.mToolDurability, aStatsToCopy.mToolQuality);
        }
        return this;
    }

    public OreDictMaterial stealStatsElement(OreDictMaterial aStatsToCopy) {
        this.mProtons = aStatsToCopy.mProtons;
        this.mElectrons = aStatsToCopy.mElectrons;
        this.mNeutrons = aStatsToCopy.mNeutrons;
        this.mMass = aStatsToCopy.mMass;
        this.mGramPerCubicCentimeter = aStatsToCopy.mGramPerCubicCentimeter;
        return this;
    }

    public OreDictMaterial setDensity(double aGramPerCubicCentimeter) {
        this.mGramPerCubicCentimeter = aGramPerCubicCentimeter;
        return this;
    }

    public OreDictMaterial addAspects(TC.TC_AspectStack ... aAspects) {
        for (TC.TC_AspectStack tAspect : aAspects) {
            tAspect.addToAspectList(this.mAspects);
        }
        return this;
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1) {
        return this.addAspects(TC.stack(aAspect1, aAmount1));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6, TC aAspect7, long aAmount7) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6), TC.stack(aAspect7, aAmount7));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6, TC aAspect7, long aAmount7, TC aAspect8, long aAmount8) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6), TC.stack(aAspect7, aAmount7), TC.stack(aAspect8, aAmount8));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6, TC aAspect7, long aAmount7, TC aAspect8, long aAmount8, TC aAspect9, long aAmount9) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6), TC.stack(aAspect7, aAmount7), TC.stack(aAspect8, aAmount8), TC.stack(aAspect9, aAmount9));
    }

    public OreDictMaterial aspects(TC aAspect1, long aAmount1, TC aAspect2, long aAmount2, TC aAspect3, long aAmount3, TC aAspect4, long aAmount4, TC aAspect5, long aAmount5, TC aAspect6, long aAmount6, TC aAspect7, long aAmount7, TC aAspect8, long aAmount8, TC aAspect9, long aAmount9, TC aAspect0, long aAmount0) {
        return this.addAspects(TC.stack(aAspect1, aAmount1), TC.stack(aAspect2, aAmount2), TC.stack(aAspect3, aAmount3), TC.stack(aAspect4, aAmount4), TC.stack(aAspect5, aAmount5), TC.stack(aAspect6, aAmount6), TC.stack(aAspect7, aAmount7), TC.stack(aAspect8, aAmount8), TC.stack(aAspect9, aAmount9), TC.stack(aAspect0, aAmount0));
    }

    public OreDictMaterial setOreMultiplier(int aMultiplier) {
        this.mOreMultiplier = (byte)Math.max(1, aMultiplier);
        return this;
    }

    public OreDictMaterial setFurnaceBurnTime(long aValue) {
        this.mFurnaceBurnTime = Math.max(0L, aValue);
        return this;
    }

    public OreDictMaterial addEnchantmentForTools(Enchantment aEnchantment, int aEnchantmentLevel) {
        this.mEnchantmentTools.add(new ObjectStack<Enchantment>(aEnchantment, aEnchantmentLevel));
        return this;
    }

    public OreDictMaterial addEnchantmentForArmors(Enchantment aEnchantment, int aEnchantmentLevel) {
        this.mEnchantmentArmors.add(new ObjectStack<Enchantment>(aEnchantment, aEnchantmentLevel));
        return this;
    }

    public void addOreByProducts(OreDictMaterial ... aMaterials) {
        this.mByProducts.addAll(Arrays.asList(aMaterials));
    }

    public OreDictMaterial liquid(FluidStack aFluidStack, long aUnit) {
        if (aFluidStack != null) {
            this.mLiquid = aFluidStack.copy();
            this.mLiquidUnit = aUnit;
            FLUID_MAP.put(aFluidStack.getFluid().getName(), OM.stack(this, UT.Code.units(aFluidStack.amount, aUnit, 420076800L, true)));
        }
        return this;
    }

    public OreDictMaterial gas(FluidStack aFluidStack, long aUnit) {
        if (aFluidStack != null) {
            this.mGas = aFluidStack.copy();
            this.mGasUnit = aUnit;
            FLUID_MAP.put(aFluidStack.getFluid().getName(), OM.stack(this, UT.Code.units(aFluidStack.amount, aUnit, 420076800L, true)));
        }
        return this;
    }

    public OreDictMaterial plasma(FluidStack aFluidStack, long aUnit) {
        if (aFluidStack != null) {
            this.mPlasma = aFluidStack.copy();
            this.mPlasmaUnit = aUnit;
            FLUID_MAP.put(aFluidStack.getFluid().getName(), OM.stack(this, UT.Code.units(aFluidStack.amount, aUnit, 420076800L, true)));
        }
        return this;
    }

    public OreDictMaterial liquid(FluidStack aFluidStack) {
        return this.liquid(aFluidStack, this.mLiquidUnit);
    }

    public OreDictMaterial gas(FluidStack aFluidStack) {
        return this.gas(aFluidStack, this.mGasUnit);
    }

    public OreDictMaterial plasma(FluidStack aFluidStack) {
        return this.plasma(aFluidStack, this.mPlasmaUnit);
    }

    public FluidStack fluid(long aMaterialAmount, boolean aRoundUp) {
        return this.fluid(293L, aMaterialAmount, aRoundUp);
    }

    public FluidStack fluid(long aTemperature, long aMaterialAmount, boolean aRoundUp) {
        if (aTemperature >= this.mPlasmaPoint) {
            return this.plasma(aMaterialAmount, aRoundUp);
        }
        if (aTemperature >= this.mBoilingPoint) {
            return this.gas(aMaterialAmount, aRoundUp);
        }
        if (aTemperature >= this.mMeltingPoint) {
            return this.liquid(aMaterialAmount, aRoundUp);
        }
        return null;
    }

    public FluidStack liquid(long aMaterialAmount, boolean aRoundUp) {
        if (this.mLiquid == null) {
            return null;
        }
        FluidStack rFluid = this.mLiquid.copy();
        rFluid.amount = (int)UT.Code.units(aMaterialAmount, this.mLiquidUnit, rFluid.amount, aRoundUp);
        return rFluid;
    }

    public FluidStack gas(long aMaterialAmount, boolean aRoundUp) {
        if (this.mGas == null) {
            return null;
        }
        FluidStack rFluid = this.mGas.copy();
        rFluid.amount = (int)UT.Code.units(aMaterialAmount, this.mGasUnit, rFluid.amount, aRoundUp);
        return rFluid;
    }

    public FluidStack plasma(long aMaterialAmount, boolean aRoundUp) {
        if (this.mPlasma == null) {
            return null;
        }
        FluidStack rFluid = this.mPlasma.copy();
        rFluid.amount = (int)UT.Code.units(aMaterialAmount, this.mPlasmaUnit, rFluid.amount, aRoundUp);
        return rFluid;
    }

    public long getNeutrons() {
        return this.mNeutrons;
    }

    public long getProtons() {
        return this.mProtons;
    }

    public long getElectrons() {
        return this.mElectrons;
    }

    public long getMass() {
        return this.mMass;
    }

    public double getWeight(long aAmount) {
        return this.mGramPerCubicCentimeter * 111.111111 * (double)aAmount / 4.200768E8;
    }

    public static OreDictMaterial get(String aMaterial) {
        OreDictMaterial tMaterial = MATERIAL_MAP.get(aMaterial);
        if (tMaterial == null) {
            return MT.NULL;
        }
        while (tMaterial != tMaterial.mTargetRegistration) {
            tMaterial = tMaterial.mTargetRegistration;
        }
        return tMaterial;
    }

    public String toString() {
        return this.mNameInternal;
    }

    public int hashCode() {
        return this.mHashID;
    }

    public boolean addListener(IOreDictListenerItem aListener) {
        if (this.mListenersItem.contains(aListener)) {
            return false;
        }
        this.mListenersItem.add(aListener);
        return true;
    }

    public boolean contains(ItemStack ... aStacks) {
        if (aStacks == null) {
            return false;
        }
        for (ItemStack aStack : aStacks) {
            if (!this.mRegisteredItems.contains(aStack, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(TagData aTag) {
        return this.mTags.contains(aTag);
    }

    public boolean containsAny(TagData ... aTags) {
        for (TagData aTag : aTags) {
            if (!this.mTags.contains(aTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(TagData ... aTags) {
        return this.mTags.containsAll(Arrays.asList(aTags));
    }

    @Override
    public boolean containsAll(Collection<TagData> aTags) {
        return this.mTags.containsAll(aTags);
    }

    public OreDictMaterial add(TagData[] aTags1, TagData ... aTags2) {
        this.add(aTags1);
        this.add(aTags2);
        return this;
    }

    @Override
    public OreDictMaterial add(TagData ... aTags) {
        if (aTags != null) {
            for (TagData aTag : aTags) {
                this.mTags.add(aTag);
            }
        }
        return this;
    }

    @Override
    public boolean remove(TagData aTag) {
        return this.mTags.remove(aTag);
    }

    @Override
    public boolean isTrue(OreDictMaterial aObject) {
        return aObject == this;
    }
}

