/*
 * Decompiled with CFR 0.152.
 */
package gregapi.oredict;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregapi.GT_API;
import gregapi.api.Abstract_Mod;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackMap;
import gregapi.code.ItemStackSet;
import gregapi.config.Config;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.oredict.IOreDictItemDataOverrideItem;
import gregapi.oredict.IOreDictListenerEvent;
import gregapi.oredict.IOreDictOptimizedParsingItem;
import gregapi.oredict.IOreDictRecyclableListener;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.OreDictPrefix;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictManager {
    public static final OreDictManager INSTANCE = new OreDictManager();
    private final Set<IOreDictListenerEvent> mGlobalOreDictListeners = new HashSetNoNulls<IOreDictListenerEvent>();
    private final Set<IOreDictListenerEvent.OreDictRegistrationContainer> mGlobalRegistrations = new HashSetNoNulls<IOreDictListenerEvent.OreDictRegistrationContainer>();
    private final Set<IOreDictRecyclableListener> mRecyclableOreDictListeners = new HashSetNoNulls<IOreDictRecyclableListener>();
    private final Set<IOreDictRecyclableListener.OreDictRecyclingContainer> mRecyclableRegistrations = new HashSetNoNulls<IOreDictRecyclableListener.OreDictRecyclingContainer>();
    private final Map<String, Collection<String>> mReRegistrationMappings = new HashMap<String, Collection<String>>();
    private final Map<String, OreDictItemData> mStringToItemDataMappings = new HashMap<String, OreDictItemData>();
    private final Set<String> mUnknownMaterials = new HashSetNoNulls<String>();
    private final Set<String> mUnknownNames = new HashSetNoNulls<String>();
    private final Set<String> mAutoBlackListedNames = new HashSetNoNulls<String>();
    private final Set<String> mAutoBlackListedMods = new HashSetNoNulls<String>();
    private final Set<String> mKnownNames = new HashSetNoNulls<String>();
    private final Set<String> mIgnoredNames = new HashSetNoNulls<String>(Arrays.asList("oreTritanium", "oreDuranium", "plateLapis", "shardEntropy", "shardAir", "shardWater", "shardEarth", "shardFire", "shardOrder", "greggy_greg_do_please_kindly_stuff_a_sock_in_it"));
    private final Set<String> mAlreadyRegisteredNames = new HashSetNoNulls<String>();
    private final Set<ItemStack> mAllRegisteredOres = new HashSetNoNulls<ItemStack>();
    public Config mUnificationConfig;
    private boolean mIsRunningInIterationMode = true;
    private final Set<IOreDictListenerEvent> mBufferedListeners1 = new HashSetNoNulls<IOreDictListenerEvent>();
    private final Set<IOreDictRecyclableListener> mBufferedListeners2 = new HashSetNoNulls<IOreDictRecyclableListener>();
    private List<OreDictEventContainer> mBufferedRegistrations = new ArrayListNoNulls<OreDictEventContainer>();
    private final Map<String, ItemStack> sName2StackMap = new HashMap<String, ItemStack>();
    private final Map<ItemStackContainer, OreDictItemData> sItemStack2DataMap = new ItemStackMap();
    private final ItemStackSet<ItemStackContainer> sNoUnificationSet = new ItemStackSet();
    private int isRegisteringOre = 0;
    private int isAddingOre = 0;

    private OreDictManager() {
        for (String string : OreDictionary.getOreNames()) {
            for (ItemStack tOreStack : OreDictionary.getOres((String)string, (boolean)false)) {
                this.onOreRegistration1(new OreDictionary.OreRegisterEvent(string, tOreStack));
            }
        }
        for (String string : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            this.onFluidContainerRegistration(new FluidContainerRegistry.FluidContainerRegisterEvent((FluidContainerRegistry.FluidContainerData)string));
        }
        this.mIsRunningInIterationMode = false;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void addListener(IOreDictListenerEvent aListener) {
        if (CS.GAPI.mStartedPostInit) {
            this.addListenerInternal(aListener);
        } else {
            this.mBufferedListeners1.add(aListener);
        }
    }

    private void addListenerInternal(IOreDictListenerEvent aListener) {
        if (this.mGlobalOreDictListeners.add(aListener)) {
            for (IOreDictListenerEvent.OreDictRegistrationContainer tEvent : this.mGlobalRegistrations) {
                aListener.onOreRegistration(tEvent);
            }
        }
    }

    public void addListener(IOreDictRecyclableListener aListener) {
        if (CS.GAPI.mStartedPostInit) {
            this.addListenerInternal(aListener);
        } else {
            this.mBufferedListeners2.add(aListener);
        }
    }

    private void addListenerInternal(IOreDictRecyclableListener aListener) {
        if (this.mRecyclableOreDictListeners.add(aListener)) {
            for (IOreDictRecyclableListener.OreDictRecyclingContainer tEvent : this.mRecyclableRegistrations) {
                aListener.onRecycleableRegistration(new IOreDictRecyclableListener.OreDictRecyclingContainer(tEvent));
            }
        }
    }

    public void onPostLoad() {
        if (CS.GAPI.mStartedPostInit) {
            UT.LoadingBar.start("OreDict", 4);
            UT.LoadingBar.step("Unification Entries");
            this.registerUnificationEntries();
            UT.LoadingBar.step("Global Listeners");
            for (IOreDictListenerEvent iOreDictListenerEvent : this.mBufferedListeners1) {
                this.addListenerInternal(iOreDictListenerEvent);
            }
            UT.LoadingBar.step("Prefix Listeners");
            for (OreDictPrefix oreDictPrefix : OreDictPrefix.VALUES) {
                oreDictPrefix.onPostLoad();
            }
            UT.LoadingBar.step("Recycling Listeners");
            for (IOreDictRecyclableListener iOreDictRecyclableListener : this.mBufferedListeners2) {
                this.addListenerInternal(iOreDictRecyclableListener);
            }
            UT.LoadingBar.finish();
        }
    }

    public void fixStacksizes() {
        for (ItemStack tStack : this.mAllRegisteredOres) {
            tStack.field_77994_a = 1;
        }
    }

    public boolean isOreDictItem(ItemStack aStack) {
        return this.mAllRegisteredOres.contains(aStack);
    }

    public boolean addReRegistrationWithReversal(String aOreToReRegister, String aAdditionalName) {
        boolean rResult = this.addReRegistration(aOreToReRegister, aAdditionalName);
        return this.addReRegistration(aAdditionalName, aOreToReRegister) || rResult;
    }

    public boolean addAutoBlackListingForMod(String aAutoBlackListedMod) {
        return this.mAutoBlackListedMods.add(aAutoBlackListedMod);
    }

    public boolean addAutoBlackListing(String aAutoBlackListedString) {
        return this.mAutoBlackListedNames.add(aAutoBlackListedString);
    }

    public boolean addKnownName(String aOreDictName) {
        return this.mKnownNames.add(aOreDictName);
    }

    public boolean addReRegistration(String aOreToReRegister, String aAdditionalName) {
        this.addKnownName(aOreToReRegister);
        this.addKnownName(aAdditionalName);
        if (aOreToReRegister.equals(aAdditionalName)) {
            return false;
        }
        Collection<String> tNames = this.mReRegistrationMappings.get(aOreToReRegister);
        if (tNames == null) {
            tNames = new HashSetNoNulls<String>();
            this.mReRegistrationMappings.put(aOreToReRegister, tNames);
        }
        if (tNames.add(aAdditionalName)) {
            for (ItemStack tOreStack : OreDictionary.getOres((String)aOreToReRegister, (boolean)false)) {
                OreDictionary.registerOre((String)aAdditionalName, (ItemStack)tOreStack);
            }
        }
        return true;
    }

    public boolean setAutomaticItemData(String aOreDictName, OreDictItemData aData) {
        this.addKnownName(aOreDictName);
        this.mStringToItemDataMappings.put(aOreDictName, aData);
        for (ItemStack tStack : OreDictManager.getOres(aOreDictName, false)) {
            this.addItemData_(tStack, OreDictItemData.copy(aData));
        }
        return true;
    }

    public OreDictItemData getAutomaticItemData(String aOreDictName) {
        return OreDictItemData.copy(this.mStringToItemDataMappings.get(aOreDictName));
    }

    public Collection<String> getUnknownMaterials() {
        return new ArrayListNoNulls<String>(this.mUnknownMaterials);
    }

    public Collection<String> getUnknownNames() {
        return new ArrayListNoNulls<String>(this.mUnknownNames);
    }

    public void enableRegistrations() {
        if (CS.GAPI.mStartedInit) {
            List<OreDictEventContainer> tBufferedRegistrations = this.mBufferedRegistrations;
            this.mBufferedRegistrations = null;
            UT.LoadingBar.start("OreDict", tBufferedRegistrations.size());
            for (OreDictEventContainer tContainer : tBufferedRegistrations) {
                UT.LoadingBar.step(tContainer.mEvent.Name);
                this.onOreRegistration2(tContainer.mModID, tContainer.mEvent);
            }
            tBufferedRegistrations.clear();
            UT.LoadingBar.finish();
        }
    }

    @SubscribeEvent
    public void onFluidContainerRegistration(FluidContainerRegistry.FluidContainerRegisterEvent aFluidEvent) {
        if (aFluidEvent.data.filledContainer.func_77973_b() == Items.field_151068_bn && UT.Stacks.meta(aFluidEvent.data.filledContainer) == 0) {
            aFluidEvent.data.fluid.amount = 0;
        }
        this.addToBlacklist(aFluidEvent.data.emptyContainer);
        UT.Fluids.addFluidContainerData(aFluidEvent.data);
    }

    @SubscribeEvent
    public void onOreRegistration1(OreDictionary.OreRegisterEvent aEvent) {
        String aModID;
        ModContainer tContainer = Loader.instance().activeModContainer();
        String string = aModID = tContainer == null || this.mIsRunningInIterationMode ? "UNKNOWN" : tContainer.getModId();
        if (CS.GT != null) {
            if (aModID.equals(MD.TC.mID) && aEvent.Name.toLowerCase().endsWith("uicksilver")) {
                return;
            }
            if (aModID.equals(MD.RoC.mID) && (aEvent.Name.equalsIgnoreCase("pulpWood") || aEvent.Name.equalsIgnoreCase("dustWood") || aEvent.Name.equalsIgnoreCase("dustWheat"))) {
                ItemStack tTargetStack = null;
                ItemStack tFoundStack = null;
                for (ItemStack tStack : OreDictionary.getOres((String)aEvent.Name, (boolean)false)) {
                    if (UT.Stacks.equal(tStack, aEvent.Ore)) {
                        tFoundStack = tStack;
                        continue;
                    }
                    tTargetStack = tStack;
                }
                if (tTargetStack != null) {
                    UT.Stacks.set(tFoundStack, tTargetStack);
                    UT.Stacks.set(aEvent.Ore, tTargetStack);
                }
                return;
            }
        }
        aEvent.Ore.field_77994_a = 1;
        this.mAllRegisteredOres.add(aEvent.Ore);
        if (aEvent.Name.contains(" ")) {
            OreDictionary.registerOre((String)aEvent.Name.replaceAll(" ", ""), (ItemStack)aEvent.Ore);
            return;
        }
        Collection<String> tReRegistrations = this.mReRegistrationMappings.get(aEvent.Name);
        if (tReRegistrations != null) {
            for (String tName : tReRegistrations) {
                OreDictionary.registerOre((String)tName, (ItemStack)aEvent.Ore);
            }
        }
        if (aEvent.Name.contains("|") || aEvent.Name.contains("*") || aEvent.Name.contains(":") || aEvent.Name.contains(".") || aEvent.Name.contains("$")) {
            return;
        }
        if (!this.mIgnoredNames.contains(aEvent.Name)) {
            if (this.mBufferedRegistrations == null) {
                this.onOreRegistration2(aModID, aEvent);
            } else {
                this.mBufferedRegistrations.add(new OreDictEventContainer(aModID, aEvent));
            }
        }
    }

    public void onOreRegistration2(String aModID, OreDictionary.OreRegisterEvent aEvent) {
        OreDictPrefix aPrefix = null;
        OreDictMaterial aMaterial = null;
        if (aEvent.Ore.func_77973_b() instanceof IOreDictOptimizedParsingItem) {
            aPrefix = ((IOreDictOptimizedParsingItem)aEvent.Ore.func_77973_b()).getPrefix(UT.Stacks.meta(aEvent.Ore));
            aMaterial = ((IOreDictOptimizedParsingItem)aEvent.Ore.func_77973_b()).getMaterial(UT.Stacks.meta(aEvent.Ore));
            if (aPrefix == null || aMaterial == null || !aEvent.Name.equals(aPrefix.mNameInternal + aMaterial.mNameInternal)) {
                aPrefix = null;
                aMaterial = null;
            }
        }
        if (this.mAutoBlackListedNames.contains(aEvent.Name) || this.mAutoBlackListedMods.contains(aEvent.Name)) {
            this.addToBlacklist_(aEvent.Ore);
        }
        if (aPrefix == null) {
            aPrefix = OreDictPrefix.get(aEvent.Name);
        }
        this.addItemData_(aEvent.Ore, OreDictItemData.copy(this.mStringToItemDataMappings.get(aEvent.Name)));
        boolean aNotAlreadyRegisteredName = this.mAlreadyRegisteredNames.add(aEvent.Name);
        if (aPrefix == null) {
            if (this.addKnownName(aEvent.Name)) {
                this.mUnknownNames.add(aEvent.Name);
            }
        } else {
            String tName;
            if (aPrefix != aPrefix.mTargetRegistration) {
                OreDictionary.registerOre((String)aEvent.Name.replaceFirst(aPrefix.mNameInternal, aPrefix.mTargetRegistration.mNameInternal), (ItemStack)aEvent.Ore);
                return;
            }
            if (aPrefix.contains(TD.Prefix.UNIFICATABLE_RECIPES)) {
                this.addToBlacklist_(aEvent.Ore);
            }
            if ((tName = aEvent.Name.replaceFirst(aPrefix.mNameInternal, "")).length() > 0) {
                if (aPrefix == OP.dye) {
                    OreDictionary.registerOre((String)"dye", (ItemStack)aEvent.Ore);
                }
                if (aPrefix == OP.gearGt) {
                    OreDictionary.registerOre((String)(OP.gear.mNameInternal + tName), (ItemStack)aEvent.Ore);
                }
                if (aPrefix == OP.plantGtFiber) {
                    OreDictionary.registerOre((String)"itemString", (ItemStack)aEvent.Ore);
                }
                if (aMaterial == null) {
                    aMaterial = OreDictMaterial.MATERIAL_MAP.get(tName);
                }
                if (aPrefix.contains(TD.Prefix.MATERIAL_BASED)) {
                    if (aMaterial == null) {
                        aMaterial = OreDictMaterial.createMaterial(-1, tName, tName).add(TD.Properties.INVALID_MATERIAL, TD.Properties.UNUSED_MATERIAL, TD.Properties.AUTO_BLACKLIST, TD.Properties.AUTO_MATERIAL);
                    }
                    if (aMaterial.contains(TD.Properties.AUTO_MATERIAL) && this.addKnownName(aEvent.Name)) {
                        this.mUnknownMaterials.add(aEvent.Name);
                    }
                    if (aMaterial != aMaterial.mTargetRegistration) {
                        OreDictionary.registerOre((String)(aPrefix.mNameInternal + aMaterial.mTargetRegistration.mNameInternal), (ItemStack)aEvent.Ore);
                    }
                    if (aMaterial.contains(TD.Properties.AUTO_BLACKLIST)) {
                        this.addToBlacklist_(aEvent.Ore);
                    }
                    for (OreDictMaterial tReRegisteredMaterial : aMaterial.mReRegistrations) {
                        OreDictionary.registerOre((String)(aPrefix.mNameInternal + tReRegisteredMaterial.mNameInternal), (ItemStack)aEvent.Ore);
                    }
                    if (!aMaterial.contains(TD.Properties.INVALID_MATERIAL) && aPrefix.contains(TD.Prefix.UNIFICATABLE)) {
                        this.setTarget_(aPrefix, aMaterial, aEvent.Ore, false, true);
                    }
                }
            }
            aPrefix.onOreRegistration(new IOreDictListenerEvent.OreDictRegistrationContainer(aPrefix, aMaterial, aEvent.Name, aEvent.Ore, aEvent, aModID, aNotAlreadyRegisteredName));
        }
        IOreDictListenerEvent.OreDictRegistrationContainer tRegistration = new IOreDictListenerEvent.OreDictRegistrationContainer(aPrefix, aMaterial, aEvent.Name, aEvent.Ore, aEvent, aModID, aNotAlreadyRegisteredName);
        for (IOreDictListenerEvent tListener : this.mGlobalOreDictListeners) {
            tListener.onOreRegistration(tRegistration);
        }
        this.mGlobalRegistrations.add(tRegistration);
    }

    public void addToBlacklist(ItemStack aStack) {
        if (UT.Stacks.valid(aStack)) {
            this.addToBlacklist_(aStack);
        }
    }

    public void addToBlacklist_(ItemStack aStack) {
        OreDictItemData tData;
        if (this.sNoUnificationSet.add(new ItemStackContainer(aStack)) && (tData = this.getItemData_(aStack)) != null) {
            tData.mBlocked = true;
            tData.mBlackListed = true;
        }
    }

    public boolean isBlacklisted(ItemStack aStack) {
        return this.sNoUnificationSet.contains(aStack, true);
    }

    public boolean addTarget(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        return this.setTarget(aPrefix, aMaterial, aStack, false, false);
    }

    public boolean addTarget_(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        return this.setTarget_(aPrefix, aMaterial, aStack, false, false);
    }

    public boolean setTarget(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        return this.setTarget(aPrefix, aMaterial, aStack, true, false);
    }

    public boolean setTarget_(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        return this.setTarget_(aPrefix, aMaterial, aStack, true, false);
    }

    public boolean setTarget(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack, boolean aOverwrite, boolean aAlreadyRegistered) {
        if (aMaterial == null || aPrefix == null || UT.Stacks.invalid(aStack) || UT.Stacks.meta(aStack) == Short.MAX_VALUE) {
            return false;
        }
        return this.setTarget_(aPrefix, aMaterial, aStack, aOverwrite, aAlreadyRegistered);
    }

    public boolean setTarget_(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack, boolean aOverwrite, boolean aAlreadyRegistered) {
        ++this.isAddingOre;
        aStack = UT.Stacks.amount(1L, aStack);
        aStack.func_77982_d(null);
        if (!aAlreadyRegistered) {
            this.registerOre_(aPrefix.mNameInternal + aMaterial.mNameInternal, aStack);
        }
        this.addAssociation_(aPrefix, aMaterial, aStack);
        if (!this.isBlacklisted(aStack) && (aOverwrite || UT.Stacks.invalid(this.sName2StackMap.get(aPrefix.mNameInternal + aMaterial.mNameInternal)))) {
            this.sName2StackMap.put(aPrefix.mNameInternal + aMaterial.mNameInternal, aStack);
        }
        --this.isAddingOre;
        return true;
    }

    public ItemStack getFirstOre(Object aName, long aAmount) {
        if (UT.Code.stringInvalid(aName)) {
            return null;
        }
        ItemStack tStack = this.sName2StackMap.get(aName.toString());
        if (UT.Stacks.valid(tStack)) {
            return UT.Stacks.amount(aAmount, tStack);
        }
        return UT.Stacks.amount(aAmount, OreDictManager.getOres(aName, false).toArray());
    }

    public ItemStack getStack(Object aName, long aAmount) {
        return this.getStack(aName, null, aAmount, true, true);
    }

    public ItemStack getStack(Object aName, ItemStack aReplacement, long aAmount) {
        return this.getStack(aName, aReplacement, aAmount, true, true);
    }

    public ItemStack getStack(OreDictPrefix aPrefix, OreDictMaterial aMaterial, long aAmount) {
        return this.getStack(aPrefix, aMaterial, null, aAmount);
    }

    public ItemStack getStack(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aReplacement, long aAmount) {
        return this.getStack(aPrefix.mNameInternal + aMaterial.mNameInternal, aReplacement, aAmount, false, true);
    }

    public ItemStack getStack(Object aName, ItemStack aReplacement, long aAmount, boolean aMentionPossibleTypos, boolean aNoInvalidAmounts) {
        if (aNoInvalidAmounts && aAmount < 1L) {
            return null;
        }
        if (!this.sName2StackMap.containsKey(aName.toString()) && aMentionPossibleTypos) {
            CS.ERR.println("Unknown Key for Unification, Typo? " + aName);
        }
        return UT.Stacks.amount(aAmount, this.sName2StackMap.get(aName.toString()), this.getFirstOre(aName, aAmount), aReplacement);
    }

    public ItemStack[] setStackArray(boolean aUseBlackList, ItemStack ... aStacks) {
        for (int i = 0; i < aStacks.length; ++i) {
            aStacks[i] = this.getStack(aUseBlackList, aStacks[i]);
        }
        return aStacks;
    }

    public ItemStack[] setStackArray_(boolean aUseBlackList, ItemStack ... aStacks) {
        for (int i = 0; i < aStacks.length; ++i) {
            aStacks[i] = this.getStack_(aUseBlackList, aStacks[i]);
        }
        return aStacks;
    }

    public ItemStack[] getStackArray(boolean aUseBlackList, Object ... aStacks) {
        ItemStack[] rStacks = new ItemStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            rStacks[i] = this.getStack(aUseBlackList, (ItemStack)aStacks[i]);
        }
        return rStacks;
    }

    public ItemStack[] getStackArray_(boolean aUseBlackList, Object ... aStacks) {
        ItemStack[] rStacks = new ItemStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            rStacks[i] = this.getStack_(aUseBlackList, (ItemStack)aStacks[i]);
        }
        return rStacks;
    }

    public ItemStack setStack(boolean aUseBlackList, ItemStack aStack) {
        if (UT.Stacks.invalid(aStack)) {
            return aStack;
        }
        return this.setStack_(aUseBlackList, aStack);
    }

    public ItemStack setStack_(boolean aUseBlackList, ItemStack aStack) {
        ItemStack tStack = this.getStack_(aUseBlackList, aStack);
        if (tStack == null || UT.Stacks.equal(aStack, tStack)) {
            return aStack;
        }
        aStack.func_150996_a(tStack.func_77973_b());
        return UT.Stacks.meta(aStack, UT.Stacks.meta(tStack));
    }

    public ItemStack getStack(boolean aUseBlackList, ItemStack aStack) {
        if (UT.Stacks.invalid(aStack)) {
            return null;
        }
        return this.getStack_(aUseBlackList, aStack);
    }

    public ItemStack getStack_(boolean aUseBlackList, ItemStack aStack) {
        OreDictItemData tAssociation = this.getAssociation_(aStack, false);
        ItemStack rStack = null;
        if (tAssociation == null || aUseBlackList && tAssociation.mBlocked) {
            return UT.Stacks.copy(aStack);
        }
        if (tAssociation.mUnificationTarget == null) {
            tAssociation.mUnificationTarget = this.sName2StackMap.get(tAssociation.toString());
        }
        if (UT.Stacks.invalid(rStack = UT.Stacks.amount(aStack.field_77994_a, tAssociation.mUnificationTarget))) {
            return UT.Stacks.copy(aStack);
        }
        rStack.func_77982_d(aStack.func_77978_p());
        return rStack;
    }

    public boolean equal(boolean aUseBlackList, ItemStack aUnificatableStack, ItemStack aStackToCheckAgainst) {
        if (UT.Stacks.invalid(aUnificatableStack) || UT.Stacks.invalid(aStackToCheckAgainst)) {
            return false;
        }
        return this.equal_(aUseBlackList, aUnificatableStack, aStackToCheckAgainst);
    }

    public boolean equal_(boolean aUseBlackList, ItemStack aUnificatableStack, ItemStack aStackToCheckAgainst) {
        if (UT.Stacks.equal(aUnificatableStack, aStackToCheckAgainst, true)) {
            return true;
        }
        OreDictItemData tAssociation = this.getAssociation_(aUnificatableStack, true);
        if (tAssociation == null || aUseBlackList && tAssociation.mBlocked) {
            return false;
        }
        if (tAssociation.mUnificationTarget == null) {
            tAssociation.mUnificationTarget = this.sName2StackMap.get(tAssociation.toString());
        }
        return UT.Stacks.valid(tAssociation.mUnificationTarget) && UT.Stacks.equal(tAssociation.mUnificationTarget, aStackToCheckAgainst, true);
    }

    public boolean addItemData(ItemStack aStack, OreDictItemData aData) {
        if (UT.Stacks.invalid(aStack)) {
            return false;
        }
        if (this.getItemData_(aStack) == null) {
            return this.setItemData_(aStack, aData);
        }
        return false;
    }

    public boolean addItemData_(ItemStack aStack, OreDictItemData aData) {
        if (this.getItemData_(aStack) == null && aData != null) {
            return this.setItemData_(aStack, aData);
        }
        return false;
    }

    public boolean setItemData(ItemStack aStack, OreDictItemData aData) {
        if (UT.Stacks.invalid(aStack) || aData == null) {
            return false;
        }
        return this.setItemData_(aStack, aData);
    }

    public boolean setItemData_(ItemStack aStack, OreDictItemData aData) {
        if (this.getAssociation_(aStack, false) != null) {
            return false;
        }
        if (aStack.field_77994_a > 1) {
            if (aData.mMaterial != null) {
                aData.mMaterial.mAmount /= (long)aStack.field_77994_a;
            }
            for (OreDictMaterialStack tMaterial : aData.mByProducts) {
                tMaterial.mAmount /= (long)aStack.field_77994_a;
            }
            aStack = UT.Stacks.amount(1L, aStack);
        }
        if (!aData.mBlackListed) {
            aData.mBlackListed = this.isBlacklisted(aStack);
        }
        if (!aData.mBlocked) {
            aData.mBlocked = aData.mBlackListed || UT.Stacks.block(aStack) != CS.NB || UT.Fluids.getFluidForFilledItem(aStack, true) != null || aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0;
        }
        this.sItemStack2DataMap.put(new ItemStackContainer(aStack), aData);
        if (aData.hasValidMaterialData()) {
            long tValidMaterialAmount = aData.mMaterial.mMaterial.contains(TD.Processing.UNRECYCLABLE) ? 0L : (aData.mMaterial.mAmount >= 0L ? aData.mMaterial.mAmount : 420076800L);
            for (OreDictMaterialStack tMaterial : aData.mByProducts) {
                tValidMaterialAmount += tMaterial.mMaterial.contains(TD.Processing.UNRECYCLABLE) ? 0L : (tMaterial.mAmount >= 0L ? tMaterial.mAmount : 420076800L);
            }
            if (tValidMaterialAmount < 420076800L && GT_API.sCompatIC2 != null) {
                GT_API.sCompatIC2.blacklist(aStack);
            }
        }
        if (!aData.hasValidPrefixData() || aData.mPrefix.contains(TD.Prefix.RECYCLABLE)) {
            IOreDictRecyclableListener.OreDictRecyclingContainer tRegistration = new IOreDictRecyclableListener.OreDictRecyclingContainer(aStack, aData);
            for (IOreDictRecyclableListener tListener : this.mRecyclableOreDictListeners) {
                tListener.onRecycleableRegistration(tRegistration);
            }
            this.mRecyclableRegistrations.add(tRegistration);
        }
        return true;
    }

    public OreDictItemData getItemData(ItemStack aStack) {
        return this.getItemData(aStack, false);
    }

    public OreDictItemData getItemData_(ItemStack aStack) {
        return this.getItemData_(aStack, false);
    }

    public OreDictItemData getItemData(ItemStack aStack, boolean aAllowOverride) {
        if (UT.Stacks.invalid(aStack)) {
            return null;
        }
        return this.getItemData_(aStack, aAllowOverride);
    }

    public OreDictItemData getItemData_(ItemStack aStack, boolean aAllowOverride) {
        OreDictItemData rData = null;
        if (aAllowOverride) {
            List<OreDictMaterialStack> tList;
            OreDictItemData tData = null;
            NBTTagCompound tNBT = aStack.func_77978_p();
            if (tNBT != null && tNBT.func_74764_b("gt.recycling.mats") && !(tList = OreDictMaterialStack.loadList("gt.recycling.mats", tNBT)).isEmpty()) {
                rData = new OreDictItemData(tList.remove(0), tList.toArray(CS.ZL_MATERIALSTACK));
            }
            if (aStack.func_77973_b() instanceof IOreDictItemDataOverrideItem) {
                tData = ((IOreDictItemDataOverrideItem)aStack.func_77973_b()).getOreDictItemData(aStack);
            }
            if (tData != null) {
                return rData != null ? new OreDictItemData(tData, rData) : tData;
            }
            if (rData != null) {
                return rData;
            }
        }
        if ((rData = this.sItemStack2DataMap.get(new ItemStackContainer(aStack))) != null) {
            return rData;
        }
        rData = this.sItemStack2DataMap.get(new ItemStackContainer(UT.Stacks.copyMeta(32767L, aStack)));
        if (rData != null) {
            return rData;
        }
        if (aAllowOverride && aStack.func_77973_b().func_77645_m() && (rData = this.sItemStack2DataMap.get(new ItemStackContainer(UT.Stacks.copyMeta(0L, aStack)))) != null && rData.mUseVanillaDamage) {
            OreDictMaterialStack[] tByProducts = new OreDictMaterialStack[rData.mByProducts.length];
            for (int i = 0; i < tByProducts.length; ++i) {
                tByProducts[i] = OM.stack(rData.mByProducts[i].mMaterial, UT.Code.units(aStack.func_77958_k() - aStack.func_77960_j(), aStack.func_77958_k(), rData.mByProducts[i].mAmount, false));
            }
            rData = new OreDictItemData(OM.stack(rData.mMaterial.mMaterial, UT.Code.units(aStack.func_77958_k() - aStack.func_77960_j(), aStack.func_77958_k(), rData.mMaterial.mAmount, false)), tByProducts);
        }
        return rData;
    }

    public boolean addAssociation(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        if (aPrefix == null || aMaterial == null || UT.Stacks.invalid(aStack)) {
            return false;
        }
        return this.addAssociation_(aPrefix, aMaterial, aStack);
    }

    public boolean addAssociation_(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        if (UT.Stacks.meta(aStack) == Short.MAX_VALUE) {
            for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
                this.setItemData_(UT.Stacks.copyAmountAndMeta(1L, i, aStack), new OreDictItemData(aPrefix, aMaterial));
            }
        }
        return this.setItemData_(aStack, new OreDictItemData(aPrefix, aMaterial));
    }

    public OreDictItemData getAssociation(ItemStack aStack, boolean aOverwrite) {
        if (UT.Stacks.invalid(aStack)) {
            return null;
        }
        return this.getAssociation_(aStack, aOverwrite);
    }

    public OreDictItemData getAssociation_(ItemStack aStack, boolean aOverwrite) {
        OreDictItemData rData = this.getItemData_(aStack, aOverwrite);
        return rData != null && rData.hasValidPrefixMaterialData() ? rData : null;
    }

    public static boolean isItemStackInstanceOf(ItemStack aStack, Object aName) {
        if (UT.Code.stringInvalid(aName) || UT.Stacks.invalid(aStack)) {
            return false;
        }
        return OreDictManager.isItemStackInstanceOf_(aStack, aName);
    }

    public static boolean isItemStackInstanceOf_(ItemStack aStack, Object aName) {
        for (ItemStack tOreStack : OreDictManager.getOres(aName.toString(), false)) {
            if (!UT.Stacks.equal(tOreStack, aStack, true)) continue;
            return true;
        }
        return false;
    }

    public boolean registerOre(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        if (UT.Stacks.invalid(aStack)) {
            return false;
        }
        return this.registerOre_(aPrefix, aMaterial, aStack);
    }

    public boolean registerOre_(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack) {
        return this.registerOre_(aPrefix.mNameInternal + aMaterial.mNameInternal, aStack);
    }

    public boolean registerOre(Object aName, ItemStack aStack) {
        if (UT.Code.stringInvalid(aName) || UT.Stacks.invalid(aStack)) {
            return false;
        }
        return this.registerOre_(aName, aStack);
    }

    public boolean registerOre_(Object aName, ItemStack aStack) {
        if (Abstract_Mod.sStartedPostInit > 0) {
            throw new IllegalStateException("Late OreDict Registration using GT OreDict Utility. Only @Init and @PreInit are allowed for this when you use this Function instead of the Forge one.");
        }
        String tName = aName.toString();
        if (UT.Code.stringInvalid(tName)) {
            return false;
        }
        List<ItemStack> tList = OreDictManager.getOres(tName, false);
        for (int i = 0; i < tList.size(); ++i) {
            if (!UT.Stacks.equal(tList.get(i), aStack, true)) continue;
            return false;
        }
        ++this.isRegisteringOre;
        OreDictionary.registerOre((String)tName, (ItemStack)UT.Stacks.amount(1L, aStack));
        --this.isRegisteringOre;
        return true;
    }

    public boolean isRegisteringOres() {
        return this.isRegisteringOre > 0;
    }

    public boolean isAddingOres() {
        return this.isAddingOre > 0;
    }

    private void registerUnificationEntries() {
        for (OreDictItemData tPrefixMaterial : this.sItemStack2DataMap.values()) {
            tPrefixMaterial.mUnificationTarget = null;
        }
        for (IOreDictListenerEvent.OreDictRegistrationContainer tEvent : this.mGlobalRegistrations) {
            if (tEvent.mPrefix == null || tEvent.mMaterial == null || !tEvent.mPrefix.contains(TD.Prefix.UNIFICATABLE) || tEvent.mMaterial.contains(TD.Properties.INVALID_MATERIAL)) continue;
            this.addAssociation_(tEvent.mPrefix, tEvent.mMaterial, tEvent.mStack);
            this.setTarget_(tEvent.mPrefix, tEvent.mMaterial, tEvent.mStack, this.mUnificationConfig.get((Object)("specialunificationtargets." + tEvent.mModName), tEvent.mEvent.Name, false), true);
        }
    }

    public static List<ItemStack> getOres(OreDictPrefix aPrefix, OreDictMaterial aMaterial, boolean aTransformWildcardBlocksTo16) {
        return OreDictManager.getOres(aPrefix.mNameInternal + aMaterial.mNameInternal, aTransformWildcardBlocksTo16);
    }

    public static List<ItemStack> getOres(Object aOreName, boolean aTransformWildcardBlocksTo16) {
        String aName = aOreName == null ? "" : aOreName.toString();
        ArrayListNoNulls<ItemStack> rList = new ArrayListNoNulls<ItemStack>();
        if (UT.Code.stringValid(aName)) {
            if (aTransformWildcardBlocksTo16) {
                List tList = OreDictionary.getOres((String)aName, (boolean)false);
                for (ItemStack tStack : tList) {
                    if (UT.Stacks.meta(tStack) == Short.MAX_VALUE && UT.Stacks.block(tStack) != CS.NB) {
                        for (int i = 0; i < 16; ++i) {
                            rList.add(UT.Stacks.make(tStack.func_77973_b(), 1L, (long)i));
                        }
                        continue;
                    }
                    rList.add(tStack);
                }
            } else {
                rList.addAll(OreDictionary.getOres((String)aName, (boolean)false));
            }
        }
        return rList;
    }

    private static class OreDictEventContainer {
        protected final String mModID;
        protected final OreDictionary.OreRegisterEvent mEvent;

        protected OreDictEventContainer(String aModID, OreDictionary.OreRegisterEvent aEvent) {
            this.mModID = aModID;
            this.mEvent = aEvent;
        }
    }
}

