/*
 * Decompiled with CFR 0.152.
 */
package gregapi.oredict;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.LH;
import gregapi.lang.LanguageHandler;
import gregapi.oredict.IOreDictListenerItem;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public class OreDictListenerItem_Washing
extends IOreDictListenerItem.OreDictListenerItem {
    private final OreDictPrefix mItemToGet;
    private final OreDictPrefix[] mByProductPrefixes;
    private final int mChance;

    public OreDictListenerItem_Washing(OreDictPrefix aItemToGet, int aChance, OreDictPrefix ... aByProductPrefixes) {
        LH.add("gt.behaviour.washing", "Throw into Cauldron to clean this Item");
        this.mByProductPrefixes = aByProductPrefixes;
        this.mItemToGet = aItemToGet;
        this.mChance = aChance;
    }

    @Override
    public ItemStack onTickWorld(OreDictPrefix aPrefix, OreDictMaterial aMaterial, ItemStack aStack, EntityItem aItem) {
        if (aMaterial != null) {
            ItemStack tStack;
            int tX = MathHelper.func_76128_c((double)aItem.field_70165_t);
            int tY = MathHelper.func_76128_c((double)aItem.field_70163_u);
            int tZ = MathHelper.func_76128_c((double)aItem.field_70161_v);
            Block tBlock = aItem.field_70170_p.func_147439_a(tX, tY, tZ);
            byte tMetaData = (byte)aItem.field_70170_p.func_72805_g(tX, tY, tZ);
            if (tBlock instanceof BlockCauldron && tMetaData > 0 && (tStack = this.mItemToGet.mat(aMaterial, 1L)) != null) {
                ((BlockCauldron)tBlock).func_150024_a(aItem.field_70170_p, tX, tY, tZ, tMetaData - 1);
                if (this.mByProductPrefixes.length > 0 && aItem.field_70170_p.field_73012_v.nextInt(this.mChance) > 0) {
                    ArrayListNoNulls<ItemStack> tStacks = new ArrayListNoNulls<ItemStack>();
                    for (OreDictPrefix tPrefix : this.mByProductPrefixes) {
                        tStacks.add(tPrefix.mat(aMaterial.mByProducts.size() > 0 ? UT.Code.selectInList(aItem.field_70170_p.field_73012_v.nextInt(aMaterial.mByProducts.size()), aMaterial, aMaterial.mByProducts) : aMaterial, 1L));
                    }
                    if (tStacks.size() > 0) {
                        aItem.field_70170_p.func_72838_d((Entity)new EntityItem(aItem.field_70170_p, aItem.field_70165_t, aItem.field_70163_u, aItem.field_70161_v, (ItemStack)tStacks.get(aItem.field_70170_p.field_73012_v.nextInt(tStacks.size()))));
                    }
                }
                aItem.field_70170_p.func_72838_d((Entity)new EntityItem(aItem.field_70170_p, aItem.field_70165_t, aItem.field_70163_u, aItem.field_70161_v, tStack));
                return aStack.field_77994_a > 1 ? UT.Stacks.amount(aStack.field_77994_a - 1, aStack) : null;
            }
        }
        return aStack;
    }

    @Override
    public String getListenerToolTip(ItemStack aStack) {
        return LanguageHandler.translate("gt.behaviour.washing", "Throw into Cauldron to clean this Item");
    }
}

