/*
 * Decompiled with CFR 0.152.
 */
package gregapi.oredict;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.OreDictPrefix;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.item.ItemStack;

public class OreDictItemData {
    public boolean mBlackListed = false;
    public boolean mBlocked = false;
    public boolean mUseVanillaDamage = false;
    public ItemStack mUnificationTarget = null;
    public final OreDictPrefix mPrefix;
    public final OreDictMaterialStack mMaterial;
    public final OreDictMaterialStack[] mByProducts;

    public OreDictItemData(OreDictPrefix aPrefix, OreDictMaterial aMaterial) {
        this.mPrefix = aPrefix;
        this.mMaterial = aMaterial == null ? null : OM.stack(aMaterial, aPrefix.mAmount);
        this.mByProducts = aPrefix.mByProducts.isEmpty() ? CS.ZL_MATERIALSTACK : aPrefix.mByProducts.toArray(CS.ZL_MATERIALSTACK);
    }

    public OreDictItemData(OreDictMaterialStack aMaterial, OreDictMaterialStack ... aByProducts) {
        this.mPrefix = null;
        this.mMaterial = aMaterial == null ? null : aMaterial.clone();
        this.mBlackListed = true;
        if (aByProducts == null) {
            this.mByProducts = CS.ZL_MATERIALSTACK;
        } else {
            int i;
            OreDictMaterialStack[] tByProducts = aByProducts.length < 1 ? CS.ZL_MATERIALSTACK : new OreDictMaterialStack[aByProducts.length];
            int j = 0;
            for (i = 0; i < aByProducts.length; ++i) {
                if (aByProducts[i] == null) continue;
                tByProducts[j++] = aByProducts[i].clone();
            }
            this.mByProducts = j > 0 ? new OreDictMaterialStack[j] : CS.ZL_MATERIALSTACK;
            for (i = 0; i < this.mByProducts.length; ++i) {
                this.mByProducts[i] = tByProducts[i];
            }
        }
    }

    public OreDictItemData(OreDictMaterial aMaterial, long aAmount, OreDictMaterialStack ... aByProducts) {
        this(OM.stack(aMaterial, aAmount), aByProducts);
    }

    public OreDictItemData(OreDictMaterial aMaterial, long aAmount, OreDictMaterial aByProduct, long aByProductAmount) {
        this(OM.stack(aMaterial, aAmount), OM.stack(aByProduct, aByProductAmount));
    }

    public OreDictItemData(Collection<OreDictItemData> aData) {
        this(aData.toArray(CS.ZL_OREDICTITEMDATA));
    }

    public OreDictItemData(OreDictItemData ... aData) {
        this.mPrefix = null;
        this.mBlackListed = true;
        ArrayListNoNulls<OreDictMaterialStack> aList = new ArrayListNoNulls<OreDictMaterialStack>();
        ArrayListNoNulls<OreDictMaterialStack> rList = new ArrayListNoNulls<OreDictMaterialStack>();
        for (OreDictItemData tData : aData) {
            if (tData == null) continue;
            if (tData.hasValidMaterialData() && tData.mMaterial.mAmount > 0L) {
                ((ArrayList)aList).add(tData.mMaterial.clone());
            }
            for (OreDictMaterialStack tMaterial : tData.mByProducts) {
                if (tMaterial.mAmount <= 0L) continue;
                ((ArrayList)aList).add(tMaterial.clone());
            }
        }
        for (OreDictMaterialStack aMaterial : aList) {
            boolean temp = true;
            for (OreDictMaterialStack tMaterial : rList) {
                if (aMaterial.mMaterial != tMaterial.mMaterial) continue;
                tMaterial.mAmount += aMaterial.mAmount;
                temp = false;
                break;
            }
            if (!temp) continue;
            ((ArrayList)rList).add(aMaterial.clone());
        }
        Collections.sort(rList, new Comparator<OreDictMaterialStack>(){

            @Override
            public int compare(OreDictMaterialStack a, OreDictMaterialStack b) {
                return a.mAmount == b.mAmount ? 0 : (a.mAmount > b.mAmount ? -1 : 1);
            }
        });
        if (rList.isEmpty()) {
            this.mMaterial = null;
        } else {
            this.mMaterial = (OreDictMaterialStack)rList.get(0);
            rList.remove(0);
        }
        this.mByProducts = rList.toArray(CS.ZL_MATERIALSTACK);
    }

    public boolean hasValidPrefixMaterialData() {
        return this.mPrefix != null && this.mMaterial != null;
    }

    public boolean hasValidPrefixData() {
        return this.mPrefix != null;
    }

    public boolean hasValidMaterialData() {
        return this.mMaterial != null;
    }

    public List<OreDictMaterialStack> getAllMaterialStacks() {
        ArrayListNoNulls<OreDictMaterialStack> rList = new ArrayListNoNulls<OreDictMaterialStack>(this.mByProducts.length + 1);
        if (this.hasValidMaterialData()) {
            rList.add(this.mMaterial);
        }
        rList.addAll(Arrays.asList(this.mByProducts));
        return rList;
    }

    public OreDictMaterialStack getByProduct(int aIndex) {
        return aIndex >= 0 && aIndex < this.mByProducts.length ? this.mByProducts[aIndex] : null;
    }

    public ItemStack getStack(long aAmount) {
        return this.mUnificationTarget == null ? this.mPrefix.mat(this.mMaterial.mMaterial, aAmount) : UT.Stacks.amount(aAmount, this.mUnificationTarget);
    }

    public String toString() {
        if (this.mPrefix == null || this.mMaterial == null) {
            return "";
        }
        return this.mPrefix.mNameInternal + this.mMaterial.mMaterial.mNameInternal;
    }

    public OreDictItemData setUseVanillaDamage() {
        this.mUseVanillaDamage = true;
        return this;
    }

    public static OreDictItemData copy(OreDictItemData aData) {
        return aData == null ? null : aData.copy();
    }

    public OreDictItemData copy() {
        OreDictItemData rData = this.mPrefix == null ? new OreDictItemData(this.mMaterial, this.mByProducts) : new OreDictItemData(this.mPrefix, this.mMaterial.mMaterial);
        rData.mUnificationTarget = this.mUnificationTarget;
        rData.mUseVanillaDamage = this.mUseVanillaDamage;
        rData.mBlackListed = this.mBlackListed;
        rData.mBlocked = this.mBlocked;
        return rData;
    }
}

