/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network.packets;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import gregapi.network.INetworkHandler;
import gregapi.network.packets.PacketCoordinates;
import gregapi.util.UT;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;

public class PacketSound
extends PacketCoordinates {
    private String mSoundName;
    private float mSoundStrength;
    private float mSoundPitch;

    public PacketSound(int aDecoderType) {
        super(aDecoderType);
    }

    public PacketSound(String aSoundName, float aSoundStrength, float aSoundPitch, ChunkCoordinates aCoords) {
        super(aCoords);
        this.mSoundName = aSoundName;
        this.mSoundStrength = aSoundStrength;
        this.mSoundPitch = aSoundPitch;
    }

    public PacketSound(String aSoundName, float aSoundStrength, float aSoundPitch, int aX, int aY, int aZ) {
        super(aX, aY, aZ);
        this.mSoundName = aSoundName;
        this.mSoundStrength = aSoundStrength;
        this.mSoundPitch = aSoundPitch;
    }

    @Override
    public byte getPacketIDOffset() {
        return -128;
    }

    @Override
    public ByteArrayDataOutput encode2(ByteArrayDataOutput aData) {
        aData.writeUTF(this.mSoundName);
        aData.writeFloat(this.mSoundStrength);
        aData.writeFloat(this.mSoundPitch);
        return aData;
    }

    @Override
    public PacketCoordinates decode2(int aX, int aY, int aZ, ByteArrayDataInput aData) {
        return new PacketSound(aData.readUTF(), aData.readFloat(), aData.readFloat(), aX, aY, aZ);
    }

    @Override
    public void process(IBlockAccess aWorld, INetworkHandler aNetworkHandler) {
        UT.Sounds.play(this.mSoundName, 10, this.mSoundStrength, this.mSoundPitch, this.mX, this.mY, this.mZ);
    }
}

