/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network.packets;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import gregapi.GT_API;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.util.UT;
import java.io.IOException;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class PacketItemStackChat
implements IPacket {
    private ItemStack mStack;

    public PacketItemStackChat() {
    }

    public PacketItemStackChat(ItemStack aStack) {
        this.mStack = aStack;
    }

    @Override
    public byte getPacketID() {
        return 125;
    }

    @Override
    public ByteArrayDataOutput encode() {
        ByteArrayDataOutput aData = ByteStreams.newDataOutput();
        aData.writeShort((int)UT.Stacks.id(this.mStack));
        aData.writeByte(this.mStack.field_77994_a);
        aData.writeShort((int)UT.Stacks.meta(this.mStack));
        NBTTagCompound tNBT = this.mStack.func_77978_p();
        if (tNBT == null) {
            aData.writeShort(-1);
        } else {
            try {
                byte[] tData = CompressedStreamTools.func_74798_a((NBTTagCompound)tNBT);
                aData.writeShort(tData.length);
                aData.write(tData);
            }
            catch (IOException e) {
                e.printStackTrace(CS.ERR);
            }
        }
        return aData;
    }

    @Override
    public IPacket decode(ByteArrayDataInput aData) {
        return new PacketItemStackChat(UT.Stacks.make(Item.func_150899_d((int)aData.readShort()), (long)aData.readByte(), (long)aData.readShort(), this.readNBTTagCompoundFromBuffer(aData)));
    }

    public NBTTagCompound readNBTTagCompoundFromBuffer(ByteArrayDataInput aData) {
        short tLength = aData.readShort();
        if (tLength <= 0) {
            return null;
        }
        byte[] tData = new byte[tLength];
        aData.readFully(tData);
        try {
            return CompressedStreamTools.func_152457_a((byte[])tData, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException e) {
            e.printStackTrace(CS.ERR);
            return null;
        }
    }

    @Override
    public void process(IBlockAccess aWorld, INetworkHandler aNetworkHandler) {
        UT.Entities.chat((Object)GT_API.api_proxy.getThePlayer(), this.mStack.func_151000_E());
        List tList = this.mStack.func_82840_a(GT_API.api_proxy.getThePlayer(), false);
        if (tList != null && !tList.isEmpty()) {
            tList.remove(0);
            tList.remove(LH.Chat.DGRAY + "Can be placed inside a GT Bookshelf");
            UT.Entities.chat((Object)GT_API.api_proxy.getThePlayer(), tList, false);
        }
    }
}

