/*
 * Decompiled with CFR 0.152.
 */
package gregapi.lang;

import cpw.mods.fml.common.registry.LanguageRegistry;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.util.UT;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class LanguageHandler {
    public static Configuration sLangFile;
    private static final HashMap<String, String> TEMPMAP;
    private static final HashMap<String, String> BUFFERMAP;
    private static boolean mWritingEnabled;
    private static boolean mUseFile;

    public static void save() {
        if (sLangFile != null) {
            mWritingEnabled = true;
            sLangFile.save();
        }
    }

    public static synchronized void add(String aKey, String aEnglish) {
        if (aKey == null) {
            return;
        }
        aKey = aKey.trim();
        if (sLangFile == null) {
            BUFFERMAP.put(aKey, aEnglish);
        } else {
            Property tProperty;
            if (!BUFFERMAP.isEmpty()) {
                mUseFile = sLangFile.get("EnableLangFile", "UseThisFileAsLanguageFile", false).getBoolean(false);
                for (Map.Entry<String, String> tEntry : BUFFERMAP.entrySet()) {
                    Property tProperty2 = sLangFile.get("LanguageFile", tEntry.getKey(), tEntry.getValue());
                    TEMPMAP.put(tEntry.getKey(), mUseFile ? tProperty2.getString() : tEntry.getValue());
                    LanguageRegistry.instance().injectLanguage("en_US", TEMPMAP);
                    TEMPMAP.clear();
                }
                if (mWritingEnabled) {
                    sLangFile.save();
                }
                BUFFERMAP.clear();
            }
            if (!(tProperty = sLangFile.get("LanguageFile", aKey, aEnglish)).wasRead() && mWritingEnabled) {
                sLangFile.save();
            }
            TEMPMAP.put(aKey, mUseFile ? tProperty.getString() : aEnglish);
            LanguageRegistry.instance().injectLanguage("en_US", TEMPMAP);
            TEMPMAP.clear();
        }
    }

    public static String get(String aKey, String aDefault) {
        LanguageHandler.add(aKey, aDefault);
        return LanguageHandler.translate(aKey, aDefault);
    }

    public static String translate(String aKey) {
        return LanguageHandler.translate(aKey, aKey);
    }

    public static String translate(String aKey, String aDefault) {
        if (aKey == null) {
            return "";
        }
        aKey = aKey.trim();
        String rTranslation = LanguageRegistry.instance().getStringLocalization(aKey);
        if (UT.Code.stringInvalid(rTranslation) && (UT.Code.stringInvalid(rTranslation = StatCollector.func_74838_a((String)aKey)) || aKey.equals(rTranslation)) && (aKey.endsWith(".name") ? UT.Code.stringInvalid(rTranslation = StatCollector.func_74838_a((String)(aKey = aKey.substring(0, aKey.length() - 5)))) || aKey.equals(rTranslation) : UT.Code.stringInvalid(rTranslation = StatCollector.func_74838_a((String)(aKey = aKey + ".name"))) || aKey.equals(rTranslation))) {
            return aDefault;
        }
        return rTranslation;
    }

    public static String separate(String aKey, String aSeparator) {
        if (aKey == null) {
            return "";
        }
        String rTranslation = "";
        for (String tString : aKey.split(aSeparator)) {
            rTranslation = rTranslation + LanguageHandler.get(tString, tString);
        }
        return rTranslation;
    }

    public static String getTranslateableItemStackName(ItemStack aStack) {
        String tName;
        if (UT.Stacks.invalid(aStack)) {
            return "null";
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT != null && tNBT.func_74764_b("display") && UT.Code.stringValid(tName = tNBT.func_74775_l("display").func_74779_i("Name"))) {
            return tName;
        }
        return aStack.func_77977_a() + ".name";
    }

    public static String getLocalName(OreDictPrefix aPrefix, OreDictMaterial aMaterial) {
        if (aPrefix == OP.crateGtGem || aPrefix == OP.blockGem) {
            return aPrefix.mMaterialPre + LanguageHandler.getLocalName(OP.gem, aMaterial);
        }
        if (aPrefix == OP.crateGtDust || aPrefix == OP.blockDust) {
            return aPrefix.mMaterialPre + LanguageHandler.getLocalName(OP.dust, aMaterial);
        }
        if (aPrefix == OP.crateGtIngot || aPrefix == OP.blockIngot) {
            return aPrefix.mMaterialPre + LanguageHandler.getLocalName(OP.ingot, aMaterial);
        }
        if (aPrefix == OP.crateGtPlate || aPrefix == OP.blockPlate) {
            return aPrefix.mMaterialPre + LanguageHandler.getLocalName(OP.plate, aMaterial);
        }
        if (aPrefix == OP.crateGtPlateGem || aPrefix == OP.blockPlateGem) {
            return aPrefix.mMaterialPre + LanguageHandler.getLocalName(OP.plateGem, aMaterial);
        }
        if (aMaterial == MT.Empty) {
            if (aPrefix == OP.chemtube) {
                return "Empty Glass Tube";
            }
        } else if (aMaterial == MT.Glass) {
            if (aPrefix.mNameInternal.startsWith("gem")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Crystal";
            }
            if (aPrefix.mNameInternal.startsWith("plate")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Pane";
            }
        } else if (aMaterial == MT.InfusedAir || aMaterial == MT.InfusedDull || aMaterial == MT.InfusedEarth || aMaterial == MT.InfusedEntropy || aMaterial == MT.InfusedFire || aMaterial == MT.InfusedOrder || aMaterial == MT.InfusedVis || aMaterial == MT.InfusedWater || aMaterial == MT.InfusedBalance) {
            if (aPrefix.mNameInternal.startsWith("ore")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Infused Stone";
            }
            if (aPrefix.mNameInternal.startsWith("gem")) {
                return aPrefix.mMaterialPre + "Shard of " + aMaterial.mNameLocal;
            }
            if (aPrefix.mNameInternal.startsWith("crystal")) {
                return aPrefix.mMaterialPre + "Shard of " + aMaterial.mNameLocal;
            }
            if (aPrefix.mNameInternal.startsWith("plate")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Crystal Plate";
            }
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Crystal Powder";
            }
            if (aPrefix.mNameInternal.startsWith("crushed")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Crystals";
            }
        } else if (aMaterial == MT.Wheat) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Flour";
            }
        } else if (aMaterial == MT.Oat) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Oatmeal";
            }
        } else if (aMaterial == MT.Rye) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Rye Flour";
            }
        } else if (aMaterial == MT.Barley) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Barley Flour";
            }
        } else if (aMaterial == MT.Corn) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Cornmeal";
            }
        } else if (aMaterial == MT.Rice) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Rice";
            }
        } else if (aMaterial == MT.Ice) {
            if (aPrefix == OP.gemChipped) {
                return "Ice Cubes";
            }
            if (aPrefix == OP.gemFlawed) {
                return "Medium Ice Cube";
            }
            if (aPrefix == OP.gem) {
                return "Large Ice Cube";
            }
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Crushed Ice";
            }
        } else if (aMaterial == MT.Wood || aMaterial == MT.WoodSealed || aMaterial == MT.WoodRubber) {
            if (aPrefix.mNameInternal.startsWith("bolt")) {
                return "Short " + aMaterial.mNameLocal + " Stick";
            }
            if (aPrefix.mNameInternal.startsWith("stick")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Stick";
            }
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Pulp";
            }
            if (aPrefix.mNameInternal.startsWith("nugget")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Chip";
            }
            if (aPrefix.mNameInternal.startsWith("plate")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Plank";
            }
        } else if (aMaterial == MT.Plastic || aMaterial == MT.Rubber) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Pulp";
            }
            if (aPrefix.mNameInternal.startsWith("plate")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Sheet";
            }
            if (aPrefix.mNameInternal.startsWith("ingot")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Bar";
            }
            if (aPrefix.mNameInternal.startsWith("nugget")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Chip";
            }
            if (aPrefix.mNameInternal.startsWith("foil")) {
                return "Thin " + aMaterial.mNameLocal + " Sheet";
            }
        } else if (aMaterial == MT.FierySteel) {
            if (aPrefix.contains(TD.Prefix.IS_CONTAINER)) {
                return aPrefix.mMaterialPre + "Fiery Blood" + aPrefix.mMaterialPost;
            }
        } else if (aMaterial == MT.Steeleaf) {
            if (aPrefix == OP.plantGtBlossom) {
                return "Steeleaf Leaf";
            }
            if (aPrefix.mNameInternal.startsWith("ingot")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal;
            }
        } else if (aMaterial == MT.Bone) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Bonemeal";
            }
        } else if (aMaterial == MT.Tea || aMaterial == MT.Mint) {
            if (aPrefix == OP.plantGtBlossom) {
                return aMaterial.mNameLocal + " Leaf";
            }
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Powder";
            }
        } else if (aMaterial == MT.Fe) {
            if (aPrefix == OP.plantGtBlossom) {
                return "Ferru Leaf";
            }
        } else if (aMaterial == MT.Au) {
            if (aPrefix == OP.plantGtBlossom) {
                return "Aurelia Leaf";
            }
        } else if (aMaterial == MT.Pb) {
            if (aPrefix == OP.plantGtBlossom) {
                return "Plumbilia Leaf";
            }
        } else if (aMaterial == MT.Ag) {
            if (aPrefix == OP.plantGtBlossom) {
                return "Argentia Leaf";
            }
        } else if (aMaterial == MT.Sn) {
            if (aPrefix == OP.plantGtTwig) {
                return "Tine Twig";
            }
        } else if (aMaterial == MT.Cu) {
            if (aPrefix == OP.plantGtFiber) {
                return "Coppon Fiber";
            }
        } else if (aMaterial == MT.Emerald) {
            if (aPrefix == OP.plantGtBerry) {
                return "Bobs-Yer-Uncle-Berry";
            }
        } else if (aMaterial == MT.Milk) {
            if (aPrefix == OP.plantGtWart) {
                return "Milkwart";
            }
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Powder";
            }
        } else if (aMaterial == MT.Chocolate || aMaterial == MT.Cheese) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Powder";
            }
            if (aPrefix.mNameInternal.startsWith("ingot")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Bar";
            }
        } else if (aMaterial == MT.Indigo || aMaterial == MT.Blaze || aMaterial == MT.ConstructionFoam || aMaterial == MT.Cocoa || aMaterial == MT.Curry || aMaterial == MT.Chocolate || aMaterial == MT.Coffee || aMaterial == MT.Chili || aMaterial == MT.Cheese || aMaterial == MT.Snow) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Powder";
            }
        } else if (aMaterial == MT.Potato || aMaterial == MT.Nutmeg || aMaterial == MT.Cinnamon || aMaterial == MT.Vanilla || aMaterial == MT.PepperBlack) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Ground " + aMaterial.mNameLocal;
            }
        } else if (aMaterial == MT.Paper) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Chad";
            }
            if (aPrefix == OP.plate) {
                return "Sheet of Paper";
            }
            if (aPrefix == OP.plateDouble) {
                return "Paperboard";
            }
            if (aPrefix == OP.plateTriple) {
                return "Carton";
            }
            if (aPrefix == OP.plateQuadruple) {
                return "Cardboard";
            }
            if (aPrefix == OP.plateQuintuple) {
                return "Thick Cardboard";
            }
            if (aPrefix == OP.plateDense) {
                return "Strong Cardboard";
            }
        } else if (aMaterial == MT.FishRaw) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Fishmeal";
            }
        } else if (aMaterial == MT.FishCooked) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Cooked Fishmeal";
            }
        } else if (aMaterial == MT.FishRotten) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Rotten Fishmeal";
            }
        } else if (aMaterial == MT.MeatRaw) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Mince Meat";
            }
        } else if (aMaterial == MT.MeatCooked) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Cooked Mince Meat";
            }
        } else if (aMaterial == MT.MeatRotten) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + "Rotten Mince Meat";
            }
        } else if (aMaterial == MT.SoylentGreen || aMaterial == MT.Tofu) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal;
            }
            if (aPrefix.mNameInternal.startsWith("ingot")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Bar";
            }
        } else if (aMaterial == MT.Peat || aMaterial == MT.PeatBituminous) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal;
            }
            if (aPrefix.mNameInternal.startsWith("ingot")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Brick";
            }
        } else if (aMaterial == MT.Sugar) {
            if (aPrefix == OP.gemChipped) {
                return "Sugar Cubes";
            }
        } else if (aMaterial == MT.Tallow || aMaterial == MT.Gunpowder || aMaterial == MT.Salt || aMaterial == MT.RockSalt || aMaterial == MT.IodineSalt || aMaterial == MT.Asphalt) {
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal;
            }
        } else if (aMaterial == MT.Black || aMaterial == MT.Red || aMaterial == MT.Green || aMaterial == MT.Brown || aMaterial == MT.Blue || aMaterial == MT.Purple || aMaterial == MT.Cyan || aMaterial == MT.LightGray || aMaterial == MT.Gray || aMaterial == MT.Pink || aMaterial == MT.Lime || aMaterial == MT.Yellow || aMaterial == MT.LightBlue || aMaterial == MT.Magenta || aMaterial == MT.Orange || aMaterial == MT.White) {
            if (aPrefix == OP.plantGtFiber) {
                return aMaterial.mNameLocal + " String";
            }
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal + " Dye";
            }
        } else if (aMaterial == MT.Wax || aMaterial == MT.WaxMagic || aMaterial == MT.WaxBee || aMaterial == MT.WaxRefractory || aMaterial == MT.WaxPlant || aMaterial == MT.WaxParaffin || aMaterial == MT.Ash || aMaterial == MT.DarkAsh || aMaterial == MT.VolcanicAsh || aMaterial == MT.OREMATS.Vermiculite || aMaterial == MT.OREMATS.Bentonite || aMaterial == MT.OREMATS.Kaolinite || aMaterial == MT.Talc || aMaterial == MT.OREMATS.BasalticMineralSand || aMaterial == MT.OREMATS.GraniticMineralSand || aMaterial == MT.OREMATS.GlauconiteSand || aMaterial == MT.OREMATS.CassiteriteSand || aMaterial == MT.OREMATS.GarnetSand || aMaterial == MT.SluiceSand || aMaterial == MT.OREMATS.QuartzSand || aMaterial == MT.OREMATS.Pitchblende || aMaterial == MT.OREMATS.FullersEarth || aMaterial == MT.RareEarth || aMaterial == MT.Oilsands) {
            if (aPrefix.mNameInternal.startsWith("ore")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal;
            }
            if (aPrefix.mNameInternal.startsWith("dust")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal;
            }
            if (aPrefix == OP.crushed) {
                return "Ground " + aMaterial.mNameLocal;
            }
            if (aPrefix == OP.crushedTiny) {
                return "Tiny Ground " + aMaterial.mNameLocal;
            }
            if (aPrefix.mNameInternal.startsWith("crushed")) {
                return aPrefix.mMaterialPre + aMaterial.mNameLocal;
            }
        }
        return aPrefix.mMaterialPre + aMaterial.mNameLocal + aPrefix.mMaterialPost;
    }

    static {
        TEMPMAP = new HashMap();
        BUFFERMAP = new HashMap();
        mWritingEnabled = false;
        mUseFile = false;
    }
}

