/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.prefixitem;

import cpw.mods.fml.common.FMLLog;
import gregapi.code.ObjectStack;
import gregapi.code.TagData;
import gregapi.data.MT;
import gregapi.item.IItemProjectile;
import gregapi.item.prefixitem.PrefixItem;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.util.UT;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class PrefixItemProjectile
extends PrefixItem
implements IItemProjectile {
    public final TagData mProjectileType;
    public final Class<? extends IItemProjectile.EntityProjectile> mEntityClass;
    public final float mSpeedMultiplier;
    public final float mPrecision;

    public PrefixItemProjectile(String aModIDOwner, String aModIDTextures, String aNameInternal, OreDictPrefix aPrefix, TagData aProjectileType, Class<? extends IItemProjectile.EntityProjectile> aEntityClass, float aSpeedMultiplier, float aPrecision, boolean aDispensable) {
        super(aModIDOwner, aModIDTextures, aNameInternal, aPrefix);
        this.mProjectileType = aProjectileType;
        this.mEntityClass = aEntityClass;
        this.mPrecision = aPrecision;
        this.mSpeedMultiplier = aSpeedMultiplier;
        if (aDispensable) {
            BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new MetaItemDispense());
        }
    }

    @Override
    public boolean hasProjectile(TagData aProjectileType, ItemStack aStack) {
        return this.mProjectileType == aProjectileType && UT.Code.exists(UT.Stacks.meta(aStack), OreDictMaterial.MATERIAL_ARRAY) && OreDictMaterial.MATERIAL_ARRAY[UT.Stacks.meta(aStack)] != MT.Empty;
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(TagData aProjectileType, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        if (!this.hasProjectile(aProjectileType, aStack)) {
            return null;
        }
        try {
            IItemProjectile.EntityProjectile tProjectile = this.mEntityClass.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(aWorld, aX, aY, aZ);
            tProjectile.setProjectileStack(UT.Stacks.amount(1L, aStack));
            return tProjectile;
        }
        catch (Throwable e) {
            FMLLog.severe((String)"Problems with '%s'", (Object[])new Object[]{this.mEntityClass.getName()});
            FMLLog.severe((String)e.toString(), (Object[])new Object[0]);
            return null;
        }
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(TagData aProjectileType, ItemStack aStack, World aWorld, EntityLivingBase aEntity, float aSpeed) {
        if (!this.hasProjectile(aProjectileType, aStack)) {
            return null;
        }
        try {
            IItemProjectile.EntityProjectile tProjectile = this.mEntityClass.getConstructor(World.class, EntityLivingBase.class, Float.TYPE).newInstance(aWorld, aEntity, Float.valueOf(this.mSpeedMultiplier * aSpeed));
            tProjectile.setProjectileStack(UT.Stacks.amount(1L, aStack));
            return tProjectile;
        }
        catch (Throwable e) {
            FMLLog.severe((String)"Problems with '%s'", (Object[])new Object[]{this.mEntityClass.getName()});
            FMLLog.severe((String)e.toString(), (Object[])new Object[0]);
            return null;
        }
    }

    public boolean onLeftClickEntity(ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        super.onLeftClickEntity(aStack, aPlayer, aEntity);
        if (aEntity instanceof EntityLivingBase) {
            UT.Enchantments.applyBullshitA((EntityLivingBase)aEntity, (Entity)aPlayer, aStack);
            UT.Enchantments.applyBullshitB((EntityLivingBase)aPlayer, aEntity, aStack);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                --aStack.field_77994_a;
            }
            if (aStack.field_77994_a <= 0) {
                aPlayer.func_71028_bD();
            }
            return false;
        }
        return false;
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
        NBTTagCompound tNBT;
        super.updateItemStack(aStack);
        short aMetaData = UT.Stacks.meta(aStack);
        if (UT.Code.exists(aMetaData, OreDictMaterial.MATERIAL_ARRAY) && !OreDictMaterial.MATERIAL_ARRAY[aMetaData].mEnchantmentTools.isEmpty() && !(tNBT = UT.NBT.getNBT(aStack)).func_74767_n("gt.u")) {
            tNBT.func_74757_a("gt.u", true);
            UT.NBT.setNBT(aStack, tNBT);
            for (ObjectStack<Enchantment> tEnchantment : OreDictMaterial.MATERIAL_ARRAY[aMetaData].mEnchantmentTools) {
                if (tEnchantment.mObject == Enchantment.field_77346_s) {
                    UT.NBT.addEnchantment(aStack, Enchantment.field_77335_o, tEnchantment.mAmount);
                    continue;
                }
                if (((Enchantment)tEnchantment.mObject).field_77351_y != EnumEnchantmentType.weapon) continue;
                UT.NBT.addEnchantment(aStack, (Enchantment)tEnchantment.mObject, tEnchantment.mAmount);
            }
        }
    }

    public ItemStack onDispense(IBlockSource aSource, ItemStack aStack) {
        World aWorld = aSource.func_82618_k();
        IPosition tPosition = BlockDispenser.func_149939_a((IBlockSource)aSource);
        EnumFacing tFacing = BlockDispenser.func_149937_b((int)aSource.func_82620_h());
        IItemProjectile.EntityProjectile tProjectile = this.getProjectile(this.mProjectileType, aStack, aWorld, tPosition.func_82615_a(), tPosition.func_82617_b(), tPosition.func_82616_c());
        if (tProjectile != null) {
            tProjectile.func_70186_c(tFacing.func_82601_c(), (float)tFacing.func_96559_d() + 0.1f, tFacing.func_82599_e(), this.mSpeedMultiplier * 1.1f, this.mPrecision);
            tProjectile.setProjectileStack(UT.Stacks.amount(1L, aStack));
            tProjectile.field_70251_a = 1;
            aWorld.func_72838_d((Entity)tProjectile);
            if (aStack.field_77994_a < 100) {
                --aStack.field_77994_a;
            }
            return aStack;
        }
        EnumFacing enumfacing = BlockDispenser.func_149937_b((int)aSource.func_82620_h());
        IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)aSource);
        ItemStack itemstack1 = aStack.func_77979_a(1);
        BehaviorDefaultDispenseItem.func_82486_a((World)aSource.func_82618_k(), (ItemStack)itemstack1, (int)6, (EnumFacing)enumfacing, (IPosition)iposition);
        return aStack;
    }

    public static class MetaItemDispense
    extends BehaviorProjectileDispense {
        public ItemStack func_82487_b(IBlockSource aSource, ItemStack aStack) {
            return ((PrefixItemProjectile)aStack.func_77973_b()).onDispense(aSource, aStack);
        }

        protected IProjectile func_82499_a(World aWorld, IPosition aPosition) {
            return null;
        }
    }
}

