/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem.food;

import gregapi.damage.DamageSources;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.item.multiitem.MultiItemRandom;
import gregapi.item.multiitem.food.IFoodStat;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class FoodStat
implements IFoodStat {
    private final int mFoodLevel;
    private final int[] mPotionEffects;
    private final float mSaturation;
    private final float mHydration;
    private final float mTemperature;
    private final float mTemperatureEffect;
    private final EnumAction mAction;
    private final ItemStack mEmptyContainer;
    private final boolean mAlwaysEdible;
    private final boolean mInvisibleParticles;
    private final boolean mIsRotten;
    private boolean mExplosive = false;
    private boolean mMilk = false;
    private boolean mExtinguish = false;
    private boolean mUseAPC = true;
    private boolean mAutoDetectEmpty = false;

    public FoodStat(int aFoodLevel, float aSaturation, float aHydration, float aTemperature, float aTemperatureEffect, EnumAction aAction, ItemStack aEmptyContainer, boolean aAlwaysEdible, boolean aInvisibleParticles, boolean aIsRotten, boolean aAutoDetectEmpty, int ... aPotionEffects) {
        this.mFoodLevel = aFoodLevel;
        this.mSaturation = aSaturation;
        this.mHydration = aHydration;
        this.mTemperature = aTemperature;
        this.mTemperatureEffect = aTemperatureEffect;
        this.mAction = aAction == null ? EnumAction.eat : aAction;
        this.mPotionEffects = aPotionEffects;
        this.mEmptyContainer = UT.Stacks.copy(aEmptyContainer);
        this.mInvisibleParticles = aInvisibleParticles;
        this.mAlwaysEdible = aAlwaysEdible;
        this.mAutoDetectEmpty = aAutoDetectEmpty;
        this.mIsRotten = aIsRotten;
    }

    public FoodStat setExplosive() {
        this.mExplosive = true;
        return this;
    }

    public FoodStat setExtinguish() {
        this.mExtinguish = true;
        return this;
    }

    public FoodStat setMilk() {
        this.mMilk = true;
        return this;
    }

    @Override
    public int getFoodLevel(MultiItemRandom aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mFoodLevel;
    }

    @Override
    public float getSaturation(MultiItemRandom aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mSaturation;
    }

    @Override
    public float getHydration(MultiItemRandom aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mHydration;
    }

    @Override
    public float getTemperature(MultiItemRandom aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mTemperature;
    }

    @Override
    public float getTemperatureEffect(MultiItemRandom aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mTemperatureEffect;
    }

    @Override
    public void onEaten(MultiItemRandom aItem, ItemStack aStack, EntityPlayer aPlayer) {
        if (!UT.Entities.hasInfiniteItems(aPlayer)) {
            --aStack.field_77994_a;
            ItemStack tStack = OM.get(UT.Stacks.copy(this.mEmptyContainer));
            if (tStack == null && this.mAutoDetectEmpty) {
                tStack = UT.Stacks.container(aStack, false);
            }
            if (tStack != null && !aPlayer.field_71071_by.func_70441_a(tStack)) {
                aPlayer.func_71019_a(tStack, true);
            }
        }
        aPlayer.field_70170_p.func_72956_a((Entity)aPlayer, "random.burp", 0.5f, aPlayer.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        if (!aPlayer.field_70170_p.field_72995_K) {
            if (this.mExtinguish) {
                aPlayer.func_70066_B();
            }
            if (this.mMilk) {
                aPlayer.curePotionEffects(UT.Stacks.make(Items.field_151117_aB, 1L, 0L));
            }
            for (int i = 3; i < this.mPotionEffects.length; i += 4) {
                if (this.mPotionEffects[i - 3] < -1) {
                    switch (this.mPotionEffects[i - 3]) {
                        case -2: {
                            this.mPotionEffects[i - 3] = CS.PotionsGT.ID_RADIATION;
                            break;
                        }
                        case -3: {
                            this.mPotionEffects[i - 3] = CS.PotionsGT.ID_HYPOTHERMIA;
                            break;
                        }
                        case -4: {
                            this.mPotionEffects[i - 3] = CS.PotionsGT.ID_HEATSTROKE;
                            break;
                        }
                        case -5: {
                            this.mPotionEffects[i - 3] = CS.PotionsGT.ID_FROSTBITE;
                            break;
                        }
                        case -6: {
                            this.mPotionEffects[i - 3] = CS.PotionsGT.ID_DEHYDRATION;
                            break;
                        }
                        case -7: {
                            this.mPotionEffects[i - 3] = CS.PotionsGT.ID_INSANITY;
                        }
                    }
                }
                if (this.mPotionEffects[i - 3] < 0 || aPlayer.field_70170_p.field_73012_v.nextInt(100) >= this.mPotionEffects[i]) continue;
                if (this.mPotionEffects[i - 1] >= 0) {
                    aPlayer.func_70690_d(new PotionEffect(this.mPotionEffects[i - 3], this.mPotionEffects[i - 2], this.mPotionEffects[i - 1], this.mInvisibleParticles));
                    continue;
                }
                aPlayer.func_82170_o(this.mPotionEffects[i - 3]);
            }
            if (this.mExplosive) {
                aPlayer.field_70170_p.func_72885_a((Entity)aPlayer, aPlayer.field_70165_t, aPlayer.field_70163_u, aPlayer.field_70161_v, 4.0f, true, true);
                aPlayer.func_70097_a(DamageSources.getExplodingDamage(), Float.MAX_VALUE);
            }
        }
    }

    @Override
    public EnumAction getFoodAction(MultiItemRandom aItem, ItemStack aStack) {
        return this.mAction;
    }

    @Override
    public boolean alwaysEdible(MultiItemRandom aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mAlwaysEdible;
    }

    @Override
    public boolean isRotten(MultiItemRandom aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mIsRotten;
    }

    @Override
    public boolean useAppleCoreFunctionality(MultiItemRandom aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mUseAPC;
    }

    @Override
    public void addAdditionalToolTips(MultiItemRandom aItem, List aList, ItemStack aStack, boolean aF3_H) {
        String tString;
        if (!(this.useAppleCoreFunctionality(aItem, aStack, null) && MD.APC.mLoaded || this.mFoodLevel <= 0 && !(this.mSaturation > 0.0f))) {
            aList.add(LH.Chat.RED + "Food: " + this.mFoodLevel + " - Saturation: " + this.mSaturation);
        }
        if (UT.Code.stringValid(tString = (this.mTemperature >= 313.0f ? "Hot" + (this.mHydration == 0.0f ? "" : " - ") : (this.mTemperature >= 311.0f ? "Warm" + (this.mHydration == 0.0f ? "" : " - ") : (this.mTemperature <= 307.0f ? "Very Cold" + (this.mHydration == 0.0f ? "" : " - ") : (this.mTemperature <= 309.0f ? "Cold" + (this.mHydration == 0.0f ? "" : " - ") : "")))) + (this.mHydration > 0.0f ? "Hydration: " + this.mHydration : (this.mHydration < 0.0f ? "Dehydration: " + -this.mHydration : ""))) && MD.ENVM.mLoaded) {
            aList.add(LH.Chat.RED + tString);
        }
        if (this.mExplosive) {
            aList.add(LH.Chat.DRED + "smells like explosives");
        }
        if (this.mIsRotten) {
            aList.add(LH.Chat.DRED + "smells rotten");
        }
    }
}

