/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem.energy;

import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import gregapi.item.IItemEnergy;
import gregapi.item.multiitem.MultiItem;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EnergyStat
implements IItemEnergy {
    public long mSize;
    public long mAmount;
    public long mCapacity;
    public TagData mType;
    public boolean mCanCharge;
    public boolean mCanDecharge;
    public ItemStack mEmptyItem;
    public ItemStack mHalfItem;
    public ItemStack mFullItem;

    public EnergyStat(TagData aEnergyType, long aCapacity, long aSize, long aAmount, boolean aCanCharge, boolean aCanDecharge, ItemStack aEmptyItem, ItemStack aHalfItem, ItemStack aFullItem) {
        this.mSize = aSize;
        this.mAmount = aAmount;
        this.mCapacity = aCapacity;
        this.mType = aEnergyType;
        this.mCanCharge = aCanCharge;
        this.mCanDecharge = aCanDecharge;
        this.mEmptyItem = aEmptyItem;
        this.mHalfItem = aHalfItem;
        this.mFullItem = aFullItem;
    }

    public static IItemEnergy makeREBattery(TagData aEnergyType, long aCapacity, long aSize, ItemStack aEmptyItem, ItemStack aHalfItem, ItemStack aFullItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, 1L, true, true, aEmptyItem, aHalfItem, aFullItem);
    }

    public static IItemEnergy makeSUBattery(TagData aEnergyType, long aCapacity, long aSize, ItemStack aEmptyItem, ItemStack aHalfItem, ItemStack aFullItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, 1L, false, true, aEmptyItem, aHalfItem, aFullItem);
    }

    public static IItemEnergy makeTool(TagData aEnergyType, long aCapacity, long aSize, ItemStack aEmptyItem, ItemStack aHalfItem, ItemStack aFullItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, 1L, true, false, aEmptyItem, aHalfItem, aFullItem);
    }

    public static IItemEnergy makeREBattery(TagData aEnergyType, long aCapacity, long aSize, ItemStack aItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, 1L, true, true, aItem, aItem, aItem);
    }

    public static IItemEnergy makeSUBattery(TagData aEnergyType, long aCapacity, long aSize, ItemStack aItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, 1L, false, true, aItem, aItem, aItem);
    }

    public static IItemEnergy makeTool(TagData aEnergyType, long aCapacity, long aSize, ItemStack aItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, 1L, true, false, aItem, aItem, aItem);
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, ItemStack aStack, boolean aEmitting) {
        return aEnergyType == this.mType;
    }

    @Override
    public long doEnergyInjection(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoInject) {
        if (!this.canEnergyInjection(aEnergyType, aStack, aSize = Math.abs(aSize))) {
            return 0L;
        }
        long tStored = this.getEnergyStored(aEnergyType, aStack);
        if (tStored >= this.mCapacity) {
            return 0L;
        }
        if ((aAmount = Math.min(this.mAmount, aAmount)) <= 0L) {
            return 0L;
        }
        long rAmount = 0L;
        while (rAmount++ < aAmount && tStored + rAmount * aSize < this.mCapacity) {
        }
        this.setEnergyStored(aEnergyType, aStack, tStored + rAmount * aSize);
        return rAmount;
    }

    @Override
    public long doEnergyExtraction(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoExtract) {
        if (!this.canEnergyExtraction(aEnergyType, aStack, aSize = Math.abs(aSize))) {
            return 0L;
        }
        long tStored = this.getEnergyStored(aEnergyType, aStack);
        if (tStored <= aSize) {
            return 0L;
        }
        if ((aAmount = Math.min(this.mAmount, aAmount)) <= 0L) {
            return 0L;
        }
        long rAmount = 0L;
        while (rAmount++ < aAmount) {
            if (tStored - rAmount * aSize >= aSize) continue;
            --rAmount;
            break;
        }
        this.setEnergyStored(aEnergyType, aStack, tStored - rAmount * aSize);
        return rAmount;
    }

    public ItemStack rechargeFromPlayer(TagData aEnergyType, ItemStack aStack, EntityLivingBase aPlayer, IInventory aInventory, World aWorld, int aX, int aY, int aZ) {
        if (aEnergyType != this.mType) {
            return aStack;
        }
        if (aStack.func_77973_b() instanceof MultiItem) {
            ((MultiItem)aStack.func_77973_b()).chargeFromArmor(aStack, aPlayer);
        }
        return aStack;
    }

    @Override
    public boolean useEnergy(TagData aEnergyType, ItemStack aStack, long aEnergyAmount, EntityLivingBase aPlayer, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoUse) {
        if (aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).field_71075_bZ.field_75098_d) {
            return true;
        }
        if (aEnergyType != this.mType) {
            return false;
        }
        this.rechargeFromPlayer(aEnergyType, aStack, aPlayer, aInventory, aWorld, aX, aY, aZ);
        long tStored = this.getEnergyStored(aEnergyType, aStack);
        if (tStored >= aEnergyAmount) {
            if (aDoUse) {
                this.setEnergyStored(aEnergyType, aStack, tStored - aEnergyAmount);
                this.rechargeFromPlayer(aEnergyType, aStack, aPlayer, aInventory, aWorld, aX, aY, aZ);
            }
            return true;
        }
        if (aDoUse) {
            this.setEnergyStored(aEnergyType, aStack, 0L);
            this.rechargeFromPlayer(aEnergyType, aStack, aPlayer, aInventory, aWorld, aX, aY, aZ);
        }
        return false;
    }

    @Override
    public ItemStack setEnergyStored(TagData aEnergyType, ItemStack aStack, long aAmount) {
        if (aEnergyType != this.mType) {
            return aStack;
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        } else {
            tNBT.func_82580_o("gt.energy");
        }
        aAmount = Math.min(aAmount, this.mCapacity);
        if (aAmount > 0L) {
            if (aAmount >= this.mCapacity) {
                if (this.mFullItem != null) {
                    UT.Stacks.set(aStack, this.mFullItem);
                }
            } else if (this.mHalfItem != null) {
                UT.Stacks.set(aStack, this.mHalfItem);
            }
            UT.NBT.setNumber(tNBT, "gt.energy", aAmount);
        } else if (this.mEmptyItem == null) {
            --aStack.field_77994_a;
        } else {
            UT.Stacks.set(aStack, this.mEmptyItem);
        }
        aStack.func_77982_d(tNBT);
        return UT.Stacks.update_(aStack);
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, ItemStack aStack) {
        if (aEnergyType != this.mType) {
            return 0L;
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        return tNBT == null ? 0L : tNBT.func_74763_f("gt.energy");
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, ItemStack aStack) {
        if (aEnergyType != this.mType) {
            return 0L;
        }
        return this.mCapacity;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, ItemStack aStack) {
        if (aEnergyType != this.mType) {
            return 0L;
        }
        return this.mSize <= 8L ? 1L : this.mSize / 2L;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, ItemStack aStack) {
        if (aEnergyType != this.mType) {
            return 0L;
        }
        return this.mSize <= 8L ? 1L : this.mSize / 2L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, ItemStack aStack) {
        if (aEnergyType != this.mType) {
            return 0L;
        }
        return this.mSize;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, ItemStack aStack) {
        if (aEnergyType != this.mType) {
            return 0L;
        }
        return this.mSize;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, ItemStack aStack) {
        if (aEnergyType != this.mType) {
            return 0L;
        }
        return this.mSize * 2L;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, ItemStack aStack) {
        if (aEnergyType != this.mType) {
            return 0L;
        }
        return this.mSize * 2L;
    }

    @Override
    public Collection<TagData> getEnergyTypes(ItemStack aStack) {
        return new HashSetNoNulls<TagData>(false, this.mType);
    }

    @Override
    public boolean canEnergyInjection(TagData aEnergyType, ItemStack aStack, long aSize) {
        return aEnergyType == this.mType && aStack.field_77994_a == 1 && this.mCanCharge && aSize <= this.getEnergySizeInputMax(aEnergyType, aStack) && aSize >= this.getEnergySizeInputMin(aEnergyType, aStack);
    }

    @Override
    public boolean canEnergyExtraction(TagData aEnergyType, ItemStack aStack, long aSize) {
        return aEnergyType == this.mType && aStack.field_77994_a == 1 && this.mCanDecharge && aSize <= this.getEnergySizeOutputMax(aEnergyType, aStack) && aSize >= this.getEnergySizeOutputMin(aEnergyType, aStack);
    }
}

