/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem.behaviors;

import gregapi.code.TagData;
import gregapi.item.IItemProjectile;
import gregapi.item.multiitem.MultiItem;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public interface IBehavior<E extends Item> {
    public boolean onLeftClickEntity(E var1, ItemStack var2, EntityPlayer var3, Entity var4);

    public boolean onRightClickEntity(E var1, ItemStack var2, EntityPlayer var3, Entity var4);

    public boolean onItemUse(E var1, ItemStack var2, EntityPlayer var3, World var4, int var5, int var6, int var7, byte var8, float var9, float var10, float var11);

    public boolean onItemUseFirst(E var1, ItemStack var2, EntityPlayer var3, World var4, int var5, int var6, int var7, byte var8, float var9, float var10, float var11);

    public ItemStack onItemRightClick(E var1, ItemStack var2, World var3, EntityPlayer var4);

    public List<String> getAdditionalToolTips(E var1, List<String> var2, ItemStack var3);

    public void onUpdate(E var1, ItemStack var2, World var3, Entity var4, int var5, boolean var6);

    public boolean isItemStackUsable(E var1, ItemStack var2);

    public boolean canDispense(E var1, IBlockSource var2, ItemStack var3);

    public ItemStack onDispense(E var1, IBlockSource var2, ItemStack var3);

    public boolean hasProjectile(E var1, TagData var2, ItemStack var3);

    public IItemProjectile.EntityProjectile getProjectile(E var1, TagData var2, ItemStack var3, World var4, double var5, double var7, double var9);

    public IItemProjectile.EntityProjectile getProjectile(E var1, TagData var2, ItemStack var3, World var4, EntityLivingBase var5, float var6);

    public static abstract class Behaviour_None
    implements IBehavior<MultiItem> {
        @Override
        public boolean onLeftClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
            return false;
        }

        @Override
        public boolean onRightClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
            return false;
        }

        @Override
        public boolean onItemUse(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
            return false;
        }

        @Override
        public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
            return false;
        }

        @Override
        public ItemStack onItemRightClick(MultiItem aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
            return aStack;
        }

        @Override
        public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
            return aList;
        }

        @Override
        public void onUpdate(MultiItem aItem, ItemStack aStack, World aWorld, Entity aPlayer, int aTimer, boolean aIsInHand) {
        }

        @Override
        public boolean isItemStackUsable(MultiItem aItem, ItemStack aStack) {
            return true;
        }

        @Override
        public boolean canDispense(MultiItem aItem, IBlockSource aSource, ItemStack aStack) {
            return false;
        }

        @Override
        public boolean hasProjectile(MultiItem aItem, TagData aProjectileType, ItemStack aStack) {
            return false;
        }

        @Override
        public IItemProjectile.EntityProjectile getProjectile(MultiItem aItem, TagData aProjectileType, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
            return null;
        }

        @Override
        public IItemProjectile.EntityProjectile getProjectile(MultiItem aItem, TagData aProjectileType, ItemStack aStack, World aWorld, EntityLivingBase aEntity, float aSpeed) {
            return null;
        }

        @Override
        public ItemStack onDispense(MultiItem aItem, IBlockSource aSource, ItemStack aStack) {
            EnumFacing enumfacing = BlockDispenser.func_149937_b((int)aSource.func_82620_h());
            IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)aSource);
            ItemStack itemstack1 = aStack.func_77979_a(1);
            BehaviorDefaultDispenseItem.func_82486_a((World)aSource.func_82618_k(), (ItemStack)itemstack1, (int)6, (EnumFacing)enumfacing, (IPosition)iposition);
            return aStack;
        }

        protected MovingObjectPosition getMovingObjectPositionFromPlayer(World aWorld, EntityPlayer aPlayer, boolean aFlag) {
            float f = 1.0f;
            float f1 = aPlayer.field_70127_C + (aPlayer.field_70125_A - aPlayer.field_70127_C) * f;
            float f2 = aPlayer.field_70126_B + (aPlayer.field_70177_z - aPlayer.field_70126_B) * f;
            double d0 = aPlayer.field_70169_q + (aPlayer.field_70165_t - aPlayer.field_70169_q) * (double)f;
            double d1 = aPlayer.field_70167_r + (aPlayer.field_70163_u - aPlayer.field_70167_r) * (double)f + (double)(aWorld.field_72995_K ? aPlayer.func_70047_e() - aPlayer.getDefaultEyeHeight() : aPlayer.func_70047_e());
            double d2 = aPlayer.field_70166_s + (aPlayer.field_70161_v - aPlayer.field_70166_s) * (double)f;
            Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
            float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
            float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d3 = 5.0;
            if (aPlayer instanceof EntityPlayerMP) {
                d3 = ((EntityPlayerMP)aPlayer).field_71134_c.getBlockReachDistance();
            }
            Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
            return aWorld.func_147447_a(vec3, vec31, aFlag, !aFlag, false);
        }
    }
}

