/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.IToolGrafter;
import gregapi.GT_API;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.ItemStackSet;
import gregapi.code.ObjectStack;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.TC;
import gregapi.data.TD;
import gregapi.enchants.Enchantment_Radioactivity;
import gregapi.item.IItemDamagable;
import gregapi.item.IItemEnergy;
import gregapi.item.IItemGTContainerTool;
import gregapi.item.IItemGTHandTool;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.energy.EnergyStat;
import gregapi.item.multiitem.tools.IToolStats;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.OM;
import gregapi.util.UT;
import ic2.api.item.IBoxable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.railcraft.api.core.items.IToolCrowbar;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;

@Optional.InterfaceList(value={@Optional.Interface(iface="forestry.api.arboriculture.IToolGrafter", modid="Forestry"), @Optional.Interface(iface="mods.railcraft.api.core.items.IToolCrowbar", modid="Railcraft"), @Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="BuildCraft|Core"), @Optional.Interface(iface="ic2.api.item.IBoxable", modid="IC2")})
public class MultiItemTool
extends MultiItem
implements IItemDamagable,
IItemGTHandTool,
IItemGTContainerTool,
IToolGrafter,
IToolCrowbar,
IToolWrench,
IBoxable {
    public final HashMap<Short, IToolStats> mToolStats = new HashMap();
    public static ChunkCoordinates LAST_TOOL_COORDS_BEFORE_DAMAGE = null;

    public MultiItemTool(String aModID, String aUnlocalized) {
        super(aModID, aUnlocalized);
        this.func_77625_d(1);
    }

    public final ItemStack addTool(int aID, String aEnglish, String aToolTip, IToolStats aToolStats, Object ... aRandomParameters) {
        if (aToolTip == null) {
            aToolTip = "";
        }
        if (aID >= 0 && aID < 32766 && aID % 2 == 0) {
            LH.add(this.func_77658_a() + "." + aID + ".name", aEnglish);
            LH.add(this.func_77658_a() + "." + aID + ".tooltip", aToolTip);
            LH.add(this.func_77658_a() + "." + (aID + 1) + ".name", aEnglish + " (Empty)");
            LH.add(this.func_77658_a() + "." + (aID + 1) + ".tooltip", "You need to recharge it");
            this.mToolStats.put((short)aID, aToolStats);
            this.mToolStats.put((short)(aID + 1), aToolStats);
            aToolStats.onStatsAddedToTool(this, aID);
            ItemStack rStack = UT.Stacks.make(this, 1L, (long)aID);
            ArrayListNoNulls<TC.TC_AspectStack> tAspects = new ArrayListNoNulls<TC.TC_AspectStack>();
            for (Object tRandomParameter : aRandomParameters) {
                if (tRandomParameter instanceof TC.TC_AspectStack) {
                    ((TC.TC_AspectStack)tRandomParameter).addToAspectList(tAspects);
                    continue;
                }
                if (tRandomParameter instanceof ItemStackSet) {
                    ((ItemStackSet)tRandomParameter).add(rStack.func_77946_l());
                    continue;
                }
                OM.reg(tRandomParameter, rStack);
            }
            if (GT_API.sCompatTC != null) {
                GT_API.sCompatTC.registerThaumcraftAspectsToItem(rStack, tAspects, false);
            }
            return rStack;
        }
        return null;
    }

    public final ItemStack getToolWithStats(int aToolID, int aAmount, OreDictMaterial aPrimaryMaterial, OreDictMaterial aSecondaryMaterial, long aMaxCharge, long aVoltage) {
        ItemStack rStack = UT.Stacks.make(this, (long)aAmount, (long)aToolID);
        IToolStats tToolStats = this.getToolStats(rStack);
        if (tToolStats != null) {
            NBTTagCompound tMainNBT = new NBTTagCompound();
            NBTTagCompound tToolNBT = new NBTTagCompound();
            if (aPrimaryMaterial != null) {
                if (aPrimaryMaterial.mID > 0) {
                    tToolNBT.func_74777_a("a", aPrimaryMaterial.mID);
                } else {
                    tToolNBT.func_74778_a("b", aPrimaryMaterial.toString());
                }
                UT.NBT.setNumber(tToolNBT, "j", 100L * (long)((float)aPrimaryMaterial.mToolDurability * tToolStats.getMaxDurabilityMultiplier()));
            }
            if (aSecondaryMaterial != null) {
                if (aSecondaryMaterial.mID > 0) {
                    tToolNBT.func_74777_a("c", aSecondaryMaterial.mID);
                } else {
                    tToolNBT.func_74778_a("d", aSecondaryMaterial.toString());
                }
            }
            if (aMaxCharge > 0L) {
                tToolNBT.func_74757_a("e", true);
                UT.NBT.setNumber(tToolNBT, "f", aMaxCharge);
                UT.NBT.setNumber(tToolNBT, "g", aVoltage);
            }
            tMainNBT.func_74782_a("GT.ToolStats", (NBTBase)tToolNBT);
            rStack.func_77982_d(tMainNBT);
        }
        this.isItemStackUsable(rStack);
        return rStack;
    }

    public void onHarvestBlockEvent(ArrayList<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        IToolStats tStats = this.getToolStats(aStack);
        if (this.isItemStackUsable(aStack) && this.getDigSpeed(aStack, aBlock, aMetaData) > 0.0f) {
            int tDamage = tStats.convertBlockDrops(aDrops, aStack, aPlayer, aBlock, (MultiItemTool.getToolMaxDamage(aStack) - MultiItemTool.getToolDamage(aStack)) / (long)tStats.getToolDamagePerDropConversion(), aX, aY, aZ, aMetaData, aFortune, aSilkTouch, aEvent);
            LAST_TOOL_COORDS_BEFORE_DAMAGE = new ChunkCoordinates((int)aPlayer.field_70165_t, (int)aPlayer.field_70163_u, (int)aPlayer.field_70161_v);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                this.doDamage(aStack, tDamage * tStats.getToolDamagePerDropConversion());
            }
            LAST_TOOL_COORDS_BEFORE_DAMAGE = null;
        }
    }

    public float onBlockBreakSpeedEvent(float aDefault, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, byte aMetaData, PlayerEvent.BreakSpeed aEvent) {
        IToolStats tStats = this.getToolStats(aStack);
        return tStats == null ? aDefault : tStats.getMiningSpeed(aBlock, aMetaData, aDefault, aPlayer, aPlayer.field_70170_p, aX, aY, aZ);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null || !this.isItemStackUsable(aStack)) {
            return true;
        }
        if (CS.TOOL_SOUNDS) {
            UT.Sounds.play(tStats.getEntityHitSound(), 20, 1.0f, aEntity);
        }
        if (super.onLeftClickEntity(aStack, aPlayer, aEntity)) {
            return true;
        }
        if (aEntity.func_70075_an() && !aEntity.func_85031_j((Entity)aPlayer)) {
            float tMagicDamage = tStats.getMagicDamageAgainstEntity(aEntity instanceof EntityLivingBase ? EnchantmentHelper.func_77512_a((EntityLivingBase)aPlayer, (EntityLivingBase)((EntityLivingBase)aEntity)) : 0.0f, aEntity, aStack, aPlayer);
            float tDamage = tStats.getNormalDamageAgainstEntity((float)aPlayer.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() + this.getToolCombatDamage(aStack), aEntity, aStack, aPlayer);
            if (tDamage + tMagicDamage > 0.0f) {
                boolean tCriticalHit;
                boolean bl = tCriticalHit = aPlayer.field_70143_R > 0.0f && !aPlayer.field_70122_E && !aPlayer.func_70617_f_() && !aPlayer.func_70090_H() && !aPlayer.func_70644_a(Potion.field_76440_q) && aPlayer.field_70154_o == null && aEntity instanceof EntityLivingBase;
                if (tCriticalHit && tDamage > 0.0f) {
                    tDamage *= 1.5f;
                }
                if (aEntity.func_70097_a(tStats.getDamageSource((EntityLivingBase)aPlayer, aEntity), tDamage += tMagicDamage)) {
                    int tKnockcack;
                    if (aEntity instanceof EntityLivingBase) {
                        aEntity.func_70015_d(EnchantmentHelper.func_90036_a((EntityLivingBase)aPlayer) * 4);
                    }
                    if ((tKnockcack = (aPlayer.func_70051_ag() ? 1 : 0) + (aEntity instanceof EntityLivingBase ? EnchantmentHelper.func_77507_b((EntityLivingBase)aPlayer, (EntityLivingBase)((EntityLivingBase)aEntity)) : 0)) > 0) {
                        aEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(aPlayer.field_70177_z * (float)Math.PI / 180.0f)) * (float)tKnockcack * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(aPlayer.field_70177_z * (float)Math.PI / 180.0f)) * (float)tKnockcack * 0.5f));
                        aPlayer.field_70159_w *= 0.6;
                        aPlayer.field_70179_y *= 0.6;
                        aPlayer.func_70031_b(false);
                    }
                    if (tCriticalHit) {
                        aPlayer.func_71009_b(aEntity);
                    }
                    if (tMagicDamage > 0.0f) {
                        aPlayer.func_71047_c(aEntity);
                    }
                    if (tDamage >= 18.0f) {
                        aPlayer.func_71029_a((StatBase)AchievementList.field_75999_E);
                    }
                    aPlayer.func_130011_c(aEntity);
                    if (aEntity instanceof EntityLivingBase) {
                        UT.Enchantments.applyBullshitA((EntityLivingBase)aEntity, (Entity)aPlayer, aStack);
                    }
                    UT.Enchantments.applyBullshitB((EntityLivingBase)aPlayer, aEntity, aStack);
                    if (aEntity instanceof EntityLivingBase) {
                        aPlayer.func_71064_a(StatList.field_75951_w, Math.round(tDamage * 10.0f));
                    }
                    aEntity.field_70172_ad = Math.max(1, tStats.getHurtResistanceTime(aEntity.field_70172_ad, aEntity));
                    aPlayer.func_71020_j(tStats.getExhaustionPerAttack(aEntity));
                    LAST_TOOL_COORDS_BEFORE_DAMAGE = new ChunkCoordinates((int)aPlayer.field_70165_t, (int)aPlayer.field_70163_u, (int)aPlayer.field_70161_v);
                    if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                        this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
                    }
                    LAST_TOOL_COORDS_BEFORE_DAMAGE = null;
                }
            }
        }
        if (aStack.field_77994_a <= 0) {
            aPlayer.func_71028_bD();
        }
        return true;
    }

    @Override
    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && tStats.canBlock()) {
            aPlayer.func_71008_a(aStack, 72000);
        }
        return super.func_77659_a(aStack, aWorld, aPlayer);
    }

    public final int func_77626_a(ItemStack aStack) {
        return 72000;
    }

    public final EnumAction func_77661_b(ItemStack aStack) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && tStats.canBlock()) {
            return EnumAction.block;
        }
        return EnumAction.none;
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        for (int i = 0; i < 32766; i += 2) {
            if (this.getToolStats(UT.Stacks.make(this, 1L, (long)i)) == null) continue;
            ItemStack tStack = UT.Stacks.make(this, 1L, (long)i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
    }

    @Override
    public void addAdditionalToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        long tMaxDamage = MultiItemTool.getToolMaxDamage(aStack);
        long tDamage = MultiItemTool.getToolDamage(aStack);
        OreDictMaterial tMaterial = MultiItemTool.getPrimaryMaterial(aStack, MT.NULL);
        IToolStats tStats = this.getToolStats(aStack);
        if (tMaxDamage > 0L && tStats != null) {
            aList.add(LH.Chat.WHITE + "Durability: " + LH.Chat.GREEN + (tMaxDamage - tDamage) + " / " + tMaxDamage + LH.Chat.GRAY);
            aList.add(LH.Chat.WHITE + tMaterial.getLocal() + LH.Chat.YELLOW + " lvl " + this.getHarvestLevel(aStack, "") + LH.Chat.GRAY);
            aList.add(LH.Chat.WHITE + "Attack Damage: " + LH.Chat.BLUE + this.getToolCombatDamage(aStack) + LH.Chat.GRAY);
            aList.add(LH.Chat.WHITE + "Mining Speed: " + LH.Chat.PINK + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.NULL).mToolSpeed) + LH.Chat.GRAY);
            aList.add(LH.Chat.WHITE + "Crafting Uses: " + LH.Chat.GREEN + UT.Code.divup(this.getEnergyStats(aStack) == null ? tMaxDamage - tDamage : this.getRealCharge(aStack), tStats.getToolDamagePerContainerCraft()) + LH.Chat.GRAY);
        }
    }

    public static final OreDictMaterial getPrimaryMaterial(ItemStack aStack, OreDictMaterial aDefault) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null) {
            if (aNBT.func_74764_b("a")) {
                return OreDictMaterial.MATERIAL_ARRAY[aNBT.func_74765_d("a")];
            }
            if (aNBT.func_74764_b("b")) {
                return OreDictMaterial.get(aNBT.func_74779_i("b"));
            }
            return OreDictMaterial.get(aNBT.func_74779_i("PrimaryMaterial"));
        }
        return aDefault;
    }

    public static final OreDictMaterial getPrimaryMaterial(ItemStack aStack) {
        return MultiItemTool.getPrimaryMaterial(aStack, MT.NULL);
    }

    public static final OreDictMaterial getSecondaryMaterial(ItemStack aStack, OreDictMaterial aDefault) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null) {
            if (aNBT.func_74764_b("c")) {
                return OreDictMaterial.MATERIAL_ARRAY[aNBT.func_74765_d("c")];
            }
            if (aNBT.func_74764_b("d")) {
                return OreDictMaterial.get(aNBT.func_74779_i("d"));
            }
            return OreDictMaterial.get(aNBT.func_74779_i("SecondaryMaterial"));
        }
        return aDefault;
    }

    public static final OreDictMaterial getSecondaryMaterial(ItemStack aStack) {
        return MultiItemTool.getSecondaryMaterial(aStack, MT.NULL);
    }

    @Override
    public IItemEnergy getEnergyStats(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null && aNBT.func_74767_n("e")) {
            return EnergyStat.makeTool(TD.Energy.EU, aNBT.func_74763_f("f"), aNBT.func_74763_f("g"), UT.Stacks.make(aStack.func_77973_b(), 1L, (long)this.getEmptyMetaData(aStack)), UT.Stacks.make(aStack.func_77973_b(), 1L, (long)this.getChargedMetaData(aStack)), UT.Stacks.make(aStack.func_77973_b(), 1L, (long)this.getChargedMetaData(aStack)));
        }
        return null;
    }

    public float getToolCombatDamage(ItemStack aStack) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null) {
            return 0.0f;
        }
        return tStats.getBaseDamage() + (float)MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.NULL).mToolQuality;
    }

    public static final long getToolMaxDamage(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("GT.ToolStats")).func_74764_b("j")) {
                return Math.max(1L, aNBT.func_74763_f("j"));
            }
            return Math.max(1L, aNBT.func_74763_f("MaxDamage"));
        }
        return 1L;
    }

    public static final long getToolDamage(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("GT.ToolStats")).func_74764_b("k")) {
                return aNBT.func_74763_f("k");
            }
            return aNBT.func_74763_f("Damage");
        }
        return 0L;
    }

    public static final boolean setToolDamage(ItemStack aStack, long aDamage) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            UT.NBT.setNumber(aNBT.func_74775_l("GT.ToolStats"), "k", aDamage);
            return true;
        }
        return false;
    }

    @Override
    public final boolean doDamageToItem(ItemStack aStack, int aVanillaDamage) {
        return this.doDamage(aStack, aVanillaDamage * 100);
    }

    public final boolean doDamage(ItemStack aStack, long aAmount) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IItemEnergy tElectric = this.getEnergyStats(aStack);
        if (tElectric == null || CS.RANDOM.nextInt(25) == 0) {
            long tNewDamage = MultiItemTool.getToolDamage(aStack) + aAmount;
            MultiItemTool.setToolDamage(aStack, tNewDamage);
            if (tNewDamage >= MultiItemTool.getToolMaxDamage(aStack)) {
                IToolStats tStats = this.getToolStats(aStack);
                if (tStats == null) {
                    aStack.field_77994_a = 0;
                } else {
                    if (CS.TOOL_SOUNDS) {
                        if (LAST_TOOL_COORDS_BEFORE_DAMAGE == null) {
                            UT.Sounds.play(tStats.getBreakingSound(), 200, 1.0f);
                        } else {
                            UT.Sounds.play(tStats.getBreakingSound(), 200, 1.0f, LAST_TOOL_COORDS_BEFORE_DAMAGE);
                            LAST_TOOL_COORDS_BEFORE_DAMAGE = null;
                        }
                    }
                    if (UT.Stacks.set(aStack, tStats.getBrokenItem(aStack)) == null) {
                        aStack.field_77994_a = 0;
                    }
                }
            }
            return tElectric == null || this.useEnergy(TD.Energy.EU, aStack, aAmount, null, null, null, 0, 0, 0, true);
        }
        return this.useEnergy(TD.Energy.EU, aStack, aAmount, null, null, null, 0, 0, 0, true);
    }

    public float getDigSpeed(ItemStack aStack, Block aBlock, int aMetaData) {
        if (!this.isItemStackUsable(aStack)) {
            return 0.0f;
        }
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null || Math.max(0, this.getHarvestLevel(aStack, "")) < aBlock.getHarvestLevel(aMetaData)) {
            return 0.0f;
        }
        return tStats.getMiningSpeed(aBlock, (byte)aMetaData) * Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.Steel).mToolSpeed);
    }

    public final boolean canHarvestBlock(Block aBlock, ItemStack aStack) {
        return this.getDigSpeed(aStack, aBlock, 0) > 0.0f;
    }

    public final int getHarvestLevel(ItemStack aStack, String aToolClass) {
        IToolStats tStats = this.getToolStats(aStack);
        return tStats == null ? -1 : tStats.getBaseQuality() + MultiItemTool.getPrimaryMaterial((ItemStack)aStack, (OreDictMaterial)MT.NULL).mToolQuality;
    }

    public boolean func_150894_a(ItemStack aStack, World aWorld, Block aBlock, int aX, int aY, int aZ, EntityLivingBase aPlayer) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null) {
            return false;
        }
        if (CS.TOOL_SOUNDS) {
            UT.Sounds.play(tStats.getMiningSound(), 5, 1.0f, aX, aY, aZ);
        }
        LAST_TOOL_COORDS_BEFORE_DAMAGE = new ChunkCoordinates(aX, aY, aZ);
        if (!UT.Entities.hasInfiniteItems(aPlayer)) {
            this.doDamage(aStack, (int)Math.max(1.0f, aBlock.func_149712_f(aWorld, aX, aY, aZ) * (float)tStats.getToolDamagePerBlockBreak()));
        }
        LAST_TOOL_COORDS_BEFORE_DAMAGE = null;
        return this.getDigSpeed(aStack, aBlock, aWorld.func_72805_g(aX, aY, aZ)) > 0.0f;
    }

    @Override
    public ItemStack getContainerItem(ItemStack aStack) {
        if (!this.isItemStackUsable(aStack)) {
            return null;
        }
        IToolStats tStats = this.getToolStats(aStack = UT.Stacks.amount(1L, aStack));
        if (tStats == null) {
            return null;
        }
        this.doDamage(aStack, tStats.getToolDamagePerContainerCraft());
        Object object = aStack = aStack.field_77994_a > 0 ? aStack : null;
        if (CS.TOOL_SOUNDS && aStack != null) {
            UT.Sounds.play(tStats.getCraftingSound(), 200, 1.0f, LAST_TOOL_COORDS_BEFORE_DAMAGE);
        }
        return aStack;
    }

    @Override
    public boolean hasContainerItem(ItemStack aStack) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack = UT.Stacks.amount(1L, aStack));
        if (tStats == null) {
            return false;
        }
        this.doDamage(aStack, tStats.getToolDamagePerContainerCraft());
        return aStack.field_77994_a > 0;
    }

    public IToolStats getToolStats(ItemStack aStack) {
        this.isItemStackUsable(aStack);
        return this.getToolStatsInternal(aStack);
    }

    private IToolStats getToolStatsInternal(ItemStack aStack) {
        return aStack == null ? null : this.getToolStatsInternal(UT.Stacks.meta(aStack));
    }

    private IToolStats getToolStatsInternal(int aDamage) {
        return this.mToolStats.get((short)aDamage);
    }

    public float getSaplingModifier(ItemStack aStack, World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ) {
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isGrafter() ? Math.min(100.0f, (float)(1 + this.getHarvestLevel(aStack, "")) * 20.0f) : 0.0f;
    }

    public boolean canWrench(EntityPlayer aPlayer, int aX, int aY, int aZ) {
        ItemStack aStack = aPlayer.func_71045_bC();
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isWrench();
    }

    public void wrenchUsed(EntityPlayer aPlayer, int aX, int aY, int aZ) {
        ItemStack aStack = aPlayer.func_71045_bC();
        IToolStats tStats = this.getToolStats(aStack);
        LAST_TOOL_COORDS_BEFORE_DAMAGE = new ChunkCoordinates(aX, aY, aZ);
        if (tStats != null && !UT.Entities.hasInfiniteItems(aPlayer)) {
            this.doDamage(aStack, 100L);
        }
        LAST_TOOL_COORDS_BEFORE_DAMAGE = null;
    }

    public boolean canWhack(EntityPlayer aPlayer, ItemStack aStack, int aX, int aY, int aZ) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    public void onWhack(EntityPlayer aPlayer, ItemStack aStack, int aX, int aY, int aZ) {
        IToolStats tStats = this.getToolStats(aStack);
        LAST_TOOL_COORDS_BEFORE_DAMAGE = new ChunkCoordinates(aX, aY, aZ);
        if (tStats != null && !UT.Entities.hasInfiniteItems(aPlayer)) {
            this.doDamage(aStack, 100L);
        }
        LAST_TOOL_COORDS_BEFORE_DAMAGE = null;
    }

    public boolean canLink(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    public void onLink(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        IToolStats tStats = this.getToolStats(aStack);
        LAST_TOOL_COORDS_BEFORE_DAMAGE = new ChunkCoordinates((int)cart.field_70165_t, (int)cart.field_70163_u, (int)cart.field_70161_v);
        if (tStats != null && !UT.Entities.hasInfiniteItems(aPlayer)) {
            this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
        }
        LAST_TOOL_COORDS_BEFORE_DAMAGE = null;
    }

    public boolean canBoost(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    public void onBoost(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        IToolStats tStats = this.getToolStats(aStack);
        LAST_TOOL_COORDS_BEFORE_DAMAGE = new ChunkCoordinates((int)cart.field_70165_t, (int)cart.field_70163_u, (int)cart.field_70161_v);
        if (tStats != null && !UT.Entities.hasInfiniteItems(aPlayer)) {
            this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
        }
        LAST_TOOL_COORDS_BEFORE_DAMAGE = null;
    }

    @Override
    public void func_77622_d(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        aStack.func_77982_d(UT.NBT.setNumber(UT.NBT.getNBT(aStack), "gt.rand", CS.RANDOM.nextInt(Short.MAX_VALUE)));
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && aPlayer != null) {
            tStats.onToolCrafted(aStack, aPlayer);
        }
        super.func_77622_d(aStack, aWorld, aPlayer);
    }

    public final boolean func_77630_h(ItemStack aStack) {
        return false;
    }

    @Override
    public final int getItemStackLimit(ItemStack aStack) {
        return 1;
    }

    public boolean func_77662_d() {
        return true;
    }

    @Override
    public boolean isItemStackUsable(ItemStack aStack) {
        IToolStats tStats = this.getToolStatsInternal(aStack);
        if (UT.Stacks.meta(aStack) % 2 == 1 || tStats == null) {
            NBTTagCompound aNBT = aStack.func_77978_p();
            if (aNBT != null) {
                aNBT.func_82580_o("ench");
            }
            return false;
        }
        OreDictMaterial aMaterial = MultiItemTool.getPrimaryMaterial(aStack, MT.NULL);
        HashMap<Integer, Integer> tMap = new HashMap<Integer, Integer>();
        HashMap tResult = new HashMap();
        for (ObjectStack<Enchantment> tEnchantment : aMaterial.mEnchantmentTools) {
            tMap.put(((Enchantment)tEnchantment.mObject).field_77352_x, (int)tEnchantment.mAmount);
            if (tEnchantment.mObject == Enchantment.field_77346_s) {
                tMap.put(Enchantment.field_77335_o.field_77352_x, (int)tEnchantment.mAmount);
            }
            if (tEnchantment.mObject == Enchantment.field_77337_m) {
                tMap.put(Enchantment.field_77344_u.field_77352_x, (int)tEnchantment.mAmount);
            }
            if (tEnchantment.mObject != Enchantment.field_77334_n) continue;
            tMap.put(Enchantment.field_77343_v.field_77352_x, (int)tEnchantment.mAmount);
        }
        Enchantment[] tEnchants = tStats.getEnchantments(aStack, aMaterial);
        int[] tLevels = tStats.getEnchantmentLevels(aStack);
        for (int i = 0; i < tEnchants.length; ++i) {
            if (tLevels[i] <= 0) continue;
            Integer tLevel = (Integer)tMap.get(tEnchants[i].field_77352_x);
            tMap.put(tEnchants[i].field_77352_x, tLevel == null ? tLevels[i] : (tLevel == tLevels[i] ? tLevel + 1 : Math.max(tLevel, tLevels[i])));
        }
        for (Map.Entry tEntry : tMap.entrySet()) {
            if ((Integer)tEntry.getKey() == 33 || (Integer)tEntry.getKey() == 20 && (Integer)tEntry.getValue() > 2 || (Integer)tEntry.getKey() == Enchantment_Radioactivity.INSTANCE.field_77352_x) {
                tResult.put(tEntry.getKey(), tEntry.getValue());
                continue;
            }
            switch (Enchantment.field_77331_b[((Integer)tEntry.getKey()).intValue()].field_77351_y) {
                case weapon: {
                    if (!tStats.isWeapon()) break;
                    tResult.put(tEntry.getKey(), tEntry.getValue());
                    break;
                }
                case all: {
                    tResult.put(tEntry.getKey(), tEntry.getValue());
                    break;
                }
                case armor: 
                case armor_feet: 
                case armor_head: 
                case armor_legs: 
                case armor_torso: {
                    break;
                }
                case bow: {
                    if (!tStats.isRangedWeapon()) break;
                    tResult.put(tEntry.getKey(), tEntry.getValue());
                    break;
                }
                case breakable: {
                    break;
                }
                case fishing_rod: {
                    break;
                }
                case digger: {
                    if (!tStats.isMiningTool()) break;
                    tResult.put(tEntry.getKey(), tEntry.getValue());
                }
            }
        }
        EnchantmentHelper.func_82782_a(tResult, (ItemStack)aStack);
        return MultiItemTool.getToolDamage(aStack) <= MultiItemTool.getToolMaxDamage(aStack);
    }

    @Override
    public short getChargedMetaData(ItemStack aStack) {
        return (short)(UT.Stacks.meta(aStack) - UT.Stacks.meta(aStack) % 2);
    }

    @Override
    public short getEmptyMetaData(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            aNBT.func_82580_o("ench");
        }
        return (short)(UT.Stacks.meta(aStack) + 1 - UT.Stacks.meta(aStack) % 2);
    }

    @Override
    public int func_77619_b() {
        return 0;
    }

    @Override
    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    @Override
    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    public int getRenderPasses(int aMetaData) {
        IToolStats tStats = this.getToolStatsInternal(aMetaData);
        if (tStats != null) {
            return tStats.getRenderPasses() + 2;
        }
        return 2;
    }

    public boolean func_77623_v() {
        return true;
    }

    @Override
    public void func_94581_a(IIconRegister aIconRegister) {
    }

    public int func_94901_k() {
        return 1;
    }

    public int func_82790_a(ItemStack aStack, int aRenderPass) {
        IToolStats tStats = this.getToolStatsInternal(aStack);
        if (tStats != null) {
            return UT.Code.getRGBaInt(tStats.getRGBa(aStack, aRenderPass));
        }
        return 0xFFFFFF;
    }

    public IIcon func_77650_f(ItemStack aStack) {
        return this.getIcon(aStack, 0);
    }

    @Override
    public IIcon func_77617_a(int aMetaData) {
        return this.func_77650_f(UT.Stacks.make(this, 1L, (long)aMetaData));
    }

    public IIcon getIcon(ItemStack aStack, int aRenderPass) {
        return this.getIcon(aStack, aRenderPass, null, null, 0);
    }

    public IIcon getIcon(ItemStack aStack, int aRenderPass, EntityPlayer aPlayer, ItemStack aUsedStack, int aUseRemaining) {
        IToolStats tStats = this.getToolStatsInternal(aStack);
        if (tStats == null) {
            return Textures.ItemIcons.VOID.getIcon(0);
        }
        if (aRenderPass < tStats.getRenderPasses()) {
            IIcon rIcon = tStats.getIcon(aStack, aRenderPass);
            return rIcon == null ? Textures.ItemIcons.VOID.getIcon(0) : rIcon;
        }
        if (aPlayer == null) {
            IItemEnergy tElectric;
            if ((aRenderPass -= tStats.getRenderPasses()) == 0) {
                long tDamage = MultiItemTool.getToolDamage(aStack);
                long tMaxDamage = MultiItemTool.getToolMaxDamage(aStack);
                if (tMaxDamage <= 0L) {
                    return Textures.ItemIcons.VOID.getIcon(0);
                }
                if (tDamage <= 0L) {
                    return Textures.ItemIcons.DURABILITY_BAR[8].getIcon(0);
                }
                if (tDamage >= tMaxDamage) {
                    return Textures.ItemIcons.DURABILITY_BAR[0].getIcon(0);
                }
                return Textures.ItemIcons.DURABILITY_BAR[(int)Math.max(0L, Math.min(7L, (tMaxDamage - tDamage) * 8L / tMaxDamage))].getIcon(0);
            }
            if (aRenderPass == 1 && (tElectric = this.getEnergyStats(aStack)) != null) {
                long tStored = tElectric.getEnergyStored(TD.Energy.EU, aStack);
                long tCapacity = tElectric.getEnergyCapacity(TD.Energy.EU, aStack);
                if (tStored <= 0L) {
                    return Textures.ItemIcons.ENERGY_BAR[0].getIcon(0);
                }
                if (tStored >= tCapacity) {
                    return Textures.ItemIcons.ENERGY_BAR[8].getIcon(0);
                }
                return Textures.ItemIcons.ENERGY_BAR[7 - (int)Math.max(0L, Math.min(6L, (tCapacity - tStored) * 7L / tCapacity))].getIcon(0);
            }
        }
        return Textures.ItemIcons.VOID.getIcon(0);
    }

    public IIcon func_77618_c(int aMetaData, int aRenderPass) {
        return this.func_77617_a(aMetaData);
    }

    public boolean func_77636_d(ItemStack aStack) {
        return false;
    }

    public boolean hasEffect(ItemStack aStack, int aRenderPass) {
        return false;
    }

    @Override
    public Long[] getFluidContainerStats(ItemStack aStack) {
        return null;
    }

    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }
}

