/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enviromine.handlers.EM_StatusManager;
import enviromine.trackers.EnviroDataTracker;
import gregapi.GT_API;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.IItemContainer;
import gregapi.code.TagData;
import gregapi.cover.CoverRegistry;
import gregapi.cover.ICover;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.TC;
import gregapi.data.TD;
import gregapi.item.IItemEnergy;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.item.multiitem.food.IFoodStat;
import gregapi.item.prefixitem.PrefixItem;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.UT;
import ic2.api.item.IItemReactorPlanStorage;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;

@Optional.InterfaceList(value={@Optional.Interface(iface="squeek.applecore.api.food.IEdible", modid="AppleCore"), @Optional.Interface(iface="ic2.api.item.IItemReactorPlanStorage", modid="IC2-Classic-Spmod")})
public abstract class MultiItemRandom
extends MultiItem
implements IEdible,
IItemReactorPlanStorage,
Runnable {
    public final BitSet mEnabledItems = new BitSet(Short.MAX_VALUE);
    public final BitSet mVisibleItems = new BitSet(Short.MAX_VALUE);
    public final IIcon[][] mIconList = new IIcon[Short.MAX_VALUE][1];
    public final HashMap<Short, IFoodStat> mFoodStats = new HashMap();
    public final HashMap<Short, IItemEnergy> mElectricStats = new HashMap();
    public final HashMap<Short, Short> mBurnValues = new HashMap();
    private boolean mAllowedToAddItems = false;

    public MultiItemRandom(String aModID, String aUnlocalized) {
        super(aModID, aUnlocalized);
        CS.GAPI.mBeforeInit.add(this);
    }

    public abstract void addItems();

    @Override
    public final void run() {
        this.mAllowedToAddItems = true;
        this.addItems();
    }

    @Override
    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        this.use(aStack, 0.0, (EntityLivingBase)aPlayer);
        this.isItemStackUsable(aStack);
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        if (tStat != null && (UT.Entities.isCreative(aPlayer) || aPlayer.func_71024_bL().func_75121_c() || tStat.alwaysEdible(this, aStack, aPlayer))) {
            aPlayer.func_71008_a(aStack, 32);
        }
        return super.func_77659_a(aStack, aWorld, aPlayer);
    }

    public final ItemStack addItem(int aID, String aEnglish, String aToolTip, Object ... aRandomData) {
        if (aToolTip == null) {
            aToolTip = "";
        }
        if (this.mAllowedToAddItems && aID >= 0 && aID < Short.MAX_VALUE && aID != Short.MAX_VALUE) {
            ItemStack rStack = UT.Stacks.make(this, 1L, (long)aID);
            this.mEnabledItems.set(aID);
            this.mVisibleItems.set(aID);
            LH.add(this.func_77667_c(rStack) + ".name", aEnglish);
            LH.add(this.func_77667_c(rStack) + ".tooltip", aToolTip);
            ArrayListNoNulls<TC.TC_AspectStack> tAspects = new ArrayListNoNulls<TC.TC_AspectStack>();
            for (Object tRandomData : aRandomData) {
                if (!(tRandomData instanceof TagData)) continue;
                if (tRandomData == TD.Creative.HIDDEN) {
                    this.mVisibleItems.set(aID, false);
                    continue;
                }
                if (tRandomData != TD.Properties.AUTO_BLACKLIST) continue;
                OreDictManager.INSTANCE.addToBlacklist_(rStack);
            }
            for (Object tRandomData : aRandomData) {
                if (tRandomData == null) continue;
                boolean tUseOreDict = true;
                if (tRandomData instanceof TagData) continue;
                if (tRandomData instanceof IFoodStat) {
                    int tFoodValue;
                    this.setFoodBehavior(aID, (IFoodStat)tRandomData);
                    if (this.getContainerItem(rStack) == null && (tFoodValue = ((IFoodStat)tRandomData).getFoodLevel(this, rStack, null)) > 0) {
                        Recipe.RecipeMap.sCannerRecipes.addRecipe2(true, 16L, (long)(tFoodValue * 16), rStack, IL.IC2_Food_Can_Empty.get(tFoodValue, new Object[0]), ((IFoodStat)tRandomData).isRotten(this, rStack, null) ? IL.IC2_Food_Can_Spoiled.get(tFoodValue, new Object[0]) : IL.IC2_Food_Can_Filled.get(tFoodValue, new Object[0]));
                    }
                    tUseOreDict = false;
                }
                if (tRandomData instanceof ICover) {
                    CoverRegistry.put(rStack, (ICover)tRandomData);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IBehavior) {
                    this.addItemBehavior(aID, (IBehavior)tRandomData);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IItemEnergy) {
                    this.setElectricStats(aID, (IItemEnergy)tRandomData);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IItemContainer) {
                    ((IItemContainer)tRandomData).set(rStack);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof TC.TC_AspectStack) {
                    ((TC.TC_AspectStack)tRandomData).addToAspectList(tAspects);
                    continue;
                }
                if (tRandomData instanceof OreDictItemData) {
                    ItemStack tStack;
                    if (((OreDictItemData)tRandomData).hasValidPrefixMaterialData() && (UT.Stacks.invalid(tStack = ((OreDictItemData)tRandomData).getStack(1L)) || tStack.func_77973_b() instanceof PrefixItem)) {
                        OreDictManager.INSTANCE.setTarget_(((OreDictItemData)tRandomData).mPrefix, ((OreDictItemData)tRandomData).mMaterial.mMaterial, rStack);
                        continue;
                    }
                    OreDictManager.INSTANCE.addItemData_(rStack, (OreDictItemData)tRandomData);
                    continue;
                }
                if (tRandomData instanceof FluidStack) {
                    tRandomData = new FluidContainerRegistry.FluidContainerData((FluidStack)tRandomData, UT.Stacks.copy(rStack), this.getContainerItem(rStack), true);
                    if (((FluidContainerRegistry.FluidContainerData)tRandomData).emptyContainer != null) {
                        Recipe.RecipeMap.sCannerRecipes.addRecipe1(true, 16L, (long)Math.max(((FluidContainerRegistry.FluidContainerData)tRandomData).fluid.amount / 64, 16), ((FluidContainerRegistry.FluidContainerData)tRandomData).emptyContainer, ((FluidContainerRegistry.FluidContainerData)tRandomData).fluid, CS.NF, ((FluidContainerRegistry.FluidContainerData)tRandomData).filledContainer);
                    }
                    Recipe.RecipeMap.sCannerRecipes.addRecipe1(true, 16L, (long)Math.max(((FluidContainerRegistry.FluidContainerData)tRandomData).fluid.amount / 64, 16), ((FluidContainerRegistry.FluidContainerData)tRandomData).filledContainer, CS.NF, ((FluidContainerRegistry.FluidContainerData)tRandomData).fluid, UT.Stacks.container(((FluidContainerRegistry.FluidContainerData)tRandomData).filledContainer, false));
                    FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)((FluidContainerRegistry.FluidContainerData)tRandomData));
                    continue;
                }
                if (tRandomData instanceof FluidContainerRegistry.FluidContainerData) {
                    if (((FluidContainerRegistry.FluidContainerData)tRandomData).emptyContainer != null) {
                        Recipe.RecipeMap.sCannerRecipes.addRecipe1(true, 16L, (long)Math.max(((FluidContainerRegistry.FluidContainerData)tRandomData).fluid.amount / 64, 16), ((FluidContainerRegistry.FluidContainerData)tRandomData).emptyContainer, ((FluidContainerRegistry.FluidContainerData)tRandomData).fluid, CS.NF, ((FluidContainerRegistry.FluidContainerData)tRandomData).filledContainer);
                    }
                    Recipe.RecipeMap.sCannerRecipes.addRecipe1(true, 16L, (long)Math.max(((FluidContainerRegistry.FluidContainerData)tRandomData).fluid.amount / 64, 16), ((FluidContainerRegistry.FluidContainerData)tRandomData).filledContainer, CS.NF, ((FluidContainerRegistry.FluidContainerData)tRandomData).fluid, UT.Stacks.container(((FluidContainerRegistry.FluidContainerData)tRandomData).filledContainer, false));
                    FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)((FluidContainerRegistry.FluidContainerData)tRandomData));
                    continue;
                }
                if (tRandomData instanceof Runnable) {
                    CS.GAPI.mAfterPostInit.add((Runnable)tRandomData);
                    continue;
                }
                if (!tUseOreDict) continue;
                OM.reg(tRandomData, rStack);
            }
            if (GT_API.sCompatTC != null) {
                GT_API.sCompatTC.registerThaumcraftAspectsToItem(rStack, tAspects, false);
            }
            rStack = UT.Stacks.make(this, 1L, (long)aID);
            UT.Stacks.update(rStack);
            return rStack;
        }
        return null;
    }

    public MultiItemRandom setFoodBehavior(int aMetaValue, IFoodStat aFoodBehavior) {
        if (aMetaValue < 0 || aMetaValue >= this.mEnabledItems.length()) {
            return this;
        }
        if (aFoodBehavior == null) {
            this.mFoodStats.remove((short)aMetaValue);
        } else {
            this.mFoodStats.put((short)aMetaValue, aFoodBehavior);
        }
        return this;
    }

    public MultiItemRandom setBurnValue(int aMetaValue, int aValue) {
        if (aMetaValue < 0 || aMetaValue >= this.mEnabledItems.length() || aValue < 0) {
            return this;
        }
        if (aValue == 0) {
            this.mBurnValues.remove((short)aMetaValue);
        } else {
            this.mBurnValues.put((short)aMetaValue, (short)(aValue > Short.MAX_VALUE ? Short.MAX_VALUE : (short)aValue));
        }
        return this;
    }

    public MultiItemRandom setElectricStats(int aMetaValue, IItemEnergy aStats) {
        if (aMetaValue < 0 || aMetaValue >= this.mEnabledItems.length()) {
            return this;
        }
        if (aStats == null) {
            this.mElectricStats.remove((short)aMetaValue);
        } else {
            this.mElectricStats.put((short)aMetaValue, aStats);
            this.mIconList[aMetaValue] = Arrays.copyOf(this.mIconList[aMetaValue], Math.max(9, this.mIconList[aMetaValue].length));
        }
        return this;
    }

    public MultiItemRandom setFluidContainerStats(int aMetaValue, long aCapacity, long aStacksize) {
        if (aMetaValue < 0 || aMetaValue >= this.mEnabledItems.length()) {
            return this;
        }
        if (aCapacity < 0L) {
            this.mFluidContainerStats.remove((short)aMetaValue);
        } else {
            this.mFluidContainerStats.put((short)aMetaValue, new Long[]{aCapacity, Math.max(1L, aStacksize)});
        }
        return this;
    }

    public int func_77626_a(ItemStack aStack) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        return tStat == null ? 0 : Math.max(tStat.getFoodLevel(this, aStack, null) * 8, 8);
    }

    public EnumAction func_77661_b(ItemStack aStack) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        return tStat == null ? EnumAction.none : tStat.getFoodAction(this, aStack);
    }

    public ItemStack func_77654_b(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        if (tStat != null) {
            if (tStat.useAppleCoreFunctionality(this, aStack, aPlayer) && MD.APC.mLoaded) {
                aPlayer.func_71024_bL().func_151686_a((ItemFood)UT.Reflection.callConstructor("squeek.applecore.api.food.ItemFoodProxy.ItemFoodProxy", 0, null, true, this), aStack);
            } else {
                aPlayer.func_71024_bL().func_75122_a(tStat.getFoodLevel(this, aStack, aPlayer), tStat.getSaturation(this, aStack, aPlayer));
            }
            if (!aWorld.field_72995_K && MD.ENVM.mLoaded) {
                try {
                    float tTemperature = tStat.getTemperature(this, aStack, aPlayer) - 273.0f;
                    float tHydration = tStat.getHydration(this, aStack, aPlayer);
                    EnviroDataTracker tTracker = EM_StatusManager.lookupTracker((EntityLivingBase)aPlayer);
                    if (tTracker != null && tTracker.bodyTemp >= 0.0f) {
                        tTracker.bodyTemp += (tTemperature - tTracker.bodyTemp) * tStat.getTemperatureEffect(this, aStack, aPlayer);
                        if (tHydration > 0.0f) {
                            tTracker.hydrate(tHydration);
                        } else if (tHydration < 0.0f) {
                            tTracker.dehydrate(-tHydration);
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
            tStat.onEaten(this, aStack, aPlayer);
        }
        return aStack;
    }

    @Override
    public IItemEnergy getEnergyStats(ItemStack aStack) {
        return this.mElectricStats.get(UT.Stacks.meta(aStack));
    }

    @Override
    public Long[] getFluidContainerStats(ItemStack aStack) {
        return (Long[])this.mFluidContainerStats.get(UT.Stacks.meta(aStack));
    }

    @Optional.Method(modid="AppleCore")
    public FoodValues getFoodValues(ItemStack aStack) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        return tStat == null ? null : new FoodValues(tStat.getFoodLevel(this, aStack, null), tStat.getSaturation(this, aStack, null));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        int j = this.mEnabledItems.length();
        for (int i = 0; i < j; ++i) {
            ItemStack tStack;
            if (!this.mVisibleItems.get(i) && (!CS.SHOW_HIDDEN_ITEMS || !this.mEnabledItems.get(i))) continue;
            IItemEnergy tStats = this.mElectricStats.get((short)i);
            if (tStats == null) {
                tStack = UT.Stacks.make(this, 1L, (long)i);
                this.isItemStackUsable(tStack);
                aList.add(tStack);
                continue;
            }
            tStack = UT.Stacks.make(this, 1L, (long)i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
            tStack = UT.Stacks.make(this, 1L, (long)i);
            for (TagData tEnergyType : tStats.getEnergyTypes(tStack)) {
                tStats.setEnergyStored(tEnergyType, tStack, Long.MAX_VALUE);
            }
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
        if (aList.isEmpty()) {
            UT.Stacks.hide(this);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
        short j = (short)this.mEnabledItems.length();
        for (short i = 0; i < j; i = (short)(i + 1)) {
            if (!this.mEnabledItems.get(i)) continue;
            for (int k = 1; k < this.mIconList[i].length; k = (int)((byte)(k + 1))) {
                this.mIconList[i][k] = aIconRegister.func_94245_a(this.mModID + ":" + this.func_77658_a() + "/" + i + "/" + k);
            }
            this.mIconList[i][0] = aIconRegister.func_94245_a(this.mModID + ":" + this.func_77658_a() + "/" + i);
        }
    }

    public IIcon func_77650_f(ItemStack aStack) {
        short aMetaData = UT.Stacks.meta(aStack);
        if (!UT.Code.exists(aMetaData, this.mIconList)) {
            return null;
        }
        IItemEnergy tStats = this.mElectricStats.get(aMetaData);
        if (tStats != null) {
            TagData tEnergyType = tStats.getEnergyTypes(aStack).iterator().next();
            long tStored = tStats.getEnergyStored(tEnergyType, aStack);
            long tCapacity = tStats.getEnergyCapacity(tEnergyType, aStack);
            if (tStored <= 0L) {
                return this.mIconList[aMetaData][1];
            }
            if (tStored >= tCapacity) {
                return this.mIconList[aMetaData][8];
            }
            return this.mIconList[aMetaData][7 - (int)Math.max(0L, Math.min(5L, (tCapacity - tStored) * 6L / tCapacity))];
        }
        return this.mIconList[aMetaData][0];
    }

    @Override
    public IIcon func_77617_a(int aMetaData) {
        return UT.Code.exists(aMetaData, this.mIconList) ? this.mIconList[aMetaData][0] : null;
    }

    public IIcon getIcon(ItemStack aStack, int aRenderPass) {
        return this.func_77650_f(aStack);
    }

    public IIcon getIcon(ItemStack aStack, int aRenderPass, EntityPlayer aPlayer, ItemStack aUsedStack, int aUseRemaining) {
        return this.func_77650_f(aStack);
    }

    public IIcon func_77618_c(int aMetaData, int aRenderPass) {
        return this.func_77617_a(aMetaData);
    }

    @Override
    public void addAdditionalToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        IFoodStat tStat = this.mFoodStats.get((short)this.getDamage(aStack));
        if (tStat != null) {
            tStat.addAdditionalToolTips(this, aList, aStack, aF3_H);
        }
    }

    public boolean isPlanStorage(ItemStack aStack) {
        return OM.is(CS.OD_USB_STICKS[2], aStack);
    }

    public boolean setSetup(ItemStack aStack, String aSetup) {
        if (OM.is(CS.OD_USB_STICKS[2], aStack)) {
            if (!aStack.func_77942_o()) {
                aStack.func_77982_d(new NBTTagCompound());
            }
            aStack.func_77978_p().func_74782_a("gt.usb.data", (NBTBase)UT.NBT.getNBTString(UT.NBT.getNBTString(null, "gt.reactor.setup.name", "" + aSetup.hashCode()), "gt.reactor.setup", aSetup));
            aStack.func_77978_p().func_74774_a("gt.usb.tier", (byte)2);
            return true;
        }
        return false;
    }

    public void setPlanName(ItemStack aStack, String aName) {
        aStack.func_77978_p().func_74775_l("gt.usb.data").func_74778_a("gt.reactor.setup.name", aName);
    }

    public boolean hasSetup(ItemStack aStack) {
        return OM.is(CS.OD_USB_STICKS[2], aStack) && aStack.func_77942_o() && aStack.func_77978_p().func_74775_l("gt.usb.data").func_74764_b("gt.reactor.setup");
    }

    public String getSetup(ItemStack aStack) {
        return aStack.func_77978_p().func_74775_l("gt.usb.data").func_74779_i("gt.reactor.setup");
    }
}

