/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem;

import cpw.mods.fml.common.Optional;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.item.IItemEnergy;
import gregapi.item.IItemProjectile;
import gregapi.item.ItemBase;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.lang.LanguageHandler;
import gregapi.recipes.GT_ModHandler;
import gregapi.util.UT;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2"), @Optional.Interface(iface="ic2.api.item.IElectricItemManager", modid="IC2")})
public abstract class MultiItem
extends ItemBase
implements ISpecialElectricItem,
IElectricItemManager,
IItemEnergy {
    private final HashMap<Short, ArrayList<IBehavior<MultiItem>>> mItemBehaviors = new HashMap();
    public final HashMap<Short, Long[]> mFluidContainerStats = new HashMap();

    public MultiItem(String aModID, String aUnlocalized) {
        super(aModID, aUnlocalized, "Generated Item", null);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public MultiItem addItemBehavior(int aMetaValue, IBehavior<MultiItem> aBehavior) {
        if (aMetaValue < 0 || aMetaValue >= 32766 || aBehavior == null) {
            return this;
        }
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)aMetaValue);
        if (tList == null) {
            tList = new ArrayListNoNulls<IBehavior<MultiItem>>();
            this.mItemBehaviors.put((short)aMetaValue, tList);
        }
        tList.add(aBehavior);
        return this;
    }

    @Override
    public boolean hasProjectile(TagData aProjectileType, ItemStack aStack) {
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                if (!tBehavior.hasProjectile(this, aProjectileType, aStack)) continue;
                return true;
            }
        }
        return super.hasProjectile(aProjectileType, aStack);
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(TagData aProjectileType, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                IItemProjectile.EntityProjectile rArrow = tBehavior.getProjectile(this, aProjectileType, aStack, aWorld, aX, aY, aZ);
                if (rArrow == null) continue;
                return rArrow;
            }
        }
        return super.getProjectile(aProjectileType, aStack, aWorld, aX, aY, aZ);
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(TagData aProjectileType, ItemStack aStack, World aWorld, EntityLivingBase aEntity, float aSpeed) {
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                IItemProjectile.EntityProjectile rArrow = tBehavior.getProjectile(this, aProjectileType, aStack, aWorld, aEntity, aSpeed);
                if (rArrow == null) continue;
                return rArrow;
            }
        }
        return super.getProjectile(aProjectileType, aStack, aWorld, aEntity, aSpeed);
    }

    @Override
    public ItemStack onDispense(IBlockSource aSource, ItemStack aStack) {
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                if (!tBehavior.canDispense(this, aSource, aStack)) continue;
                return tBehavior.onDispense(this, aSource, aStack);
            }
        }
        return super.onDispense(aSource, aStack);
    }

    @Override
    public boolean isItemStackUsable(ItemStack aStack) {
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                if (tBehavior.isItemStackUsable(this, aStack)) continue;
                return false;
            }
        }
        return super.isItemStackUsable(aStack);
    }

    public boolean func_111207_a(ItemStack aStack, EntityPlayer aPlayer, EntityLivingBase aEntity) {
        this.use(aStack, 0.0, (EntityLivingBase)aPlayer);
        this.isItemStackUsable(aStack);
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                try {
                    if (tBehavior.onRightClickEntity(this, aStack, aPlayer, (Entity)aEntity)) {
                        if (aStack.field_77994_a <= 0) {
                            aPlayer.func_71028_bD();
                        }
                        return true;
                    }
                    if (aStack.field_77994_a > 0) continue;
                    aPlayer.func_71028_bD();
                    return false;
                }
                catch (Throwable e) {
                    if (!CS.D1) continue;
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        return false;
    }

    public boolean onLeftClickEntity(ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        this.use(aStack, 0.0, (EntityLivingBase)aPlayer);
        this.isItemStackUsable(aStack);
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                try {
                    if (tBehavior.onLeftClickEntity(this, aStack, aPlayer, aEntity)) {
                        if (aStack.field_77994_a <= 0) {
                            aPlayer.func_71028_bD();
                        }
                        return true;
                    }
                    if (aStack.field_77994_a > 0) continue;
                    aPlayer.func_71028_bD();
                    return false;
                }
                catch (Throwable e) {
                    if (!CS.D1) continue;
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        return false;
    }

    public boolean func_77648_a(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        this.use(aStack, 0.0, (EntityLivingBase)aPlayer);
        this.isItemStackUsable(aStack);
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                try {
                    if (tBehavior.onItemUse(this, aStack, aPlayer, aWorld, aX, aY, aZ, UT.Code.side(aSide), hitX, hitY, hitZ)) {
                        if (aStack.field_77994_a <= 0) {
                            aPlayer.func_71028_bD();
                        }
                        return true;
                    }
                    if (aStack.field_77994_a > 0) continue;
                    aPlayer.func_71028_bD();
                    return false;
                }
                catch (Throwable e) {
                    if (!CS.D1) continue;
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        this.use(aStack, 0.0, (EntityLivingBase)aPlayer);
        this.isItemStackUsable(aStack);
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                try {
                    if (tBehavior.onItemUseFirst(this, aStack, aPlayer, aWorld, aX, aY, aZ, UT.Code.side(aSide), hitX, hitY, hitZ)) {
                        if (aStack.field_77994_a <= 0) {
                            aPlayer.func_71028_bD();
                        }
                        return true;
                    }
                    if (aStack.field_77994_a > 0) continue;
                    aPlayer.func_71028_bD();
                    return false;
                }
                catch (Throwable e) {
                    if (!CS.D1) continue;
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        this.use(aStack, 0.0, (EntityLivingBase)aPlayer);
        this.isItemStackUsable(aStack);
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                try {
                    aStack = tBehavior.onItemRightClick(this, aStack, aWorld, aPlayer);
                }
                catch (Throwable e) {
                    if (!CS.D1) continue;
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        return aStack;
    }

    @Override
    public final void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        Long[] tStats;
        IItemEnergy tEnergyStats;
        String tKey = this.func_77667_c(aStack) + ".tooltip";
        String tString = LanguageHandler.translate(tKey, tKey);
        if (UT.Code.stringValid(tString) && !tKey.equals(tString)) {
            aList.add(tString);
        }
        if ((tEnergyStats = this.getEnergyStats(aStack)) != null) {
            for (TagData tEnergyType : tEnergyStats.getEnergyTypes(aStack)) {
                aList.add(LH.Chat.WHITE + tEnergyStats.getEnergyStored(tEnergyType, aStack) + " / " + tEnergyStats.getEnergyCapacity(tEnergyType, aStack) + " " + tEnergyType.mChatFormat + tEnergyType.getLocalisedNameShort() + LH.Chat.WHITE + " - Size: " + tEnergyStats.getEnergySizeInputRecommended(tEnergyType, aStack) + EnumChatFormatting.GRAY);
            }
        }
        if ((tStats = this.getFluidContainerStats(aStack)) != null && tStats[0] > 0L) {
            FluidStack tFluid = this.getFluidContent(aStack);
            aList.add(LH.Chat.BLUE + (tFluid == null ? "No Fluids Contained" : UT.Fluids.name(tFluid, true)) + LH.Chat.GRAY);
            aList.add(LH.Chat.BLUE + (tFluid == null ? 0 : tFluid.amount) + "L / " + tStats[0] + "L" + LH.Chat.GRAY);
        }
        this.addAdditionalToolTips(aList, aStack, aF3_H);
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                aList = tBehavior.getAdditionalToolTips(this, aList, aStack);
            }
        }
    }

    public void func_77663_a(ItemStack aStack, World aWorld, Entity aPlayer, int aTimer, boolean aIsInHand) {
        ArrayList<IBehavior<MultiItem>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IBehavior<MultiItem> tBehavior : tList) {
                tBehavior.onUpdate(this, aStack, aWorld, aPlayer, aTimer, aIsInHand);
            }
        }
    }

    public boolean canProvideEnergy(ItemStack aStack) {
        return true;
    }

    public double getMaxCharge(ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0.0;
        }
        return tStats.getEnergyCapacity(TD.Energy.EU, aStack);
    }

    public double getTransferLimit(ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0.0;
        }
        return tStats.getEnergySizeInputRecommended(TD.Energy.EU, aStack);
    }

    public double charge(ItemStack aStack, double aCharge, int aTier, boolean aIgnoreTransferLimit, boolean aSimulate) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        aTier = UT.Code.bind4(aTier);
        if (tStats == null || aCharge < (double)CS.V[aTier]) {
            return 0.0;
        }
        return CS.V[aTier] * tStats.doEnergyInjection(TD.Energy.EU, aStack, CS.V[aTier], (long)(aCharge / (double)CS.V[aTier]), null, null, 0, 0, 0, !aSimulate);
    }

    public double discharge(ItemStack aStack, double aCharge, int aTier, boolean aIgnoreTransferLimit, boolean aBatteryAlike, boolean aSimulate) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        aTier = UT.Code.bind4(aTier);
        if (tStats == null || aCharge < (double)CS.V[aTier]) {
            return 0.0;
        }
        return CS.V[aTier] * tStats.doEnergyExtraction(TD.Energy.EU, aStack, CS.V[aTier], (long)(aCharge / (double)CS.V[aTier]), null, null, 0, 0, 0, !aSimulate);
    }

    public double getCharge(ItemStack aStack) {
        return this.getRealCharge(aStack);
    }

    public boolean canUse(ItemStack aStack, double aAmount) {
        return false;
    }

    public boolean use(ItemStack aStack, double aAmount, EntityLivingBase aPlayer) {
        return false;
    }

    public void chargeFromArmor(ItemStack aStack, EntityLivingBase aPlayer) {
        if (aPlayer == null || aPlayer.field_70170_p.field_72995_K) {
            return;
        }
        for (int i = 1; i < 5; ++i) {
            Container tContainer;
            double tCharge;
            IElectricItem tArmorItem;
            ItemStack tArmor = aPlayer.func_71124_b(i);
            if (!GT_ModHandler.isElectricItem(tArmor) || !(tArmorItem = (IElectricItem)tArmor.func_77973_b()).canProvideEnergy(tArmor) || tArmorItem.getTier(tArmor) < this.getTier(aStack) || !((tCharge = ElectricItem.manager.discharge(tArmor, this.charge(aStack, 2.147483646E9, Integer.MAX_VALUE, true, true), Integer.MAX_VALUE, true, true, false)) > 0.0)) continue;
            this.charge(aStack, tCharge, Integer.MAX_VALUE, true, false);
            if (!(aPlayer instanceof EntityPlayer) || (tContainer = ((EntityPlayer)aPlayer).field_71070_bA) == null) continue;
            tContainer.func_75142_b();
        }
    }

    public long getRealCharge(ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergyStored(TD.Energy.EU, aStack);
    }

    public boolean setCharge(ItemStack aStack, long aCharge) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return false;
        }
        tStats.setEnergyStored(TD.Energy.EU, aStack, aCharge);
        return true;
    }

    public short getChargedMetaData(ItemStack aStack) {
        return UT.Stacks.meta(aStack);
    }

    public short getEmptyMetaData(ItemStack aStack) {
        return UT.Stacks.meta(aStack);
    }

    public FluidStack getFluid(ItemStack aStack) {
        return this.getFluidContent(aStack);
    }

    public int getCapacity(ItemStack aStack) {
        Long[] tStats = this.getFluidContainerStats(aStack);
        return tStats == null ? 0 : (int)Math.max(0L, tStats[0]);
    }

    public int fill(ItemStack aStack, FluidStack aFluid, boolean doFill) {
        if (aStack == null || aStack.field_77994_a != 1) {
            return 0;
        }
        ItemStack tStack = UT.Fluids.fillFluidContainer(aFluid, aStack, false, false, false);
        if (tStack != null) {
            aStack.func_77964_b((int)UT.Stacks.meta(tStack));
            aStack.func_150996_a(tStack.func_77973_b());
            return UT.Fluids.getFluidForFilledItem((ItemStack)tStack, (boolean)false).amount;
        }
        Long[] tStats = this.getFluidContainerStats(aStack);
        if (tStats == null || tStats[0] <= 0L || aFluid == null || aFluid.amount <= 0 || !this.isAllowedToFill(aStack, aFluid)) {
            return 0;
        }
        FluidStack tFluid = this.getFluidContent(aStack);
        if (tFluid == null) {
            if ((long)aFluid.amount <= tStats[0]) {
                if (doFill) {
                    this.setFluidContent(aStack, aFluid);
                }
                return aFluid.amount;
            }
            if (doFill) {
                tFluid = aFluid.copy();
                tFluid.amount = (int)tStats[0].longValue();
                this.setFluidContent(aStack, tFluid);
            }
            return (int)tStats[0].longValue();
        }
        if (!tFluid.isFluidEqual(aFluid)) {
            return 0;
        }
        int space = (int)tStats[0].longValue() - tFluid.amount;
        if (aFluid.amount <= space) {
            if (doFill) {
                tFluid.amount += aFluid.amount;
                this.setFluidContent(aStack, tFluid);
            }
            return aFluid.amount;
        }
        if (doFill) {
            tFluid.amount = (int)tStats[0].longValue();
            this.setFluidContent(aStack, tFluid);
        }
        return space;
    }

    public boolean isAllowedToFill(ItemStack aStack, FluidStack aFluid) {
        return true;
    }

    public FluidStack drain(ItemStack aStack, int aMaxDrain, boolean aDoDrain) {
        if (aStack == null || aStack.field_77994_a != 1) {
            return null;
        }
        FluidStack tFluid = UT.Fluids.getFluidForFilledItem(aStack, false);
        if (tFluid != null && aMaxDrain >= tFluid.amount) {
            if (aDoDrain) {
                ItemStack tStack = UT.Stacks.container(aStack, false);
                if (tStack == null) {
                    aStack.field_77994_a = 0;
                    return tFluid;
                }
                aStack.func_77964_b((int)UT.Stacks.meta(tStack));
                aStack.func_150996_a(tStack.func_77973_b());
            }
            return tFluid;
        }
        Long[] tStats = this.getFluidContainerStats(aStack);
        if (tStats == null || tStats[0] <= 0L) {
            return null;
        }
        tFluid = this.getFluidContent(aStack);
        if (tFluid == null) {
            return null;
        }
        if (tFluid.amount < aMaxDrain) {
            aMaxDrain = tFluid.amount;
        }
        if (aDoDrain) {
            tFluid.amount -= aMaxDrain;
            this.setFluidContent(aStack, tFluid);
        }
        FluidStack tDrained = tFluid.copy();
        tDrained.amount = aMaxDrain;
        return tDrained;
    }

    public FluidStack getFluidContent(ItemStack aStack) {
        Long[] tStats = this.getFluidContainerStats(aStack);
        if (tStats == null || tStats[0] <= 0L) {
            return UT.Fluids.getFluidForFilledItem(aStack, false);
        }
        return UT.Fluids.load(aStack.func_77978_p(), "gt.fluidcontent");
    }

    public void setFluidContent(ItemStack aStack, FluidStack aFluid) {
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        } else {
            tNBT.func_82580_o("gt.fluidcontent");
        }
        if (aFluid != null && aFluid.amount > 0) {
            UT.Fluids.save(tNBT, "gt.fluidcontent", aFluid);
        }
        aStack.func_77982_d(tNBT.func_82582_d() ? null : tNBT);
        this.isItemStackUsable(aStack);
    }

    public int getItemStackLimit(ItemStack aStack) {
        if (aStack.func_77942_o() && aStack.func_77978_p().func_74764_b("gt.energy")) {
            return 1;
        }
        Long[] tStats = this.getFluidContainerStats(aStack);
        if (tStats != null) {
            return (int)tStats[1].longValue();
        }
        return UT.Code.bindStack(this.getDefaultStackLimit(aStack));
    }

    public int getDefaultStackLimit(ItemStack aStack) {
        return 64;
    }

    @Optional.Method(modid="IC2")
    public IElectricItemManager getManager(ItemStack aStack) {
        return this;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public int getTier(ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        return tStats == null ? Integer.MAX_VALUE : (int)UT.Code.tierMax(tStats.getEnergySizeInputMax(TD.Energy.EU, aStack));
    }

    public String getToolTip(ItemStack aStack) {
        return null;
    }

    public final boolean func_77651_p() {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, ItemStack aStack, boolean aEmitting) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return false;
        }
        return tStats.isEnergyType(aEnergyType, aStack, aEmitting);
    }

    @Override
    public long doEnergyInjection(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoInject) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.doEnergyInjection(aEnergyType, aStack, aSize, aAmount, aInventory, aWorld, aX, aY, aZ, aDoInject);
    }

    @Override
    public long doEnergyExtraction(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoExtract) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.doEnergyExtraction(aEnergyType, aStack, aSize, aAmount, aInventory, aWorld, aX, aY, aZ, aDoExtract);
    }

    @Override
    public boolean useEnergy(TagData aEnergyType, ItemStack aStack, long aEnergyAmount, EntityLivingBase aPlayer, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoUse) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return false;
        }
        return tStats.useEnergy(aEnergyType, aStack, aEnergyAmount, aPlayer, aInventory, aWorld, aX, aY, aZ, aDoUse);
    }

    @Override
    public ItemStack setEnergyStored(TagData aEnergyType, ItemStack aStack, long aAmount) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return aStack;
        }
        return tStats.setEnergyStored(aEnergyType, aStack, aAmount);
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergyStored(aEnergyType, aStack);
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergyCapacity(aEnergyType, aStack);
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergySizeInputMin(aEnergyType, aStack);
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergySizeOutputMin(aEnergyType, aStack);
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergySizeInputRecommended(aEnergyType, aStack);
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergySizeOutputRecommended(aEnergyType, aStack);
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergySizeInputMax(aEnergyType, aStack);
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        return tStats.getEnergySizeOutputMax(aEnergyType, aStack);
    }

    @Override
    public Collection<TagData> getEnergyTypes(ItemStack aStack) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        if (tStats == null) {
            return Collections.EMPTY_LIST;
        }
        return tStats.getEnergyTypes(aStack);
    }

    @Override
    public boolean canEnergyInjection(TagData aEnergyType, ItemStack aStack, long aSize) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        return tStats != null && tStats.canEnergyInjection(aEnergyType, aStack, aSize);
    }

    @Override
    public boolean canEnergyExtraction(TagData aEnergyType, ItemStack aStack, long aSize) {
        IItemEnergy tStats = this.getEnergyStats(aStack);
        return tStats != null && tStats.canEnergyExtraction(aEnergyType, aStack, aSize);
    }

    public abstract IItemEnergy getEnergyStats(ItemStack var1);

    public abstract Long[] getFluidContainerStats(ItemStack var1);
}

