/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.GT_API;
import gregapi.api.Abstract_Mod;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.item.IItemUpdatable;
import gregapi.old.GT_BaseCrop;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemFluidDisplay
extends Item
implements IFluidContainerItem,
IItemUpdatable {
    protected IIcon mIcon;
    private final String mName;

    public ItemFluidDisplay() {
        this.mName = "gt.display.fluid";
        LH.add(this.mName + ".name", "Fluid Display");
        GameRegistry.registerItem((Item)this, (String)this.mName, (String)MD.GAPI.mID);
        if (!CS.D1) {
            UT.Stacks.hide(this);
        }
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        Fluid tFluid = FluidRegistry.getFluid((int)UT.Stacks.meta(aStack));
        if (CS.D1 && tFluid != null) {
            aList.add("Registry: " + tFluid.getName());
        }
        if (aNBT != null) {
            long tToolTipAmount = aNBT.func_74763_f("a");
            if (tToolTipAmount > 0L) {
                long tAmount;
                OreDictMaterialStack tMaterial;
                aList.add(LH.Chat.BLUE + "Amount: " + tToolTipAmount + " L" + LH.Chat.GRAY);
                if (tFluid != null && (tMaterial = OreDictMaterial.FLUID_MAP.get(tFluid.getName())) != null && tMaterial.mAmount > 0L && (tAmount = UT.Code.units(tToolTipAmount, tMaterial.mAmount, 420076800L, false)) > 0L) {
                    int tDigits = (int)((double)(tAmount % 420076800L) / 4.200768E8 * 1000.0);
                    aList.add(LH.Chat.BLUE + "Worth: " + tAmount / 420076800L + "." + (tDigits < 1 ? "000" : (tDigits < 10 ? "00" + tDigits : (tDigits < 100 ? "0" + tDigits : Integer.valueOf(tDigits)))) + " Units of " + tMaterial.mMaterial.getLocal() + LH.Chat.GRAY);
                }
            }
            aList.add(LH.Chat.RED + "Temperature: " + aNBT.func_74763_f("h") + " K" + LH.Chat.GRAY);
            aList.add(LH.Chat.GREEN + "State: " + (aNBT.func_74767_n("s") ? "Gas" : "Liquid") + LH.Chat.GRAY);
            if (UT.Fluids.simple(tFluid)) {
                aList.add(LH.Chat.DGREEN + "This is a simple Fluid" + LH.Chat.GRAY);
            }
            if (UT.Fluids.acid(tFluid)) {
                aList.add(LH.Chat.ORANGE + "Acidous! Handle with Care!" + LH.Chat.GRAY);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
        if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI) {
            CS.OUT.println("GT_API: Setting up Icon Register for Blocks");
            GT_API.sBlockIcons = aIconRegister;
            CS.OUT.println("GT_API: Starting Block Icon Load Phase");
            for (Runnable tRunnable : GT_API.sBlockIconload) {
                try {
                    tRunnable.run();
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
            CS.OUT.println("GT_API: Registering Crop specific Textures");
            try {
                for (GT_BaseCrop tCrop : GT_BaseCrop.sCropList) {
                    tCrop.registerSprites(aIconRegister);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            CS.OUT.println("GT_API: Finished Block Icon Load Phase");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int aMeta) {
        Fluid tFluid = FluidRegistry.getFluid((int)aMeta);
        return tFluid == null ? FluidRegistry.WATER.getStillIcon() : tFluid.getStillIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack aStack, int aRenderPass) {
        Fluid tFluid = FluidRegistry.getFluid((int)UT.Stacks.meta(aStack));
        return tFluid == null ? 0xFFFFFF : tFluid.getColor();
    }

    public int func_94901_k() {
        return 0;
    }

    public String func_77667_c(ItemStack aStack) {
        if (aStack != null) {
            return UT.Fluids.name(FluidRegistry.getFluid((int)UT.Stacks.meta(aStack)), false);
        }
        return "";
    }

    public String func_77653_i(ItemStack aStack) {
        if (aStack != null) {
            return UT.Fluids.name(FluidRegistry.getFluid((int)UT.Stacks.meta(aStack)), true);
        }
        return "";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aTab, List aList) {
        if (CS.D1) {
            int j = FluidRegistry.getMaxID();
            for (int i = 0; i <= j; ++i) {
                ItemStack tStack = UT.Fluids.display(FluidRegistry.getFluid((int)i));
                if (tStack == null) continue;
                aList.add(tStack);
            }
        }
        for (String tName : UT.Books.BOOK_LIST) {
            aList.add(UT.Books.getBookWithTitle(tName));
        }
    }

    public final Item func_77655_b(String aName) {
        return this;
    }

    public final String func_77658_a() {
        return this.mName;
    }

    public boolean doesSneakBypassUse(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return null;
    }

    public final boolean hasContainerItem(ItemStack aStack) {
        return false;
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
        Fluid tFluid;
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
            aStack.func_77982_d(aNBT);
        }
        if ((tFluid = UT.Fluids.fluid(aNBT.func_74779_i("f"))) == null) {
            tFluid = UT.Fluids.fluid(UT.Stacks.meta(aStack));
            if (tFluid == null) {
                UT.Stacks.meta(aStack, 32767L);
            } else {
                aNBT.func_74778_a("f", tFluid.getName());
            }
        } else {
            UT.Stacks.meta(aStack, tFluid.getID());
        }
    }

    public FluidStack getFluid(ItemStack aStack) {
        long tAmount;
        Fluid tFluid = FluidRegistry.getFluid((int)UT.Stacks.meta(aStack));
        if (tFluid == null) {
            return null;
        }
        FluidStack rFluid = null;
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (tAmount = aNBT.func_74763_f("a")) > 0L) {
            rFluid = UT.Fluids.make(tFluid, tAmount);
        }
        return rFluid == null ? UT.Fluids.make(tFluid, 0L) : rFluid;
    }

    public int getCapacity(ItemStack aStack) {
        return Integer.MAX_VALUE;
    }

    public int fill(ItemStack aStack, FluidStack aFluid, boolean aDoFill) {
        return 0;
    }

    public FluidStack drain(ItemStack aStack, int aDrain, boolean aDoDrain) {
        return this.getFluid(aStack);
    }
}

