/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverDefault;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CoverTextureMulti
extends AbstractCoverDefault {
    public final ITexture[] mTextures;

    public CoverTextureMulti(ITexture ... aTextures) {
        this.mTextures = aTextures;
    }

    public CoverTextureMulti(String aFolder, int aAmount) {
        this.mTextures = new ITexture[aAmount];
        for (int i = 0; i < this.mTextures.length; ++i) {
            this.mTextures[i] = BlockTextureDefault.get(new Textures.BlockIcons.CustomIcon(aFolder + i));
        }
    }

    @Override
    public long onToolClick(byte aSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("chisel") && this.mTextures.length > 1) {
            aData.visual(aSide, (short)((aData.mVisuals[aSide] + 1) % this.mTextures.length));
            return 100L;
        }
        return 0L;
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return this.mTextures[aData.mVisuals[aSide] % this.mTextures.length];
    }

    @Override
    public boolean needsVisualsSaved(byte aSide, CoverData aData) {
        return true;
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        if (this.mTextures.length > 1) {
            aList.add(LH.get("gt.lang.use.chisel.to.switch.design"));
        }
    }
}

