/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachmentScale;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.util.UT;
import net.minecraft.entity.Entity;

public class CoverScaleProgress
extends AbstractCoverAttachmentScale {
    public static final ITexture sTextureBackground = BlockTextureDefault.get(new Textures.BlockIcons.CustomIcon("machines/covers/progressredstone/base"));
    public static final ITexture sTextureForeground = BlockTextureDefault.get(new Textures.BlockIcons.CustomIcon("machines/covers/progressredstone/circuit"));

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !aData.mTileEntity.canTick() || !(aData.mTileEntity instanceof ITileEntityProgress);
    }

    @Override
    public void onTickPost(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide && aData.mTileEntity instanceof ITileEntityProgress) {
            long tProgress = ((ITileEntityProgress)((Object)aData.mTileEntity)).getProgressValue(aSide);
            long tMax = ((ITileEntityProgress)((Object)aData.mTileEntity)).getProgressMax(aSide);
            byte tNewValue = UT.Code.bind4(tProgress <= 0L || tMax <= 0L ? 0L : (tProgress >= tMax ? 15L : (long)(14 - (int)Math.max(0L, Math.min(13L, (tMax - tProgress) * 14L / tMax)))));
            if (aData.mValues[aSide] != tNewValue) {
                aData.value(aSide, tNewValue);
                aData.mTileEntity.sendBlockUpdateFromCover();
            }
        }
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return sTextureForeground;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide != aTextureSide ? sTextureBackground : BlockTextureMulti.get(sTextureBackground, sTextureForeground);
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return sTextureBackground;
    }
}

