/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.code.TagData;
import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachmentScale;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.energy.ITileEntityEnergyDataCapacitor;
import gregapi.util.UT;
import net.minecraft.entity.Entity;

public class CoverScaleEnergy
extends AbstractCoverAttachmentScale {
    public static final ITexture sTextureBackground = BlockTextureDefault.get(new Textures.BlockIcons.CustomIcon("machines/covers/energyredstone/base"));
    public static final ITexture sTextureForeground = BlockTextureDefault.get(new Textures.BlockIcons.CustomIcon("machines/covers/energyredstone/circuit"));

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !aData.mTileEntity.canTick() || !(aData.mTileEntity instanceof ITileEntityEnergyDataCapacitor);
    }

    @Override
    public void onTickPost(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide && aData.mTileEntity instanceof ITileEntityEnergyDataCapacitor && !((ITileEntityEnergyDataCapacitor)((Object)aData.mTileEntity)).getEnergyCapacitorTypes(aSide).isEmpty()) {
            TagData tEnergyType = ((ITileEntityEnergyDataCapacitor)((Object)aData.mTileEntity)).getEnergyCapacitorTypes(aSide).iterator().next();
            long tStored = ((ITileEntityEnergyDataCapacitor)((Object)aData.mTileEntity)).getEnergyStored(tEnergyType, aSide);
            long tCapacity = ((ITileEntityEnergyDataCapacitor)((Object)aData.mTileEntity)).getEnergyCapacity(tEnergyType, aSide);
            byte tNewValue = UT.Code.bind4(tStored <= 0L || tCapacity <= 0L ? 0L : (tStored >= tCapacity ? 15L : (long)(14 - (int)Math.max(0L, Math.min(13L, (tCapacity - tStored) * 14L / tCapacity)))));
            if (aData.mValues[aSide] != tNewValue) {
                aData.value(aSide, tNewValue);
                aData.mTileEntity.sendBlockUpdateFromCover();
            }
        }
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return sTextureForeground;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide != aTextureSide ? sTextureBackground : BlockTextureMulti.get(sTextureBackground, sTextureForeground);
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return sTextureBackground;
    }
}

