/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class CoverPump
extends AbstractCoverAttachment {
    public final int mThroughput;
    public static final ITexture sTextureBase = BlockTextureDefault.get(new Textures.BlockIcons.CustomIcon("machines/covers/pump/base"));
    public static final ITexture sTextureIn = BlockTextureDefault.get(new Textures.BlockIcons.CustomIcon("machines/covers/pump/in"));
    public static final ITexture sTextureOut = BlockTextureDefault.get(new Textures.BlockIcons.CustomIcon("machines/covers/pump/out"));

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !aData.mTileEntity.canTick() || !(aData.mTileEntity instanceof IFluidHandler);
    }

    public CoverPump(int aThroughput) {
        this.mThroughput = aThroughput;
    }

    @Override
    public long onToolClick(byte aSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("screwdriver")) {
            aData.visual(aSide, (short)(aData.mVisuals[aSide] == 0 ? 1 : 0));
            return 1000L;
        }
        return 0L;
    }

    @Override
    public void onTickPre(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide && aTimer % 20L == 5L && aData.mTileEntity instanceof IFluidHandler) {
            DelegatorTileEntity<IFluidHandler> tDelegator = aData.mTileEntity.getAdjacentTank(aSide);
            if (tDelegator.mTileEntity != null) {
                if (aData.mVisuals[aSide] == 0) {
                    FluidStack tDrained = ((IFluidHandler)aData.mTileEntity).drain(CS.FORGE_DIR[aSide], this.mThroughput, false);
                    if (tDrained != null) {
                        tDrained.amount = ((IFluidHandler)tDelegator.mTileEntity).fill(CS.FORGE_DIR[tDelegator.mSideOfTileEntity], tDrained, false);
                        ((IFluidHandler)tDelegator.mTileEntity).fill(CS.FORGE_DIR[tDelegator.mSideOfTileEntity], ((IFluidHandler)aData.mTileEntity).drain(CS.FORGE_DIR[aSide], tDrained.amount, true), true);
                    }
                } else {
                    FluidStack tDrained = ((IFluidHandler)tDelegator.mTileEntity).drain(CS.FORGE_DIR[tDelegator.mSideOfTileEntity], this.mThroughput, false);
                    if (tDrained != null) {
                        tDrained.amount = ((IFluidHandler)aData.mTileEntity).fill(CS.FORGE_DIR[aSide], tDrained, false);
                        ((IFluidHandler)aData.mTileEntity).fill(CS.FORGE_DIR[aSide], ((IFluidHandler)tDelegator.mTileEntity).drain(CS.FORGE_DIR[tDelegator.mSideOfTileEntity], tDrained.amount, true), true);
                    }
                }
            }
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.CYAN + "Transfers " + this.mThroughput + " L/sec");
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return aData.mVisuals[aSide] == 0 ? sTextureOut : sTextureIn;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide == aTextureSide ? BlockTextureMulti.get(sTextureBase, aData.mVisuals[aSide] == 0 ? sTextureOut : sTextureIn) : (aSide == CS.OPPOSITES[aTextureSide] ? BlockTextureMulti.get(sTextureBase, aData.mVisuals[aSide] != 0 ? sTextureOut : sTextureIn) : sTextureBase);
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return sTextureBase;
    }

    @Override
    public boolean needsVisualsSaved(byte aSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean interceptFluidFill(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToFill) {
        return aData.mVisuals[aSide] == 0;
    }

    @Override
    public boolean interceptFluidDrain(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToDrain) {
        return aData.mVisuals[aSide] != 0;
    }
}

