/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.tileentity.connectors.MultiTileEntityPipeFluid;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;

public class CoverPressureValve
extends AbstractCoverAttachment {
    public static final float[][] BOXES_VALVES = new float[][]{{CS.PIXELS_POS[6], CS.PIXELS_POS[0], CS.PIXELS_POS[6], CS.PIXELS_NEG[6], CS.PIXELS_NEG[8], CS.PIXELS_NEG[6]}, {CS.PIXELS_POS[6], CS.PIXELS_POS[8], CS.PIXELS_POS[6], CS.PIXELS_NEG[6], CS.PIXELS_NEG[0], CS.PIXELS_NEG[6]}, {CS.PIXELS_POS[6], CS.PIXELS_POS[6], CS.PIXELS_POS[0], CS.PIXELS_NEG[6], CS.PIXELS_NEG[6], CS.PIXELS_NEG[8]}, {CS.PIXELS_POS[6], CS.PIXELS_POS[6], CS.PIXELS_POS[8], CS.PIXELS_NEG[6], CS.PIXELS_NEG[6], CS.PIXELS_NEG[0]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[6], CS.PIXELS_POS[6], CS.PIXELS_NEG[8], CS.PIXELS_NEG[6], CS.PIXELS_NEG[6]}, {CS.PIXELS_POS[8], CS.PIXELS_POS[6], CS.PIXELS_POS[6], CS.PIXELS_NEG[0], CS.PIXELS_NEG[6], CS.PIXELS_NEG[6]}};
    public static final ITexture sTextureFront = BlockTextureDefault.get(new Textures.BlockIcons.CustomIcon("machines/covers/pressurevalve/front"));
    public static final ITexture sTextureSide = BlockTextureDefault.get(new Textures.BlockIcons.CustomIcon("machines/covers/pressurevalve/side"));

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !(aData.mTileEntity instanceof MultiTileEntityPipeFluid) || ((MultiTileEntityPipeFluid)aData.mTileEntity).mTanks.length != 1;
    }

    @Override
    public void onTickPost(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        FluidTank tTank;
        ChunkCoordinates tCoords;
        if (aIsServerSide && aData.mTileEntity instanceof MultiTileEntityPipeFluid && aTimer % 2L == 0L != UT.Worlds.areCoordsEven(tCoords = aData.mTileEntity.getCoords()) && ((MultiTileEntityPipeFluid)aData.mTileEntity).mTanks.length == 1 && (tTank = ((MultiTileEntityPipeFluid)aData.mTileEntity).mTanks[0]).getFluidAmount() >= tTank.getCapacity() && UT.Fluids.gas(tTank.getFluid())) {
            DelegatorTileEntity<IFluidHandler> tDelegator = aData.mTileEntity.getAdjacentTank(aSide);
            if (tDelegator.mTileEntity != null) {
                tTank.drain(((IFluidHandler)tDelegator.mTileEntity).fill(tDelegator.getForgeSideOfTileEntity(), tTank.drain(Integer.MAX_VALUE, false), true), true);
            } else if (tDelegator.getAir(tDelegator.getCoords())) {
                block7: {
                    UT.Sounds.send(aData.mTileEntity.getWorld(), "random.fizz", 1.0f, 1.0f, tCoords);
                    try {
                        for (Entity tEntity : (ArrayList)aData.mTileEntity.getWorld().func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(tCoords.field_71574_a - 2), (double)(tCoords.field_71572_b - 2), (double)(tCoords.field_71573_c - 2), (double)(tCoords.field_71574_a + 3), (double)(tCoords.field_71572_b + 3), (double)(tCoords.field_71573_c + 3)))) {
                            UT.Entities.applyTemperatureDamage(tEntity, UT.Fluids.temperature(tTank.getFluid()), 2.0f);
                        }
                    }
                    catch (Throwable e) {
                        if (!CS.D1) break block7;
                        e.printStackTrace(CS.ERR);
                    }
                }
                tTank.drain(Integer.MAX_VALUE, true);
            }
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.CYAN + "Releases Gasses when Pipe is full.");
        aList.add(LH.Chat.ORANGE + "Requires Air or Tank in front!");
    }

    @Override
    public float[] getCoverBounds(byte aCoverSide, CoverData aData) {
        return BOXES_VALVES[aCoverSide];
    }

    @Override
    public float[] getHolderBounds(byte aCoverSide, CoverData aData) {
        return BOXES_VALVES[aCoverSide];
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return sTextureFront;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide == aTextureSide ? sTextureFront : null;
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide == aTextureSide ? null : sTextureSide;
    }

    @Override
    public boolean isSolid(byte aSide, CoverData aData) {
        return false;
    }
}

