/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.block.metatype.BlockMetaType;
import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class CoverDrain
extends AbstractCoverAttachment {
    public static final ITexture sTextureSides = BlockTextureDefault.get(new Textures.BlockIcons.CustomIcon("machines/covers/drain/sides"));
    public static final ITexture sTextureFront = BlockTextureDefault.get(new Textures.BlockIcons.CustomIcon("machines/covers/drain/front"));
    public static final ITexture sTextureBack = BlockTextureDefault.get(new Textures.BlockIcons.CustomIcon("machines/covers/drain/back"));

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !aData.mTileEntity.canTick() || !(aData.mTileEntity instanceof IFluidHandler);
    }

    @Override
    public void onTickPre(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide && aData.mTileEntity instanceof IFluidHandler) {
            if (CS.SIDES_TOP_HORIZONTAL[aSide] && aTimer % 100L == 10L && aData.mTileEntity.getWorld().func_72896_J()) {
                Block tInFront;
                BiomeGenBase tBiome = aData.mTileEntity.getBiome();
                if (tBiome.field_76751_G > 0.0f && (double)tBiome.field_76750_F >= 0.2 && !((tInFront = aData.mTileEntity.getBlockAtSide(aSide)) instanceof BlockLiquid) && !(tInFront instanceof IFluidBlock) && !tInFront.isSideSolid((IBlockAccess)aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aSide), aData.mTileEntity.getOffsetY(aSide), aData.mTileEntity.getOffsetZ(aSide), CS.FORGE_DIR_OPPOSITES[aSide]) && !tInFront.isSideSolid((IBlockAccess)aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aSide), aData.mTileEntity.getOffsetY(aSide), aData.mTileEntity.getOffsetZ(aSide), CS.FORGE_DIR[1])) {
                    FluidStack tWater;
                    boolean temp = false;
                    if (tInFront instanceof BlockMetaType || tInFront instanceof BlockSlab || tInFront instanceof BlockStairs) {
                        temp = aData.mTileEntity.getRainOffset(CS.OFFSETS_X[aSide], CS.OFFSETS_Y[aSide] + 1, CS.OFFSETS_Z[aSide]);
                    } else {
                        boolean bl = temp = aData.mTileEntity.getRainOffset(CS.OFFSETS_X[aSide], CS.OFFSETS_Y[aSide], CS.OFFSETS_Z[aSide]) && (CS.SIDES_TOP[aSide] || aData.mTileEntity.getBlockOffset(CS.OFFSETS_X[aSide], -1, CS.OFFSETS_Z[aSide]).isSideSolid((IBlockAccess)aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aSide), aData.mTileEntity.getY() - 1, aData.mTileEntity.getOffsetZ(aSide), CS.FORGE_DIR[1]));
                    }
                    if (temp && ((IFluidHandler)aData.mTileEntity).fill(CS.FORGE_DIR[aSide], tWater = UT.Fluids.water((long)Math.max(1.0f, tBiome.field_76751_G * 100.0f) * (long)(aData.mTileEntity.getWorld().func_72911_I() ? 2 : 1)), true) == 0) {
                        ((IFluidHandler)aData.mTileEntity).fill(CS.FORGE_DIR[6], tWater, true);
                    }
                }
            }
            if (aReceivedBlockUpdate || aTimer % 20L == 5L) {
                Block tBlock = aData.mTileEntity.getBlockAtSide(aSide);
                FluidStack tFluid = CS.NF;
                if ((tBlock == Blocks.field_150355_j || tBlock == Blocks.field_150358_i) && aData.mTileEntity.getMetaDataAtSide(aSide) == 0) {
                    tFluid = UT.Fluids.water(1000L);
                }
                if ((tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150356_k) && aData.mTileEntity.getMetaDataAtSide(aSide) == 0) {
                    tFluid = UT.Fluids.lava(1000L);
                }
                if (tBlock instanceof IFluidBlock) {
                    tFluid = ((IFluidBlock)tBlock).drain(aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aSide), aData.mTileEntity.getOffsetY(aSide), aData.mTileEntity.getOffsetZ(aSide), false);
                }
                if (tFluid != null && (CS.SIDES_HORIZONTAL[aSide] || UT.Fluids.gas(tFluid) || (tFluid.getFluid().getDensity(tFluid) < 0 ? CS.SIDES_BOTTOM : CS.SIDES_TOP)[aSide])) {
                    if (((IFluidHandler)aData.mTileEntity).fill(CS.FORGE_DIR[aSide], tFluid, false) == tFluid.amount) {
                        ((IFluidHandler)aData.mTileEntity).fill(CS.FORGE_DIR[aSide], tFluid, true);
                        if (tBlock instanceof IFluidBlock) {
                            ((IFluidBlock)tBlock).drain(aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aSide), aData.mTileEntity.getOffsetY(aSide), aData.mTileEntity.getOffsetZ(aSide), true);
                        } else {
                            aData.mTileEntity.getWorld().func_147468_f(aData.mTileEntity.getOffsetX(aSide), aData.mTileEntity.getOffsetY(aSide), aData.mTileEntity.getOffsetZ(aSide));
                        }
                    } else if (((IFluidHandler)aData.mTileEntity).fill(CS.FORGE_DIR[6], tFluid, false) == tFluid.amount) {
                        ((IFluidHandler)aData.mTileEntity).fill(CS.FORGE_DIR[6], tFluid, true);
                        if (tBlock instanceof IFluidBlock) {
                            ((IFluidBlock)tBlock).drain(aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aSide), aData.mTileEntity.getOffsetY(aSide), aData.mTileEntity.getOffsetZ(aSide), true);
                        } else {
                            aData.mTileEntity.getWorld().func_147468_f(aData.mTileEntity.getOffsetX(aSide), aData.mTileEntity.getOffsetY(aSide), aData.mTileEntity.getOffsetZ(aSide));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.CYAN + "Collects Fluid Blocks (if not against Gravity)");
        aList.add(LH.Chat.CYAN + "Collects Rainwater (not in Dry or Cold Areas)");
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return sTextureFront;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide == aTextureSide ? sTextureFront : (aSide == CS.OPPOSITES[aTextureSide] ? sTextureBack : sTextureSides);
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return sTextureSides;
    }
}

