/*
 * Decompiled with CFR 0.152.
 */
package gregapi.config;

import gregapi.api.Abstract_Mod;
import gregapi.data.CS;
import gregapi.util.UT;
import java.io.File;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config
implements Runnable {
    public static Configuration sConfigFileIDs;
    private static boolean sIDConfigNeedsSaving;
    private boolean mUsesDefaultsInNames = true;
    public final Configuration mConfig;

    public static int addIDConfig(Object aCategory, String aName, int aDefault) {
        if (UT.Code.stringInvalid(aName)) {
            return aDefault;
        }
        Property tProperty = sConfigFileIDs.get(aCategory.toString().replaceAll("\\|", "."), aName.replaceAll("\\|", "."), aDefault);
        int rResult = tProperty.getInt(aDefault);
        if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI && !tProperty.wasRead()) {
            sConfigFileIDs.save();
        } else {
            sIDConfigNeedsSaving = true;
        }
        return rResult;
    }

    public Config(String aFileName) {
        this(new File(CS.DirectoriesGT.CONFIG_GT, aFileName));
    }

    public Config(String aPath, String aFileName) {
        this(new File(aPath, aFileName));
    }

    public Config(File aPath, String aFileName) {
        this(new File(aPath, aFileName));
    }

    public Config(File aConfig) {
        this(new Configuration(aConfig));
    }

    public Config(Configuration aConfig) {
        this.mConfig = aConfig;
        this.mConfig.load();
        this.mConfig.save();
        Abstract_Mod.sConfigs.add(this);
    }

    @Override
    public void run() {
        this.mConfig.save();
        if (sIDConfigNeedsSaving) {
            sConfigFileIDs.save();
            sIDConfigNeedsSaving = false;
        }
    }

    public Config setUseDefaultInNames(boolean aUsesDefaultsInNames) {
        this.mUsesDefaultsInNames = aUsesDefaultsInNames;
        return this;
    }

    public boolean get(Object aCategory, ItemStack aStack, boolean aDefault) {
        return this.get(aCategory, UT.Stacks.configName(aStack), aDefault);
    }

    public boolean get(Object aCategory, String aName, boolean aDefault) {
        if (UT.Code.stringInvalid(aName)) {
            return aDefault;
        }
        Property tProperty = this.mConfig.get(aCategory.toString().replaceAll("\\|", "_"), (aName + (this.mUsesDefaultsInNames ? "_" + aDefault : "")).replaceAll("\\|", "_"), aDefault);
        boolean rResult = tProperty.getBoolean(aDefault);
        if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI && !tProperty.wasRead()) {
            this.mConfig.save();
        }
        return rResult;
    }

    public int get(Object aCategory, ItemStack aStack, long aDefault) {
        return this.get(aCategory, UT.Stacks.configName(aStack), aDefault);
    }

    public int get(Object aCategory, String aName, long aDefault) {
        if (UT.Code.stringInvalid(aName)) {
            return UT.Code.bindInt(aDefault);
        }
        Property tProperty = this.mConfig.get(aCategory.toString().replaceAll("\\|", "_"), (aName + (this.mUsesDefaultsInNames ? "_" + UT.Code.bindInt(aDefault) : "")).replaceAll("\\|", "_"), UT.Code.bindInt(aDefault));
        int rResult = tProperty.getInt(UT.Code.bindInt(aDefault));
        if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI && !tProperty.wasRead()) {
            this.mConfig.save();
        }
        return rResult;
    }

    public String get(Object aCategory, ItemStack aStack, String aDefault) {
        return this.get(aCategory, UT.Stacks.configName(aStack), aDefault);
    }

    public String get(Object aCategory, String aName, String aDefault) {
        if (UT.Code.stringInvalid(aName)) {
            return aDefault;
        }
        Property tProperty = this.mConfig.get(aCategory.toString().replaceAll("\\|", "_"), (aName + (this.mUsesDefaultsInNames ? "_" + aDefault : "")).replaceAll("\\|", "_"), aDefault);
        String rResult = tProperty.getString();
        if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI && !tProperty.wasRead()) {
            this.mConfig.save();
        }
        return rResult;
    }

    public double get(Object aCategory, ItemStack aStack, double aDefault) {
        return this.get(aCategory, UT.Stacks.configName(aStack), aDefault);
    }

    public double get(Object aCategory, String aName, double aDefault) {
        if (UT.Code.stringInvalid(aName)) {
            return aDefault;
        }
        Property tProperty = this.mConfig.get(aCategory.toString().replaceAll("\\|", "_"), (aName + (this.mUsesDefaultsInNames ? "_" + aDefault : "")).replaceAll("\\|", "_"), aDefault);
        double rResult = tProperty.getDouble(aDefault);
        if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI && !tProperty.wasRead()) {
            this.mConfig.save();
        }
        return rResult;
    }

    public String toString() {
        return "Config File";
    }

    static {
        sIDConfigNeedsSaving = false;
    }
}

