/*
 * Decompiled with CFR 0.152.
 */
package gregapi.compat.industrialcraft;

import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregapi.block.IBlockPlacable;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackSet;
import gregapi.compat.CompatBase;
import gregapi.compat.industrialcraft.ICompatIC2;
import gregapi.config.ConfigCategories;
import gregapi.cover.CoverData;
import gregapi.cover.ITileEntityCoverable;
import gregapi.cover.covers.CoverTextureCanvas;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.util.OM;
import gregapi.util.UT;
import ic2.api.event.RetextureEvent;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import ic2.core.IC2;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public class CompatIC2
extends CompatBase
implements ICompatIC2 {
    private ItemStackSet<ItemStackContainer> mToBlacklist = new ItemStackSet();

    public CompatIC2() {
        this.valuable(Blocks.field_150426_aN, 0, 1);
        this.valuable(Blocks.field_150425_aM, 0, 1);
        if (Recipes.scrapboxDrops == null) {
            // empty if block
        }
        if (Recipes.recyclerBlacklist == null) {
            // empty if block
        }
        if (Recipes.recyclerWhitelist == null) {
            // empty if block
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onPostLoad(FMLPostInitializationEvent aEvent) {
        for (IBlockPlacable tOre : CS.BlocksGT.stoneToSmallOres.values()) {
            this.valuable((Block)tOre, 2);
        }
        for (IBlockPlacable tOre : CS.BlocksGT.stoneToNormalOres.values()) {
            this.valuable((Block)tOre, 2);
        }
        for (IBlockPlacable tOre : CS.BlocksGT.stoneToBrokenOres.values()) {
            this.valuable((Block)tOre, 2);
        }
        if (this.mToBlacklist != null) {
            for (ItemStackContainer tStack : this.mToBlacklist) {
                Recipes.recyclerBlacklist.add((IRecipeInput)new RecipeInputItemStack(tStack.toStack()));
            }
            this.mToBlacklist.clear();
            this.mToBlacklist = null;
        }
    }

    @SubscribeEvent
    public void onRetextureEvent(RetextureEvent aEvent) {
        CoverData tData;
        TileEntity tTileEntity = UT.Worlds.getTileEntity(aEvent.world, aEvent.x, aEvent.y, aEvent.z, true);
        if (tTileEntity instanceof ITileEntityCoverable && (tData = ((ITileEntityCoverable)tTileEntity).getCoverData()) != null && tData.mBehaviours[aEvent.side] instanceof CoverTextureCanvas) {
            if (tData.mNBTs[aEvent.side] == null) {
                tData.mNBTs[aEvent.side] = new NBTTagCompound();
            }
            tData.mNBTs[aEvent.side].func_74768_a("gt.canvas.block", Block.func_149682_b((Block)aEvent.referencedBlock));
            tData.mNBTs[aEvent.side].func_74768_a("gt.canvas.meta", aEvent.referencedMeta);
            tData.mBehaviours[aEvent.side].onCoverPlaced((byte)aEvent.side, tData, null, tData.getCoverItem((byte)aEvent.side));
            aEvent.applied = true;
        }
    }

    @Override
    public boolean valuable(Block aBlock, int aMeta, int aValue) {
        if (aValue <= 0 || aBlock == null || aBlock == CS.NB) {
            return false;
        }
        IC2.addValuableOre((IRecipeInput)new RecipeInputItemStack(UT.Stacks.make(aBlock, 1L, (long)aMeta)), (int)aValue);
        return true;
    }

    @Override
    public boolean valuable(Block aBlock, int aValue) {
        if (aValue <= 0 || aBlock == null || aBlock == CS.NB) {
            return false;
        }
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            this.valuable(aBlock, i, aValue);
        }
        return true;
    }

    @Override
    public ItemStack recycler(ItemStack aInput, int aScrapChance) {
        if (aInput == null || aScrapChance != 0 || Recipes.recyclerBlacklist.contains(aInput)) {
            return null;
        }
        return Recipes.recyclerWhitelist.isEmpty() || Recipes.recyclerWhitelist.contains(aInput) ? IL.IC2_Scrap.get(1L, new Object[0]) : null;
    }

    @Override
    public ItemStack scrapbox(ItemStack aBox) {
        return Recipes.scrapboxDrops.getDrop(aBox, false);
    }

    @Override
    public boolean scrapbox(float aChance, ItemStack aOutput) {
        if (UT.Stacks.invalid(aOutput) || aChance <= 0.0f) {
            return false;
        }
        aOutput = OM.get_(aOutput);
        aOutput.field_77994_a = 1;
        if ((aChance = (float)CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.scrapboxdrops, aOutput, (double)aChance)) <= 0.0f) {
            return false;
        }
        Recipes.scrapboxDrops.addDrop(UT.Stacks.copy(aOutput), aChance);
        return true;
    }

    @Override
    public boolean blacklist(ItemStack aBlacklisted) {
        if (UT.Stacks.invalid(aBlacklisted)) {
            return false;
        }
        if (Recipes.recyclerBlacklist == null) {
            this.mToBlacklist.add(aBlacklisted);
        } else {
            Recipes.recyclerBlacklist.add((IRecipeInput)new RecipeInputItemStack(aBlacklisted));
        }
        return true;
    }
}

