/*
 * Decompiled with CFR 0.152.
 */
package gregapi.code;

import gregapi.GT_API;
import gregapi.code.ItemStackContainer;
import gregapi.util.UT;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.item.ItemStack;

public class ItemStackSet<E extends ItemStackContainer>
extends AbstractSet<E> {
    private transient HashMap<ItemStackContainer, Object> map;
    private static final Object OBJECT = new Object();

    public ItemStackSet() {
        this.map = new HashMap();
        GT_API.STACKMAPS.add(this.map);
    }

    public ItemStackSet(Collection<? extends E> c) {
        this.map = new HashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
        GT_API.STACKMAPS.add(this.map);
    }

    public ItemStackSet(int initialCapacity, float loadFactor) {
        this.map = new HashMap(initialCapacity, loadFactor);
        GT_API.STACKMAPS.add(this.map);
    }

    public ItemStackSet(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
        GT_API.STACKMAPS.add(this.map);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object aObject) {
        return this.map.containsKey(aObject);
    }

    public boolean contains(ItemStack aObject, boolean aWildCard) {
        return this.map.containsKey(new ItemStackContainer(aObject)) || aWildCard && this.map.containsKey(new ItemStackContainer(aObject, 32767L));
    }

    public boolean contains(ItemStackContainer aObject, boolean aWildCard) {
        return this.map.containsKey(aObject) || aWildCard && this.map.containsKey(new ItemStackContainer(aObject.mItem, 1L, 32767L));
    }

    @Override
    public boolean add(ItemStack aStack) {
        return UT.Stacks.valid(aStack) && this.map.put(new ItemStackContainer(aStack), OBJECT) == null;
    }

    @Override
    public boolean add(E aStack) {
        return aStack != null && this.map.put((ItemStackContainer)aStack, OBJECT) == null;
    }

    @Override
    public boolean remove(Object aStack) {
        return this.map.remove(aStack) == OBJECT;
    }

    @Override
    public boolean equals(Object aStack) {
        return this == aStack;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

